/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.AuthorizationCheckResultDto;
import org.camunda.community.rest.client.dto.AuthorizationCreateDto;
import org.camunda.community.rest.client.dto.AuthorizationDto;
import org.camunda.community.rest.client.dto.AuthorizationUpdateDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ResourceOptionsDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class AuthorizationApi {
    private ApiClient localVarApiClient;

    public AuthorizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call availableOperationsAuthorizationCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authorization";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call availableOperationsAuthorizationValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.availableOperationsAuthorizationCall(_callback);
        return localVarCall;
    }

    public ResourceOptionsDto availableOperationsAuthorization() throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = this.availableOperationsAuthorizationWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ResourceOptionsDto> availableOperationsAuthorizationWithHttpInfo() throws ApiException {
        Call localVarCall = this.availableOperationsAuthorizationValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call availableOperationsAuthorizationAsync(ApiCallback<ResourceOptionsDto> _callback) throws ApiException {
        Call localVarCall = this.availableOperationsAuthorizationValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call availableOperationsAuthorizationInstanceCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authorization/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call availableOperationsAuthorizationInstanceValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling availableOperationsAuthorizationInstance(Async)");
        }
        Call localVarCall = this.availableOperationsAuthorizationInstanceCall(id, _callback);
        return localVarCall;
    }

    public ResourceOptionsDto availableOperationsAuthorizationInstance(String id) throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = this.availableOperationsAuthorizationInstanceWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ResourceOptionsDto> availableOperationsAuthorizationInstanceWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.availableOperationsAuthorizationInstanceValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call availableOperationsAuthorizationInstanceAsync(String id, ApiCallback<ResourceOptionsDto> _callback) throws ApiException {
        Call localVarCall = this.availableOperationsAuthorizationInstanceValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createAuthorizationCall(AuthorizationCreateDto authorizationCreateDto, ApiCallback _callback) throws ApiException {
        AuthorizationCreateDto localVarPostBody = authorizationCreateDto;
        String localVarPath = "/authorization/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createAuthorizationValidateBeforeCall(AuthorizationCreateDto authorizationCreateDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createAuthorizationCall(authorizationCreateDto, _callback);
        return localVarCall;
    }

    public AuthorizationDto createAuthorization(AuthorizationCreateDto authorizationCreateDto) throws ApiException {
        ApiResponse<AuthorizationDto> localVarResp = this.createAuthorizationWithHttpInfo(authorizationCreateDto);
        return localVarResp.getData();
    }

    public ApiResponse<AuthorizationDto> createAuthorizationWithHttpInfo(AuthorizationCreateDto authorizationCreateDto) throws ApiException {
        Call localVarCall = this.createAuthorizationValidateBeforeCall(authorizationCreateDto, null);
        Type localVarReturnType = new TypeToken<AuthorizationDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createAuthorizationAsync(AuthorizationCreateDto authorizationCreateDto, ApiCallback<AuthorizationDto> _callback) throws ApiException {
        Call localVarCall = this.createAuthorizationValidateBeforeCall(authorizationCreateDto, _callback);
        Type localVarReturnType = new TypeToken<AuthorizationDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAuthorizationCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authorization/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAuthorizationValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteAuthorization(Async)");
        }
        Call localVarCall = this.deleteAuthorizationCall(id, _callback);
        return localVarCall;
    }

    public void deleteAuthorization(String id) throws ApiException {
        this.deleteAuthorizationWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteAuthorizationWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.deleteAuthorizationValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAuthorizationAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAuthorizationValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAuthorizationCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authorization/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAuthorizationValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getAuthorization(Async)");
        }
        Call localVarCall = this.getAuthorizationCall(id, _callback);
        return localVarCall;
    }

    public AuthorizationDto getAuthorization(String id) throws ApiException {
        ApiResponse<AuthorizationDto> localVarResp = this.getAuthorizationWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<AuthorizationDto> getAuthorizationWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getAuthorizationValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<AuthorizationDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAuthorizationAsync(String id, ApiCallback<AuthorizationDto> _callback) throws ApiException {
        Call localVarCall = this.getAuthorizationValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<AuthorizationDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAuthorizationCountCall(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/authorization/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (userIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("userIdIn", userIdIn));
        }
        if (groupIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("groupIdIn", groupIdIn));
        }
        if (resourceType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceType", resourceType));
        }
        if (resourceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceId", resourceId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAuthorizationCountValidateBeforeCall(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAuthorizationCountCall(id, type, userIdIn, groupIdIn, resourceType, resourceId, _callback);
        return localVarCall;
    }

    public CountResultDto getAuthorizationCount(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getAuthorizationCountWithHttpInfo(id, type, userIdIn, groupIdIn, resourceType, resourceId);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getAuthorizationCountWithHttpInfo(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId) throws ApiException {
        Call localVarCall = this.getAuthorizationCountValidateBeforeCall(id, type, userIdIn, groupIdIn, resourceType, resourceId, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAuthorizationCountAsync(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getAuthorizationCountValidateBeforeCall(id, type, userIdIn, groupIdIn, resourceType, resourceId, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call isUserAuthorizedCall(String permissionName, String resourceName, Integer resourceType, String resourceId, String userId, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/authorization/check";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (permissionName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("permissionName", permissionName));
        }
        if (resourceName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceName", resourceName));
        }
        if (resourceType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceType", resourceType));
        }
        if (resourceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceId", resourceId));
        }
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("userId", userId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call isUserAuthorizedValidateBeforeCall(String permissionName, String resourceName, Integer resourceType, String resourceId, String userId, ApiCallback _callback) throws ApiException {
        if (permissionName == null) {
            throw new ApiException("Missing the required parameter 'permissionName' when calling isUserAuthorized(Async)");
        }
        if (resourceName == null) {
            throw new ApiException("Missing the required parameter 'resourceName' when calling isUserAuthorized(Async)");
        }
        if (resourceType == null) {
            throw new ApiException("Missing the required parameter 'resourceType' when calling isUserAuthorized(Async)");
        }
        Call localVarCall = this.isUserAuthorizedCall(permissionName, resourceName, resourceType, resourceId, userId, _callback);
        return localVarCall;
    }

    public AuthorizationCheckResultDto isUserAuthorized(String permissionName, String resourceName, Integer resourceType, String resourceId, String userId) throws ApiException {
        ApiResponse<AuthorizationCheckResultDto> localVarResp = this.isUserAuthorizedWithHttpInfo(permissionName, resourceName, resourceType, resourceId, userId);
        return localVarResp.getData();
    }

    public ApiResponse<AuthorizationCheckResultDto> isUserAuthorizedWithHttpInfo(String permissionName, String resourceName, Integer resourceType, String resourceId, String userId) throws ApiException {
        Call localVarCall = this.isUserAuthorizedValidateBeforeCall(permissionName, resourceName, resourceType, resourceId, userId, null);
        Type localVarReturnType = new TypeToken<AuthorizationCheckResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call isUserAuthorizedAsync(String permissionName, String resourceName, Integer resourceType, String resourceId, String userId, ApiCallback<AuthorizationCheckResultDto> _callback) throws ApiException {
        Call localVarCall = this.isUserAuthorizedValidateBeforeCall(permissionName, resourceName, resourceType, resourceId, userId, _callback);
        Type localVarReturnType = new TypeToken<AuthorizationCheckResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryAuthorizationsCall(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/authorization";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (userIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("userIdIn", userIdIn));
        }
        if (groupIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("groupIdIn", groupIdIn));
        }
        if (resourceType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceType", resourceType));
        }
        if (resourceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceId", resourceId));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryAuthorizationsValidateBeforeCall(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryAuthorizationsCall(id, type, userIdIn, groupIdIn, resourceType, resourceId, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<AuthorizationDto> queryAuthorizations(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<AuthorizationDto>> localVarResp = this.queryAuthorizationsWithHttpInfo(id, type, userIdIn, groupIdIn, resourceType, resourceId, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<AuthorizationDto>> queryAuthorizationsWithHttpInfo(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.queryAuthorizationsValidateBeforeCall(id, type, userIdIn, groupIdIn, resourceType, resourceId, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<AuthorizationDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryAuthorizationsAsync(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<List<AuthorizationDto>> _callback) throws ApiException {
        Call localVarCall = this.queryAuthorizationsValidateBeforeCall(id, type, userIdIn, groupIdIn, resourceType, resourceId, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<AuthorizationDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAuthorizationCall(String id, AuthorizationUpdateDto authorizationUpdateDto, ApiCallback _callback) throws ApiException {
        AuthorizationUpdateDto localVarPostBody = authorizationUpdateDto;
        String localVarPath = "/authorization/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAuthorizationValidateBeforeCall(String id, AuthorizationUpdateDto authorizationUpdateDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateAuthorization(Async)");
        }
        Call localVarCall = this.updateAuthorizationCall(id, authorizationUpdateDto, _callback);
        return localVarCall;
    }

    public void updateAuthorization(String id, AuthorizationUpdateDto authorizationUpdateDto) throws ApiException {
        this.updateAuthorizationWithHttpInfo(id, authorizationUpdateDto);
    }

    public ApiResponse<Void> updateAuthorizationWithHttpInfo(String id, AuthorizationUpdateDto authorizationUpdateDto) throws ApiException {
        Call localVarCall = this.updateAuthorizationValidateBeforeCall(id, authorizationUpdateDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateAuthorizationAsync(String id, AuthorizationUpdateDto authorizationUpdateDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateAuthorizationValidateBeforeCall(id, authorizationUpdateDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

