/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ResourceOptionsDto;
import org.camunda.community.rest.client.dto.TenantDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class TenantApi {
    private ApiClient localVarApiClient;

    public TenantApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TenantApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call availableTenantGroupMembersOperationsCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tenant/{id}/group-members".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call availableTenantGroupMembersOperationsValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling availableTenantGroupMembersOperations(Async)");
        }
        Call localVarCall = this.availableTenantGroupMembersOperationsCall(id, _callback);
        return localVarCall;
    }

    public ResourceOptionsDto availableTenantGroupMembersOperations(String id) throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = this.availableTenantGroupMembersOperationsWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ResourceOptionsDto> availableTenantGroupMembersOperationsWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.availableTenantGroupMembersOperationsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call availableTenantGroupMembersOperationsAsync(String id, ApiCallback<ResourceOptionsDto> _callback) throws ApiException {
        Call localVarCall = this.availableTenantGroupMembersOperationsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call availableTenantInstanceOperationsCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tenant/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call availableTenantInstanceOperationsValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling availableTenantInstanceOperations(Async)");
        }
        Call localVarCall = this.availableTenantInstanceOperationsCall(id, _callback);
        return localVarCall;
    }

    public ResourceOptionsDto availableTenantInstanceOperations(String id) throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = this.availableTenantInstanceOperationsWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ResourceOptionsDto> availableTenantInstanceOperationsWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.availableTenantInstanceOperationsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call availableTenantInstanceOperationsAsync(String id, ApiCallback<ResourceOptionsDto> _callback) throws ApiException {
        Call localVarCall = this.availableTenantInstanceOperationsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call availableTenantResourceOperationsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tenant";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call availableTenantResourceOperationsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.availableTenantResourceOperationsCall(_callback);
        return localVarCall;
    }

    public ResourceOptionsDto availableTenantResourceOperations() throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = this.availableTenantResourceOperationsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ResourceOptionsDto> availableTenantResourceOperationsWithHttpInfo() throws ApiException {
        Call localVarCall = this.availableTenantResourceOperationsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call availableTenantResourceOperationsAsync(ApiCallback<ResourceOptionsDto> _callback) throws ApiException {
        Call localVarCall = this.availableTenantResourceOperationsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call availableTenantUserMembersOperationsCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tenant/{id}/user-members".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call availableTenantUserMembersOperationsValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling availableTenantUserMembersOperations(Async)");
        }
        Call localVarCall = this.availableTenantUserMembersOperationsCall(id, _callback);
        return localVarCall;
    }

    public ResourceOptionsDto availableTenantUserMembersOperations(String id) throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = this.availableTenantUserMembersOperationsWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ResourceOptionsDto> availableTenantUserMembersOperationsWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.availableTenantUserMembersOperationsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call availableTenantUserMembersOperationsAsync(String id, ApiCallback<ResourceOptionsDto> _callback) throws ApiException {
        Call localVarCall = this.availableTenantUserMembersOperationsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createGroupMembershipCall(String id, String groupId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tenant/{id}/group-members/{groupId}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{groupId\\}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createGroupMembershipValidateBeforeCall(String id, String groupId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createGroupMembership(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling createGroupMembership(Async)");
        }
        Call localVarCall = this.createGroupMembershipCall(id, groupId, _callback);
        return localVarCall;
    }

    public void createGroupMembership(String id, String groupId) throws ApiException {
        this.createGroupMembershipWithHttpInfo(id, groupId);
    }

    public ApiResponse<Void> createGroupMembershipWithHttpInfo(String id, String groupId) throws ApiException {
        Call localVarCall = this.createGroupMembershipValidateBeforeCall(id, groupId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createGroupMembershipAsync(String id, String groupId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createGroupMembershipValidateBeforeCall(id, groupId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call createTenantCall(TenantDto tenantDto, ApiCallback _callback) throws ApiException {
        TenantDto localVarPostBody = tenantDto;
        String localVarPath = "/tenant/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTenantValidateBeforeCall(TenantDto tenantDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createTenantCall(tenantDto, _callback);
        return localVarCall;
    }

    public void createTenant(TenantDto tenantDto) throws ApiException {
        this.createTenantWithHttpInfo(tenantDto);
    }

    public ApiResponse<Void> createTenantWithHttpInfo(TenantDto tenantDto) throws ApiException {
        Call localVarCall = this.createTenantValidateBeforeCall(tenantDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createTenantAsync(TenantDto tenantDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createTenantValidateBeforeCall(tenantDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call createUserMembershipCall(String id, String userId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tenant/{id}/user-members/{userId}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{userId\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUserMembershipValidateBeforeCall(String id, String userId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createUserMembership(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createUserMembership(Async)");
        }
        Call localVarCall = this.createUserMembershipCall(id, userId, _callback);
        return localVarCall;
    }

    public void createUserMembership(String id, String userId) throws ApiException {
        this.createUserMembershipWithHttpInfo(id, userId);
    }

    public ApiResponse<Void> createUserMembershipWithHttpInfo(String id, String userId) throws ApiException {
        Call localVarCall = this.createUserMembershipValidateBeforeCall(id, userId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createUserMembershipAsync(String id, String userId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createUserMembershipValidateBeforeCall(id, userId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteGroupMembershipCall(String id, String groupId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tenant/{id}/group-members/{groupId}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{groupId\\}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteGroupMembershipValidateBeforeCall(String id, String groupId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteGroupMembership(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling deleteGroupMembership(Async)");
        }
        Call localVarCall = this.deleteGroupMembershipCall(id, groupId, _callback);
        return localVarCall;
    }

    public void deleteGroupMembership(String id, String groupId) throws ApiException {
        this.deleteGroupMembershipWithHttpInfo(id, groupId);
    }

    public ApiResponse<Void> deleteGroupMembershipWithHttpInfo(String id, String groupId) throws ApiException {
        Call localVarCall = this.deleteGroupMembershipValidateBeforeCall(id, groupId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteGroupMembershipAsync(String id, String groupId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteGroupMembershipValidateBeforeCall(id, groupId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteTenantCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tenant/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTenantValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteTenant(Async)");
        }
        Call localVarCall = this.deleteTenantCall(id, _callback);
        return localVarCall;
    }

    public void deleteTenant(String id) throws ApiException {
        this.deleteTenantWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteTenantWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.deleteTenantValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTenantAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTenantValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteUserMembershipCall(String id, String userId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tenant/{id}/user-members/{userId}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{userId\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserMembershipValidateBeforeCall(String id, String userId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteUserMembership(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteUserMembership(Async)");
        }
        Call localVarCall = this.deleteUserMembershipCall(id, userId, _callback);
        return localVarCall;
    }

    public void deleteUserMembership(String id, String userId) throws ApiException {
        this.deleteUserMembershipWithHttpInfo(id, userId);
    }

    public ApiResponse<Void> deleteUserMembershipWithHttpInfo(String id, String userId) throws ApiException {
        Call localVarCall = this.deleteUserMembershipValidateBeforeCall(id, userId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteUserMembershipAsync(String id, String userId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserMembershipValidateBeforeCall(id, userId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getTenantCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tenant/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTenantValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTenant(Async)");
        }
        Call localVarCall = this.getTenantCall(id, _callback);
        return localVarCall;
    }

    public TenantDto getTenant(String id) throws ApiException {
        ApiResponse<TenantDto> localVarResp = this.getTenantWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<TenantDto> getTenantWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getTenantValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<TenantDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTenantAsync(String id, ApiCallback<TenantDto> _callback) throws ApiException {
        Call localVarCall = this.getTenantValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<TenantDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTenantCountCall(String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/tenant/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (userMember != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("userMember", userMember));
        }
        if (groupMember != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("groupMember", groupMember));
        }
        if (includingGroupsOfUser != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includingGroupsOfUser", includingGroupsOfUser));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTenantCountValidateBeforeCall(String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTenantCountCall(id, name, nameLike, userMember, groupMember, includingGroupsOfUser, _callback);
        return localVarCall;
    }

    public CountResultDto getTenantCount(String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getTenantCountWithHttpInfo(id, name, nameLike, userMember, groupMember, includingGroupsOfUser);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getTenantCountWithHttpInfo(String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser) throws ApiException {
        Call localVarCall = this.getTenantCountValidateBeforeCall(id, name, nameLike, userMember, groupMember, includingGroupsOfUser, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTenantCountAsync(String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getTenantCountValidateBeforeCall(id, name, nameLike, userMember, groupMember, includingGroupsOfUser, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryTenantsCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/tenant";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (userMember != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("userMember", userMember));
        }
        if (groupMember != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("groupMember", groupMember));
        }
        if (includingGroupsOfUser != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includingGroupsOfUser", includingGroupsOfUser));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryTenantsValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryTenantsCall(sortBy, sortOrder, firstResult, maxResults, id, name, nameLike, userMember, groupMember, includingGroupsOfUser, _callback);
        return localVarCall;
    }

    public List<TenantDto> queryTenants(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser) throws ApiException {
        ApiResponse<List<TenantDto>> localVarResp = this.queryTenantsWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, id, name, nameLike, userMember, groupMember, includingGroupsOfUser);
        return localVarResp.getData();
    }

    public ApiResponse<List<TenantDto>> queryTenantsWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser) throws ApiException {
        Call localVarCall = this.queryTenantsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, id, name, nameLike, userMember, groupMember, includingGroupsOfUser, null);
        Type localVarReturnType = new TypeToken<List<TenantDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryTenantsAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser, ApiCallback<List<TenantDto>> _callback) throws ApiException {
        Call localVarCall = this.queryTenantsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, id, name, nameLike, userMember, groupMember, includingGroupsOfUser, _callback);
        Type localVarReturnType = new TypeToken<List<TenantDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateTenantCall(String id, TenantDto tenantDto, ApiCallback _callback) throws ApiException {
        TenantDto localVarPostBody = tenantDto;
        String localVarPath = "/tenant/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateTenantValidateBeforeCall(String id, TenantDto tenantDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateTenant(Async)");
        }
        Call localVarCall = this.updateTenantCall(id, tenantDto, _callback);
        return localVarCall;
    }

    public void updateTenant(String id, TenantDto tenantDto) throws ApiException {
        this.updateTenantWithHttpInfo(id, tenantDto);
    }

    public ApiResponse<Void> updateTenantWithHttpInfo(String id, TenantDto tenantDto) throws ApiException {
        Call localVarCall = this.updateTenantValidateBeforeCall(id, tenantDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateTenantAsync(String id, TenantDto tenantDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateTenantValidateBeforeCall(id, tenantDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

