/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.VariableValueDto;

public class CompleteExternalTaskDto {
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private Map<String, VariableValueDto> variables = null;
    public static final String SERIALIZED_NAME_LOCAL_VARIABLES = "localVariables";
    @SerializedName(value="localVariables")
    private Map<String, VariableValueDto> localVariables = null;
    public static final String SERIALIZED_NAME_WORKER_ID = "workerId";
    @SerializedName(value="workerId")
    private String workerId;

    public CompleteExternalTaskDto variables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
        return this;
    }

    public CompleteExternalTaskDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, VariableValueDto>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON object containing variable key-value pairs. Each key is a variable name and each value a JSON variable value object with the following properties:")
    public Map<String, VariableValueDto> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
    }

    public CompleteExternalTaskDto localVariables(Map<String, VariableValueDto> localVariables) {
        this.localVariables = localVariables;
        return this;
    }

    public CompleteExternalTaskDto putLocalVariablesItem(String key, VariableValueDto localVariablesItem) {
        if (this.localVariables == null) {
            this.localVariables = new HashMap<String, VariableValueDto>();
        }
        this.localVariables.put(key, localVariablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON object containing local variable key-value pairs. Local variables are set only in the scope of external task. Each key is a variable name and each value a JSON variable value object with the following properties:")
    public Map<String, VariableValueDto> getLocalVariables() {
        return this.localVariables;
    }

    public void setLocalVariables(Map<String, VariableValueDto> localVariables) {
        this.localVariables = localVariables;
    }

    public CompleteExternalTaskDto workerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Mandatory.** The ID of the worker who is performing the operation on the external task. If the task is already locked, must match the id of the worker who has most recently locked the task.")
    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteExternalTaskDto completeExternalTaskDto = (CompleteExternalTaskDto)o;
        return Objects.equals(this.variables, completeExternalTaskDto.variables) && Objects.equals(this.localVariables, completeExternalTaskDto.localVariables) && Objects.equals(this.workerId, completeExternalTaskDto.workerId);
    }

    public int hashCode() {
        return Objects.hash(this.variables, this.localVariables, this.workerId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompleteExternalTaskDto {\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    localVariables: ").append(this.toIndentedString(this.localVariables)).append("\n");
        sb.append("    workerId: ").append(this.toIndentedString(this.workerId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

