/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines by which selection criterion to activate or suspend job definitions. The selection criteria are mutually exclusive and can only be one of: * `processDefinitionId` * `processDefinitionKey`")
public class JobDefinitionsSuspensionStateDtoAllOf {
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_TENANT_ID = "processDefinitionTenantId";
    @SerializedName(value="processDefinitionTenantId")
    private String processDefinitionTenantId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_WITHOUT_TENANT_ID = "processDefinitionWithoutTenantId";
    @SerializedName(value="processDefinitionWithoutTenantId")
    private Boolean processDefinitionWithoutTenantId;

    public JobDefinitionsSuspensionStateDtoAllOf processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process definition id of the job definitions to activate or suspend.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public JobDefinitionsSuspensionStateDtoAllOf processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process definition key of the job definitions to activate or suspend.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public JobDefinitionsSuspensionStateDtoAllOf processDefinitionTenantId(String processDefinitionTenantId) {
        this.processDefinitionTenantId = processDefinitionTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only activate or suspend job definitions of a process definition which belongs to a tenant with the given id.  Note that this parameter will only be considered  in combination with `processDefinitionKey`.")
    public String getProcessDefinitionTenantId() {
        return this.processDefinitionTenantId;
    }

    public void setProcessDefinitionTenantId(String processDefinitionTenantId) {
        this.processDefinitionTenantId = processDefinitionTenantId;
    }

    public JobDefinitionsSuspensionStateDtoAllOf processDefinitionWithoutTenantId(Boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only activate or suspend job definitions of a process definition which belongs to no tenant. Value may only be `true`, as `false` is the default behavior.  Note that this parameter will only be considered  in combination with `processDefinitionKey`.")
    public Boolean getProcessDefinitionWithoutTenantId() {
        return this.processDefinitionWithoutTenantId;
    }

    public void setProcessDefinitionWithoutTenantId(Boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDefinitionsSuspensionStateDtoAllOf jobDefinitionsSuspensionStateDtoAllOf = (JobDefinitionsSuspensionStateDtoAllOf)o;
        return Objects.equals(this.processDefinitionId, jobDefinitionsSuspensionStateDtoAllOf.processDefinitionId) && Objects.equals(this.processDefinitionKey, jobDefinitionsSuspensionStateDtoAllOf.processDefinitionKey) && Objects.equals(this.processDefinitionTenantId, jobDefinitionsSuspensionStateDtoAllOf.processDefinitionTenantId) && Objects.equals(this.processDefinitionWithoutTenantId, jobDefinitionsSuspensionStateDtoAllOf.processDefinitionWithoutTenantId);
    }

    public int hashCode() {
        return Objects.hash(this.processDefinitionId, this.processDefinitionKey, this.processDefinitionTenantId, this.processDefinitionWithoutTenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobDefinitionsSuspensionStateDtoAllOf {\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionTenantId: ").append(this.toIndentedString(this.processDefinitionTenantId)).append("\n");
        sb.append("    processDefinitionWithoutTenantId: ").append(this.toIndentedString(this.processDefinitionWithoutTenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

