/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class JobDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_JOB_DEFINITION_ID = "jobDefinitionId";
    @SerializedName(value="jobDefinitionId")
    private String jobDefinitionId;
    public static final String SERIALIZED_NAME_DUE_DATE = "dueDate";
    @SerializedName(value="dueDate")
    private Date dueDate;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_RETRIES = "retries";
    @SerializedName(value="retries")
    private Integer retries;
    public static final String SERIALIZED_NAME_EXCEPTION_MESSAGE = "exceptionMessage";
    @SerializedName(value="exceptionMessage")
    private String exceptionMessage;
    public static final String SERIALIZED_NAME_FAILED_ACTIVITY_ID = "failedActivityId";
    @SerializedName(value="failedActivityId")
    private String failedActivityId;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private Long priority;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_CREATE_TIME = "createTime";
    @SerializedName(value="createTime")
    private Date createTime;

    public JobDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the job.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JobDto jobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the associated job definition.")
    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public JobDto dueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date on which this job is supposed to be processed.")
    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public JobDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance which execution created the job.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public JobDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The specific execution id on which the job was created.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public JobDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition which this job belongs to.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public JobDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definition which this job belongs to.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public JobDto retries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of retries this job has left.")
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public JobDto exceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The message of the exception that occurred, the last time the job was executed. Is null when no exception occurred.")
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public JobDto failedActivityId(String failedActivityId) {
        this.failedActivityId = failedActivityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity on which the last exception occurred, the last time the job was executed. Is null when no exception occurred.")
    public String getFailedActivityId() {
        return this.failedActivityId;
    }

    public void setFailedActivityId(String failedActivityId) {
        this.failedActivityId = failedActivityId;
    }

    public JobDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flag indicating whether the job is suspended or not.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public JobDto priority(Long priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The job's priority for execution.")
    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public JobDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the tenant which this job belongs to.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public JobDto createTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date on which this job has been created.")
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDto jobDto = (JobDto)o;
        return Objects.equals(this.id, jobDto.id) && Objects.equals(this.jobDefinitionId, jobDto.jobDefinitionId) && Objects.equals(this.dueDate, jobDto.dueDate) && Objects.equals(this.processInstanceId, jobDto.processInstanceId) && Objects.equals(this.executionId, jobDto.executionId) && Objects.equals(this.processDefinitionId, jobDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, jobDto.processDefinitionKey) && Objects.equals(this.retries, jobDto.retries) && Objects.equals(this.exceptionMessage, jobDto.exceptionMessage) && Objects.equals(this.failedActivityId, jobDto.failedActivityId) && Objects.equals(this.suspended, jobDto.suspended) && Objects.equals(this.priority, jobDto.priority) && Objects.equals(this.tenantId, jobDto.tenantId) && Objects.equals(this.createTime, jobDto.createTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jobDefinitionId, this.dueDate, this.processInstanceId, this.executionId, this.processDefinitionId, this.processDefinitionKey, this.retries, this.exceptionMessage, this.failedActivityId, this.suspended, this.priority, this.tenantId, this.createTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    jobDefinitionId: ").append(this.toIndentedString(this.jobDefinitionId)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("    exceptionMessage: ").append(this.toIndentedString(this.exceptionMessage)).append("\n");
        sb.append("    failedActivityId: ").append(this.toIndentedString(this.failedActivityId)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    createTime: ").append(this.toIndentedString(this.createTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

