/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ProblemDto {
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_LINE = "line";
    @SerializedName(value="line")
    private Integer line;
    public static final String SERIALIZED_NAME_COLUMN = "column";
    @SerializedName(value="column")
    private Integer column;
    public static final String SERIALIZED_NAME_MAIN_ELEMENT_ID = "mainElementId";
    @SerializedName(value="mainElementId")
    private String mainElementId;
    public static final String SERIALIZED_NAME_ELEMENT_IDS = "elementIds";
    @SerializedName(value="elementIds")
    private List<String> elementIds = null;

    public ProblemDto message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The message of the problem.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ProblemDto line(Integer line) {
        this.line = line;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The line where the problem occurred.")
    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public ProblemDto column(Integer column) {
        this.column = column;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The column where the problem occurred.")
    public Integer getColumn() {
        return this.column;
    }

    public void setColumn(Integer column) {
        this.column = column;
    }

    public ProblemDto mainElementId(String mainElementId) {
        this.mainElementId = mainElementId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The main element id where the problem occurred.")
    public String getMainElementId() {
        return this.mainElementId;
    }

    public void setMainElementId(String mainElementId) {
        this.mainElementId = mainElementId;
    }

    public ProblemDto elementIds(List<String> elementIds) {
        this.elementIds = elementIds;
        return this;
    }

    public ProblemDto addElementIdsItem(String elementIdsItem) {
        if (this.elementIds == null) {
            this.elementIds = new ArrayList<String>();
        }
        this.elementIds.add(elementIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of element id affected by the problem.")
    public List<String> getElementIds() {
        return this.elementIds;
    }

    public void setElementIds(List<String> elementIds) {
        this.elementIds = elementIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProblemDto problemDto = (ProblemDto)o;
        return Objects.equals(this.message, problemDto.message) && Objects.equals(this.line, problemDto.line) && Objects.equals(this.column, problemDto.column) && Objects.equals(this.mainElementId, problemDto.mainElementId) && Objects.equals(this.elementIds, problemDto.elementIds);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.line, this.column, this.mainElementId, this.elementIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProblemDto {\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    line: ").append(this.toIndentedString(this.line)).append("\n");
        sb.append("    column: ").append(this.toIndentedString(this.column)).append("\n");
        sb.append("    mainElementId: ").append(this.toIndentedString(this.mainElementId)).append("\n");
        sb.append("    elementIds: ").append(this.toIndentedString(this.elementIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

