/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.JobQueryDto;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDto;

public class SetJobRetriesByProcessDto {
    public static final String SERIALIZED_NAME_PROCESS_INSTANCES = "processInstances";
    @SerializedName(value="processInstances")
    private List<String> processInstances = null;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_QUERY = "processInstanceQuery";
    @SerializedName(value="processInstanceQuery")
    private ProcessInstanceQueryDto processInstanceQuery;
    public static final String SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_QUERY = "historicProcessInstanceQuery";
    @SerializedName(value="historicProcessInstanceQuery")
    private HistoricProcessInstanceQueryDto historicProcessInstanceQuery;
    public static final String SERIALIZED_NAME_JOB_IDS = "jobIds";
    @SerializedName(value="jobIds")
    private List<String> jobIds = null;
    public static final String SERIALIZED_NAME_JOB_QUERY = "jobQuery";
    @SerializedName(value="jobQuery")
    private JobQueryDto jobQuery;
    public static final String SERIALIZED_NAME_DUE_DATE = "dueDate";
    @SerializedName(value="dueDate")
    private Date dueDate;
    public static final String SERIALIZED_NAME_RETRIES = "retries";
    @SerializedName(value="retries")
    private Integer retries;

    public SetJobRetriesByProcessDto processInstances(List<String> processInstances) {
        this.processInstances = processInstances;
        return this;
    }

    public SetJobRetriesByProcessDto addProcessInstancesItem(String processInstancesItem) {
        if (this.processInstances == null) {
            this.processInstances = new ArrayList<String>();
        }
        this.processInstances.add(processInstancesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of process instance ids to fetch jobs, for which retries will be set.")
    public List<String> getProcessInstances() {
        return this.processInstances;
    }

    public void setProcessInstances(List<String> processInstances) {
        this.processInstances = processInstances;
    }

    public SetJobRetriesByProcessDto processInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProcessInstanceQueryDto getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    public void setProcessInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
    }

    public SetJobRetriesByProcessDto historicProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }

    public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    }

    public SetJobRetriesByProcessDto jobIds(List<String> jobIds) {
        this.jobIds = jobIds;
        return this;
    }

    public SetJobRetriesByProcessDto addJobIdsItem(String jobIdsItem) {
        if (this.jobIds == null) {
            this.jobIds = new ArrayList<String>();
        }
        this.jobIds.add(jobIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of job ids to set retries for.")
    public List<String> getJobIds() {
        return this.jobIds;
    }

    public void setJobIds(List<String> jobIds) {
        this.jobIds = jobIds;
    }

    public SetJobRetriesByProcessDto jobQuery(JobQueryDto jobQuery) {
        this.jobQuery = jobQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public JobQueryDto getJobQuery() {
        return this.jobQuery;
    }

    public void setJobQuery(JobQueryDto jobQuery) {
        this.jobQuery = jobQuery;
    }

    public SetJobRetriesByProcessDto dueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The due date to set for the job. A due date indicates when this job is ready for execution. Jobs with due dates in the past will be scheduled for execution.")
    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public SetJobRetriesByProcessDto retries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of retries to set for the resource.  Must be >= 0. If this is 0, an incident is created and the task, or job, cannot be fetched, or acquired anymore unless the retries are increased again. Can not be null.")
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetJobRetriesByProcessDto setJobRetriesByProcessDto = (SetJobRetriesByProcessDto)o;
        return Objects.equals(this.processInstances, setJobRetriesByProcessDto.processInstances) && Objects.equals(this.processInstanceQuery, setJobRetriesByProcessDto.processInstanceQuery) && Objects.equals(this.historicProcessInstanceQuery, setJobRetriesByProcessDto.historicProcessInstanceQuery) && Objects.equals(this.jobIds, setJobRetriesByProcessDto.jobIds) && Objects.equals(this.jobQuery, setJobRetriesByProcessDto.jobQuery) && Objects.equals(this.dueDate, setJobRetriesByProcessDto.dueDate) && Objects.equals(this.retries, setJobRetriesByProcessDto.retries);
    }

    public int hashCode() {
        return Objects.hash(this.processInstances, this.processInstanceQuery, this.historicProcessInstanceQuery, this.jobIds, this.jobQuery, this.dueDate, this.retries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetJobRetriesByProcessDto {\n");
        sb.append("    processInstances: ").append(this.toIndentedString(this.processInstances)).append("\n");
        sb.append("    processInstanceQuery: ").append(this.toIndentedString(this.processInstanceQuery)).append("\n");
        sb.append("    historicProcessInstanceQuery: ").append(this.toIndentedString(this.historicProcessInstanceQuery)).append("\n");
        sb.append("    jobIds: ").append(this.toIndentedString(this.jobIds)).append("\n");
        sb.append("    jobQuery: ").append(this.toIndentedString(this.jobQuery)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

