/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricDecisionInstanceQueryDto;

public class SetRemovalTimeToHistoricDecisionInstancesDto {
    public static final String SERIALIZED_NAME_HIERARCHICAL = "hierarchical";
    @SerializedName(value="hierarchical")
    private Boolean hierarchical;
    public static final String SERIALIZED_NAME_HISTORIC_DECISION_INSTANCE_QUERY = "historicDecisionInstanceQuery";
    @SerializedName(value="historicDecisionInstanceQuery")
    private HistoricDecisionInstanceQueryDto historicDecisionInstanceQuery;
    public static final String SERIALIZED_NAME_HISTORIC_DECISION_INSTANCE_IDS = "historicDecisionInstanceIds";
    @SerializedName(value="historicDecisionInstanceIds")
    private List<String> historicDecisionInstanceIds = null;
    public static final String SERIALIZED_NAME_ABSOLUTE_REMOVAL_TIME = "absoluteRemovalTime";
    @SerializedName(value="absoluteRemovalTime")
    private Date absoluteRemovalTime;
    public static final String SERIALIZED_NAME_CLEARED_REMOVAL_TIME = "clearedRemovalTime";
    @SerializedName(value="clearedRemovalTime")
    private Boolean clearedRemovalTime;
    public static final String SERIALIZED_NAME_CALCULATED_REMOVAL_TIME = "calculatedRemovalTime";
    @SerializedName(value="calculatedRemovalTime")
    private Boolean calculatedRemovalTime;

    public SetRemovalTimeToHistoricDecisionInstancesDto hierarchical(Boolean hierarchical) {
        this.hierarchical = hierarchical;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sets the removal time to all historic decision instances in the hierarchy. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getHierarchical() {
        return this.hierarchical;
    }

    public void setHierarchical(Boolean hierarchical) {
        this.hierarchical = hierarchical;
    }

    public SetRemovalTimeToHistoricDecisionInstancesDto historicDecisionInstanceQuery(HistoricDecisionInstanceQueryDto historicDecisionInstanceQuery) {
        this.historicDecisionInstanceQuery = historicDecisionInstanceQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public HistoricDecisionInstanceQueryDto getHistoricDecisionInstanceQuery() {
        return this.historicDecisionInstanceQuery;
    }

    public void setHistoricDecisionInstanceQuery(HistoricDecisionInstanceQueryDto historicDecisionInstanceQuery) {
        this.historicDecisionInstanceQuery = historicDecisionInstanceQuery;
    }

    public SetRemovalTimeToHistoricDecisionInstancesDto historicDecisionInstanceIds(List<String> historicDecisionInstanceIds) {
        this.historicDecisionInstanceIds = historicDecisionInstanceIds;
        return this;
    }

    public SetRemovalTimeToHistoricDecisionInstancesDto addHistoricDecisionInstanceIdsItem(String historicDecisionInstanceIdsItem) {
        if (this.historicDecisionInstanceIds == null) {
            this.historicDecisionInstanceIds = new ArrayList<String>();
        }
        this.historicDecisionInstanceIds.add(historicDecisionInstanceIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ids of the historic decision instances to set the removal time for.")
    public List<String> getHistoricDecisionInstanceIds() {
        return this.historicDecisionInstanceIds;
    }

    public void setHistoricDecisionInstanceIds(List<String> historicDecisionInstanceIds) {
        this.historicDecisionInstanceIds = historicDecisionInstanceIds;
    }

    public SetRemovalTimeToHistoricDecisionInstancesDto absoluteRemovalTime(Date absoluteRemovalTime) {
        this.absoluteRemovalTime = absoluteRemovalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date for which the instances shall be removed. Value may not be `null`.  **Note:** Cannot be set in conjunction with `clearedRemovalTime` or `calculatedRemovalTime`.")
    public Date getAbsoluteRemovalTime() {
        return this.absoluteRemovalTime;
    }

    public void setAbsoluteRemovalTime(Date absoluteRemovalTime) {
        this.absoluteRemovalTime = absoluteRemovalTime;
    }

    public SetRemovalTimeToHistoricDecisionInstancesDto clearedRemovalTime(Boolean clearedRemovalTime) {
        this.clearedRemovalTime = clearedRemovalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sets the removal time to `null`. Value may only be `true`, as `false` is the default behavior.  **Note:** Cannot be set in conjunction with `absoluteRemovalTime` or `calculatedRemovalTime`.")
    public Boolean getClearedRemovalTime() {
        return this.clearedRemovalTime;
    }

    public void setClearedRemovalTime(Boolean clearedRemovalTime) {
        this.clearedRemovalTime = clearedRemovalTime;
    }

    public SetRemovalTimeToHistoricDecisionInstancesDto calculatedRemovalTime(Boolean calculatedRemovalTime) {
        this.calculatedRemovalTime = calculatedRemovalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The removal time is calculated based on the engine's configuration settings. Value may only be `true`, as `false` is the default behavior.  **Note:** Cannot be set in conjunction with `absoluteRemovalTime` or `clearedRemovalTime`.")
    public Boolean getCalculatedRemovalTime() {
        return this.calculatedRemovalTime;
    }

    public void setCalculatedRemovalTime(Boolean calculatedRemovalTime) {
        this.calculatedRemovalTime = calculatedRemovalTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetRemovalTimeToHistoricDecisionInstancesDto setRemovalTimeToHistoricDecisionInstancesDto = (SetRemovalTimeToHistoricDecisionInstancesDto)o;
        return Objects.equals(this.hierarchical, setRemovalTimeToHistoricDecisionInstancesDto.hierarchical) && Objects.equals(this.historicDecisionInstanceQuery, setRemovalTimeToHistoricDecisionInstancesDto.historicDecisionInstanceQuery) && Objects.equals(this.historicDecisionInstanceIds, setRemovalTimeToHistoricDecisionInstancesDto.historicDecisionInstanceIds) && Objects.equals(this.absoluteRemovalTime, setRemovalTimeToHistoricDecisionInstancesDto.absoluteRemovalTime) && Objects.equals(this.clearedRemovalTime, setRemovalTimeToHistoricDecisionInstancesDto.clearedRemovalTime) && Objects.equals(this.calculatedRemovalTime, setRemovalTimeToHistoricDecisionInstancesDto.calculatedRemovalTime);
    }

    public int hashCode() {
        return Objects.hash(this.hierarchical, this.historicDecisionInstanceQuery, this.historicDecisionInstanceIds, this.absoluteRemovalTime, this.clearedRemovalTime, this.calculatedRemovalTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetRemovalTimeToHistoricDecisionInstancesDto {\n");
        sb.append("    hierarchical: ").append(this.toIndentedString(this.hierarchical)).append("\n");
        sb.append("    historicDecisionInstanceQuery: ").append(this.toIndentedString(this.historicDecisionInstanceQuery)).append("\n");
        sb.append("    historicDecisionInstanceIds: ").append(this.toIndentedString(this.historicDecisionInstanceIds)).append("\n");
        sb.append("    absoluteRemovalTime: ").append(this.toIndentedString(this.absoluteRemovalTime)).append("\n");
        sb.append("    clearedRemovalTime: ").append(this.toIndentedString(this.clearedRemovalTime)).append("\n");
        sb.append("    calculatedRemovalTime: ").append(this.toIndentedString(this.calculatedRemovalTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

