/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.AuthorizationCheckResultDto;
import org.camunda.community.rest.client.dto.AuthorizationCreateDto;
import org.camunda.community.rest.client.dto.AuthorizationDto;
import org.camunda.community.rest.client.dto.AuthorizationUpdateDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.ResourceOptionsDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class AuthorizationApi {


  private ApiClient apiClient;

  public AuthorizationApi() {
    this(Configuration.getDefaultApiClient());
  }

  public AuthorizationApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Authorization Resource Options
   * The OPTIONS request allows you to check for the set of available operations that the currently authenticated user can perform on the &#x60;/authorization&#x60; resource. Whether the user can perform an operation or not may depend on various factors, including the users authorizations to interact with this resource and the internal configuration of the process engine.
   * @return ResourceOptionsDto
   * @throws ApiException if fails to make API call
   */
  public ResourceOptionsDto availableOperationsAuthorization() throws ApiException {
    return this.availableOperationsAuthorization(Collections.emptyMap());
  }


  /**
   * Authorization Resource Options
   * The OPTIONS request allows you to check for the set of available operations that the currently authenticated user can perform on the &#x60;/authorization&#x60; resource. Whether the user can perform an operation or not may depend on various factors, including the users authorizations to interact with this resource and the internal configuration of the process engine.
   * @param additionalHeaders additionalHeaders for this call
   * @return ResourceOptionsDto
   * @throws ApiException if fails to make API call
   */
  public ResourceOptionsDto availableOperationsAuthorization(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/authorization";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<ResourceOptionsDto> localVarReturnType = new TypeReference<ResourceOptionsDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "OPTIONS",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Authorization Resource Options
   * The OPTIONS request allows you to check for the set of available operations that the currently authenticated user can perform on a given instance of the &#x60;/authorization&#x60; resource. Whether the user can perform an operation or not may depend on various factors, including the users authorizations to interact with this resource and the internal configuration of the process engine.
   * @param id The id of the authorization to be retrieved. (required)
   * @return ResourceOptionsDto
   * @throws ApiException if fails to make API call
   */
  public ResourceOptionsDto availableOperationsAuthorizationInstance(String id) throws ApiException {
    return this.availableOperationsAuthorizationInstance(id, Collections.emptyMap());
  }


  /**
   * Authorization Resource Options
   * The OPTIONS request allows you to check for the set of available operations that the currently authenticated user can perform on a given instance of the &#x60;/authorization&#x60; resource. Whether the user can perform an operation or not may depend on various factors, including the users authorizations to interact with this resource and the internal configuration of the process engine.
   * @param id The id of the authorization to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return ResourceOptionsDto
   * @throws ApiException if fails to make API call
   */
  public ResourceOptionsDto availableOperationsAuthorizationInstance(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling availableOperationsAuthorizationInstance");
    }
    
    // create path and map variables
    String localVarPath = "/authorization/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<ResourceOptionsDto> localVarReturnType = new TypeReference<ResourceOptionsDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "OPTIONS",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create a New Authorization
   * Creates a new authorization.
   * @param authorizationCreateDto  (optional)
   * @return AuthorizationDto
   * @throws ApiException if fails to make API call
   */
  public AuthorizationDto createAuthorization(AuthorizationCreateDto authorizationCreateDto) throws ApiException {
    return this.createAuthorization(authorizationCreateDto, Collections.emptyMap());
  }


  /**
   * Create a New Authorization
   * Creates a new authorization.
   * @param authorizationCreateDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return AuthorizationDto
   * @throws ApiException if fails to make API call
   */
  public AuthorizationDto createAuthorization(AuthorizationCreateDto authorizationCreateDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = authorizationCreateDto;
    
    // create path and map variables
    String localVarPath = "/authorization/create";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<AuthorizationDto> localVarReturnType = new TypeReference<AuthorizationDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete Authorization
   * Deletes an authorization by id.
   * @param id The id of the authorization to be deleted. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteAuthorization(String id) throws ApiException {
    this.deleteAuthorization(id, Collections.emptyMap());
  }


  /**
   * Delete Authorization
   * Deletes an authorization by id.
   * @param id The id of the authorization to be deleted. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteAuthorization(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteAuthorization");
    }
    
    // create path and map variables
    String localVarPath = "/authorization/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get Authorization
   * Retrieves an authorization by id.
   * @param id The id of the authorization to be retrieved. (required)
   * @return AuthorizationDto
   * @throws ApiException if fails to make API call
   */
  public AuthorizationDto getAuthorization(String id) throws ApiException {
    return this.getAuthorization(id, Collections.emptyMap());
  }


  /**
   * Get Authorization
   * Retrieves an authorization by id.
   * @param id The id of the authorization to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return AuthorizationDto
   * @throws ApiException if fails to make API call
   */
  public AuthorizationDto getAuthorization(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getAuthorization");
    }
    
    // create path and map variables
    String localVarPath = "/authorization/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<AuthorizationDto> localVarReturnType = new TypeReference<AuthorizationDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Authorization Count
   * Queries for authorizations using a list of parameters and retrieves the count.
   * @param id Filter by the id of the authorization. (optional)
   * @param type Filter by authorization type. (0&#x3D;global, 1&#x3D;grant, 2&#x3D;revoke). See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service/#authorization-type) for more information about authorization types. (optional)
   * @param userIdIn Filter by a comma-separated list of userIds. (optional)
   * @param groupIdIn Filter by a comma-separated list of groupIds. (optional)
   * @param resourceType Filter by an integer representation of the resource type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types. (optional)
   * @param resourceId Filter by resource id. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getAuthorizationCount(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId) throws ApiException {
    return this.getAuthorizationCount(id, type, userIdIn, groupIdIn, resourceType, resourceId, Collections.emptyMap());
  }


  /**
   * Get Authorization Count
   * Queries for authorizations using a list of parameters and retrieves the count.
   * @param id Filter by the id of the authorization. (optional)
   * @param type Filter by authorization type. (0&#x3D;global, 1&#x3D;grant, 2&#x3D;revoke). See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service/#authorization-type) for more information about authorization types. (optional)
   * @param userIdIn Filter by a comma-separated list of userIds. (optional)
   * @param groupIdIn Filter by a comma-separated list of groupIds. (optional)
   * @param resourceType Filter by an integer representation of the resource type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types. (optional)
   * @param resourceId Filter by resource id. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getAuthorizationCount(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/authorization/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("id", id));
    localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
    localVarQueryParams.addAll(apiClient.parameterToPair("userIdIn", userIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("groupIdIn", groupIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceType", resourceType));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceId", resourceId));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Perform an Authorization Check
   * Performs an authorization check for the currently authenticated user.
   * @param permissionName String value representing the permission name to check for. (required)
   * @param resourceName String value for the name of the resource to check permissions for. (required)
   * @param resourceType An integer representing the resource type to check permissions for. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types. (required)
   * @param resourceId The id of the resource to check permissions for. If left blank, a check for global permissions on the resource is performed. (optional)
   * @param userId The id of the user to check permissions for. The currently authenticated user must have a READ permission for the Authorization resource. If &#x60;userId&#x60; is blank, a check for the currently authenticated user is performed. (optional)
   * @return AuthorizationCheckResultDto
   * @throws ApiException if fails to make API call
   */
  public AuthorizationCheckResultDto isUserAuthorized(String permissionName, String resourceName, Integer resourceType, String resourceId, String userId) throws ApiException {
    return this.isUserAuthorized(permissionName, resourceName, resourceType, resourceId, userId, Collections.emptyMap());
  }


  /**
   * Perform an Authorization Check
   * Performs an authorization check for the currently authenticated user.
   * @param permissionName String value representing the permission name to check for. (required)
   * @param resourceName String value for the name of the resource to check permissions for. (required)
   * @param resourceType An integer representing the resource type to check permissions for. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types. (required)
   * @param resourceId The id of the resource to check permissions for. If left blank, a check for global permissions on the resource is performed. (optional)
   * @param userId The id of the user to check permissions for. The currently authenticated user must have a READ permission for the Authorization resource. If &#x60;userId&#x60; is blank, a check for the currently authenticated user is performed. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return AuthorizationCheckResultDto
   * @throws ApiException if fails to make API call
   */
  public AuthorizationCheckResultDto isUserAuthorized(String permissionName, String resourceName, Integer resourceType, String resourceId, String userId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'permissionName' is set
    if (permissionName == null) {
      throw new ApiException(400, "Missing the required parameter 'permissionName' when calling isUserAuthorized");
    }
    
    // verify the required parameter 'resourceName' is set
    if (resourceName == null) {
      throw new ApiException(400, "Missing the required parameter 'resourceName' when calling isUserAuthorized");
    }
    
    // verify the required parameter 'resourceType' is set
    if (resourceType == null) {
      throw new ApiException(400, "Missing the required parameter 'resourceType' when calling isUserAuthorized");
    }
    
    // create path and map variables
    String localVarPath = "/authorization/check";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("permissionName", permissionName));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceName", resourceName));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceType", resourceType));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceId", resourceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("userId", userId));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<AuthorizationCheckResultDto> localVarReturnType = new TypeReference<AuthorizationCheckResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Authorizations
   * Queries for a list of authorizations using a list of parameters. The size of the result set can be retrieved by using the [Get Authorization Count](https://docs.camunda.org/manual/7.21/reference/rest/authorization/get-query-count/) method.
   * @param id Filter by the id of the authorization. (optional)
   * @param type Filter by authorization type. (0&#x3D;global, 1&#x3D;grant, 2&#x3D;revoke). See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service/#authorization-type) for more information about authorization types. (optional)
   * @param userIdIn Filter by a comma-separated list of userIds. (optional)
   * @param groupIdIn Filter by a comma-separated list of groupIds. (optional)
   * @param resourceType Filter by an integer representation of the resource type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types. (optional)
   * @param resourceId Filter by resource id. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;AuthorizationDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<AuthorizationDto> queryAuthorizations(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.queryAuthorizations(id, type, userIdIn, groupIdIn, resourceType, resourceId, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get Authorizations
   * Queries for a list of authorizations using a list of parameters. The size of the result set can be retrieved by using the [Get Authorization Count](https://docs.camunda.org/manual/7.21/reference/rest/authorization/get-query-count/) method.
   * @param id Filter by the id of the authorization. (optional)
   * @param type Filter by authorization type. (0&#x3D;global, 1&#x3D;grant, 2&#x3D;revoke). See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service/#authorization-type) for more information about authorization types. (optional)
   * @param userIdIn Filter by a comma-separated list of userIds. (optional)
   * @param groupIdIn Filter by a comma-separated list of groupIds. (optional)
   * @param resourceType Filter by an integer representation of the resource type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types. (optional)
   * @param resourceId Filter by resource id. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;AuthorizationDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<AuthorizationDto> queryAuthorizations(String id, Integer type, String userIdIn, String groupIdIn, Integer resourceType, String resourceId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/authorization";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("id", id));
    localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
    localVarQueryParams.addAll(apiClient.parameterToPair("userIdIn", userIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("groupIdIn", groupIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceType", resourceType));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceId", resourceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<AuthorizationDto>> localVarReturnType = new TypeReference<List<AuthorizationDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update an Authorization
   * Updates an authorization by id.
   * @param id The id of the authorization to be updated. (required)
   * @param authorizationUpdateDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateAuthorization(String id, AuthorizationUpdateDto authorizationUpdateDto) throws ApiException {
    this.updateAuthorization(id, authorizationUpdateDto, Collections.emptyMap());
  }


  /**
   * Update an Authorization
   * Updates an authorization by id.
   * @param id The id of the authorization to be updated. (required)
   * @param authorizationUpdateDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateAuthorization(String id, AuthorizationUpdateDto authorizationUpdateDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = authorizationUpdateDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling updateAuthorization");
    }
    
    // create path and map variables
    String localVarPath = "/authorization/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

}
