/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.BatchStatisticsDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import java.time.OffsetDateTime;
import org.camunda.community.rest.client.dto.SuspensionStateDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class BatchApi {


  private ApiClient apiClient;

  public BatchApi() {
    this(Configuration.getDefaultApiClient());
  }

  public BatchApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Delete
   * Deletes a batch by id, including all related jobs and job definitions. Optionally also deletes the batch history.
   * @param id The id of the batch to be deleted. (required)
   * @param cascade &#x60;true&#x60;, if the historic batch and historic job logs for this batch should also be deleted. (optional)
   * @throws ApiException if fails to make API call
   */
  public void deleteBatch(String id, Boolean cascade) throws ApiException {
    this.deleteBatch(id, cascade, Collections.emptyMap());
  }


  /**
   * Delete
   * Deletes a batch by id, including all related jobs and job definitions. Optionally also deletes the batch history.
   * @param id The id of the batch to be deleted. (required)
   * @param cascade &#x60;true&#x60;, if the historic batch and historic job logs for this batch should also be deleted. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteBatch(String id, Boolean cascade, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteBatch");
    }
    
    // create path and map variables
    String localVarPath = "/batch/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("cascade", cascade));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get
   * Retrieves a batch by id, according to the Batch interface in the engine.
   * @param id The id of the batch to be retrieved. (required)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto getBatch(String id) throws ApiException {
    return this.getBatch(id, Collections.emptyMap());
  }


  /**
   * Get
   * Retrieves a batch by id, according to the Batch interface in the engine.
   * @param id The id of the batch to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto getBatch(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getBatch");
    }
    
    // create path and map variables
    String localVarPath = "/batch/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Statistics
   * Queries for batch statistics that fulfill given parameters. Parameters may be the properties of batches, such as the id or type. The size of the result set can be retrieved by using the  [Get Batch Statistics Count](https://docs.camunda.org/manual/7.21/reference/rest/batch/get-statistics-query-count/) method.
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param batchId Filter by batch id. (optional)
   * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
   * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
   * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
   * @param createdBy Only include batches that were started by this user id. (optional)
   * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
   * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
   * @return List&lt;BatchStatisticsDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<BatchStatisticsDto> getBatchStatistics(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
    return this.getBatchStatistics(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, Collections.emptyMap());
  }


  /**
   * Get Statistics
   * Queries for batch statistics that fulfill given parameters. Parameters may be the properties of batches, such as the id or type. The size of the result set can be retrieved by using the  [Get Batch Statistics Count](https://docs.camunda.org/manual/7.21/reference/rest/batch/get-statistics-query-count/) method.
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param batchId Filter by batch id. (optional)
   * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
   * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
   * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
   * @param createdBy Only include batches that were started by this user id. (optional)
   * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
   * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;BatchStatisticsDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<BatchStatisticsDto> getBatchStatistics(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/batch/statistics";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    localVarQueryParams.addAll(apiClient.parameterToPair("batchId", batchId));
    localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("createdBy", createdBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedBefore", startedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedAfter", startedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("withFailures", withFailures));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutFailures", withoutFailures));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<BatchStatisticsDto>> localVarReturnType = new TypeReference<List<BatchStatisticsDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Statistics Count
   * Requests the number of batch statistics that fulfill the query criteria. Takes the same filtering parameters as the [Get Batch Statistics](https://docs.camunda.org/manual/7.21/reference/rest/batch/get-statistics-query/) method.
   * @param batchId Filter by batch id. (optional)
   * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
   * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
   * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
   * @param createdBy Only include batches that were started by this user id. (optional)
   * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
   * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getBatchStatisticsCount(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
    return this.getBatchStatisticsCount(batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, Collections.emptyMap());
  }


  /**
   * Get Statistics Count
   * Requests the number of batch statistics that fulfill the query criteria. Takes the same filtering parameters as the [Get Batch Statistics](https://docs.camunda.org/manual/7.21/reference/rest/batch/get-statistics-query/) method.
   * @param batchId Filter by batch id. (optional)
   * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
   * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
   * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
   * @param createdBy Only include batches that were started by this user id. (optional)
   * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
   * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getBatchStatisticsCount(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/batch/statistics/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("batchId", batchId));
    localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("createdBy", createdBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedBefore", startedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedAfter", startedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("withFailures", withFailures));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutFailures", withoutFailures));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List
   * Queries for batches that fulfill given parameters. Parameters may be the properties of batches, such as the id or type. The size of the result set can be retrieved by using the [Get Batch Count](https://docs.camunda.org/manual/7.21/reference/rest/batch/get-query-count/) method.
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param batchId Filter by batch id. (optional)
   * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
   * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
   * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
   * @param createdBy Only include batches that were started by this user id. (optional)
   * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
   * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
   * @return List&lt;BatchDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<BatchDto> getBatches(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
    return this.getBatches(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, Collections.emptyMap());
  }


  /**
   * Get List
   * Queries for batches that fulfill given parameters. Parameters may be the properties of batches, such as the id or type. The size of the result set can be retrieved by using the [Get Batch Count](https://docs.camunda.org/manual/7.21/reference/rest/batch/get-query-count/) method.
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param batchId Filter by batch id. (optional)
   * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
   * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
   * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
   * @param createdBy Only include batches that were started by this user id. (optional)
   * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
   * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;BatchDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<BatchDto> getBatches(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/batch";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    localVarQueryParams.addAll(apiClient.parameterToPair("batchId", batchId));
    localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("createdBy", createdBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedBefore", startedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedAfter", startedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("withFailures", withFailures));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutFailures", withoutFailures));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<BatchDto>> localVarReturnType = new TypeReference<List<BatchDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List Count
   * Requests the number of batches that fulfill the query criteria. Takes the same filtering parameters as the [Get Batches](https://docs.camunda.org/manual/7.21/reference/rest/batch/get-query/) method.
   * @param batchId Filter by batch id. (optional)
   * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
   * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
   * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
   * @param createdBy Only include batches that were started by this user id. (optional)
   * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
   * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getBatchesCount(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
    return this.getBatchesCount(batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, Collections.emptyMap());
  }


  /**
   * Get List Count
   * Requests the number of batches that fulfill the query criteria. Takes the same filtering parameters as the [Get Batches](https://docs.camunda.org/manual/7.21/reference/rest/batch/get-query/) method.
   * @param batchId Filter by batch id. (optional)
   * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
   * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
   * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
   * @param createdBy Only include batches that were started by this user id. (optional)
   * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
   * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getBatchesCount(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/batch/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("batchId", batchId));
    localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("createdBy", createdBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedBefore", startedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedAfter", startedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("withFailures", withFailures));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutFailures", withoutFailures));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Activate/Suspend
   * Activates or suspends a batch by id.
   * @param id The id of the batch to activate or suspend. (required)
   * @param suspensionStateDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateBatchSuspensionState(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
    this.updateBatchSuspensionState(id, suspensionStateDto, Collections.emptyMap());
  }


  /**
   * Activate/Suspend
   * Activates or suspends a batch by id.
   * @param id The id of the batch to activate or suspend. (required)
   * @param suspensionStateDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateBatchSuspensionState(String id, SuspensionStateDto suspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = suspensionStateDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling updateBatchSuspensionState");
    }
    
    // create path and map variables
    String localVarPath = "/batch/{id}/suspended"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

}
