/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.DecisionDefinitionDiagramDto;
import org.camunda.community.rest.client.dto.DecisionDefinitionDto;
import org.camunda.community.rest.client.dto.EvaluateDecisionDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import java.io.File;
import org.camunda.community.rest.client.dto.HistoryTimeToLiveDto;
import java.time.OffsetDateTime;
import org.camunda.community.rest.client.dto.VariableValueDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class DecisionDefinitionApi {


  private ApiClient apiClient;

  public DecisionDefinitionApi() {
    this(Configuration.getDefaultApiClient());
  }

  public DecisionDefinitionApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Evaluate By Id
   * Evaluates a given decision and returns the result. The input values of the decision have to be supplied in the request body.
   * @param id The id of the decision definition to be evaluated. (required)
   * @param evaluateDecisionDto  (optional)
   * @return List&lt;Map&lt;String, VariableValueDto&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public List<Map<String, VariableValueDto>> evaluateDecisionById(String id, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
    return this.evaluateDecisionById(id, evaluateDecisionDto, Collections.emptyMap());
  }


  /**
   * Evaluate By Id
   * Evaluates a given decision and returns the result. The input values of the decision have to be supplied in the request body.
   * @param id The id of the decision definition to be evaluated. (required)
   * @param evaluateDecisionDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;Map&lt;String, VariableValueDto&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public List<Map<String, VariableValueDto>> evaluateDecisionById(String id, EvaluateDecisionDto evaluateDecisionDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = evaluateDecisionDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling evaluateDecisionById");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/{id}/evaluate"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<Map<String, VariableValueDto>>> localVarReturnType = new TypeReference<List<Map<String, VariableValueDto>>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Evaluate By Key
   * Evaluates the latest version of the decision definition which belongs to no tenant. The input values of the decision have to be supplied in the request body.
   * @param key The key of the decision definition (the latest version thereof) to be evaluated. (required)
   * @param evaluateDecisionDto  (optional)
   * @return List&lt;Map&lt;String, VariableValueDto&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public List<Map<String, VariableValueDto>> evaluateDecisionByKey(String key, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
    return this.evaluateDecisionByKey(key, evaluateDecisionDto, Collections.emptyMap());
  }


  /**
   * Evaluate By Key
   * Evaluates the latest version of the decision definition which belongs to no tenant. The input values of the decision have to be supplied in the request body.
   * @param key The key of the decision definition (the latest version thereof) to be evaluated. (required)
   * @param evaluateDecisionDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;Map&lt;String, VariableValueDto&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public List<Map<String, VariableValueDto>> evaluateDecisionByKey(String key, EvaluateDecisionDto evaluateDecisionDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = evaluateDecisionDto;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling evaluateDecisionByKey");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/key/{key}/evaluate"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<Map<String, VariableValueDto>>> localVarReturnType = new TypeReference<List<Map<String, VariableValueDto>>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Evaluate By Key And Tenant
   * Evaluates the latest version of the decision definition for tenant. The input values of the decision have to be supplied in the request body.
   * @param key The key of the decision definition (the latest version thereof) to be evaluated. (required)
   * @param tenantId The id of the tenant the decision definition belongs to. (required)
   * @param evaluateDecisionDto  (optional)
   * @return List&lt;Map&lt;String, VariableValueDto&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public List<Map<String, VariableValueDto>> evaluateDecisionByKeyAndTenant(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
    return this.evaluateDecisionByKeyAndTenant(key, tenantId, evaluateDecisionDto, Collections.emptyMap());
  }


  /**
   * Evaluate By Key And Tenant
   * Evaluates the latest version of the decision definition for tenant. The input values of the decision have to be supplied in the request body.
   * @param key The key of the decision definition (the latest version thereof) to be evaluated. (required)
   * @param tenantId The id of the tenant the decision definition belongs to. (required)
   * @param evaluateDecisionDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;Map&lt;String, VariableValueDto&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public List<Map<String, VariableValueDto>> evaluateDecisionByKeyAndTenant(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = evaluateDecisionDto;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling evaluateDecisionByKeyAndTenant");
    }
    
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling evaluateDecisionByKeyAndTenant");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/evaluate"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "tenant-id" + "\\}", apiClient.escapeString(tenantId.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<Map<String, VariableValueDto>>> localVarReturnType = new TypeReference<List<Map<String, VariableValueDto>>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Decision Definition By Id
   * Retrieves a decision definition by id, according to the &#x60;DecisionDefinition&#x60; interface in the engine.
   * @param id The id of the decision definition to be retrieved. (required)
   * @return DecisionDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public DecisionDefinitionDto getDecisionDefinitionById(String id) throws ApiException {
    return this.getDecisionDefinitionById(id, Collections.emptyMap());
  }


  /**
   * Get Decision Definition By Id
   * Retrieves a decision definition by id, according to the &#x60;DecisionDefinition&#x60; interface in the engine.
   * @param id The id of the decision definition to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return DecisionDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public DecisionDefinitionDto getDecisionDefinitionById(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getDecisionDefinitionById");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<DecisionDefinitionDto> localVarReturnType = new TypeReference<DecisionDefinitionDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Decision Definition By Key
   * Retrieves the latest version of the decision definition which belongs to no tenant.
   * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
   * @return DecisionDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public DecisionDefinitionDto getDecisionDefinitionByKey(String key) throws ApiException {
    return this.getDecisionDefinitionByKey(key, Collections.emptyMap());
  }


  /**
   * Get Decision Definition By Key
   * Retrieves the latest version of the decision definition which belongs to no tenant.
   * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return DecisionDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public DecisionDefinitionDto getDecisionDefinitionByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionDefinitionByKey");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/key/{key}"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<DecisionDefinitionDto> localVarReturnType = new TypeReference<DecisionDefinitionDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Decision Definition By Key And Tenant Id
   * Retrieves the latest version of the decision definition for tenant
   * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
   * @param tenantId The id of the tenant the decision definition belongs to. (required)
   * @return DecisionDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public DecisionDefinitionDto getDecisionDefinitionByKeyAndTenantId(String key, String tenantId) throws ApiException {
    return this.getDecisionDefinitionByKeyAndTenantId(key, tenantId, Collections.emptyMap());
  }


  /**
   * Get Decision Definition By Key And Tenant Id
   * Retrieves the latest version of the decision definition for tenant
   * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
   * @param tenantId The id of the tenant the decision definition belongs to. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return DecisionDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public DecisionDefinitionDto getDecisionDefinitionByKeyAndTenantId(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionDefinitionByKeyAndTenantId");
    }
    
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getDecisionDefinitionByKeyAndTenantId");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "tenant-id" + "\\}", apiClient.escapeString(tenantId.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<DecisionDefinitionDto> localVarReturnType = new TypeReference<DecisionDefinitionDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Diagram
   * Retrieves the diagram of a decision definition.
   * @param id The id of the process definition. (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getDecisionDefinitionDiagram(String id) throws ApiException {
    return this.getDecisionDefinitionDiagram(id, Collections.emptyMap());
  }


  /**
   * Get Diagram
   * Retrieves the diagram of a decision definition.
   * @param id The id of the process definition. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getDecisionDefinitionDiagram(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getDecisionDefinitionDiagram");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/{id}/diagram"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/octet-stream", "*/*", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<File> localVarReturnType = new TypeReference<File>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Diagram By Key
   * Returns the diagram for the latest version of the decision definition which belongs to no tenant
   * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getDecisionDefinitionDiagramByKey(String key) throws ApiException {
    return this.getDecisionDefinitionDiagramByKey(key, Collections.emptyMap());
  }


  /**
   * Get Diagram By Key
   * Returns the diagram for the latest version of the decision definition which belongs to no tenant
   * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getDecisionDefinitionDiagramByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionDefinitionDiagramByKey");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/key/{key}/diagram"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/octet-stream", "*/*", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<File> localVarReturnType = new TypeReference<File>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Diagram By Key And Tenant
   * Returns the XML of the latest version of the decision definition for tenant.
   * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
   * @param tenantId The id of the tenant the decision definition belongs to. (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getDecisionDefinitionDiagramByKeyAndTenant(String key, String tenantId) throws ApiException {
    return this.getDecisionDefinitionDiagramByKeyAndTenant(key, tenantId, Collections.emptyMap());
  }


  /**
   * Get Diagram By Key And Tenant
   * Returns the XML of the latest version of the decision definition for tenant.
   * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
   * @param tenantId The id of the tenant the decision definition belongs to. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getDecisionDefinitionDiagramByKeyAndTenant(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionDefinitionDiagramByKeyAndTenant");
    }
    
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getDecisionDefinitionDiagramByKeyAndTenant");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/diagram"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "tenant-id" + "\\}", apiClient.escapeString(tenantId.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/octet-stream", "*/*", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<File> localVarReturnType = new TypeReference<File>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get XML By Id
   * Retrieves the DMN XML of a decision definition.
   * @param id The id of the decision definition. (required)
   * @return DecisionDefinitionDiagramDto
   * @throws ApiException if fails to make API call
   */
  public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlById(String id) throws ApiException {
    return this.getDecisionDefinitionDmnXmlById(id, Collections.emptyMap());
  }


  /**
   * Get XML By Id
   * Retrieves the DMN XML of a decision definition.
   * @param id The id of the decision definition. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return DecisionDefinitionDiagramDto
   * @throws ApiException if fails to make API call
   */
  public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlById(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getDecisionDefinitionDmnXmlById");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/{id}/xml"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<DecisionDefinitionDiagramDto> localVarReturnType = new TypeReference<DecisionDefinitionDiagramDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get XML By Key
   * Retrieves the XML for the latest version of the decision definition which belongs to no tenant.
   * @param key The key of the decision definition (the latest version thereof). (required)
   * @return DecisionDefinitionDiagramDto
   * @throws ApiException if fails to make API call
   */
  public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlByKey(String key) throws ApiException {
    return this.getDecisionDefinitionDmnXmlByKey(key, Collections.emptyMap());
  }


  /**
   * Get XML By Key
   * Retrieves the XML for the latest version of the decision definition which belongs to no tenant.
   * @param key The key of the decision definition (the latest version thereof). (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return DecisionDefinitionDiagramDto
   * @throws ApiException if fails to make API call
   */
  public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionDefinitionDmnXmlByKey");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/key/{key}/xml"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<DecisionDefinitionDiagramDto> localVarReturnType = new TypeReference<DecisionDefinitionDiagramDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get XML By Key and Tenant
   * Retrieves the XML of the latest version of the decision definition for tenant
   * @param key The key of the decision definition (the latest version thereof). (required)
   * @param tenantId The id of the tenant the decision definition belongs to. (required)
   * @return DecisionDefinitionDiagramDto
   * @throws ApiException if fails to make API call
   */
  public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlByKeyAndTenant(String key, String tenantId) throws ApiException {
    return this.getDecisionDefinitionDmnXmlByKeyAndTenant(key, tenantId, Collections.emptyMap());
  }


  /**
   * Get XML By Key and Tenant
   * Retrieves the XML of the latest version of the decision definition for tenant
   * @param key The key of the decision definition (the latest version thereof). (required)
   * @param tenantId The id of the tenant the decision definition belongs to. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return DecisionDefinitionDiagramDto
   * @throws ApiException if fails to make API call
   */
  public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlByKeyAndTenant(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionDefinitionDmnXmlByKeyAndTenant");
    }
    
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getDecisionDefinitionDmnXmlByKeyAndTenant");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/xml"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "tenant-id" + "\\}", apiClient.escapeString(tenantId.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<DecisionDefinitionDiagramDto> localVarReturnType = new TypeReference<DecisionDefinitionDiagramDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List
   * Queries for decision definitions that fulfill given parameters. Parameters may be the properties of decision definitions, such as the name, key or version. The size of the result set can be retrieved by using the [Get Decision Definition Count](https://docs.camunda.org/manual/7.21/reference/rest/decision-definition/get-query-count/) method.
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param decisionDefinitionId Filter by decision definition id. (optional)
   * @param decisionDefinitionIdIn Filter by decision definition ids. (optional)
   * @param name Filter by decision definition name. (optional)
   * @param nameLike Filter by decision definition names that the parameter is a substring of. (optional)
   * @param deploymentId Filter by the deployment the id belongs to. (optional)
   * @param deployedAfter Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed after (exclusive) a specific time. (optional)
   * @param deployedAt Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed at a specific time (exact match). (optional)
   * @param key Filter by decision definition key, i.e., the id in the DMN 1.0 XML. Exact match. (optional)
   * @param keyLike Filter by decision definition keys that the parameter is a substring of. (optional)
   * @param category Filter by decision definition category. Exact match. (optional)
   * @param categoryLike Filter by decision definition categories that the parameter is a substring of. (optional)
   * @param version Filter by decision definition version. (optional)
   * @param latestVersion Only include those decision definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param resourceName Filter by the name of the decision definition resource. Exact match. (optional)
   * @param resourceNameLike Filter by names of those decision definition resources that the parameter is a substring of. (optional)
   * @param decisionRequirementsDefinitionId Filter by the id of the decision requirements definition this decision definition belongs to. (optional)
   * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition this decision definition belongs to. (optional)
   * @param withoutDecisionRequirementsDefinition Only include decision definitions which does not belongs to any decision requirements definition. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A decision definition must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include decision definitions which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeDecisionDefinitionsWithoutTenantId Include decision definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param versionTag Filter by the version tag. (optional)
   * @param versionTagLike Filter by the version tags of those decision definition resources that the parameter is a substring of. (optional)
   * @return List&lt;DecisionDefinitionDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<DecisionDefinitionDto> getDecisionDefinitions(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, OffsetDateTime deployedAfter, OffsetDateTime deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike) throws ApiException {
    return this.getDecisionDefinitions(sortBy, sortOrder, firstResult, maxResults, decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, Collections.emptyMap());
  }


  /**
   * Get List
   * Queries for decision definitions that fulfill given parameters. Parameters may be the properties of decision definitions, such as the name, key or version. The size of the result set can be retrieved by using the [Get Decision Definition Count](https://docs.camunda.org/manual/7.21/reference/rest/decision-definition/get-query-count/) method.
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param decisionDefinitionId Filter by decision definition id. (optional)
   * @param decisionDefinitionIdIn Filter by decision definition ids. (optional)
   * @param name Filter by decision definition name. (optional)
   * @param nameLike Filter by decision definition names that the parameter is a substring of. (optional)
   * @param deploymentId Filter by the deployment the id belongs to. (optional)
   * @param deployedAfter Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed after (exclusive) a specific time. (optional)
   * @param deployedAt Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed at a specific time (exact match). (optional)
   * @param key Filter by decision definition key, i.e., the id in the DMN 1.0 XML. Exact match. (optional)
   * @param keyLike Filter by decision definition keys that the parameter is a substring of. (optional)
   * @param category Filter by decision definition category. Exact match. (optional)
   * @param categoryLike Filter by decision definition categories that the parameter is a substring of. (optional)
   * @param version Filter by decision definition version. (optional)
   * @param latestVersion Only include those decision definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param resourceName Filter by the name of the decision definition resource. Exact match. (optional)
   * @param resourceNameLike Filter by names of those decision definition resources that the parameter is a substring of. (optional)
   * @param decisionRequirementsDefinitionId Filter by the id of the decision requirements definition this decision definition belongs to. (optional)
   * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition this decision definition belongs to. (optional)
   * @param withoutDecisionRequirementsDefinition Only include decision definitions which does not belongs to any decision requirements definition. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A decision definition must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include decision definitions which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeDecisionDefinitionsWithoutTenantId Include decision definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param versionTag Filter by the version tag. (optional)
   * @param versionTagLike Filter by the version tags of those decision definition resources that the parameter is a substring of. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;DecisionDefinitionDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<DecisionDefinitionDto> getDecisionDefinitions(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, OffsetDateTime deployedAfter, OffsetDateTime deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/decision-definition";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionId", decisionDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
    localVarQueryParams.addAll(apiClient.parameterToPair("nameLike", nameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("deploymentId", deploymentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("deployedAfter", deployedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("deployedAt", deployedAt));
    localVarQueryParams.addAll(apiClient.parameterToPair("key", key));
    localVarQueryParams.addAll(apiClient.parameterToPair("keyLike", keyLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("category", category));
    localVarQueryParams.addAll(apiClient.parameterToPair("categoryLike", categoryLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
    localVarQueryParams.addAll(apiClient.parameterToPair("latestVersion", latestVersion));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceName", resourceName));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceNameLike", resourceNameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutDecisionRequirementsDefinition", withoutDecisionRequirementsDefinition));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("includeDecisionDefinitionsWithoutTenantId", includeDecisionDefinitionsWithoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("versionTag", versionTag));
    localVarQueryParams.addAll(apiClient.parameterToPair("versionTagLike", versionTagLike));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<DecisionDefinitionDto>> localVarReturnType = new TypeReference<List<DecisionDefinitionDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List Count
   * Requests the number of decision definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Decision Definition](https://docs.camunda.org/manual/7.21/reference/rest/decision-definition/get-query/) method.
   * @param decisionDefinitionId Filter by decision definition id. (optional)
   * @param decisionDefinitionIdIn Filter by decision definition ids. (optional)
   * @param name Filter by decision definition name. (optional)
   * @param nameLike Filter by decision definition names that the parameter is a substring of. (optional)
   * @param deploymentId Filter by the deployment the id belongs to. (optional)
   * @param deployedAfter Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed after (exclusive) a specific time. (optional)
   * @param deployedAt Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed at a specific time (exact match). (optional)
   * @param key Filter by decision definition key, i.e., the id in the DMN 1.0 XML. Exact match. (optional)
   * @param keyLike Filter by decision definition keys that the parameter is a substring of. (optional)
   * @param category Filter by decision definition category. Exact match. (optional)
   * @param categoryLike Filter by decision definition categories that the parameter is a substring of. (optional)
   * @param version Filter by decision definition version. (optional)
   * @param latestVersion Only include those decision definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param resourceName Filter by the name of the decision definition resource. Exact match. (optional)
   * @param resourceNameLike Filter by names of those decision definition resources that the parameter is a substring of. (optional)
   * @param decisionRequirementsDefinitionId Filter by the id of the decision requirements definition this decision definition belongs to. (optional)
   * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition this decision definition belongs to. (optional)
   * @param withoutDecisionRequirementsDefinition Only include decision definitions which does not belongs to any decision requirements definition. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A decision definition must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include decision definitions which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeDecisionDefinitionsWithoutTenantId Include decision definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param versionTag Filter by the version tag. (optional)
   * @param versionTagLike Filter by the version tags of those decision definition resources that the parameter is a substring of. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getDecisionDefinitionsCount(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, OffsetDateTime deployedAfter, OffsetDateTime deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike) throws ApiException {
    return this.getDecisionDefinitionsCount(decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, Collections.emptyMap());
  }


  /**
   * Get List Count
   * Requests the number of decision definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Decision Definition](https://docs.camunda.org/manual/7.21/reference/rest/decision-definition/get-query/) method.
   * @param decisionDefinitionId Filter by decision definition id. (optional)
   * @param decisionDefinitionIdIn Filter by decision definition ids. (optional)
   * @param name Filter by decision definition name. (optional)
   * @param nameLike Filter by decision definition names that the parameter is a substring of. (optional)
   * @param deploymentId Filter by the deployment the id belongs to. (optional)
   * @param deployedAfter Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed after (exclusive) a specific time. (optional)
   * @param deployedAt Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed at a specific time (exact match). (optional)
   * @param key Filter by decision definition key, i.e., the id in the DMN 1.0 XML. Exact match. (optional)
   * @param keyLike Filter by decision definition keys that the parameter is a substring of. (optional)
   * @param category Filter by decision definition category. Exact match. (optional)
   * @param categoryLike Filter by decision definition categories that the parameter is a substring of. (optional)
   * @param version Filter by decision definition version. (optional)
   * @param latestVersion Only include those decision definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param resourceName Filter by the name of the decision definition resource. Exact match. (optional)
   * @param resourceNameLike Filter by names of those decision definition resources that the parameter is a substring of. (optional)
   * @param decisionRequirementsDefinitionId Filter by the id of the decision requirements definition this decision definition belongs to. (optional)
   * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition this decision definition belongs to. (optional)
   * @param withoutDecisionRequirementsDefinition Only include decision definitions which does not belongs to any decision requirements definition. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A decision definition must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include decision definitions which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeDecisionDefinitionsWithoutTenantId Include decision definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param versionTag Filter by the version tag. (optional)
   * @param versionTagLike Filter by the version tags of those decision definition resources that the parameter is a substring of. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getDecisionDefinitionsCount(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, OffsetDateTime deployedAfter, OffsetDateTime deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/decision-definition/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionId", decisionDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
    localVarQueryParams.addAll(apiClient.parameterToPair("nameLike", nameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("deploymentId", deploymentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("deployedAfter", deployedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("deployedAt", deployedAt));
    localVarQueryParams.addAll(apiClient.parameterToPair("key", key));
    localVarQueryParams.addAll(apiClient.parameterToPair("keyLike", keyLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("category", category));
    localVarQueryParams.addAll(apiClient.parameterToPair("categoryLike", categoryLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
    localVarQueryParams.addAll(apiClient.parameterToPair("latestVersion", latestVersion));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceName", resourceName));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceNameLike", resourceNameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutDecisionRequirementsDefinition", withoutDecisionRequirementsDefinition));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("includeDecisionDefinitionsWithoutTenantId", includeDecisionDefinitionsWithoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("versionTag", versionTag));
    localVarQueryParams.addAll(apiClient.parameterToPair("versionTagLike", versionTagLike));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update History Time to Live
   * Updates history time to live for decision definition. The field is used within [History cleanup](https://docs.camunda.org/manual/7.21/user-guide/process-engine/history/#history-cleanup).
   * @param id The id of the decision definition to change history time to live. (required)
   * @param historyTimeToLiveDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateHistoryTimeToLiveByDecisionDefinitionId(String id, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
    this.updateHistoryTimeToLiveByDecisionDefinitionId(id, historyTimeToLiveDto, Collections.emptyMap());
  }


  /**
   * Update History Time to Live
   * Updates history time to live for decision definition. The field is used within [History cleanup](https://docs.camunda.org/manual/7.21/user-guide/process-engine/history/#history-cleanup).
   * @param id The id of the decision definition to change history time to live. (required)
   * @param historyTimeToLiveDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateHistoryTimeToLiveByDecisionDefinitionId(String id, HistoryTimeToLiveDto historyTimeToLiveDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historyTimeToLiveDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling updateHistoryTimeToLiveByDecisionDefinitionId");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/{id}/history-time-to-live"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Update History Time to Live By Key
   * Updates the latest version of the decision definition which belongs to no tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.21/user-guide/process-engine/history/#history-cleanup).
   * @param key The key of the decision definitions to change history time to live. (required)
   * @param historyTimeToLiveDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateHistoryTimeToLiveByDecisionDefinitionKey(String key, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
    this.updateHistoryTimeToLiveByDecisionDefinitionKey(key, historyTimeToLiveDto, Collections.emptyMap());
  }


  /**
   * Update History Time to Live By Key
   * Updates the latest version of the decision definition which belongs to no tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.21/user-guide/process-engine/history/#history-cleanup).
   * @param key The key of the decision definitions to change history time to live. (required)
   * @param historyTimeToLiveDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateHistoryTimeToLiveByDecisionDefinitionKey(String key, HistoryTimeToLiveDto historyTimeToLiveDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historyTimeToLiveDto;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling updateHistoryTimeToLiveByDecisionDefinitionKey");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/key/{key}/history-time-to-live"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Update History Time to Live By Key And Tenant
   * Updates the latest version of the decision definition for tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.21/user-guide/process-engine/history/#history-cleanup). The value of the update is mandatory by default and does not allow &#x60;null&#x60; values. To enable them, please set the feature flag &#x60;enforceHistoryTimeToLive&#x60; to &#x60;false&#x60;. Read more in [Configuration Properties] (https://docs.camunda.org/manual/7.21/reference/deployment-descriptors/tags/process-engine#configuration-properties)
   * @param key The key of the decision definitions to change history time to live. (required)
   * @param tenantId The id of the tenant the decision definition belongs to. (required)
   * @param historyTimeToLiveDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
    this.updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant(key, tenantId, historyTimeToLiveDto, Collections.emptyMap());
  }


  /**
   * Update History Time to Live By Key And Tenant
   * Updates the latest version of the decision definition for tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.21/user-guide/process-engine/history/#history-cleanup). The value of the update is mandatory by default and does not allow &#x60;null&#x60; values. To enable them, please set the feature flag &#x60;enforceHistoryTimeToLive&#x60; to &#x60;false&#x60;. Read more in [Configuration Properties] (https://docs.camunda.org/manual/7.21/reference/deployment-descriptors/tags/process-engine#configuration-properties)
   * @param key The key of the decision definitions to change history time to live. (required)
   * @param tenantId The id of the tenant the decision definition belongs to. (required)
   * @param historyTimeToLiveDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historyTimeToLiveDto;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant");
    }
    
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant");
    }
    
    // create path and map variables
    String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/history-time-to-live"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "tenant-id" + "\\}", apiClient.escapeString(tenantId.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

}
