/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.DecisionRequirementsDefinitionDto;
import org.camunda.community.rest.client.dto.DecisionRequirementsDefinitionXmlDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import java.io.File;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class DecisionRequirementsDefinitionApi {


  private ApiClient apiClient;

  public DecisionRequirementsDefinitionApi() {
    this(Configuration.getDefaultApiClient());
  }

  public DecisionRequirementsDefinitionApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get Decision Requirements Definition by ID
   * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine.
   * @param id The id of the decision requirements definition to be retrieved. (required)
   * @return DecisionRequirementsDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public DecisionRequirementsDefinitionDto getDecisionRequirementsDefinitionById(String id) throws ApiException {
    return this.getDecisionRequirementsDefinitionById(id, Collections.emptyMap());
  }


  /**
   * Get Decision Requirements Definition by ID
   * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine.
   * @param id The id of the decision requirements definition to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return DecisionRequirementsDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public DecisionRequirementsDefinitionDto getDecisionRequirementsDefinitionById(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getDecisionRequirementsDefinitionById");
    }
    
    // create path and map variables
    String localVarPath = "/decision-requirements-definition/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<DecisionRequirementsDefinitionDto> localVarReturnType = new TypeReference<DecisionRequirementsDefinitionDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Decision Requirements Definition by Key
   * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine.  Returns the latest version of the decision requirements definition  which belongs to no tenant.
   * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
   * @return DecisionRequirementsDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public DecisionRequirementsDefinitionDto getDecisionRequirementsDefinitionByKey(String key) throws ApiException {
    return this.getDecisionRequirementsDefinitionByKey(key, Collections.emptyMap());
  }


  /**
   * Get Decision Requirements Definition by Key
   * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine.  Returns the latest version of the decision requirements definition  which belongs to no tenant.
   * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return DecisionRequirementsDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public DecisionRequirementsDefinitionDto getDecisionRequirementsDefinitionByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionRequirementsDefinitionByKey");
    }
    
    // create path and map variables
    String localVarPath = "/decision-requirements-definition/key/{key}"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<DecisionRequirementsDefinitionDto> localVarReturnType = new TypeReference<DecisionRequirementsDefinitionDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Decision Requirements Definition by Key and Tenant ID
   * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine. Returns the latest version of the decision requirements definition  for a tenant.
   * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
   * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
   * @return DecisionRequirementsDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public DecisionRequirementsDefinitionDto getDecisionRequirementsDefinitionByKeyAndTenantId(String key, String tenantId) throws ApiException {
    return this.getDecisionRequirementsDefinitionByKeyAndTenantId(key, tenantId, Collections.emptyMap());
  }


  /**
   * Get Decision Requirements Definition by Key and Tenant ID
   * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine. Returns the latest version of the decision requirements definition  for a tenant.
   * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
   * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return DecisionRequirementsDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public DecisionRequirementsDefinitionDto getDecisionRequirementsDefinitionByKeyAndTenantId(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionRequirementsDefinitionByKeyAndTenantId");
    }
    
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getDecisionRequirementsDefinitionByKeyAndTenantId");
    }
    
    // create path and map variables
    String localVarPath = "/decision-requirements-definition/key/{key}/tenant-id/{tenant-id}"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "tenant-id" + "\\}", apiClient.escapeString(tenantId.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<DecisionRequirementsDefinitionDto> localVarReturnType = new TypeReference<DecisionRequirementsDefinitionDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Decision Requirements Diagram by ID
   * Retrieves the diagram of a decision requirements definition.
   * @param id The id of the decision requirements definition. (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getDecisionRequirementsDefinitionDiagramById(String id) throws ApiException {
    return this.getDecisionRequirementsDefinitionDiagramById(id, Collections.emptyMap());
  }


  /**
   * Get Decision Requirements Diagram by ID
   * Retrieves the diagram of a decision requirements definition.
   * @param id The id of the decision requirements definition. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getDecisionRequirementsDefinitionDiagramById(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getDecisionRequirementsDefinitionDiagramById");
    }
    
    // create path and map variables
    String localVarPath = "/decision-requirements-definition/{id}/diagram"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "image/*", "application/octet-stream", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<File> localVarReturnType = new TypeReference<File>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Decision Requirements Diagram by Key
   * Retrieves the diagram of a decision requirements definition. Returns the diagram for the latest version of the decision requirements  definition which belongs to no tenant.
   * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getDecisionRequirementsDefinitionDiagramByKey(String key) throws ApiException {
    return this.getDecisionRequirementsDefinitionDiagramByKey(key, Collections.emptyMap());
  }


  /**
   * Get Decision Requirements Diagram by Key
   * Retrieves the diagram of a decision requirements definition. Returns the diagram for the latest version of the decision requirements  definition which belongs to no tenant.
   * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getDecisionRequirementsDefinitionDiagramByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionRequirementsDefinitionDiagramByKey");
    }
    
    // create path and map variables
    String localVarPath = "/decision-requirements-definition/key/{key}/diagram"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "image/*", "application/octet-stream", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<File> localVarReturnType = new TypeReference<File>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Decision Requirements Diagram by Key and Tenant ID
   * Retrieves the diagram of a decision requirements definition. Returns the diagram of the latest version of the decision requirements  definition for a tenant.
   * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
   * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getDecisionRequirementsDefinitionDiagramByKeyAndTenantId(String key, String tenantId) throws ApiException {
    return this.getDecisionRequirementsDefinitionDiagramByKeyAndTenantId(key, tenantId, Collections.emptyMap());
  }


  /**
   * Get Decision Requirements Diagram by Key and Tenant ID
   * Retrieves the diagram of a decision requirements definition. Returns the diagram of the latest version of the decision requirements  definition for a tenant.
   * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
   * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getDecisionRequirementsDefinitionDiagramByKeyAndTenantId(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionRequirementsDefinitionDiagramByKeyAndTenantId");
    }
    
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getDecisionRequirementsDefinitionDiagramByKeyAndTenantId");
    }
    
    // create path and map variables
    String localVarPath = "/decision-requirements-definition/key/{key}/tenant-id/{tenant-id}/diagram"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "tenant-id" + "\\}", apiClient.escapeString(tenantId.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "image/*", "application/octet-stream", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<File> localVarReturnType = new TypeReference<File>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get DMN XML by ID
   * Retrieves the DMN XML of a decision requirements definition.
   * @param id The id of the decision requirements definition. (required)
   * @return DecisionRequirementsDefinitionXmlDto
   * @throws ApiException if fails to make API call
   */
  public DecisionRequirementsDefinitionXmlDto getDecisionRequirementsDefinitionDmnXmlById(String id) throws ApiException {
    return this.getDecisionRequirementsDefinitionDmnXmlById(id, Collections.emptyMap());
  }


  /**
   * Get DMN XML by ID
   * Retrieves the DMN XML of a decision requirements definition.
   * @param id The id of the decision requirements definition. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return DecisionRequirementsDefinitionXmlDto
   * @throws ApiException if fails to make API call
   */
  public DecisionRequirementsDefinitionXmlDto getDecisionRequirementsDefinitionDmnXmlById(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getDecisionRequirementsDefinitionDmnXmlById");
    }
    
    // create path and map variables
    String localVarPath = "/decision-requirements-definition/{id}/xml"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<DecisionRequirementsDefinitionXmlDto> localVarReturnType = new TypeReference<DecisionRequirementsDefinitionXmlDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get DMN XML by Key
   * Retrieves the DMN XML of a decision requirements definition. Returns the XML for the latest version of the decision requirements  definition which belongs to no tenant.
   * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
   * @return DecisionRequirementsDefinitionXmlDto
   * @throws ApiException if fails to make API call
   */
  public DecisionRequirementsDefinitionXmlDto getDecisionRequirementsDefinitionDmnXmlByKey(String key) throws ApiException {
    return this.getDecisionRequirementsDefinitionDmnXmlByKey(key, Collections.emptyMap());
  }


  /**
   * Get DMN XML by Key
   * Retrieves the DMN XML of a decision requirements definition. Returns the XML for the latest version of the decision requirements  definition which belongs to no tenant.
   * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return DecisionRequirementsDefinitionXmlDto
   * @throws ApiException if fails to make API call
   */
  public DecisionRequirementsDefinitionXmlDto getDecisionRequirementsDefinitionDmnXmlByKey(String key, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionRequirementsDefinitionDmnXmlByKey");
    }
    
    // create path and map variables
    String localVarPath = "/decision-requirements-definition/key/{key}/xml"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<DecisionRequirementsDefinitionXmlDto> localVarReturnType = new TypeReference<DecisionRequirementsDefinitionXmlDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get DMN XML by Key and Tenant ID
   * Retrieves the DMN XML of a decision requirements definition. Returns the XML of the latest version of the decision requirements  definition for a tenant.
   * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
   * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
   * @return DecisionRequirementsDefinitionXmlDto
   * @throws ApiException if fails to make API call
   */
  public DecisionRequirementsDefinitionXmlDto getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantId(String key, String tenantId) throws ApiException {
    return this.getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantId(key, tenantId, Collections.emptyMap());
  }


  /**
   * Get DMN XML by Key and Tenant ID
   * Retrieves the DMN XML of a decision requirements definition. Returns the XML of the latest version of the decision requirements  definition for a tenant.
   * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
   * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return DecisionRequirementsDefinitionXmlDto
   * @throws ApiException if fails to make API call
   */
  public DecisionRequirementsDefinitionXmlDto getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantId(String key, String tenantId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantId");
    }
    
    // verify the required parameter 'tenantId' is set
    if (tenantId == null) {
      throw new ApiException(400, "Missing the required parameter 'tenantId' when calling getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantId");
    }
    
    // create path and map variables
    String localVarPath = "/decision-requirements-definition/key/{key}/tenant-id/{tenant-id}/xml"
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "tenant-id" + "\\}", apiClient.escapeString(tenantId.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<DecisionRequirementsDefinitionXmlDto> localVarReturnType = new TypeReference<DecisionRequirementsDefinitionXmlDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Decision Requirements Definitions
   * Queries for decision requirements definitions that fulfill given parameters. Parameters may be the properties of decision requirements definitions, such as the name, key or version.  The size of the result set can be retrieved by using the [Get Decision Requirements Definition Count](https://docs.camunda.org/manual/7.21/reference/rest/decision-requirements-definition/get-query-count/) method.
   * @param decisionRequirementsDefinitionId Filter by decision requirements definition id. (optional)
   * @param decisionRequirementsDefinitionIdIn Filter by decision requirements definition ids. (optional)
   * @param name Filter by decision requirements definition name. (optional)
   * @param nameLike Filter by decision requirements definition names that the parameter is a substring of. (optional)
   * @param deploymentId Filter by the id of the deployment a decision requirement definition belongs to. (optional)
   * @param key Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match. (optional)
   * @param keyLike Filter by decision requirements definition keys that the parameter is a substring of. (optional)
   * @param category Filter by decision requirements definition category. Exact match. (optional)
   * @param categoryLike Filter by decision requirements definition categories that the parameter is a substring of. (optional)
   * @param version Filter by decision requirements definition version. (optional)
   * @param latestVersion Only include those decision requirements definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param resourceName Filter by the name of the decision requirements definition resource. Exact match. (optional)
   * @param resourceNameLike Filter by names of those decision requirements definition resources that the parameter is a substring of. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include decision requirements definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeDecisionRequirementsDefinitionsWithoutTenantId Include decision requirements definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;DecisionRequirementsDefinitionDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<DecisionRequirementsDefinitionDto> getDecisionRequirementsDefinitions(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.getDecisionRequirementsDefinitions(decisionRequirementsDefinitionId, decisionRequirementsDefinitionIdIn, name, nameLike, deploymentId, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, tenantIdIn, withoutTenantId, includeDecisionRequirementsDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get Decision Requirements Definitions
   * Queries for decision requirements definitions that fulfill given parameters. Parameters may be the properties of decision requirements definitions, such as the name, key or version.  The size of the result set can be retrieved by using the [Get Decision Requirements Definition Count](https://docs.camunda.org/manual/7.21/reference/rest/decision-requirements-definition/get-query-count/) method.
   * @param decisionRequirementsDefinitionId Filter by decision requirements definition id. (optional)
   * @param decisionRequirementsDefinitionIdIn Filter by decision requirements definition ids. (optional)
   * @param name Filter by decision requirements definition name. (optional)
   * @param nameLike Filter by decision requirements definition names that the parameter is a substring of. (optional)
   * @param deploymentId Filter by the id of the deployment a decision requirement definition belongs to. (optional)
   * @param key Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match. (optional)
   * @param keyLike Filter by decision requirements definition keys that the parameter is a substring of. (optional)
   * @param category Filter by decision requirements definition category. Exact match. (optional)
   * @param categoryLike Filter by decision requirements definition categories that the parameter is a substring of. (optional)
   * @param version Filter by decision requirements definition version. (optional)
   * @param latestVersion Only include those decision requirements definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param resourceName Filter by the name of the decision requirements definition resource. Exact match. (optional)
   * @param resourceNameLike Filter by names of those decision requirements definition resources that the parameter is a substring of. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include decision requirements definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeDecisionRequirementsDefinitionsWithoutTenantId Include decision requirements definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;DecisionRequirementsDefinitionDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<DecisionRequirementsDefinitionDto> getDecisionRequirementsDefinitions(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/decision-requirements-definition";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionRequirementsDefinitionIdIn", decisionRequirementsDefinitionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
    localVarQueryParams.addAll(apiClient.parameterToPair("nameLike", nameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("deploymentId", deploymentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("key", key));
    localVarQueryParams.addAll(apiClient.parameterToPair("keyLike", keyLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("category", category));
    localVarQueryParams.addAll(apiClient.parameterToPair("categoryLike", categoryLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
    localVarQueryParams.addAll(apiClient.parameterToPair("latestVersion", latestVersion));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceName", resourceName));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceNameLike", resourceNameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("includeDecisionRequirementsDefinitionsWithoutTenantId", includeDecisionRequirementsDefinitionsWithoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<DecisionRequirementsDefinitionDto>> localVarReturnType = new TypeReference<List<DecisionRequirementsDefinitionDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Decision Requirements Definition Count
   * Requests the number of decision requirements definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Decision Requirements Definitions](https://docs.camunda.org/manual/7.21/reference/rest/decision-requirements-definition/get-query/) method.
   * @param decisionRequirementsDefinitionId Filter by decision requirements definition id. (optional)
   * @param decisionRequirementsDefinitionIdIn Filter by decision requirements definition ids. (optional)
   * @param name Filter by decision requirements definition name. (optional)
   * @param nameLike Filter by decision requirements definition names that the parameter is a substring of. (optional)
   * @param deploymentId Filter by the id of the deployment a decision requirement definition belongs to. (optional)
   * @param key Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match. (optional)
   * @param keyLike Filter by decision requirements definition keys that the parameter is a substring of. (optional)
   * @param category Filter by decision requirements definition category. Exact match. (optional)
   * @param categoryLike Filter by decision requirements definition categories that the parameter is a substring of. (optional)
   * @param version Filter by decision requirements definition version. (optional)
   * @param latestVersion Only include those decision requirements definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param resourceName Filter by the name of the decision requirements definition resource. Exact match. (optional)
   * @param resourceNameLike Filter by names of those decision requirements definition resources that the parameter is a substring of. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include decision requirements definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeDecisionRequirementsDefinitionsWithoutTenantId Include decision requirements definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getDecisionRequirementsDefinitionsCount(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId) throws ApiException {
    return this.getDecisionRequirementsDefinitionsCount(decisionRequirementsDefinitionId, decisionRequirementsDefinitionIdIn, name, nameLike, deploymentId, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, tenantIdIn, withoutTenantId, includeDecisionRequirementsDefinitionsWithoutTenantId, Collections.emptyMap());
  }


  /**
   * Get Decision Requirements Definition Count
   * Requests the number of decision requirements definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Decision Requirements Definitions](https://docs.camunda.org/manual/7.21/reference/rest/decision-requirements-definition/get-query/) method.
   * @param decisionRequirementsDefinitionId Filter by decision requirements definition id. (optional)
   * @param decisionRequirementsDefinitionIdIn Filter by decision requirements definition ids. (optional)
   * @param name Filter by decision requirements definition name. (optional)
   * @param nameLike Filter by decision requirements definition names that the parameter is a substring of. (optional)
   * @param deploymentId Filter by the id of the deployment a decision requirement definition belongs to. (optional)
   * @param key Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match. (optional)
   * @param keyLike Filter by decision requirements definition keys that the parameter is a substring of. (optional)
   * @param category Filter by decision requirements definition category. Exact match. (optional)
   * @param categoryLike Filter by decision requirements definition categories that the parameter is a substring of. (optional)
   * @param version Filter by decision requirements definition version. (optional)
   * @param latestVersion Only include those decision requirements definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param resourceName Filter by the name of the decision requirements definition resource. Exact match. (optional)
   * @param resourceNameLike Filter by names of those decision requirements definition resources that the parameter is a substring of. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include decision requirements definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeDecisionRequirementsDefinitionsWithoutTenantId Include decision requirements definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getDecisionRequirementsDefinitionsCount(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/decision-requirements-definition/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionRequirementsDefinitionIdIn", decisionRequirementsDefinitionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
    localVarQueryParams.addAll(apiClient.parameterToPair("nameLike", nameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("deploymentId", deploymentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("key", key));
    localVarQueryParams.addAll(apiClient.parameterToPair("keyLike", keyLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("category", category));
    localVarQueryParams.addAll(apiClient.parameterToPair("categoryLike", categoryLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
    localVarQueryParams.addAll(apiClient.parameterToPair("latestVersion", latestVersion));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceName", resourceName));
    localVarQueryParams.addAll(apiClient.parameterToPair("resourceNameLike", resourceNameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("includeDecisionRequirementsDefinitionsWithoutTenantId", includeDecisionRequirementsDefinitionsWithoutTenantId));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
