/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.CreateIncidentDto;
import org.camunda.community.rest.client.dto.EventSubscriptionDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.ExecutionDto;
import org.camunda.community.rest.client.dto.ExecutionQueryDto;
import org.camunda.community.rest.client.dto.ExecutionTriggerDto;
import java.io.File;
import org.camunda.community.rest.client.dto.IncidentDto;
import org.camunda.community.rest.client.dto.PatchVariablesDto;
import org.camunda.community.rest.client.dto.VariableValueDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class ExecutionApi {


  private ApiClient apiClient;

  public ExecutionApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ExecutionApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Create Incident
   * Creates a custom incident with given properties.
   * @param id The id of the execution to create a new incident for. (required)
   * @param createIncidentDto  (optional)
   * @return IncidentDto
   * @throws ApiException if fails to make API call
   */
  public IncidentDto createIncident(String id, CreateIncidentDto createIncidentDto) throws ApiException {
    return this.createIncident(id, createIncidentDto, Collections.emptyMap());
  }


  /**
   * Create Incident
   * Creates a custom incident with given properties.
   * @param id The id of the execution to create a new incident for. (required)
   * @param createIncidentDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return IncidentDto
   * @throws ApiException if fails to make API call
   */
  public IncidentDto createIncident(String id, CreateIncidentDto createIncidentDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createIncidentDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling createIncident");
    }
    
    // create path and map variables
    String localVarPath = "/execution/{id}/create-incident"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<IncidentDto> localVarReturnType = new TypeReference<IncidentDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete Local Execution Variable
   * Deletes a variable in the context of a given execution by id. Deletion does not propagate upwards in the execution hierarchy.
   * @param id The id of the execution to delete the variable from. (required)
   * @param varName The name of the variable to delete. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteLocalExecutionVariable(String id, String varName) throws ApiException {
    this.deleteLocalExecutionVariable(id, varName, Collections.emptyMap());
  }


  /**
   * Delete Local Execution Variable
   * Deletes a variable in the context of a given execution by id. Deletion does not propagate upwards in the execution hierarchy.
   * @param id The id of the execution to delete the variable from. (required)
   * @param varName The name of the variable to delete. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteLocalExecutionVariable(String id, String varName, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteLocalExecutionVariable");
    }
    
    // verify the required parameter 'varName' is set
    if (varName == null) {
      throw new ApiException(400, "Missing the required parameter 'varName' when calling deleteLocalExecutionVariable");
    }
    
    // create path and map variables
    String localVarPath = "/execution/{id}/localVariables/{varName}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
      .replaceAll("\\{" + "varName" + "\\}", apiClient.escapeString(varName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get Execution
   * Retrieves an execution by id, according to the &#x60;Execution&#x60; interface in the engine.
   * @param id The id of the execution to be retrieved. (required)
   * @return ExecutionDto
   * @throws ApiException if fails to make API call
   */
  public ExecutionDto getExecution(String id) throws ApiException {
    return this.getExecution(id, Collections.emptyMap());
  }


  /**
   * Get Execution
   * Retrieves an execution by id, according to the &#x60;Execution&#x60; interface in the engine.
   * @param id The id of the execution to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return ExecutionDto
   * @throws ApiException if fails to make API call
   */
  public ExecutionDto getExecution(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getExecution");
    }
    
    // create path and map variables
    String localVarPath = "/execution/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<ExecutionDto> localVarReturnType = new TypeReference<ExecutionDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Executions
   * Queries for the executions that fulfill given parameters. Parameters may be static as well as dynamic runtime properties of executions. The size of the result set can be retrieved by using the [Get Execution Count](https://docs.camunda.org/manual/7.21/reference/rest/execution/get-query-count/) method.
   * @param businessKey Filter by the business key of the process instances the executions belong to. (optional)
   * @param processDefinitionId Filter by the process definition the executions run on. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the executions run on. (optional)
   * @param processInstanceId Filter by the id of the process instance the execution belongs to. (optional)
   * @param activityId Filter by the id of the activity the execution currently executes. (optional)
   * @param signalEventSubscriptionName Select only those executions that expect a signal of the given name. (optional)
   * @param messageEventSubscriptionName Select only those executions that expect a message of the given name. (optional)
   * @param active Only include active executions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended Only include suspended executions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param incidentId Filter by the incident id. (optional)
   * @param incidentType Filter by the incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Filter by the incident message. Exact match. (optional)
   * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. An execution must have one of the given tenant ids. (optional)
   * @param variables Only include executions that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param processVariables Only include executions that belong to a process instance with variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param variableNamesIgnoreCase Match all variable names provided in &#x60;variables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match all variable values provided in &#x60;variables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;ExecutionDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<ExecutionDto> getExecutions(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.getExecutions(businessKey, processDefinitionId, processDefinitionKey, processInstanceId, activityId, signalEventSubscriptionName, messageEventSubscriptionName, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, variables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get Executions
   * Queries for the executions that fulfill given parameters. Parameters may be static as well as dynamic runtime properties of executions. The size of the result set can be retrieved by using the [Get Execution Count](https://docs.camunda.org/manual/7.21/reference/rest/execution/get-query-count/) method.
   * @param businessKey Filter by the business key of the process instances the executions belong to. (optional)
   * @param processDefinitionId Filter by the process definition the executions run on. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the executions run on. (optional)
   * @param processInstanceId Filter by the id of the process instance the execution belongs to. (optional)
   * @param activityId Filter by the id of the activity the execution currently executes. (optional)
   * @param signalEventSubscriptionName Select only those executions that expect a signal of the given name. (optional)
   * @param messageEventSubscriptionName Select only those executions that expect a message of the given name. (optional)
   * @param active Only include active executions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended Only include suspended executions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param incidentId Filter by the incident id. (optional)
   * @param incidentType Filter by the incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Filter by the incident message. Exact match. (optional)
   * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. An execution must have one of the given tenant ids. (optional)
   * @param variables Only include executions that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param processVariables Only include executions that belong to a process instance with variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param variableNamesIgnoreCase Match all variable names provided in &#x60;variables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match all variable values provided in &#x60;variables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;ExecutionDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<ExecutionDto> getExecutions(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/execution";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("businessKey", businessKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityId", activityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("signalEventSubscriptionName", signalEventSubscriptionName));
    localVarQueryParams.addAll(apiClient.parameterToPair("messageEventSubscriptionName", messageEventSubscriptionName));
    localVarQueryParams.addAll(apiClient.parameterToPair("active", active));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentId", incidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentType", incidentType));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessage", incidentMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("variables", variables));
    localVarQueryParams.addAll(apiClient.parameterToPair("processVariables", processVariables));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<ExecutionDto>> localVarReturnType = new TypeReference<List<ExecutionDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Execution Count
   * Queries for the number of executions that fulfill given parameters. Takes the same parameters as the [Get Executions](https://docs.camunda.org/manual/7.21/reference/rest/execution/get-query/) method.
   * @param businessKey Filter by the business key of the process instances the executions belong to. (optional)
   * @param processDefinitionId Filter by the process definition the executions run on. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the executions run on. (optional)
   * @param processInstanceId Filter by the id of the process instance the execution belongs to. (optional)
   * @param activityId Filter by the id of the activity the execution currently executes. (optional)
   * @param signalEventSubscriptionName Select only those executions that expect a signal of the given name. (optional)
   * @param messageEventSubscriptionName Select only those executions that expect a message of the given name. (optional)
   * @param active Only include active executions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended Only include suspended executions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param incidentId Filter by the incident id. (optional)
   * @param incidentType Filter by the incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Filter by the incident message. Exact match. (optional)
   * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. An execution must have one of the given tenant ids. (optional)
   * @param variables Only include executions that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param processVariables Only include executions that belong to a process instance with variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param variableNamesIgnoreCase Match all variable names provided in &#x60;variables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match all variable values provided in &#x60;variables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getExecutionsCount(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
    return this.getExecutionsCount(businessKey, processDefinitionId, processDefinitionKey, processInstanceId, activityId, signalEventSubscriptionName, messageEventSubscriptionName, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, variables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, Collections.emptyMap());
  }


  /**
   * Get Execution Count
   * Queries for the number of executions that fulfill given parameters. Takes the same parameters as the [Get Executions](https://docs.camunda.org/manual/7.21/reference/rest/execution/get-query/) method.
   * @param businessKey Filter by the business key of the process instances the executions belong to. (optional)
   * @param processDefinitionId Filter by the process definition the executions run on. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the executions run on. (optional)
   * @param processInstanceId Filter by the id of the process instance the execution belongs to. (optional)
   * @param activityId Filter by the id of the activity the execution currently executes. (optional)
   * @param signalEventSubscriptionName Select only those executions that expect a signal of the given name. (optional)
   * @param messageEventSubscriptionName Select only those executions that expect a message of the given name. (optional)
   * @param active Only include active executions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended Only include suspended executions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param incidentId Filter by the incident id. (optional)
   * @param incidentType Filter by the incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Filter by the incident message. Exact match. (optional)
   * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. An execution must have one of the given tenant ids. (optional)
   * @param variables Only include executions that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param processVariables Only include executions that belong to a process instance with variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param variableNamesIgnoreCase Match all variable names provided in &#x60;variables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match all variable values provided in &#x60;variables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getExecutionsCount(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/execution/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("businessKey", businessKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityId", activityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("signalEventSubscriptionName", signalEventSubscriptionName));
    localVarQueryParams.addAll(apiClient.parameterToPair("messageEventSubscriptionName", messageEventSubscriptionName));
    localVarQueryParams.addAll(apiClient.parameterToPair("active", active));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentId", incidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentType", incidentType));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessage", incidentMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("variables", variables));
    localVarQueryParams.addAll(apiClient.parameterToPair("processVariables", processVariables));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Local Execution Variable
   * Retrieves a variable from the context of a given execution by id. Does not traverse the parent execution hierarchy.
   * @param id The id of the execution to retrieve the variable from. (required)
   * @param varName The name of the variable to get. (required)
   * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath. If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @return VariableValueDto
   * @throws ApiException if fails to make API call
   */
  public VariableValueDto getLocalExecutionVariable(String id, String varName, Boolean deserializeValue) throws ApiException {
    return this.getLocalExecutionVariable(id, varName, deserializeValue, Collections.emptyMap());
  }


  /**
   * Get Local Execution Variable
   * Retrieves a variable from the context of a given execution by id. Does not traverse the parent execution hierarchy.
   * @param id The id of the execution to retrieve the variable from. (required)
   * @param varName The name of the variable to get. (required)
   * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath. If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return VariableValueDto
   * @throws ApiException if fails to make API call
   */
  public VariableValueDto getLocalExecutionVariable(String id, String varName, Boolean deserializeValue, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getLocalExecutionVariable");
    }
    
    // verify the required parameter 'varName' is set
    if (varName == null) {
      throw new ApiException(400, "Missing the required parameter 'varName' when calling getLocalExecutionVariable");
    }
    
    // create path and map variables
    String localVarPath = "/execution/{id}/localVariables/{varName}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
      .replaceAll("\\{" + "varName" + "\\}", apiClient.escapeString(varName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("deserializeValue", deserializeValue));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<VariableValueDto> localVarReturnType = new TypeReference<VariableValueDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Local Execution Variable (Binary)
   * Retrieves a binary variable from the context of a given execution by id. Does not traverse the parent execution hierarchy. Applicable for byte array and file variables.
   * @param id The id of the execution to retrieve the variable from. (required)
   * @param varName The name of the variable to get. (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getLocalExecutionVariableBinary(String id, String varName) throws ApiException {
    return this.getLocalExecutionVariableBinary(id, varName, Collections.emptyMap());
  }


  /**
   * Get Local Execution Variable (Binary)
   * Retrieves a binary variable from the context of a given execution by id. Does not traverse the parent execution hierarchy. Applicable for byte array and file variables.
   * @param id The id of the execution to retrieve the variable from. (required)
   * @param varName The name of the variable to get. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getLocalExecutionVariableBinary(String id, String varName, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getLocalExecutionVariableBinary");
    }
    
    // verify the required parameter 'varName' is set
    if (varName == null) {
      throw new ApiException(400, "Missing the required parameter 'varName' when calling getLocalExecutionVariableBinary");
    }
    
    // create path and map variables
    String localVarPath = "/execution/{id}/localVariables/{varName}/data"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
      .replaceAll("\\{" + "varName" + "\\}", apiClient.escapeString(varName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/octet-stream", "text/plain", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<File> localVarReturnType = new TypeReference<File>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Local Execution Variables
   * Retrieves all variables of a given execution by id.
   * @param id The id of the execution to retrieve the variables from. (required)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @return Map&lt;String, VariableValueDto&gt;
   * @throws ApiException if fails to make API call
   */
  public Map<String, VariableValueDto> getLocalExecutionVariables(String id, Boolean deserializeValues) throws ApiException {
    return this.getLocalExecutionVariables(id, deserializeValues, Collections.emptyMap());
  }


  /**
   * Get Local Execution Variables
   * Retrieves all variables of a given execution by id.
   * @param id The id of the execution to retrieve the variables from. (required)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return Map&lt;String, VariableValueDto&gt;
   * @throws ApiException if fails to make API call
   */
  public Map<String, VariableValueDto> getLocalExecutionVariables(String id, Boolean deserializeValues, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getLocalExecutionVariables");
    }
    
    // create path and map variables
    String localVarPath = "/execution/{id}/localVariables"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("deserializeValues", deserializeValues));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<Map<String, VariableValueDto>> localVarReturnType = new TypeReference<Map<String, VariableValueDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Message Event Subscription
   * Retrieves a message event subscription for a given execution by id and a message name.
   * @param id The id of the execution that holds the subscription. (required)
   * @param messageName The name of the message that the subscription corresponds to. (required)
   * @return EventSubscriptionDto
   * @throws ApiException if fails to make API call
   */
  public EventSubscriptionDto getMessageEventSubscription(String id, String messageName) throws ApiException {
    return this.getMessageEventSubscription(id, messageName, Collections.emptyMap());
  }


  /**
   * Get Message Event Subscription
   * Retrieves a message event subscription for a given execution by id and a message name.
   * @param id The id of the execution that holds the subscription. (required)
   * @param messageName The name of the message that the subscription corresponds to. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return EventSubscriptionDto
   * @throws ApiException if fails to make API call
   */
  public EventSubscriptionDto getMessageEventSubscription(String id, String messageName, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getMessageEventSubscription");
    }
    
    // verify the required parameter 'messageName' is set
    if (messageName == null) {
      throw new ApiException(400, "Missing the required parameter 'messageName' when calling getMessageEventSubscription");
    }
    
    // create path and map variables
    String localVarPath = "/execution/{id}/messageSubscriptions/{messageName}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
      .replaceAll("\\{" + "messageName" + "\\}", apiClient.escapeString(messageName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<EventSubscriptionDto> localVarReturnType = new TypeReference<EventSubscriptionDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update/Delete Local Execution Variables
   * Updates or deletes the variables in the context of an execution by id. The updates do not propagate upwards in the execution hierarchy. Updates precede deletions. So, if a variable is updated AND deleted, the deletion overrides the update.
   * @param id The id of the execution to set variables for. (required)
   * @param patchVariablesDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void modifyLocalExecutionVariables(String id, PatchVariablesDto patchVariablesDto) throws ApiException {
    this.modifyLocalExecutionVariables(id, patchVariablesDto, Collections.emptyMap());
  }


  /**
   * Update/Delete Local Execution Variables
   * Updates or deletes the variables in the context of an execution by id. The updates do not propagate upwards in the execution hierarchy. Updates precede deletions. So, if a variable is updated AND deleted, the deletion overrides the update.
   * @param id The id of the execution to set variables for. (required)
   * @param patchVariablesDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void modifyLocalExecutionVariables(String id, PatchVariablesDto patchVariablesDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = patchVariablesDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling modifyLocalExecutionVariables");
    }
    
    // create path and map variables
    String localVarPath = "/execution/{id}/localVariables"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Put Local Execution Variable
   * Sets a variable in the context of a given execution by id. Update does not propagate upwards in the execution hierarchy.
   * @param id The id of the execution to set the variable for. (required)
   * @param varName The name of the variable to set. (required)
   * @param variableValueDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void putLocalExecutionVariable(String id, String varName, VariableValueDto variableValueDto) throws ApiException {
    this.putLocalExecutionVariable(id, varName, variableValueDto, Collections.emptyMap());
  }


  /**
   * Put Local Execution Variable
   * Sets a variable in the context of a given execution by id. Update does not propagate upwards in the execution hierarchy.
   * @param id The id of the execution to set the variable for. (required)
   * @param varName The name of the variable to set. (required)
   * @param variableValueDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void putLocalExecutionVariable(String id, String varName, VariableValueDto variableValueDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = variableValueDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling putLocalExecutionVariable");
    }
    
    // verify the required parameter 'varName' is set
    if (varName == null) {
      throw new ApiException(400, "Missing the required parameter 'varName' when calling putLocalExecutionVariable");
    }
    
    // create path and map variables
    String localVarPath = "/execution/{id}/localVariables/{varName}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
      .replaceAll("\\{" + "varName" + "\\}", apiClient.escapeString(varName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get Executions (POST)
   * Queries for executions that fulfill given parameters through a JSON object. This method is slightly more powerful than the [Get Executions](https://docs.camunda.org/manual/7.21/reference/rest/execution/get-query/) method because it allows to filter by multiple instance and execution variables of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param executionQueryDto  (optional)
   * @return List&lt;ExecutionDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<ExecutionDto> queryExecutions(Integer firstResult, Integer maxResults, ExecutionQueryDto executionQueryDto) throws ApiException {
    return this.queryExecutions(firstResult, maxResults, executionQueryDto, Collections.emptyMap());
  }


  /**
   * Get Executions (POST)
   * Queries for executions that fulfill given parameters through a JSON object. This method is slightly more powerful than the [Get Executions](https://docs.camunda.org/manual/7.21/reference/rest/execution/get-query/) method because it allows to filter by multiple instance and execution variables of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param executionQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;ExecutionDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<ExecutionDto> queryExecutions(Integer firstResult, Integer maxResults, ExecutionQueryDto executionQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = executionQueryDto;
    
    // create path and map variables
    String localVarPath = "/execution";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<ExecutionDto>> localVarReturnType = new TypeReference<List<ExecutionDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Execution Count (POST)
   * Queries for the number of executions that fulfill given parameters. This method takes the same message body as the [Get Executions POST](https://docs.camunda.org/manual/7.21/reference/rest/execution/post-query/) method and therefore it is slightly more powerful than the [Get Execution Count](https://docs.camunda.org/manual/7.21/reference/rest/execution/get-query-count/) method.
   * @param executionQueryDto  (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryExecutionsCount(ExecutionQueryDto executionQueryDto) throws ApiException {
    return this.queryExecutionsCount(executionQueryDto, Collections.emptyMap());
  }


  /**
   * Get Execution Count (POST)
   * Queries for the number of executions that fulfill given parameters. This method takes the same message body as the [Get Executions POST](https://docs.camunda.org/manual/7.21/reference/rest/execution/post-query/) method and therefore it is slightly more powerful than the [Get Execution Count](https://docs.camunda.org/manual/7.21/reference/rest/execution/get-query-count/) method.
   * @param executionQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryExecutionsCount(ExecutionQueryDto executionQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = executionQueryDto;
    
    // create path and map variables
    String localVarPath = "/execution/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Post Local Execution Variable (Binary)
   * Sets the serialized value for a binary variable or the binary value for a file variable in the context of a given execution by id.
   * @param id The id of the execution to set the variable for. (required)
   * @param varName The name of the variable to set. (required)
   * @param data The binary data to be set. For File variables, this multipart can contain the filename, binary value and MIME type of the file variable to be set Only the filename is mandatory. (optional)
   * @param valueType The name of the variable type. Either Bytes for a byte array variable or File for a file variable. (optional)
   * @throws ApiException if fails to make API call
   */
  public void setLocalExecutionVariableBinary(String id, String varName, File data, String valueType) throws ApiException {
    this.setLocalExecutionVariableBinary(id, varName, data, valueType, Collections.emptyMap());
  }


  /**
   * Post Local Execution Variable (Binary)
   * Sets the serialized value for a binary variable or the binary value for a file variable in the context of a given execution by id.
   * @param id The id of the execution to set the variable for. (required)
   * @param varName The name of the variable to set. (required)
   * @param data The binary data to be set. For File variables, this multipart can contain the filename, binary value and MIME type of the file variable to be set Only the filename is mandatory. (optional)
   * @param valueType The name of the variable type. Either Bytes for a byte array variable or File for a file variable. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void setLocalExecutionVariableBinary(String id, String varName, File data, String valueType, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling setLocalExecutionVariableBinary");
    }
    
    // verify the required parameter 'varName' is set
    if (varName == null) {
      throw new ApiException(400, "Missing the required parameter 'varName' when calling setLocalExecutionVariableBinary");
    }
    
    // create path and map variables
    String localVarPath = "/execution/{id}/localVariables/{varName}/data"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
      .replaceAll("\\{" + "varName" + "\\}", apiClient.escapeString(varName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    if (data != null)
      localVarFormParams.put("data", data);
if (valueType != null)
      localVarFormParams.put("valueType", valueType);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "multipart/form-data"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Trigger Execution
   * Signals an execution by id. Can for example be used to explicitly skip user tasks or signal asynchronous continuations.
   * @param id The id of the execution to signal. (required)
   * @param executionTriggerDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void signalExecution(String id, ExecutionTriggerDto executionTriggerDto) throws ApiException {
    this.signalExecution(id, executionTriggerDto, Collections.emptyMap());
  }


  /**
   * Trigger Execution
   * Signals an execution by id. Can for example be used to explicitly skip user tasks or signal asynchronous continuations.
   * @param id The id of the execution to signal. (required)
   * @param executionTriggerDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void signalExecution(String id, ExecutionTriggerDto executionTriggerDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = executionTriggerDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling signalExecution");
    }
    
    // create path and map variables
    String localVarPath = "/execution/{id}/signal"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Trigger Message Event Subscription
   * Delivers a message to a specific execution by id, to trigger an existing message event subscription. Inject process variables as the message&#39;s payload.
   * @param id The id of the execution to submit the message to. (required)
   * @param messageName The name of the message that the addressed subscription corresponds to. (required)
   * @param executionTriggerDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void triggerEvent(String id, String messageName, ExecutionTriggerDto executionTriggerDto) throws ApiException {
    this.triggerEvent(id, messageName, executionTriggerDto, Collections.emptyMap());
  }


  /**
   * Trigger Message Event Subscription
   * Delivers a message to a specific execution by id, to trigger an existing message event subscription. Inject process variables as the message&#39;s payload.
   * @param id The id of the execution to submit the message to. (required)
   * @param messageName The name of the message that the addressed subscription corresponds to. (required)
   * @param executionTriggerDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void triggerEvent(String id, String messageName, ExecutionTriggerDto executionTriggerDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = executionTriggerDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling triggerEvent");
    }
    
    // verify the required parameter 'messageName' is set
    if (messageName == null) {
      throw new ApiException(400, "Missing the required parameter 'messageName' when calling triggerEvent");
    }
    
    // create path and map variables
    String localVarPath = "/execution/{id}/messageSubscriptions/{messageName}/trigger"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
      .replaceAll("\\{" + "messageName" + "\\}", apiClient.escapeString(messageName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

}
