/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.DeleteHistoricDecisionInstancesDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricDecisionInstanceDto;
import java.time.OffsetDateTime;
import org.camunda.community.rest.client.dto.SetRemovalTimeToHistoricDecisionInstancesDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricDecisionInstanceApi {


  private ApiClient apiClient;

  public HistoricDecisionInstanceApi() {
    this(Configuration.getDefaultApiClient());
  }

  public HistoricDecisionInstanceApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Delete Async (POST)
   * Delete multiple historic decision instances asynchronously (batch). At least &#x60;historicDecisionInstanceIds&#x60; or &#x60;historicDecisionInstanceQuery&#x60;  has to be provided. If both are provided then all instances matching query  criterion and instances from the list will be deleted.
   * @param deleteHistoricDecisionInstancesDto  (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto deleteAsync(DeleteHistoricDecisionInstancesDto deleteHistoricDecisionInstancesDto) throws ApiException {
    return this.deleteAsync(deleteHistoricDecisionInstancesDto, Collections.emptyMap());
  }


  /**
   * Delete Async (POST)
   * Delete multiple historic decision instances asynchronously (batch). At least &#x60;historicDecisionInstanceIds&#x60; or &#x60;historicDecisionInstanceQuery&#x60;  has to be provided. If both are provided then all instances matching query  criterion and instances from the list will be deleted.
   * @param deleteHistoricDecisionInstancesDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto deleteAsync(DeleteHistoricDecisionInstancesDto deleteHistoricDecisionInstancesDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = deleteHistoricDecisionInstancesDto;
    
    // create path and map variables
    String localVarPath = "/history/decision-instance/delete";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Historic Decision Instance
   * Retrieves a historic decision instance by id, according to the  &#x60;HistoricDecisionInstance&#x60; interface in the engine.
   * @param id The id of the historic decision instance to be retrieved. (required)
   * @param includeInputs Include input values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeOutputs Include output values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param disableBinaryFetching Disables fetching of byte array input and output values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param disableCustomObjectDeserialization Disables deserialization of input and output values that are custom objects. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @return HistoricDecisionInstanceDto
   * @throws ApiException if fails to make API call
   */
  public HistoricDecisionInstanceDto getHistoricDecisionInstance(String id, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization) throws ApiException {
    return this.getHistoricDecisionInstance(id, includeInputs, includeOutputs, disableBinaryFetching, disableCustomObjectDeserialization, Collections.emptyMap());
  }


  /**
   * Get Historic Decision Instance
   * Retrieves a historic decision instance by id, according to the  &#x60;HistoricDecisionInstance&#x60; interface in the engine.
   * @param id The id of the historic decision instance to be retrieved. (required)
   * @param includeInputs Include input values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeOutputs Include output values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param disableBinaryFetching Disables fetching of byte array input and output values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param disableCustomObjectDeserialization Disables deserialization of input and output values that are custom objects. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return HistoricDecisionInstanceDto
   * @throws ApiException if fails to make API call
   */
  public HistoricDecisionInstanceDto getHistoricDecisionInstance(String id, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getHistoricDecisionInstance");
    }
    
    // create path and map variables
    String localVarPath = "/history/decision-instance/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("includeInputs", includeInputs));
    localVarQueryParams.addAll(apiClient.parameterToPair("includeOutputs", includeOutputs));
    localVarQueryParams.addAll(apiClient.parameterToPair("disableBinaryFetching", disableBinaryFetching));
    localVarQueryParams.addAll(apiClient.parameterToPair("disableCustomObjectDeserialization", disableCustomObjectDeserialization));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<HistoricDecisionInstanceDto> localVarReturnType = new TypeReference<HistoricDecisionInstanceDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Historic Decision Instances
   * Queries for historic decision instances that fulfill the given parameters.  The size of the result set can be retrieved by using the  [Get Historic Decision Instance Count](https://docs.camunda.org/manual/7.21/reference/rest/history/decision-instance/get-decision-instance-query-count/)  method.
   * @param decisionInstanceId Filter by decision instance id. (optional)
   * @param decisionInstanceIdIn Filter by decision instance ids. Must be a comma-separated list of decision instance ids. (optional)
   * @param decisionDefinitionId Filter by the decision definition the instances belongs to. (optional)
   * @param decisionDefinitionIdIn Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids. (optional)
   * @param decisionDefinitionKey Filter by the key of the decision definition the instances belongs to. (optional)
   * @param decisionDefinitionKeyIn Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys. (optional)
   * @param decisionDefinitionName Filter by the name of the decision definition the instances belongs to. (optional)
   * @param decisionDefinitionNameLike Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of. (optional)
   * @param processDefinitionId Filter by the process definition the instances belongs to. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the instances belongs to. (optional)
   * @param processInstanceId Filter by the process instance the instances belongs to. (optional)
   * @param caseDefinitionId Filter by the case definition the instances belongs to. (optional)
   * @param caseDefinitionKey Filter by the key of the case definition the instances belongs to. (optional)
   * @param caseInstanceId Filter by the case instance the instances belongs to. (optional)
   * @param activityIdIn Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids. (optional)
   * @param activityInstanceIdIn Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include historic decision instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param evaluatedBefore Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param evaluatedAfter Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param userId Restrict to instances that were evaluated by the given user. (optional)
   * @param rootDecisionInstanceId Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id. (optional)
   * @param rootDecisionInstancesOnly Restrict to instances those are the root decision instance of an evaluation. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param decisionRequirementsDefinitionId Filter by the decision requirements definition the instances belongs to. (optional)
   * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition the instances belongs to. (optional)
   * @param includeInputs Include input values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeOutputs Include output values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param disableBinaryFetching Disables fetching of byte array input and output values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param disableCustomObjectDeserialization Disables deserialization of input and output values that are custom objects. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;HistoricDecisionInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricDecisionInstanceDto> getHistoricDecisionInstances(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, OffsetDateTime evaluatedBefore, OffsetDateTime evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.getHistoricDecisionInstances(decisionInstanceId, decisionInstanceIdIn, decisionDefinitionId, decisionDefinitionIdIn, decisionDefinitionKey, decisionDefinitionKeyIn, decisionDefinitionName, decisionDefinitionNameLike, processDefinitionId, processDefinitionKey, processInstanceId, caseDefinitionId, caseDefinitionKey, caseInstanceId, activityIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, evaluatedBefore, evaluatedAfter, userId, rootDecisionInstanceId, rootDecisionInstancesOnly, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, includeInputs, includeOutputs, disableBinaryFetching, disableCustomObjectDeserialization, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get Historic Decision Instances
   * Queries for historic decision instances that fulfill the given parameters.  The size of the result set can be retrieved by using the  [Get Historic Decision Instance Count](https://docs.camunda.org/manual/7.21/reference/rest/history/decision-instance/get-decision-instance-query-count/)  method.
   * @param decisionInstanceId Filter by decision instance id. (optional)
   * @param decisionInstanceIdIn Filter by decision instance ids. Must be a comma-separated list of decision instance ids. (optional)
   * @param decisionDefinitionId Filter by the decision definition the instances belongs to. (optional)
   * @param decisionDefinitionIdIn Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids. (optional)
   * @param decisionDefinitionKey Filter by the key of the decision definition the instances belongs to. (optional)
   * @param decisionDefinitionKeyIn Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys. (optional)
   * @param decisionDefinitionName Filter by the name of the decision definition the instances belongs to. (optional)
   * @param decisionDefinitionNameLike Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of. (optional)
   * @param processDefinitionId Filter by the process definition the instances belongs to. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the instances belongs to. (optional)
   * @param processInstanceId Filter by the process instance the instances belongs to. (optional)
   * @param caseDefinitionId Filter by the case definition the instances belongs to. (optional)
   * @param caseDefinitionKey Filter by the key of the case definition the instances belongs to. (optional)
   * @param caseInstanceId Filter by the case instance the instances belongs to. (optional)
   * @param activityIdIn Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids. (optional)
   * @param activityInstanceIdIn Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include historic decision instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param evaluatedBefore Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param evaluatedAfter Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param userId Restrict to instances that were evaluated by the given user. (optional)
   * @param rootDecisionInstanceId Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id. (optional)
   * @param rootDecisionInstancesOnly Restrict to instances those are the root decision instance of an evaluation. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param decisionRequirementsDefinitionId Filter by the decision requirements definition the instances belongs to. (optional)
   * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition the instances belongs to. (optional)
   * @param includeInputs Include input values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeOutputs Include output values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param disableBinaryFetching Disables fetching of byte array input and output values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param disableCustomObjectDeserialization Disables deserialization of input and output values that are custom objects. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricDecisionInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricDecisionInstanceDto> getHistoricDecisionInstances(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, OffsetDateTime evaluatedBefore, OffsetDateTime evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/decision-instance";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("decisionInstanceId", decisionInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionInstanceIdIn", decisionInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionId", decisionDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionKey", decisionDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionKeyIn", decisionDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionName", decisionDefinitionName));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionNameLike", decisionDefinitionNameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseDefinitionKey", caseDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityIdIn", activityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("evaluatedBefore", evaluatedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("evaluatedAfter", evaluatedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("userId", userId));
    localVarQueryParams.addAll(apiClient.parameterToPair("rootDecisionInstanceId", rootDecisionInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("rootDecisionInstancesOnly", rootDecisionInstancesOnly));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("includeInputs", includeInputs));
    localVarQueryParams.addAll(apiClient.parameterToPair("includeOutputs", includeOutputs));
    localVarQueryParams.addAll(apiClient.parameterToPair("disableBinaryFetching", disableBinaryFetching));
    localVarQueryParams.addAll(apiClient.parameterToPair("disableCustomObjectDeserialization", disableCustomObjectDeserialization));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricDecisionInstanceDto>> localVarReturnType = new TypeReference<List<HistoricDecisionInstanceDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Historic Decision Instance Count
   * Queries for the number of historic decision instances that fulfill the given parameters.  Takes the same parameters as the  [Get Historic Decision Instances](https://docs.camunda.org/manual/7.21/reference/rest/history/decision-instance/get-decision-instance-query/)  method.
   * @param decisionInstanceId Filter by decision instance id. (optional)
   * @param decisionInstanceIdIn Filter by decision instance ids. Must be a comma-separated list of decision instance ids. (optional)
   * @param decisionDefinitionId Filter by the decision definition the instances belongs to. (optional)
   * @param decisionDefinitionIdIn Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids. (optional)
   * @param decisionDefinitionKey Filter by the key of the decision definition the instances belongs to. (optional)
   * @param decisionDefinitionKeyIn Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys. (optional)
   * @param decisionDefinitionName Filter by the name of the decision definition the instances belongs to. (optional)
   * @param decisionDefinitionNameLike Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of. (optional)
   * @param processDefinitionId Filter by the process definition the instances belongs to. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the instances belongs to. (optional)
   * @param processInstanceId Filter by the process instance the instances belongs to. (optional)
   * @param caseDefinitionId Filter by the case definition the instances belongs to. (optional)
   * @param caseDefinitionKey Filter by the key of the case definition the instances belongs to. (optional)
   * @param caseInstanceId Filter by the case instance the instances belongs to. (optional)
   * @param activityIdIn Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids. (optional)
   * @param activityInstanceIdIn Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include historic decision instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param evaluatedBefore Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param evaluatedAfter Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param userId Restrict to instances that were evaluated by the given user. (optional)
   * @param rootDecisionInstanceId Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id. (optional)
   * @param rootDecisionInstancesOnly Restrict to instances those are the root decision instance of an evaluation. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param decisionRequirementsDefinitionId Filter by the decision requirements definition the instances belongs to. (optional)
   * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition the instances belongs to. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricDecisionInstancesCount(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, OffsetDateTime evaluatedBefore, OffsetDateTime evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey) throws ApiException {
    return this.getHistoricDecisionInstancesCount(decisionInstanceId, decisionInstanceIdIn, decisionDefinitionId, decisionDefinitionIdIn, decisionDefinitionKey, decisionDefinitionKeyIn, decisionDefinitionName, decisionDefinitionNameLike, processDefinitionId, processDefinitionKey, processInstanceId, caseDefinitionId, caseDefinitionKey, caseInstanceId, activityIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, evaluatedBefore, evaluatedAfter, userId, rootDecisionInstanceId, rootDecisionInstancesOnly, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, Collections.emptyMap());
  }


  /**
   * Get Historic Decision Instance Count
   * Queries for the number of historic decision instances that fulfill the given parameters.  Takes the same parameters as the  [Get Historic Decision Instances](https://docs.camunda.org/manual/7.21/reference/rest/history/decision-instance/get-decision-instance-query/)  method.
   * @param decisionInstanceId Filter by decision instance id. (optional)
   * @param decisionInstanceIdIn Filter by decision instance ids. Must be a comma-separated list of decision instance ids. (optional)
   * @param decisionDefinitionId Filter by the decision definition the instances belongs to. (optional)
   * @param decisionDefinitionIdIn Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids. (optional)
   * @param decisionDefinitionKey Filter by the key of the decision definition the instances belongs to. (optional)
   * @param decisionDefinitionKeyIn Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys. (optional)
   * @param decisionDefinitionName Filter by the name of the decision definition the instances belongs to. (optional)
   * @param decisionDefinitionNameLike Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of. (optional)
   * @param processDefinitionId Filter by the process definition the instances belongs to. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the instances belongs to. (optional)
   * @param processInstanceId Filter by the process instance the instances belongs to. (optional)
   * @param caseDefinitionId Filter by the case definition the instances belongs to. (optional)
   * @param caseDefinitionKey Filter by the key of the case definition the instances belongs to. (optional)
   * @param caseInstanceId Filter by the case instance the instances belongs to. (optional)
   * @param activityIdIn Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids. (optional)
   * @param activityInstanceIdIn Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include historic decision instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param evaluatedBefore Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param evaluatedAfter Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param userId Restrict to instances that were evaluated by the given user. (optional)
   * @param rootDecisionInstanceId Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id. (optional)
   * @param rootDecisionInstancesOnly Restrict to instances those are the root decision instance of an evaluation. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param decisionRequirementsDefinitionId Filter by the decision requirements definition the instances belongs to. (optional)
   * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition the instances belongs to. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricDecisionInstancesCount(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, OffsetDateTime evaluatedBefore, OffsetDateTime evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/decision-instance/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("decisionInstanceId", decisionInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionInstanceIdIn", decisionInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionId", decisionDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionKey", decisionDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionKeyIn", decisionDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionName", decisionDefinitionName));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionDefinitionNameLike", decisionDefinitionNameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseDefinitionKey", caseDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityIdIn", activityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("evaluatedBefore", evaluatedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("evaluatedAfter", evaluatedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("userId", userId));
    localVarQueryParams.addAll(apiClient.parameterToPair("rootDecisionInstanceId", rootDecisionInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("rootDecisionInstancesOnly", rootDecisionInstancesOnly));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Set Removal Time Async (POST)
   * Sets the removal time to multiple historic decision instances asynchronously (batch).  At least &#x60;historicDecisionInstanceIds&#x60; or &#x60;historicDecisionInstanceQuery&#x60; has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.
   * @param setRemovalTimeToHistoricDecisionInstancesDto  (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto setRemovalTimeAsyncHistoricDecisionInstance(SetRemovalTimeToHistoricDecisionInstancesDto setRemovalTimeToHistoricDecisionInstancesDto) throws ApiException {
    return this.setRemovalTimeAsyncHistoricDecisionInstance(setRemovalTimeToHistoricDecisionInstancesDto, Collections.emptyMap());
  }


  /**
   * Set Removal Time Async (POST)
   * Sets the removal time to multiple historic decision instances asynchronously (batch).  At least &#x60;historicDecisionInstanceIds&#x60; or &#x60;historicDecisionInstanceQuery&#x60; has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.
   * @param setRemovalTimeToHistoricDecisionInstancesDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto setRemovalTimeAsyncHistoricDecisionInstance(SetRemovalTimeToHistoricDecisionInstancesDto setRemovalTimeToHistoricDecisionInstancesDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = setRemovalTimeToHistoricDecisionInstancesDto;
    
    // create path and map variables
    String localVarPath = "/history/decision-instance/set-removal-time";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
