/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricDecisionInstanceStatisticsDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricDecisionRequirementsDefinitionApi {


  private ApiClient apiClient;

  public HistoricDecisionRequirementsDefinitionApi() {
    this(Configuration.getDefaultApiClient());
  }

  public HistoricDecisionRequirementsDefinitionApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get DRD Statistics
   * Retrieves evaluation statistics of a given decision requirements definition.
   * @param id The id of the decision requirements definition. (required)
   * @param decisionInstanceId Restrict query results to be based only on specific evaluation instance of a given decision requirements definition. (optional)
   * @return List&lt;HistoricDecisionInstanceStatisticsDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricDecisionInstanceStatisticsDto> getDecisionStatistics(String id, String decisionInstanceId) throws ApiException {
    return this.getDecisionStatistics(id, decisionInstanceId, Collections.emptyMap());
  }


  /**
   * Get DRD Statistics
   * Retrieves evaluation statistics of a given decision requirements definition.
   * @param id The id of the decision requirements definition. (required)
   * @param decisionInstanceId Restrict query results to be based only on specific evaluation instance of a given decision requirements definition. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricDecisionInstanceStatisticsDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricDecisionInstanceStatisticsDto> getDecisionStatistics(String id, String decisionInstanceId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getDecisionStatistics");
    }
    
    // create path and map variables
    String localVarPath = "/history/decision-requirements-definition/{id}/statistics"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("decisionInstanceId", decisionInstanceId));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricDecisionInstanceStatisticsDto>> localVarReturnType = new TypeReference<List<HistoricDecisionInstanceStatisticsDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
