/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import java.io.File;
import org.camunda.community.rest.client.dto.HistoricDetailDto;
import org.camunda.community.rest.client.dto.HistoricDetailQueryDto;
import java.time.OffsetDateTime;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricDetailApi {


  private ApiClient apiClient;

  public HistoricDetailApi() {
    this(Configuration.getDefaultApiClient());
  }

  public HistoricDetailApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get Historic Details
   * Queries for historic details that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.21/reference/rest/history/detail/get-detail-query-count/) method.
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processInstanceIdIn Only include historic details which belong to one of the passed comma-separated process instance ids. (optional)
   * @param executionId Filter by execution id. (optional)
   * @param taskId Filter by task id. (optional)
   * @param activityInstanceId Filter by activity instance id. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param caseExecutionId Filter by case execution id. (optional)
   * @param variableInstanceId Filter by variable instance id. (optional)
   * @param variableTypeIn Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.21/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
   * @param withoutTenantId Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param userOperationId Filter by a user operation id. (optional)
   * @param formFields Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param variableUpdates Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param excludeTaskDetails Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param initial Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param occurredBefore Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param occurredAfter Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @return List&lt;HistoricDetailDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricDetailDto> getHistoricDetails(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, OffsetDateTime occurredBefore, OffsetDateTime occurredAfter, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues) throws ApiException {
    return this.getHistoricDetails(processInstanceId, processInstanceIdIn, executionId, taskId, activityInstanceId, caseInstanceId, caseExecutionId, variableInstanceId, variableTypeIn, tenantIdIn, withoutTenantId, userOperationId, formFields, variableUpdates, excludeTaskDetails, initial, occurredBefore, occurredAfter, sortBy, sortOrder, firstResult, maxResults, deserializeValues, Collections.emptyMap());
  }


  /**
   * Get Historic Details
   * Queries for historic details that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.21/reference/rest/history/detail/get-detail-query-count/) method.
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processInstanceIdIn Only include historic details which belong to one of the passed comma-separated process instance ids. (optional)
   * @param executionId Filter by execution id. (optional)
   * @param taskId Filter by task id. (optional)
   * @param activityInstanceId Filter by activity instance id. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param caseExecutionId Filter by case execution id. (optional)
   * @param variableInstanceId Filter by variable instance id. (optional)
   * @param variableTypeIn Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.21/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
   * @param withoutTenantId Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param userOperationId Filter by a user operation id. (optional)
   * @param formFields Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param variableUpdates Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param excludeTaskDetails Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param initial Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param occurredBefore Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param occurredAfter Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricDetailDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricDetailDto> getHistoricDetails(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, OffsetDateTime occurredBefore, OffsetDateTime occurredAfter, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/detail";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionId", executionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskId", taskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityInstanceId", activityInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseExecutionId", caseExecutionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableInstanceId", variableInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableTypeIn", variableTypeIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("userOperationId", userOperationId));
    localVarQueryParams.addAll(apiClient.parameterToPair("formFields", formFields));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableUpdates", variableUpdates));
    localVarQueryParams.addAll(apiClient.parameterToPair("excludeTaskDetails", excludeTaskDetails));
    localVarQueryParams.addAll(apiClient.parameterToPair("initial", initial));
    localVarQueryParams.addAll(apiClient.parameterToPair("occurredBefore", occurredBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("occurredAfter", occurredAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    localVarQueryParams.addAll(apiClient.parameterToPair("deserializeValues", deserializeValues));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricDetailDto>> localVarReturnType = new TypeReference<List<HistoricDetailDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Historic Detail Count
   * Queries for the number of historic details that fulfill the given parameters. Takes the same parameters as the [Get Historic Details](https://docs.camunda.org/manual/7.21/reference/rest/history/detail/get-detail-query/) method.
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processInstanceIdIn Only include historic details which belong to one of the passed comma-separated process instance ids. (optional)
   * @param executionId Filter by execution id. (optional)
   * @param taskId Filter by task id. (optional)
   * @param activityInstanceId Filter by activity instance id. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param caseExecutionId Filter by case execution id. (optional)
   * @param variableInstanceId Filter by variable instance id. (optional)
   * @param variableTypeIn Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.21/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
   * @param withoutTenantId Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param userOperationId Filter by a user operation id. (optional)
   * @param formFields Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param variableUpdates Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param excludeTaskDetails Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param initial Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param occurredBefore Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param occurredAfter Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricDetailsCount(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, OffsetDateTime occurredBefore, OffsetDateTime occurredAfter) throws ApiException {
    return this.getHistoricDetailsCount(processInstanceId, processInstanceIdIn, executionId, taskId, activityInstanceId, caseInstanceId, caseExecutionId, variableInstanceId, variableTypeIn, tenantIdIn, withoutTenantId, userOperationId, formFields, variableUpdates, excludeTaskDetails, initial, occurredBefore, occurredAfter, Collections.emptyMap());
  }


  /**
   * Get Historic Detail Count
   * Queries for the number of historic details that fulfill the given parameters. Takes the same parameters as the [Get Historic Details](https://docs.camunda.org/manual/7.21/reference/rest/history/detail/get-detail-query/) method.
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processInstanceIdIn Only include historic details which belong to one of the passed comma-separated process instance ids. (optional)
   * @param executionId Filter by execution id. (optional)
   * @param taskId Filter by task id. (optional)
   * @param activityInstanceId Filter by activity instance id. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param caseExecutionId Filter by case execution id. (optional)
   * @param variableInstanceId Filter by variable instance id. (optional)
   * @param variableTypeIn Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.21/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
   * @param withoutTenantId Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param userOperationId Filter by a user operation id. (optional)
   * @param formFields Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param variableUpdates Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param excludeTaskDetails Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param initial Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param occurredBefore Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param occurredAfter Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricDetailsCount(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, OffsetDateTime occurredBefore, OffsetDateTime occurredAfter, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/detail/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionId", executionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskId", taskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityInstanceId", activityInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseExecutionId", caseExecutionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableInstanceId", variableInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableTypeIn", variableTypeIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("userOperationId", userOperationId));
    localVarQueryParams.addAll(apiClient.parameterToPair("formFields", formFields));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableUpdates", variableUpdates));
    localVarQueryParams.addAll(apiClient.parameterToPair("excludeTaskDetails", excludeTaskDetails));
    localVarQueryParams.addAll(apiClient.parameterToPair("initial", initial));
    localVarQueryParams.addAll(apiClient.parameterToPair("occurredBefore", occurredBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("occurredAfter", occurredAfter));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Historic Detail
   * Retrieves a historic detail by id.
   * @param id The id of the detail. (required)
   * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @return HistoricDetailDto
   * @throws ApiException if fails to make API call
   */
  public HistoricDetailDto historicDetail(String id, Boolean deserializeValue) throws ApiException {
    return this.historicDetail(id, deserializeValue, Collections.emptyMap());
  }


  /**
   * Get Historic Detail
   * Retrieves a historic detail by id.
   * @param id The id of the detail. (required)
   * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return HistoricDetailDto
   * @throws ApiException if fails to make API call
   */
  public HistoricDetailDto historicDetail(String id, Boolean deserializeValue, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling historicDetail");
    }
    
    // create path and map variables
    String localVarPath = "/history/detail/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("deserializeValue", deserializeValue));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<HistoricDetailDto> localVarReturnType = new TypeReference<HistoricDetailDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Historic Detail (Binary)
   * Retrieves the content of a historic variable update by id. Applicable for byte array and file variables.
   * @param id The id of the historic variable update. (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File historicDetailBinary(String id) throws ApiException {
    return this.historicDetailBinary(id, Collections.emptyMap());
  }


  /**
   * Get Historic Detail (Binary)
   * Retrieves the content of a historic variable update by id. Applicable for byte array and file variables.
   * @param id The id of the historic variable update. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File historicDetailBinary(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling historicDetailBinary");
    }
    
    // create path and map variables
    String localVarPath = "/history/detail/{id}/data"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/octet-stream", "*/*", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<File> localVarReturnType = new TypeReference<File>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Historic Details (POST)
   * Queries for historic details that fulfill the given parameters. This method is slightly more powerful than the [Get Historic Details](https://docs.camunda.org/manual/7.21/reference/rest/history/detail/get-detail-query/) method because it allows sorting by multiple parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.21/reference/rest/history/detail/get-detail-query-count/) method.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @param historicDetailQueryDto  (optional)
   * @return List&lt;HistoricDetailDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricDetailDto> queryHistoricDetails(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricDetailQueryDto historicDetailQueryDto) throws ApiException {
    return this.queryHistoricDetails(firstResult, maxResults, deserializeValues, historicDetailQueryDto, Collections.emptyMap());
  }


  /**
   * Get Historic Details (POST)
   * Queries for historic details that fulfill the given parameters. This method is slightly more powerful than the [Get Historic Details](https://docs.camunda.org/manual/7.21/reference/rest/history/detail/get-detail-query/) method because it allows sorting by multiple parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.21/reference/rest/history/detail/get-detail-query-count/) method.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @param historicDetailQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricDetailDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricDetailDto> queryHistoricDetails(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricDetailQueryDto historicDetailQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historicDetailQueryDto;
    
    // create path and map variables
    String localVarPath = "/history/detail";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    localVarQueryParams.addAll(apiClient.parameterToPair("deserializeValues", deserializeValues));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricDetailDto>> localVarReturnType = new TypeReference<List<HistoricDetailDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
