/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricExternalTaskLogDto;
import org.camunda.community.rest.client.dto.HistoricExternalTaskLogQueryDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricExternalTaskLogApi {


  private ApiClient apiClient;

  public HistoricExternalTaskLogApi() {
    this(Configuration.getDefaultApiClient());
  }

  public HistoricExternalTaskLogApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get External Task Log Error Details
   * Retrieves the corresponding error details of the passed historic external task log by id.
   * @param id The id of the historic external task log to get the error details for. (required)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object getErrorDetailsHistoricExternalTaskLog(String id) throws ApiException {
    return this.getErrorDetailsHistoricExternalTaskLog(id, Collections.emptyMap());
  }


  /**
   * Get External Task Log Error Details
   * Retrieves the corresponding error details of the passed historic external task log by id.
   * @param id The id of the historic external task log to get the error details for. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object getErrorDetailsHistoricExternalTaskLog(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getErrorDetailsHistoricExternalTaskLog");
    }
    
    // create path and map variables
    String localVarPath = "/history/external-task-log/{id}/error-details"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "text/plain", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<Object> localVarReturnType = new TypeReference<Object>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get External Task Log
   * Retrieves a historic external task log by id.
   * @param id The id of the log entry. (required)
   * @return HistoricExternalTaskLogDto
   * @throws ApiException if fails to make API call
   */
  public HistoricExternalTaskLogDto getHistoricExternalTaskLog(String id) throws ApiException {
    return this.getHistoricExternalTaskLog(id, Collections.emptyMap());
  }


  /**
   * Get External Task Log
   * Retrieves a historic external task log by id.
   * @param id The id of the log entry. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return HistoricExternalTaskLogDto
   * @throws ApiException if fails to make API call
   */
  public HistoricExternalTaskLogDto getHistoricExternalTaskLog(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getHistoricExternalTaskLog");
    }
    
    // create path and map variables
    String localVarPath = "/history/external-task-log/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<HistoricExternalTaskLogDto> localVarReturnType = new TypeReference<HistoricExternalTaskLogDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get External Task Logs
   * Queries for historic external task logs that fulfill the given parameters. The size of the result set can be retrieved by using the [Get External Task Log Count](https://docs.camunda.org/manual/7.21/reference/rest/history/external-task-log/get-external-task-log-query-count/) method.
   * @param logId Filter by historic external task log id. (optional)
   * @param externalTaskId Filter by external task id. (optional)
   * @param topicName Filter by an external task topic. (optional)
   * @param workerId Filter by the id of the worker that the task was most recently locked by. (optional)
   * @param errorMessage Filter by external task exception message. (optional)
   * @param activityIdIn Only include historic external task logs which belong to one of the passed activity ids. (optional)
   * @param activityInstanceIdIn Only include historic external task logs which belong to one of the passed activity instance ids. (optional)
   * @param executionIdIn Only include historic external task logs which belong to one of the passed execution ids. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Filter by process definition key. (optional)
   * @param tenantIdIn Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include historic external task log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param priorityLowerThanOrEquals Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param priorityHigherThanOrEquals Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;HistoricExternalTaskLogDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricExternalTaskLogDto> getHistoricExternalTaskLogs(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.getHistoricExternalTaskLogs(logId, externalTaskId, topicName, workerId, errorMessage, activityIdIn, activityInstanceIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, tenantIdIn, withoutTenantId, priorityLowerThanOrEquals, priorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get External Task Logs
   * Queries for historic external task logs that fulfill the given parameters. The size of the result set can be retrieved by using the [Get External Task Log Count](https://docs.camunda.org/manual/7.21/reference/rest/history/external-task-log/get-external-task-log-query-count/) method.
   * @param logId Filter by historic external task log id. (optional)
   * @param externalTaskId Filter by external task id. (optional)
   * @param topicName Filter by an external task topic. (optional)
   * @param workerId Filter by the id of the worker that the task was most recently locked by. (optional)
   * @param errorMessage Filter by external task exception message. (optional)
   * @param activityIdIn Only include historic external task logs which belong to one of the passed activity ids. (optional)
   * @param activityInstanceIdIn Only include historic external task logs which belong to one of the passed activity instance ids. (optional)
   * @param executionIdIn Only include historic external task logs which belong to one of the passed execution ids. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Filter by process definition key. (optional)
   * @param tenantIdIn Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include historic external task log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param priorityLowerThanOrEquals Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param priorityHigherThanOrEquals Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricExternalTaskLogDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricExternalTaskLogDto> getHistoricExternalTaskLogs(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/external-task-log";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("logId", logId));
    localVarQueryParams.addAll(apiClient.parameterToPair("externalTaskId", externalTaskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("topicName", topicName));
    localVarQueryParams.addAll(apiClient.parameterToPair("workerId", workerId));
    localVarQueryParams.addAll(apiClient.parameterToPair("errorMessage", errorMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityIdIn", activityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionIdIn", executionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
    localVarQueryParams.addAll(apiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
    localVarQueryParams.addAll(apiClient.parameterToPair("creationLog", creationLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("failureLog", failureLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("successLog", successLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("deletionLog", deletionLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricExternalTaskLogDto>> localVarReturnType = new TypeReference<List<HistoricExternalTaskLogDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get External Task Log Count
   * Queries for the number of historic external task logs that fulfill the given parameters. Takes the same parameters as the [Get External Task Logs](https://docs.camunda.org/manual/7.21/reference/rest/history/external-task-log/get-external-task-log-query/) method.
   * @param logId Filter by historic external task log id. (optional)
   * @param externalTaskId Filter by external task id. (optional)
   * @param topicName Filter by an external task topic. (optional)
   * @param workerId Filter by the id of the worker that the task was most recently locked by. (optional)
   * @param errorMessage Filter by external task exception message. (optional)
   * @param activityIdIn Only include historic external task logs which belong to one of the passed activity ids. (optional)
   * @param activityInstanceIdIn Only include historic external task logs which belong to one of the passed activity instance ids. (optional)
   * @param executionIdIn Only include historic external task logs which belong to one of the passed execution ids. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Filter by process definition key. (optional)
   * @param tenantIdIn Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include historic external task log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param priorityLowerThanOrEquals Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param priorityHigherThanOrEquals Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricExternalTaskLogsCount(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog) throws ApiException {
    return this.getHistoricExternalTaskLogsCount(logId, externalTaskId, topicName, workerId, errorMessage, activityIdIn, activityInstanceIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, tenantIdIn, withoutTenantId, priorityLowerThanOrEquals, priorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, Collections.emptyMap());
  }


  /**
   * Get External Task Log Count
   * Queries for the number of historic external task logs that fulfill the given parameters. Takes the same parameters as the [Get External Task Logs](https://docs.camunda.org/manual/7.21/reference/rest/history/external-task-log/get-external-task-log-query/) method.
   * @param logId Filter by historic external task log id. (optional)
   * @param externalTaskId Filter by external task id. (optional)
   * @param topicName Filter by an external task topic. (optional)
   * @param workerId Filter by the id of the worker that the task was most recently locked by. (optional)
   * @param errorMessage Filter by external task exception message. (optional)
   * @param activityIdIn Only include historic external task logs which belong to one of the passed activity ids. (optional)
   * @param activityInstanceIdIn Only include historic external task logs which belong to one of the passed activity instance ids. (optional)
   * @param executionIdIn Only include historic external task logs which belong to one of the passed execution ids. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Filter by process definition key. (optional)
   * @param tenantIdIn Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include historic external task log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param priorityLowerThanOrEquals Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param priorityHigherThanOrEquals Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricExternalTaskLogsCount(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/external-task-log/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("logId", logId));
    localVarQueryParams.addAll(apiClient.parameterToPair("externalTaskId", externalTaskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("topicName", topicName));
    localVarQueryParams.addAll(apiClient.parameterToPair("workerId", workerId));
    localVarQueryParams.addAll(apiClient.parameterToPair("errorMessage", errorMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityIdIn", activityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionIdIn", executionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
    localVarQueryParams.addAll(apiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
    localVarQueryParams.addAll(apiClient.parameterToPair("creationLog", creationLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("failureLog", failureLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("successLog", successLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("deletionLog", deletionLog));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get External Task Logs (POST)
   * Queries for historic external task logs that fulfill the given parameters. This method is slightly more powerful than the [Get External Task Logs](https://docs.camunda.org/manual/7.21/reference/rest/history/external-task-log/get-external-task-log-query/) method because it allows filtering by historic external task logs values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param historicExternalTaskLogQueryDto  (optional)
   * @return List&lt;HistoricExternalTaskLogDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricExternalTaskLogDto> queryHistoricExternalTaskLogs(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto) throws ApiException {
    return this.queryHistoricExternalTaskLogs(historicExternalTaskLogQueryDto, Collections.emptyMap());
  }


  /**
   * Get External Task Logs (POST)
   * Queries for historic external task logs that fulfill the given parameters. This method is slightly more powerful than the [Get External Task Logs](https://docs.camunda.org/manual/7.21/reference/rest/history/external-task-log/get-external-task-log-query/) method because it allows filtering by historic external task logs values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param historicExternalTaskLogQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricExternalTaskLogDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricExternalTaskLogDto> queryHistoricExternalTaskLogs(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historicExternalTaskLogQueryDto;
    
    // create path and map variables
    String localVarPath = "/history/external-task-log";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricExternalTaskLogDto>> localVarReturnType = new TypeReference<List<HistoricExternalTaskLogDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get External Task Log Count (POST)
   * Queries for the number of historic external task logs that fulfill the given parameters. This method takes the same message body as the [Get External Task Logs (POST)](https://docs.camunda.org/manual/7.21/reference/rest/history/external-task-log/post-external-task-log-query/) method and therefore it is slightly more powerful than the [Get External Task Log Count](https://docs.camunda.org/manual/7.21/reference/rest/history/external-task-log/get-external-task-log-query-count/) method.
   * @param historicExternalTaskLogQueryDto  (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryHistoricExternalTaskLogsCount(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto) throws ApiException {
    return this.queryHistoricExternalTaskLogsCount(historicExternalTaskLogQueryDto, Collections.emptyMap());
  }


  /**
   * Get External Task Log Count (POST)
   * Queries for the number of historic external task logs that fulfill the given parameters. This method takes the same message body as the [Get External Task Logs (POST)](https://docs.camunda.org/manual/7.21/reference/rest/history/external-task-log/post-external-task-log-query/) method and therefore it is slightly more powerful than the [Get External Task Log Count](https://docs.camunda.org/manual/7.21/reference/rest/history/external-task-log/get-external-task-log-query-count/) method.
   * @param historicExternalTaskLogQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryHistoricExternalTaskLogsCount(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historicExternalTaskLogQueryDto;
    
    // create path and map variables
    String localVarPath = "/history/external-task-log/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
