/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricIdentityLinkLogDto;
import java.time.OffsetDateTime;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricIdentityLinkLogApi {


  private ApiClient apiClient;

  public HistoricIdentityLinkLogApi() {
    this(Configuration.getDefaultApiClient());
  }

  public HistoricIdentityLinkLogApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get Identity Link Logs
   * Queries for historic identity link logs that fulfill given parameters. The size of the result set can be retrieved by using the [Get Identity-Link-Log Count](https://docs.camunda.org/manual/7.21/reference/rest/history/identity-links/get-identity-link-query-count/) method.
   * @param type Restricts to identity links that have the given type (candidate/assignee/owner). (optional)
   * @param userId Restricts to identity links that have the given user id. (optional)
   * @param groupId Restricts to identity links that have the given group id. (optional)
   * @param dateBefore Restricts to identity links that have the time before the given time. (optional)
   * @param dateAfter Restricts to identity links that have the time after the given time. (optional)
   * @param taskId Restricts to identity links that have the given task id. (optional)
   * @param processDefinitionId Restricts to identity links that have the given process definition id. (optional)
   * @param processDefinitionKey Restricts to identity links that have the given process definition key. (optional)
   * @param operationType Restricts to identity links that have the given operationType (add/delete). (optional)
   * @param assignerId Restricts to identity links that have the given assigner id. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
   * @param withoutTenantId Only include historic identity links that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;HistoricIdentityLinkLogDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricIdentityLinkLogDto> getHistoricIdentityLinks(String type, String userId, String groupId, OffsetDateTime dateBefore, OffsetDateTime dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.getHistoricIdentityLinks(type, userId, groupId, dateBefore, dateAfter, taskId, processDefinitionId, processDefinitionKey, operationType, assignerId, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get Identity Link Logs
   * Queries for historic identity link logs that fulfill given parameters. The size of the result set can be retrieved by using the [Get Identity-Link-Log Count](https://docs.camunda.org/manual/7.21/reference/rest/history/identity-links/get-identity-link-query-count/) method.
   * @param type Restricts to identity links that have the given type (candidate/assignee/owner). (optional)
   * @param userId Restricts to identity links that have the given user id. (optional)
   * @param groupId Restricts to identity links that have the given group id. (optional)
   * @param dateBefore Restricts to identity links that have the time before the given time. (optional)
   * @param dateAfter Restricts to identity links that have the time after the given time. (optional)
   * @param taskId Restricts to identity links that have the given task id. (optional)
   * @param processDefinitionId Restricts to identity links that have the given process definition id. (optional)
   * @param processDefinitionKey Restricts to identity links that have the given process definition key. (optional)
   * @param operationType Restricts to identity links that have the given operationType (add/delete). (optional)
   * @param assignerId Restricts to identity links that have the given assigner id. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
   * @param withoutTenantId Only include historic identity links that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricIdentityLinkLogDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricIdentityLinkLogDto> getHistoricIdentityLinks(String type, String userId, String groupId, OffsetDateTime dateBefore, OffsetDateTime dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/identity-link-log";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
    localVarQueryParams.addAll(apiClient.parameterToPair("userId", userId));
    localVarQueryParams.addAll(apiClient.parameterToPair("groupId", groupId));
    localVarQueryParams.addAll(apiClient.parameterToPair("dateBefore", dateBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("dateAfter", dateAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskId", taskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("operationType", operationType));
    localVarQueryParams.addAll(apiClient.parameterToPair("assignerId", assignerId));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricIdentityLinkLogDto>> localVarReturnType = new TypeReference<List<HistoricIdentityLinkLogDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Identity Link Log Count
   * Queries for the number of historic identity link logs that fulfill the given parameters. Takes the same parameters as the [Get Identity-Link-Logs](https://docs.camunda.org/manual/7.21/reference/rest/history/identity-links/get-identity-link-query/) method.
   * @param type Restricts to identity links that have the given type (candidate/assignee/owner). (optional)
   * @param userId Restricts to identity links that have the given user id. (optional)
   * @param groupId Restricts to identity links that have the given group id. (optional)
   * @param dateBefore Restricts to identity links that have the time before the given time. (optional)
   * @param dateAfter Restricts to identity links that have the time after the given time. (optional)
   * @param taskId Restricts to identity links that have the given task id. (optional)
   * @param processDefinitionId Restricts to identity links that have the given process definition id. (optional)
   * @param processDefinitionKey Restricts to identity links that have the given process definition key. (optional)
   * @param operationType Restricts to identity links that have the given operationType (add/delete). (optional)
   * @param assignerId Restricts to identity links that have the given assigner id. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
   * @param withoutTenantId Only include historic identity links that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricIdentityLinksCount(String type, String userId, String groupId, OffsetDateTime dateBefore, OffsetDateTime dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
    return this.getHistoricIdentityLinksCount(type, userId, groupId, dateBefore, dateAfter, taskId, processDefinitionId, processDefinitionKey, operationType, assignerId, tenantIdIn, withoutTenantId, Collections.emptyMap());
  }


  /**
   * Get Identity Link Log Count
   * Queries for the number of historic identity link logs that fulfill the given parameters. Takes the same parameters as the [Get Identity-Link-Logs](https://docs.camunda.org/manual/7.21/reference/rest/history/identity-links/get-identity-link-query/) method.
   * @param type Restricts to identity links that have the given type (candidate/assignee/owner). (optional)
   * @param userId Restricts to identity links that have the given user id. (optional)
   * @param groupId Restricts to identity links that have the given group id. (optional)
   * @param dateBefore Restricts to identity links that have the time before the given time. (optional)
   * @param dateAfter Restricts to identity links that have the time after the given time. (optional)
   * @param taskId Restricts to identity links that have the given task id. (optional)
   * @param processDefinitionId Restricts to identity links that have the given process definition id. (optional)
   * @param processDefinitionKey Restricts to identity links that have the given process definition key. (optional)
   * @param operationType Restricts to identity links that have the given operationType (add/delete). (optional)
   * @param assignerId Restricts to identity links that have the given assigner id. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
   * @param withoutTenantId Only include historic identity links that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricIdentityLinksCount(String type, String userId, String groupId, OffsetDateTime dateBefore, OffsetDateTime dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/identity-link-log/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
    localVarQueryParams.addAll(apiClient.parameterToPair("userId", userId));
    localVarQueryParams.addAll(apiClient.parameterToPair("groupId", groupId));
    localVarQueryParams.addAll(apiClient.parameterToPair("dateBefore", dateBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("dateAfter", dateAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskId", taskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("operationType", operationType));
    localVarQueryParams.addAll(apiClient.parameterToPair("assignerId", assignerId));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
