/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricIncidentDto;
import java.time.OffsetDateTime;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricIncidentApi {


  private ApiClient apiClient;

  public HistoricIncidentApi() {
    this(Configuration.getDefaultApiClient());
  }

  public HistoricIncidentApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get Incidents
   * Queries for historic incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.21/reference/rest/history/incident/get-incident-query-count/) method.
   * @param incidentId Restricts to incidents that have the given id. (optional)
   * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
   * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (string%), ends with (%string) or contains (%string%).  (optional)
   * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
   * @param processDefinitionKey Restricts to incidents that have the given processDefinitionKey. (optional)
   * @param processDefinitionKeyIn Restricts to incidents that have one of the given process definition keys. (optional)
   * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
   * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
   * @param createTimeBefore Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param createTimeAfter Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param endTimeBefore Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param endTimeAfter Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
   * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
   * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
   * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
   * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
   * @param historyConfiguration Restricts to incidents that have the given parameter set as history configuration. (optional)
   * @param open Restricts to incidents that are open. (optional)
   * @param resolved Restricts to incidents that are resolved. (optional)
   * @param deleted Restricts to incidents that are deleted. (optional)
   * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include historic incidents that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;HistoricIncidentDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricIncidentDto> getHistoricIncidents(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, OffsetDateTime createTimeBefore, OffsetDateTime createTimeAfter, OffsetDateTime endTimeBefore, OffsetDateTime endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.getHistoricIncidents(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processInstanceId, executionId, createTimeBefore, createTimeAfter, endTimeBefore, endTimeAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, historyConfiguration, open, resolved, deleted, tenantIdIn, withoutTenantId, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get Incidents
   * Queries for historic incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.21/reference/rest/history/incident/get-incident-query-count/) method.
   * @param incidentId Restricts to incidents that have the given id. (optional)
   * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
   * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (string%), ends with (%string) or contains (%string%).  (optional)
   * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
   * @param processDefinitionKey Restricts to incidents that have the given processDefinitionKey. (optional)
   * @param processDefinitionKeyIn Restricts to incidents that have one of the given process definition keys. (optional)
   * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
   * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
   * @param createTimeBefore Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param createTimeAfter Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param endTimeBefore Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param endTimeAfter Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
   * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
   * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
   * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
   * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
   * @param historyConfiguration Restricts to incidents that have the given parameter set as history configuration. (optional)
   * @param open Restricts to incidents that are open. (optional)
   * @param resolved Restricts to incidents that are resolved. (optional)
   * @param deleted Restricts to incidents that are deleted. (optional)
   * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include historic incidents that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricIncidentDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricIncidentDto> getHistoricIncidents(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, OffsetDateTime createTimeBefore, OffsetDateTime createTimeAfter, OffsetDateTime endTimeBefore, OffsetDateTime endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/incident";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("incidentId", incidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentType", incidentType));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessage", incidentMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionId", executionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("createTimeBefore", createTimeBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("createTimeAfter", createTimeAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("endTimeBefore", endTimeBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("endTimeAfter", endTimeAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityId", activityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("failedActivityId", failedActivityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("causeIncidentId", causeIncidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("rootCauseIncidentId", rootCauseIncidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("configuration", _configuration));
    localVarQueryParams.addAll(apiClient.parameterToPair("historyConfiguration", historyConfiguration));
    localVarQueryParams.addAll(apiClient.parameterToPair("open", open));
    localVarQueryParams.addAll(apiClient.parameterToPair("resolved", resolved));
    localVarQueryParams.addAll(apiClient.parameterToPair("deleted", deleted));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionIdIn", jobDefinitionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricIncidentDto>> localVarReturnType = new TypeReference<List<HistoricIncidentDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Incident Count
   * Queries for the number of historic incidents that fulfill the given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.21/reference/rest/history/incident/get-incident-query/) method.
   * @param incidentId Restricts to incidents that have the given id. (optional)
   * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
   * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (string%), ends with (%string) or contains (%string%).  (optional)
   * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
   * @param processDefinitionKey Restricts to incidents that have the given processDefinitionKey. (optional)
   * @param processDefinitionKeyIn Restricts to incidents that have one of the given process definition keys. (optional)
   * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
   * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
   * @param createTimeBefore Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param createTimeAfter Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param endTimeBefore Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param endTimeAfter Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
   * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
   * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
   * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
   * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
   * @param historyConfiguration Restricts to incidents that have the given parameter set as history configuration. (optional)
   * @param open Restricts to incidents that are open. (optional)
   * @param resolved Restricts to incidents that are resolved. (optional)
   * @param deleted Restricts to incidents that are deleted. (optional)
   * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include historic incidents that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricIncidentsCount(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, OffsetDateTime createTimeBefore, OffsetDateTime createTimeAfter, OffsetDateTime endTimeBefore, OffsetDateTime endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn) throws ApiException {
    return this.getHistoricIncidentsCount(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processInstanceId, executionId, createTimeBefore, createTimeAfter, endTimeBefore, endTimeAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, historyConfiguration, open, resolved, deleted, tenantIdIn, withoutTenantId, jobDefinitionIdIn, Collections.emptyMap());
  }


  /**
   * Get Incident Count
   * Queries for the number of historic incidents that fulfill the given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.21/reference/rest/history/incident/get-incident-query/) method.
   * @param incidentId Restricts to incidents that have the given id. (optional)
   * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
   * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (string%), ends with (%string) or contains (%string%).  (optional)
   * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
   * @param processDefinitionKey Restricts to incidents that have the given processDefinitionKey. (optional)
   * @param processDefinitionKeyIn Restricts to incidents that have one of the given process definition keys. (optional)
   * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
   * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
   * @param createTimeBefore Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param createTimeAfter Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param endTimeBefore Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param endTimeAfter Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
   * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
   * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
   * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
   * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
   * @param historyConfiguration Restricts to incidents that have the given parameter set as history configuration. (optional)
   * @param open Restricts to incidents that are open. (optional)
   * @param resolved Restricts to incidents that are resolved. (optional)
   * @param deleted Restricts to incidents that are deleted. (optional)
   * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include historic incidents that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricIncidentsCount(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processInstanceId, String executionId, OffsetDateTime createTimeBefore, OffsetDateTime createTimeAfter, OffsetDateTime endTimeBefore, OffsetDateTime endTimeAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String historyConfiguration, Boolean open, Boolean resolved, Boolean deleted, String tenantIdIn, Boolean withoutTenantId, String jobDefinitionIdIn, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/incident/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("incidentId", incidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentType", incidentType));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessage", incidentMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionId", executionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("createTimeBefore", createTimeBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("createTimeAfter", createTimeAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("endTimeBefore", endTimeBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("endTimeAfter", endTimeAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityId", activityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("failedActivityId", failedActivityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("causeIncidentId", causeIncidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("rootCauseIncidentId", rootCauseIncidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("configuration", _configuration));
    localVarQueryParams.addAll(apiClient.parameterToPair("historyConfiguration", historyConfiguration));
    localVarQueryParams.addAll(apiClient.parameterToPair("open", open));
    localVarQueryParams.addAll(apiClient.parameterToPair("resolved", resolved));
    localVarQueryParams.addAll(apiClient.parameterToPair("deleted", deleted));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionIdIn", jobDefinitionIdIn));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
