/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricJobLogDto;
import org.camunda.community.rest.client.dto.HistoricJobLogQueryDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricJobLogApi {


  private ApiClient apiClient;

  public HistoricJobLogApi() {
    this(Configuration.getDefaultApiClient());
  }

  public HistoricJobLogApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get Job Log
   * Retrieves a historic job log by id.
   * @param id The id of the log entry. (required)
   * @return HistoricJobLogDto
   * @throws ApiException if fails to make API call
   */
  public HistoricJobLogDto getHistoricJobLog(String id) throws ApiException {
    return this.getHistoricJobLog(id, Collections.emptyMap());
  }


  /**
   * Get Job Log
   * Retrieves a historic job log by id.
   * @param id The id of the log entry. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return HistoricJobLogDto
   * @throws ApiException if fails to make API call
   */
  public HistoricJobLogDto getHistoricJobLog(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getHistoricJobLog");
    }
    
    // create path and map variables
    String localVarPath = "/history/job-log/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<HistoricJobLogDto> localVarReturnType = new TypeReference<HistoricJobLogDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Job Logs
   * Queries for historic job logs that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Job Log Count](https://docs.camunda.org/manual/7.21/reference/rest/history/job-log/get-job-log-query-count/) method.
   * @param logId Filter by historic job log id. (optional)
   * @param jobId Filter by job id. (optional)
   * @param jobExceptionMessage Filter by job exception message. (optional)
   * @param jobDefinitionId Filter by job definition id. (optional)
   * @param jobDefinitionType Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types. (optional)
   * @param jobDefinitionConfiguration Filter by job definition configuration. (optional)
   * @param activityIdIn Only include historic job logs which belong to one of the passed activity ids. (optional)
   * @param failedActivityIdIn Only include historic job logs which belong to failures of one of the passed activity ids. (optional)
   * @param executionIdIn Only include historic job logs which belong to one of the passed execution ids. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Filter by process definition key. (optional)
   * @param deploymentId Filter by deployment id. (optional)
   * @param tenantIdIn Only include historic job log entries which belong to one of the passed and comma- separated tenant ids. (optional)
   * @param withoutTenantId Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param hostname Filter by hostname. (optional)
   * @param jobPriorityLowerThanOrEquals Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param jobPriorityHigherThanOrEquals Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;HistoricJobLogDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricJobLogDto> getHistoricJobLogs(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.getHistoricJobLogs(logId, jobId, jobExceptionMessage, jobDefinitionId, jobDefinitionType, jobDefinitionConfiguration, activityIdIn, failedActivityIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, deploymentId, tenantIdIn, withoutTenantId, hostname, jobPriorityLowerThanOrEquals, jobPriorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get Job Logs
   * Queries for historic job logs that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Job Log Count](https://docs.camunda.org/manual/7.21/reference/rest/history/job-log/get-job-log-query-count/) method.
   * @param logId Filter by historic job log id. (optional)
   * @param jobId Filter by job id. (optional)
   * @param jobExceptionMessage Filter by job exception message. (optional)
   * @param jobDefinitionId Filter by job definition id. (optional)
   * @param jobDefinitionType Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types. (optional)
   * @param jobDefinitionConfiguration Filter by job definition configuration. (optional)
   * @param activityIdIn Only include historic job logs which belong to one of the passed activity ids. (optional)
   * @param failedActivityIdIn Only include historic job logs which belong to failures of one of the passed activity ids. (optional)
   * @param executionIdIn Only include historic job logs which belong to one of the passed execution ids. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Filter by process definition key. (optional)
   * @param deploymentId Filter by deployment id. (optional)
   * @param tenantIdIn Only include historic job log entries which belong to one of the passed and comma- separated tenant ids. (optional)
   * @param withoutTenantId Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param hostname Filter by hostname. (optional)
   * @param jobPriorityLowerThanOrEquals Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param jobPriorityHigherThanOrEquals Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricJobLogDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricJobLogDto> getHistoricJobLogs(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/job-log";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("logId", logId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobId", jobId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobExceptionMessage", jobExceptionMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionType", jobDefinitionType));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionConfiguration", jobDefinitionConfiguration));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityIdIn", activityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("failedActivityIdIn", failedActivityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionIdIn", executionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("deploymentId", deploymentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("hostname", hostname));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobPriorityLowerThanOrEquals", jobPriorityLowerThanOrEquals));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobPriorityHigherThanOrEquals", jobPriorityHigherThanOrEquals));
    localVarQueryParams.addAll(apiClient.parameterToPair("creationLog", creationLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("failureLog", failureLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("successLog", successLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("deletionLog", deletionLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricJobLogDto>> localVarReturnType = new TypeReference<List<HistoricJobLogDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Job Log Count
   * Queries for the number of historic job logs that fulfill the given parameters. Takes the same parameters as the [Get Job Logs](https://docs.camunda.org/manual/7.21/reference/rest/history/job-log/get-job-log-query/) method.
   * @param logId Filter by historic job log id. (optional)
   * @param jobId Filter by job id. (optional)
   * @param jobExceptionMessage Filter by job exception message. (optional)
   * @param jobDefinitionId Filter by job definition id. (optional)
   * @param jobDefinitionType Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types. (optional)
   * @param jobDefinitionConfiguration Filter by job definition configuration. (optional)
   * @param activityIdIn Only include historic job logs which belong to one of the passed activity ids. (optional)
   * @param failedActivityIdIn Only include historic job logs which belong to failures of one of the passed activity ids. (optional)
   * @param executionIdIn Only include historic job logs which belong to one of the passed execution ids. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Filter by process definition key. (optional)
   * @param deploymentId Filter by deployment id. (optional)
   * @param tenantIdIn Only include historic job log entries which belong to one of the passed and comma- separated tenant ids. (optional)
   * @param withoutTenantId Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param hostname Filter by hostname. (optional)
   * @param jobPriorityLowerThanOrEquals Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param jobPriorityHigherThanOrEquals Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricJobLogsCount(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog) throws ApiException {
    return this.getHistoricJobLogsCount(logId, jobId, jobExceptionMessage, jobDefinitionId, jobDefinitionType, jobDefinitionConfiguration, activityIdIn, failedActivityIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, deploymentId, tenantIdIn, withoutTenantId, hostname, jobPriorityLowerThanOrEquals, jobPriorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, Collections.emptyMap());
  }


  /**
   * Get Job Log Count
   * Queries for the number of historic job logs that fulfill the given parameters. Takes the same parameters as the [Get Job Logs](https://docs.camunda.org/manual/7.21/reference/rest/history/job-log/get-job-log-query/) method.
   * @param logId Filter by historic job log id. (optional)
   * @param jobId Filter by job id. (optional)
   * @param jobExceptionMessage Filter by job exception message. (optional)
   * @param jobDefinitionId Filter by job definition id. (optional)
   * @param jobDefinitionType Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types. (optional)
   * @param jobDefinitionConfiguration Filter by job definition configuration. (optional)
   * @param activityIdIn Only include historic job logs which belong to one of the passed activity ids. (optional)
   * @param failedActivityIdIn Only include historic job logs which belong to failures of one of the passed activity ids. (optional)
   * @param executionIdIn Only include historic job logs which belong to one of the passed execution ids. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Filter by process definition key. (optional)
   * @param deploymentId Filter by deployment id. (optional)
   * @param tenantIdIn Only include historic job log entries which belong to one of the passed and comma- separated tenant ids. (optional)
   * @param withoutTenantId Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param hostname Filter by hostname. (optional)
   * @param jobPriorityLowerThanOrEquals Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param jobPriorityHigherThanOrEquals Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricJobLogsCount(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/job-log/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("logId", logId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobId", jobId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobExceptionMessage", jobExceptionMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionType", jobDefinitionType));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionConfiguration", jobDefinitionConfiguration));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityIdIn", activityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("failedActivityIdIn", failedActivityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionIdIn", executionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("deploymentId", deploymentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("hostname", hostname));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobPriorityLowerThanOrEquals", jobPriorityLowerThanOrEquals));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobPriorityHigherThanOrEquals", jobPriorityHigherThanOrEquals));
    localVarQueryParams.addAll(apiClient.parameterToPair("creationLog", creationLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("failureLog", failureLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("successLog", successLog));
    localVarQueryParams.addAll(apiClient.parameterToPair("deletionLog", deletionLog));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Job Log Exception Stacktrace
   * Retrieves the corresponding exception stacktrace to the passed historic job log by id.
   * @param id The id of the historic job log to get the exception stacktrace for. (required)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object getStacktraceHistoricJobLog(String id) throws ApiException {
    return this.getStacktraceHistoricJobLog(id, Collections.emptyMap());
  }


  /**
   * Get Job Log Exception Stacktrace
   * Retrieves the corresponding exception stacktrace to the passed historic job log by id.
   * @param id The id of the historic job log to get the exception stacktrace for. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object getStacktraceHistoricJobLog(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getStacktraceHistoricJobLog");
    }
    
    // create path and map variables
    String localVarPath = "/history/job-log/{id}/stacktrace"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "text/plain", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<Object> localVarReturnType = new TypeReference<Object>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Job Logs (POST)
   * Queries for historic job logs that fulfill the given parameters. This method is slightly more powerful than the [Get Job Logs](https://docs.camunda.org/manual/7.21/reference/rest/history/job-log/get-job-log-query/) method because it allows filtering by historic job logs values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param historicJobLogQueryDto  (optional)
   * @return List&lt;HistoricJobLogDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricJobLogDto> queryHistoricJobLogs(Integer firstResult, Integer maxResults, HistoricJobLogQueryDto historicJobLogQueryDto) throws ApiException {
    return this.queryHistoricJobLogs(firstResult, maxResults, historicJobLogQueryDto, Collections.emptyMap());
  }


  /**
   * Get Job Logs (POST)
   * Queries for historic job logs that fulfill the given parameters. This method is slightly more powerful than the [Get Job Logs](https://docs.camunda.org/manual/7.21/reference/rest/history/job-log/get-job-log-query/) method because it allows filtering by historic job logs values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param historicJobLogQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricJobLogDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricJobLogDto> queryHistoricJobLogs(Integer firstResult, Integer maxResults, HistoricJobLogQueryDto historicJobLogQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historicJobLogQueryDto;
    
    // create path and map variables
    String localVarPath = "/history/job-log";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricJobLogDto>> localVarReturnType = new TypeReference<List<HistoricJobLogDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Job Log Count (POST)
   * Queries for the number of historic job logs that fulfill the given parameters. This method takes the same message body as the [Get Job Logs (POST)](https://docs.camunda.org/manual/7.21/reference/rest/history/job-log/post-job-log-query/) method and therefore it is slightly more powerful than the [Get Job Log Count](https://docs.camunda.org/manual/7.21/reference/rest/history/job-log/get-job-log-query-count/) method.
   * @param historicJobLogQueryDto  (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryHistoricJobLogsCount(HistoricJobLogQueryDto historicJobLogQueryDto) throws ApiException {
    return this.queryHistoricJobLogsCount(historicJobLogQueryDto, Collections.emptyMap());
  }


  /**
   * Get Job Log Count (POST)
   * Queries for the number of historic job logs that fulfill the given parameters. This method takes the same message body as the [Get Job Logs (POST)](https://docs.camunda.org/manual/7.21/reference/rest/history/job-log/post-job-log-query/) method and therefore it is slightly more powerful than the [Get Job Log Count](https://docs.camunda.org/manual/7.21/reference/rest/history/job-log/get-job-log-query-count/) method.
   * @param historicJobLogQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryHistoricJobLogsCount(HistoricJobLogQueryDto historicJobLogQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historicJobLogQueryDto;
    
    // create path and map variables
    String localVarPath = "/history/job-log/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
