/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.CleanableHistoricProcessInstanceReportResultDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricActivityStatisticsDto;
import java.time.OffsetDateTime;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricProcessDefinitionApi {


  private ApiClient apiClient;

  public HistoricProcessDefinitionApi() {
    this(Configuration.getDefaultApiClient());
  }

  public HistoricProcessDefinitionApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get Cleanable Process Instance Report
   * Retrieves a report about a process definition and finished process instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.21/user-guide/process-engine/history/#history-cleanup))  so that you can tune the history time to live. These reports include the count of the finished historic process instances, cleanable process instances and basic process definition data - id, key, name and version. The size of the result set can be retrieved by using the [Get Cleanable Process Instance Report Count](https://docs.camunda.org/manual/7.21/reference/rest/history/process-definition/get-cleanable-process-instance-report-count/) method.
   * @param processDefinitionIdIn Filter by process definition ids. Must be a comma-separated list of process definition ids. (optional)
   * @param processDefinitionKeyIn Filter by process definition keys. Must be a comma-separated list of process definition keys. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process definition must have one of the given  tenant ids. (optional)
   * @param withoutTenantId Only include process definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param compact Only include process instances which have more than zero finished instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;CleanableHistoricProcessInstanceReportResultDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<CleanableHistoricProcessInstanceReportResultDto> getCleanableHistoricProcessInstanceReport(String processDefinitionIdIn, String processDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.getCleanableHistoricProcessInstanceReport(processDefinitionIdIn, processDefinitionKeyIn, tenantIdIn, withoutTenantId, compact, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get Cleanable Process Instance Report
   * Retrieves a report about a process definition and finished process instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.21/user-guide/process-engine/history/#history-cleanup))  so that you can tune the history time to live. These reports include the count of the finished historic process instances, cleanable process instances and basic process definition data - id, key, name and version. The size of the result set can be retrieved by using the [Get Cleanable Process Instance Report Count](https://docs.camunda.org/manual/7.21/reference/rest/history/process-definition/get-cleanable-process-instance-report-count/) method.
   * @param processDefinitionIdIn Filter by process definition ids. Must be a comma-separated list of process definition ids. (optional)
   * @param processDefinitionKeyIn Filter by process definition keys. Must be a comma-separated list of process definition keys. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process definition must have one of the given  tenant ids. (optional)
   * @param withoutTenantId Only include process definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param compact Only include process instances which have more than zero finished instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;CleanableHistoricProcessInstanceReportResultDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<CleanableHistoricProcessInstanceReportResultDto> getCleanableHistoricProcessInstanceReport(String processDefinitionIdIn, String processDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/process-definition/cleanable-process-instance-report";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("compact", compact));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<CleanableHistoricProcessInstanceReportResultDto>> localVarReturnType = new TypeReference<List<CleanableHistoricProcessInstanceReportResultDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Cleanable Process Instance Report Count
   * Queries for the number of report results about a process definition and finished process instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.21/user-guide/process-engine/history/#history-cleanup)). Takes the same parameters as the [Get Cleanable Process Instance Report](https://docs.camunda.org/manual/7.21/reference/rest/history/process-definition/get-cleanable-process-instance-report/) method.
   * @param processDefinitionIdIn Filter by process definition ids. Must be a comma-separated list of process definition ids. (optional)
   * @param processDefinitionKeyIn Filter by process definition keys. Must be a comma-separated list of process definition keys. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process definition must have one of the given  tenant ids. (optional)
   * @param withoutTenantId Only include process definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param compact Only include process instances which have more than zero finished instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getCleanableHistoricProcessInstanceReportCount(String processDefinitionIdIn, String processDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact) throws ApiException {
    return this.getCleanableHistoricProcessInstanceReportCount(processDefinitionIdIn, processDefinitionKeyIn, tenantIdIn, withoutTenantId, compact, Collections.emptyMap());
  }


  /**
   * Get Cleanable Process Instance Report Count
   * Queries for the number of report results about a process definition and finished process instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.21/user-guide/process-engine/history/#history-cleanup)). Takes the same parameters as the [Get Cleanable Process Instance Report](https://docs.camunda.org/manual/7.21/reference/rest/history/process-definition/get-cleanable-process-instance-report/) method.
   * @param processDefinitionIdIn Filter by process definition ids. Must be a comma-separated list of process definition ids. (optional)
   * @param processDefinitionKeyIn Filter by process definition keys. Must be a comma-separated list of process definition keys. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process definition must have one of the given  tenant ids. (optional)
   * @param withoutTenantId Only include process definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param compact Only include process instances which have more than zero finished instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getCleanableHistoricProcessInstanceReportCount(String processDefinitionIdIn, String processDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/process-definition/cleanable-process-instance-report/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("compact", compact));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Historic Activity Statistics
   * Retrieves historic statistics of a given process definition, grouped by activities. These statistics include the number of running activity instances and, optionally, the number of canceled activity instances, finished activity instances and activity instances which completed a scope (i.e., in BPMN 2.0 manner: a scope is completed by an activity instance when the activity instance consumed a token but did not emit a new token). **Note:** This only includes historic data.
   * @param id The id of the process definition. (required)
   * @param canceled Whether to include the number of canceled activity instances in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. Default: &#x60;false&#x60;. (optional)
   * @param finished Whether to include the number of finished activity instances in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. Default: &#x60;false&#x60;. (optional)
   * @param completeScope Whether to include the number of activity instances which completed a scope in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. Default: &#x60;false&#x60;. (optional)
   * @param incidents Whether to include the number of incidents. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. Default: &#x60;false&#x60;. (optional)
   * @param startedBefore Restrict to process instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/),  the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;,  e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Restrict to process instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/),  the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;,  e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedBefore Restrict to process instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/),  the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;,  e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedAfter Restrict to process instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/),  the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;,  e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param processInstanceIdIn Restrict to process instances with the given IDs. The IDs must be provided as a comma- separated list. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @return List&lt;HistoricActivityStatisticsDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricActivityStatisticsDto> getHistoricActivityStatistics(String id, Boolean canceled, Boolean finished, Boolean completeScope, Boolean incidents, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, String processInstanceIdIn, String sortBy, String sortOrder) throws ApiException {
    return this.getHistoricActivityStatistics(id, canceled, finished, completeScope, incidents, startedBefore, startedAfter, finishedBefore, finishedAfter, processInstanceIdIn, sortBy, sortOrder, Collections.emptyMap());
  }


  /**
   * Get Historic Activity Statistics
   * Retrieves historic statistics of a given process definition, grouped by activities. These statistics include the number of running activity instances and, optionally, the number of canceled activity instances, finished activity instances and activity instances which completed a scope (i.e., in BPMN 2.0 manner: a scope is completed by an activity instance when the activity instance consumed a token but did not emit a new token). **Note:** This only includes historic data.
   * @param id The id of the process definition. (required)
   * @param canceled Whether to include the number of canceled activity instances in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. Default: &#x60;false&#x60;. (optional)
   * @param finished Whether to include the number of finished activity instances in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. Default: &#x60;false&#x60;. (optional)
   * @param completeScope Whether to include the number of activity instances which completed a scope in the result or not. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. Default: &#x60;false&#x60;. (optional)
   * @param incidents Whether to include the number of incidents. Valid values are &#x60;true&#x60; or &#x60;false&#x60;. Default: &#x60;false&#x60;. (optional)
   * @param startedBefore Restrict to process instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/),  the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;,  e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Restrict to process instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/),  the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;,  e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedBefore Restrict to process instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/),  the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;,  e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedAfter Restrict to process instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/),  the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;,  e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param processInstanceIdIn Restrict to process instances with the given IDs. The IDs must be provided as a comma- separated list. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricActivityStatisticsDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricActivityStatisticsDto> getHistoricActivityStatistics(String id, Boolean canceled, Boolean finished, Boolean completeScope, Boolean incidents, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, String processInstanceIdIn, String sortBy, String sortOrder, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getHistoricActivityStatistics");
    }
    
    // create path and map variables
    String localVarPath = "/history/process-definition/{id}/statistics"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("canceled", canceled));
    localVarQueryParams.addAll(apiClient.parameterToPair("finished", finished));
    localVarQueryParams.addAll(apiClient.parameterToPair("completeScope", completeScope));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidents", incidents));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedBefore", startedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedAfter", startedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("finishedBefore", finishedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("finishedAfter", finishedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricActivityStatisticsDto>> localVarReturnType = new TypeReference<List<HistoricActivityStatisticsDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
