/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.DeleteHistoricProcessInstancesDto;
import org.camunda.community.rest.client.dto.DurationReportResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceDto;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import java.time.OffsetDateTime;
import org.camunda.community.rest.client.dto.SetRemovalTimeToHistoricProcessInstancesDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricProcessInstanceApi {


  private ApiClient apiClient;

  public HistoricProcessInstanceApi() {
    this(Configuration.getDefaultApiClient());
  }

  public HistoricProcessInstanceApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Delete
   * Deletes a process instance from the history by id.
   * @param id The id of the historic process instance to be deleted. (required)
   * @param failIfNotExists If set to &#x60;false&#x60;, the request will still be successful if the process id is not found. (optional)
   * @throws ApiException if fails to make API call
   */
  public void deleteHistoricProcessInstance(String id, Boolean failIfNotExists) throws ApiException {
    this.deleteHistoricProcessInstance(id, failIfNotExists, Collections.emptyMap());
  }


  /**
   * Delete
   * Deletes a process instance from the history by id.
   * @param id The id of the historic process instance to be deleted. (required)
   * @param failIfNotExists If set to &#x60;false&#x60;, the request will still be successful if the process id is not found. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteHistoricProcessInstance(String id, Boolean failIfNotExists, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteHistoricProcessInstance");
    }
    
    // create path and map variables
    String localVarPath = "/history/process-instance/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("failIfNotExists", failIfNotExists));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete Async (POST)
   * Delete multiple historic process instances asynchronously (batch). At least &#x60;historicProcessInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60; has to be provided. If both are provided then all instances matching query criterion and instances from the list will be deleted.
   * @param deleteHistoricProcessInstancesDto  (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto deleteHistoricProcessInstancesAsync(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto) throws ApiException {
    return this.deleteHistoricProcessInstancesAsync(deleteHistoricProcessInstancesDto, Collections.emptyMap());
  }


  /**
   * Delete Async (POST)
   * Delete multiple historic process instances asynchronously (batch). At least &#x60;historicProcessInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60; has to be provided. If both are provided then all instances matching query criterion and instances from the list will be deleted.
   * @param deleteHistoricProcessInstancesDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto deleteHistoricProcessInstancesAsync(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = deleteHistoricProcessInstancesDto;
    
    // create path and map variables
    String localVarPath = "/history/process-instance/delete";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete Variable Instances
   * Deletes all variables of a process instance from the history by id.
   * @param id The id of the process instance for which all historic variables are to be deleted. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteHistoricVariableInstancesOfHistoricProcessInstance(String id) throws ApiException {
    this.deleteHistoricVariableInstancesOfHistoricProcessInstance(id, Collections.emptyMap());
  }


  /**
   * Delete Variable Instances
   * Deletes all variables of a process instance from the history by id.
   * @param id The id of the process instance for which all historic variables are to be deleted. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteHistoricVariableInstancesOfHistoricProcessInstance(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteHistoricVariableInstancesOfHistoricProcessInstance");
    }
    
    // create path and map variables
    String localVarPath = "/history/process-instance/{id}/variable-instances"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get
   * Retrieves a historic process instance by id, according to the &#x60;HistoricProcessInstance&#x60; interface in the engine.
   * @param id The id of the historic process instance to be retrieved. (required)
   * @return HistoricProcessInstanceDto
   * @throws ApiException if fails to make API call
   */
  public HistoricProcessInstanceDto getHistoricProcessInstance(String id) throws ApiException {
    return this.getHistoricProcessInstance(id, Collections.emptyMap());
  }


  /**
   * Get
   * Retrieves a historic process instance by id, according to the &#x60;HistoricProcessInstance&#x60; interface in the engine.
   * @param id The id of the historic process instance to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return HistoricProcessInstanceDto
   * @throws ApiException if fails to make API call
   */
  public HistoricProcessInstanceDto getHistoricProcessInstance(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getHistoricProcessInstance");
    }
    
    // create path and map variables
    String localVarPath = "/history/process-instance/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<HistoricProcessInstanceDto> localVarReturnType = new TypeReference<HistoricProcessInstanceDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Duration Report
   * Retrieves a report about the duration of completed process instances, grouped by a period. These reports include the maximum, minimum and average duration of all completed process instances which were started in a given period.  **Note:** This only includes historic data.
   * @param reportType **Mandatory.** Specifies the type of the report to retrieve. To retrieve a report about the duration of process instances, the value must be set to &#x60;duration&#x60;. (required)
   * @param periodUnit **Mandatory.** Specifies the granularity of the report. Valid values are &#x60;month&#x60; and &#x60;quarter&#x60;. (required)
   * @param processDefinitionIdIn Filter by process definition ids. Must be a comma-separated list of process definition ids. (optional)
   * @param processDefinitionKeyIn Filter by process definition keys. Must be a comma-separated list of process definition keys. (optional)
   * @param startedBefore Restrict to instances that were started before the given date. By [default](), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2016-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2016-01-23T14:42:45.000+0200&#x60;. (optional)
   * @return List&lt;DurationReportResultDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<DurationReportResultDto> getHistoricProcessInstanceDurationReport(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, OffsetDateTime startedBefore, OffsetDateTime startedAfter) throws ApiException {
    return this.getHistoricProcessInstanceDurationReport(reportType, periodUnit, processDefinitionIdIn, processDefinitionKeyIn, startedBefore, startedAfter, Collections.emptyMap());
  }


  /**
   * Get Duration Report
   * Retrieves a report about the duration of completed process instances, grouped by a period. These reports include the maximum, minimum and average duration of all completed process instances which were started in a given period.  **Note:** This only includes historic data.
   * @param reportType **Mandatory.** Specifies the type of the report to retrieve. To retrieve a report about the duration of process instances, the value must be set to &#x60;duration&#x60;. (required)
   * @param periodUnit **Mandatory.** Specifies the granularity of the report. Valid values are &#x60;month&#x60; and &#x60;quarter&#x60;. (required)
   * @param processDefinitionIdIn Filter by process definition ids. Must be a comma-separated list of process definition ids. (optional)
   * @param processDefinitionKeyIn Filter by process definition keys. Must be a comma-separated list of process definition keys. (optional)
   * @param startedBefore Restrict to instances that were started before the given date. By [default](), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2016-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2016-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;DurationReportResultDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<DurationReportResultDto> getHistoricProcessInstanceDurationReport(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'reportType' is set
    if (reportType == null) {
      throw new ApiException(400, "Missing the required parameter 'reportType' when calling getHistoricProcessInstanceDurationReport");
    }
    
    // verify the required parameter 'periodUnit' is set
    if (periodUnit == null) {
      throw new ApiException(400, "Missing the required parameter 'periodUnit' when calling getHistoricProcessInstanceDurationReport");
    }
    
    // create path and map variables
    String localVarPath = "/history/process-instance/report";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("reportType", reportType));
    localVarQueryParams.addAll(apiClient.parameterToPair("periodUnit", periodUnit));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedBefore", startedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedAfter", startedAfter));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json", "application/csv", "text/csv"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<DurationReportResultDto>> localVarReturnType = new TypeReference<List<DurationReportResultDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List
   * Queries for historic process instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Process Instance Count](https://docs.camunda.org/manual/7.21/reference/rest/history/process-instance/get-process-instance-query-count/) method.
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processInstanceIds Filter by process instance ids. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
   * @param processDefinitionId Filter by the process definition the instances run on. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
   * @param processDefinitionKeyIn Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
   * @param processDefinitionName Filter by the name of the process definition the instances run on. (optional)
   * @param processDefinitionNameLike Filter by process definition names that the parameter is a substring of. (optional)
   * @param processDefinitionKeyNotIn Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
   * @param processInstanceBusinessKey Filter by process instance business key. (optional)
   * @param processInstanceBusinessKeyIn Filter by a list of business keys. A process instance must have one of the given business keys. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param processInstanceBusinessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
   * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional)
   * @param finished Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param unfinished Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withIncidents Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withRootIncidents Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentStatus Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents. (optional)
   * @param incidentMessage Filter by the incident message. Exact match. (optional)
   * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
   * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedActivityAfter Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedActivityBefore Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedJobAfter Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedJobBefore Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedBy Only include process instances that were started by the given user. (optional)
   * @param superProcessInstanceId Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
   * @param subProcessInstanceId Restrict query to one process instance that has a sub process instance with the given id. (optional)
   * @param superCaseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
   * @param subCaseInstanceId Restrict query to one process instance that has a sub case instance with the given id. (optional)
   * @param caseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
   * @param tenantIdIn Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param withoutTenantId Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param executedActivityIdIn Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param activeActivityIdIn Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param active Restrict to instances that are active. (optional)
   * @param suspended Restrict to instances that are suspended. (optional)
   * @param completed Restrict to instances that are completed. (optional)
   * @param externallyTerminated Restrict to instances that are externallyTerminated. (optional)
   * @param internallyTerminated Restrict to instances that are internallyTerminated. (optional)
   * @param variables Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.  Key and value may not contain underscore or comma characters.  (optional)
   * @param variableNamesIgnoreCase Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal. (optional)
   * @return List&lt;HistoricProcessInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricProcessInstanceDto> getHistoricProcessInstances(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, OffsetDateTime executedActivityAfter, OffsetDateTime executedActivityBefore, OffsetDateTime executedJobAfter, OffsetDateTime executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
    return this.getHistoricProcessInstances(sortBy, sortOrder, firstResult, maxResults, processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, Collections.emptyMap());
  }


  /**
   * Get List
   * Queries for historic process instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Process Instance Count](https://docs.camunda.org/manual/7.21/reference/rest/history/process-instance/get-process-instance-query-count/) method.
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processInstanceIds Filter by process instance ids. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
   * @param processDefinitionId Filter by the process definition the instances run on. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
   * @param processDefinitionKeyIn Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
   * @param processDefinitionName Filter by the name of the process definition the instances run on. (optional)
   * @param processDefinitionNameLike Filter by process definition names that the parameter is a substring of. (optional)
   * @param processDefinitionKeyNotIn Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
   * @param processInstanceBusinessKey Filter by process instance business key. (optional)
   * @param processInstanceBusinessKeyIn Filter by a list of business keys. A process instance must have one of the given business keys. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param processInstanceBusinessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
   * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional)
   * @param finished Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param unfinished Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withIncidents Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withRootIncidents Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentStatus Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents. (optional)
   * @param incidentMessage Filter by the incident message. Exact match. (optional)
   * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
   * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedActivityAfter Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedActivityBefore Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedJobAfter Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedJobBefore Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedBy Only include process instances that were started by the given user. (optional)
   * @param superProcessInstanceId Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
   * @param subProcessInstanceId Restrict query to one process instance that has a sub process instance with the given id. (optional)
   * @param superCaseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
   * @param subCaseInstanceId Restrict query to one process instance that has a sub case instance with the given id. (optional)
   * @param caseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
   * @param tenantIdIn Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param withoutTenantId Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param executedActivityIdIn Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param activeActivityIdIn Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param active Restrict to instances that are active. (optional)
   * @param suspended Restrict to instances that are suspended. (optional)
   * @param completed Restrict to instances that are completed. (optional)
   * @param externallyTerminated Restrict to instances that are externallyTerminated. (optional)
   * @param internallyTerminated Restrict to instances that are internallyTerminated. (optional)
   * @param variables Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.  Key and value may not contain underscore or comma characters.  (optional)
   * @param variableNamesIgnoreCase Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricProcessInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricProcessInstanceDto> getHistoricProcessInstances(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, OffsetDateTime executedActivityAfter, OffsetDateTime executedActivityBefore, OffsetDateTime executedJobAfter, OffsetDateTime executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/process-instance";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceIds", processInstanceIds));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionName", processDefinitionName));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionNameLike", processDefinitionNameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
    localVarQueryParams.addAll(apiClient.parameterToPair("finished", finished));
    localVarQueryParams.addAll(apiClient.parameterToPair("unfinished", unfinished));
    localVarQueryParams.addAll(apiClient.parameterToPair("withIncidents", withIncidents));
    localVarQueryParams.addAll(apiClient.parameterToPair("withRootIncidents", withRootIncidents));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentType", incidentType));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentStatus", incidentStatus));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessage", incidentMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedBefore", startedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedAfter", startedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("finishedBefore", finishedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("finishedAfter", finishedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("executedActivityAfter", executedActivityAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("executedActivityBefore", executedActivityBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("executedJobAfter", executedJobAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("executedJobBefore", executedJobBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedBy", startedBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("superProcessInstanceId", superProcessInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("subProcessInstanceId", subProcessInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("superCaseInstanceId", superCaseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("subCaseInstanceId", subCaseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("executedActivityIdIn", executedActivityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("activeActivityIdIn", activeActivityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("active", active));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("completed", completed));
    localVarQueryParams.addAll(apiClient.parameterToPair("externallyTerminated", externallyTerminated));
    localVarQueryParams.addAll(apiClient.parameterToPair("internallyTerminated", internallyTerminated));
    localVarQueryParams.addAll(apiClient.parameterToPair("variables", variables));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricProcessInstanceDto>> localVarReturnType = new TypeReference<List<HistoricProcessInstanceDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List Count
   * Queries for the number of historic process instances that fulfill the given parameters. Takes the same parameters as the [Get Process Instances](https://docs.camunda.org/manual/7.21/reference/rest/history/process-instance/get-process-instance-query/) method.
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processInstanceIds Filter by process instance ids. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
   * @param processDefinitionId Filter by the process definition the instances run on. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
   * @param processDefinitionKeyIn Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
   * @param processDefinitionName Filter by the name of the process definition the instances run on. (optional)
   * @param processDefinitionNameLike Filter by process definition names that the parameter is a substring of. (optional)
   * @param processDefinitionKeyNotIn Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
   * @param processInstanceBusinessKey Filter by process instance business key. (optional)
   * @param processInstanceBusinessKeyIn Filter by a list of business keys. A process instance must have one of the given business keys. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param processInstanceBusinessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
   * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional)
   * @param finished Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param unfinished Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withIncidents Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withRootIncidents Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentStatus Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents. (optional)
   * @param incidentMessage Filter by the incident message. Exact match. (optional)
   * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
   * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedActivityAfter Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedActivityBefore Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedJobAfter Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedJobBefore Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedBy Only include process instances that were started by the given user. (optional)
   * @param superProcessInstanceId Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
   * @param subProcessInstanceId Restrict query to one process instance that has a sub process instance with the given id. (optional)
   * @param superCaseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
   * @param subCaseInstanceId Restrict query to one process instance that has a sub case instance with the given id. (optional)
   * @param caseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
   * @param tenantIdIn Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param withoutTenantId Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param executedActivityIdIn Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param activeActivityIdIn Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param active Restrict to instances that are active. (optional)
   * @param suspended Restrict to instances that are suspended. (optional)
   * @param completed Restrict to instances that are completed. (optional)
   * @param externallyTerminated Restrict to instances that are externallyTerminated. (optional)
   * @param internallyTerminated Restrict to instances that are internallyTerminated. (optional)
   * @param variables Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.  Key and value may not contain underscore or comma characters.  (optional)
   * @param variableNamesIgnoreCase Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricProcessInstancesCount(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, OffsetDateTime executedActivityAfter, OffsetDateTime executedActivityBefore, OffsetDateTime executedJobAfter, OffsetDateTime executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
    return this.getHistoricProcessInstancesCount(processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, Collections.emptyMap());
  }


  /**
   * Get List Count
   * Queries for the number of historic process instances that fulfill the given parameters. Takes the same parameters as the [Get Process Instances](https://docs.camunda.org/manual/7.21/reference/rest/history/process-instance/get-process-instance-query/) method.
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processInstanceIds Filter by process instance ids. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
   * @param processDefinitionId Filter by the process definition the instances run on. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
   * @param processDefinitionKeyIn Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
   * @param processDefinitionName Filter by the name of the process definition the instances run on. (optional)
   * @param processDefinitionNameLike Filter by process definition names that the parameter is a substring of. (optional)
   * @param processDefinitionKeyNotIn Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of &#x60;Strings&#x60;. (optional)
   * @param processInstanceBusinessKey Filter by process instance business key. (optional)
   * @param processInstanceBusinessKeyIn Filter by a list of business keys. A process instance must have one of the given business keys. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param processInstanceBusinessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
   * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional)
   * @param finished Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param unfinished Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withIncidents Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withRootIncidents Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentStatus Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents. (optional)
   * @param incidentMessage Filter by the incident message. Exact match. (optional)
   * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
   * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedActivityAfter Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedActivityBefore Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedJobAfter Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param executedJobBefore Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedBy Only include process instances that were started by the given user. (optional)
   * @param superProcessInstanceId Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
   * @param subProcessInstanceId Restrict query to one process instance that has a sub process instance with the given id. (optional)
   * @param superCaseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
   * @param subCaseInstanceId Restrict query to one process instance that has a sub case instance with the given id. (optional)
   * @param caseInstanceId Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
   * @param tenantIdIn Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param withoutTenantId Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param executedActivityIdIn Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param activeActivityIdIn Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of &#x60;Strings&#x60; (optional)
   * @param active Restrict to instances that are active. (optional)
   * @param suspended Restrict to instances that are suspended. (optional)
   * @param completed Restrict to instances that are completed. (optional)
   * @param externallyTerminated Restrict to instances that are externallyTerminated. (optional)
   * @param internallyTerminated Restrict to instances that are internallyTerminated. (optional)
   * @param variables Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.  Key and value may not contain underscore or comma characters.  (optional)
   * @param variableNamesIgnoreCase Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricProcessInstancesCount(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, OffsetDateTime executedActivityAfter, OffsetDateTime executedActivityBefore, OffsetDateTime executedJobAfter, OffsetDateTime executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/process-instance/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceIds", processInstanceIds));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionName", processDefinitionName));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionNameLike", processDefinitionNameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
    localVarQueryParams.addAll(apiClient.parameterToPair("finished", finished));
    localVarQueryParams.addAll(apiClient.parameterToPair("unfinished", unfinished));
    localVarQueryParams.addAll(apiClient.parameterToPair("withIncidents", withIncidents));
    localVarQueryParams.addAll(apiClient.parameterToPair("withRootIncidents", withRootIncidents));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentType", incidentType));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentStatus", incidentStatus));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessage", incidentMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedBefore", startedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedAfter", startedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("finishedBefore", finishedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("finishedAfter", finishedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("executedActivityAfter", executedActivityAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("executedActivityBefore", executedActivityBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("executedJobAfter", executedJobAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("executedJobBefore", executedJobBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedBy", startedBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("superProcessInstanceId", superProcessInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("subProcessInstanceId", subProcessInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("superCaseInstanceId", superCaseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("subCaseInstanceId", subCaseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("executedActivityIdIn", executedActivityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("activeActivityIdIn", activeActivityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("active", active));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("completed", completed));
    localVarQueryParams.addAll(apiClient.parameterToPair("externallyTerminated", externallyTerminated));
    localVarQueryParams.addAll(apiClient.parameterToPair("internallyTerminated", internallyTerminated));
    localVarQueryParams.addAll(apiClient.parameterToPair("variables", variables));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List (POST)
   * Queries for historic process instances that fulfill the given parameters. This method is slightly more powerful than the [Get Process Instance](https://docs.camunda.org/manual/7.21/reference/rest/history/process-instance/get-process-instance-query/) because it allows filtering by multiple process variables of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param historicProcessInstanceQueryDto  (optional)
   * @return List&lt;HistoricProcessInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricProcessInstanceDto> queryHistoricProcessInstances(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto) throws ApiException {
    return this.queryHistoricProcessInstances(firstResult, maxResults, historicProcessInstanceQueryDto, Collections.emptyMap());
  }


  /**
   * Get List (POST)
   * Queries for historic process instances that fulfill the given parameters. This method is slightly more powerful than the [Get Process Instance](https://docs.camunda.org/manual/7.21/reference/rest/history/process-instance/get-process-instance-query/) because it allows filtering by multiple process variables of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param historicProcessInstanceQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricProcessInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricProcessInstanceDto> queryHistoricProcessInstances(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historicProcessInstanceQueryDto;
    
    // create path and map variables
    String localVarPath = "/history/process-instance";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricProcessInstanceDto>> localVarReturnType = new TypeReference<List<HistoricProcessInstanceDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List Count (POST)
   * Queries for the number of historic process instances that fulfill the given parameters. This method takes the same message body as the [Get Process Instances (POST)](https://docs.camunda.org/manual/7.21/reference/rest/history/process-instance/get-process-instance-query/) method and therefore it is slightly more powerful than the [Get Process Instance Count](https://docs.camunda.org/manual/7.21/reference/rest/history/process-instance/post-process-instance-query-count/) method.
   * @param historicProcessInstanceQueryDto  (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryHistoricProcessInstancesCount(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto) throws ApiException {
    return this.queryHistoricProcessInstancesCount(historicProcessInstanceQueryDto, Collections.emptyMap());
  }


  /**
   * Get List Count (POST)
   * Queries for the number of historic process instances that fulfill the given parameters. This method takes the same message body as the [Get Process Instances (POST)](https://docs.camunda.org/manual/7.21/reference/rest/history/process-instance/get-process-instance-query/) method and therefore it is slightly more powerful than the [Get Process Instance Count](https://docs.camunda.org/manual/7.21/reference/rest/history/process-instance/post-process-instance-query-count/) method.
   * @param historicProcessInstanceQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryHistoricProcessInstancesCount(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historicProcessInstanceQueryDto;
    
    // create path and map variables
    String localVarPath = "/history/process-instance/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Set Removal Time Async (POST)
   * Sets the removal time to multiple historic process instances asynchronously (batch).  At least &#x60;historicProcessInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60; has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.
   * @param setRemovalTimeToHistoricProcessInstancesDto  (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto setRemovalTimeAsync(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto) throws ApiException {
    return this.setRemovalTimeAsync(setRemovalTimeToHistoricProcessInstancesDto, Collections.emptyMap());
  }


  /**
   * Set Removal Time Async (POST)
   * Sets the removal time to multiple historic process instances asynchronously (batch).  At least &#x60;historicProcessInstanceIds&#x60; or &#x60;historicProcessInstanceQuery&#x60; has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.
   * @param setRemovalTimeToHistoricProcessInstancesDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto setRemovalTimeAsync(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = setRemovalTimeToHistoricProcessInstancesDto;
    
    // create path and map variables
    String localVarPath = "/history/process-instance/set-removal-time";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
