/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricTaskInstanceDto;
import org.camunda.community.rest.client.dto.HistoricTaskInstanceQueryDto;
import org.camunda.community.rest.client.dto.HistoricTaskInstanceReportResultDto;
import java.time.OffsetDateTime;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricTaskInstanceApi {


  private ApiClient apiClient;

  public HistoricTaskInstanceApi() {
    this(Configuration.getDefaultApiClient());
  }

  public HistoricTaskInstanceApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get Task Report (Historic)
   * Retrieves a report of completed tasks. When the report type is set to &#x60;count&#x60;, the report contains a list of completed task counts where an entry contains the task name, the definition key of the task, the process definition id, the process definition key, the process definition name and the count of how many tasks were completed for the specified key in a given period. When the report type is set to &#x60;duration&#x60;, the report contains a minimum, maximum and average duration value of all completed task instances in a given period.
   * @param reportType **Mandatory.** Specifies the kind of the report to execute. To retrieve a report about the duration of process instances the value must be set to &#x60;duration&#x60;. For a report of the completed tasks in a specific timespan the value must be set to &#x60;count&#x60;. (optional)
   * @param periodUnit When the report type is set to &#x60;duration&#x60;, this parameter is **mandatory**. Specifies the granularity of the report. Valid values are &#x60;month&#x60; and &#x60;quarter&#x60;. (optional)
   * @param completedBefore Restrict to tasks that were completed before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param completedAfter Restrict to tasks that were completed after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param groupBy When the report type is set to &#x60;count&#x60;, this parameter is **mandatory**. Groups the tasks report by a given criterion. Valid values are &#x60;taskName&#x60; and &#x60;processDefinition&#x60;. (optional)
   * @return List&lt;HistoricTaskInstanceReportResultDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricTaskInstanceReportResultDto> getHistoricTaskInstanceReport(String reportType, String periodUnit, OffsetDateTime completedBefore, OffsetDateTime completedAfter, String groupBy) throws ApiException {
    return this.getHistoricTaskInstanceReport(reportType, periodUnit, completedBefore, completedAfter, groupBy, Collections.emptyMap());
  }


  /**
   * Get Task Report (Historic)
   * Retrieves a report of completed tasks. When the report type is set to &#x60;count&#x60;, the report contains a list of completed task counts where an entry contains the task name, the definition key of the task, the process definition id, the process definition key, the process definition name and the count of how many tasks were completed for the specified key in a given period. When the report type is set to &#x60;duration&#x60;, the report contains a minimum, maximum and average duration value of all completed task instances in a given period.
   * @param reportType **Mandatory.** Specifies the kind of the report to execute. To retrieve a report about the duration of process instances the value must be set to &#x60;duration&#x60;. For a report of the completed tasks in a specific timespan the value must be set to &#x60;count&#x60;. (optional)
   * @param periodUnit When the report type is set to &#x60;duration&#x60;, this parameter is **mandatory**. Specifies the granularity of the report. Valid values are &#x60;month&#x60; and &#x60;quarter&#x60;. (optional)
   * @param completedBefore Restrict to tasks that were completed before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param completedAfter Restrict to tasks that were completed after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param groupBy When the report type is set to &#x60;count&#x60;, this parameter is **mandatory**. Groups the tasks report by a given criterion. Valid values are &#x60;taskName&#x60; and &#x60;processDefinition&#x60;. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricTaskInstanceReportResultDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricTaskInstanceReportResultDto> getHistoricTaskInstanceReport(String reportType, String periodUnit, OffsetDateTime completedBefore, OffsetDateTime completedAfter, String groupBy, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/task/report";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("reportType", reportType));
    localVarQueryParams.addAll(apiClient.parameterToPair("periodUnit", periodUnit));
    localVarQueryParams.addAll(apiClient.parameterToPair("completedBefore", completedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("completedAfter", completedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("groupBy", groupBy));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricTaskInstanceReportResultDto>> localVarReturnType = new TypeReference<List<HistoricTaskInstanceReportResultDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Tasks (Historic)
   * Queries for historic tasks that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Task Count](https://docs.camunda.org/manual/7.21/reference/rest/history/task/get-task-query-count/) method.
   * @param taskId Filter by task id. (optional)
   * @param taskParentTaskId Filter by parent task id. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processInstanceBusinessKey Filter by process instance business key. (optional)
   * @param processInstanceBusinessKeyIn Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list. (optional)
   * @param processInstanceBusinessKeyLike Filter by  process instance business key that has the parameter value as a substring. (optional)
   * @param executionId Filter by the id of the execution that executed the task. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Restrict to tasks that belong to a process definition with the given key. (optional)
   * @param processDefinitionName Restrict to tasks that belong to a process definition with the given name. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param caseExecutionId Filter by the id of the case execution that executed the task. (optional)
   * @param caseDefinitionId Filter by case definition id. (optional)
   * @param caseDefinitionKey Restrict to tasks that belong to a case definition with the given key. (optional)
   * @param caseDefinitionName Restrict to tasks that belong to a case definition with the given name. (optional)
   * @param activityInstanceIdIn Only include tasks which belong to one of the passed comma-separated activity instance ids. (optional)
   * @param taskName Restrict to tasks that have the given name. (optional)
   * @param taskNameLike Restrict to tasks that have a name with the given parameter value as substring. (optional)
   * @param taskDescription Restrict to tasks that have the given description. (optional)
   * @param taskDescriptionLike Restrict to tasks that have a description that has the parameter value as a substring. (optional)
   * @param taskDefinitionKey Restrict to tasks that have the given key. (optional)
   * @param taskDefinitionKeyIn Restrict to tasks that have one of the passed comma-separated task definition keys. (optional)
   * @param taskDeleteReason Restrict to tasks that have the given delete reason. (optional)
   * @param taskDeleteReasonLike Restrict to tasks that have a delete reason that has the parameter value as a substring. (optional)
   * @param taskAssignee Restrict to tasks that the given user is assigned to. (optional)
   * @param taskAssigneeLike Restrict to tasks that are assigned to users with the parameter value as a substring. (optional)
   * @param taskOwner Restrict to tasks that the given user owns. (optional)
   * @param taskOwnerLike Restrict to tasks that are owned by users with the parameter value as a substring. (optional)
   * @param taskPriority Restrict to tasks that have the given priority. (optional)
   * @param assigned If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned. (optional)
   * @param unassigned If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned. (optional)
   * @param finished Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param unfinished Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param processFinished Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param processUnfinished Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param taskDueDate Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskDueDateBefore Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskDueDateAfter Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param withoutTaskDueDate Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param taskFollowUpDate Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskFollowUpDateBefore Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskFollowUpDateAfter Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedBefore Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedBefore Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedAfter Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param taskVariables Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param processVariables Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param variableNamesIgnoreCase Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
   * @param taskInvolvedUser Restrict to tasks with a historic identity link to the given user. (optional)
   * @param taskInvolvedGroup Restrict to tasks with a historic identity link to the given group. (optional)
   * @param taskHadCandidateUser Restrict to tasks with a historic identity link to the given candidate user. (optional)
   * @param taskHadCandidateGroup Restrict to tasks with a historic identity link to the given candidate group. (optional)
   * @param withCandidateGroups Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withoutCandidateGroups Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;HistoricTaskInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricTaskInstanceDto> getHistoricTaskInstances(String taskId, String taskParentTaskId, String processInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, OffsetDateTime taskDueDate, OffsetDateTime taskDueDateBefore, OffsetDateTime taskDueDateAfter, Boolean withoutTaskDueDate, OffsetDateTime taskFollowUpDate, OffsetDateTime taskFollowUpDateBefore, OffsetDateTime taskFollowUpDateAfter, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.getHistoricTaskInstances(taskId, taskParentTaskId, processInstanceId, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, executionId, processDefinitionId, processDefinitionKey, processDefinitionName, caseInstanceId, caseExecutionId, caseDefinitionId, caseDefinitionKey, caseDefinitionName, activityInstanceIdIn, taskName, taskNameLike, taskDescription, taskDescriptionLike, taskDefinitionKey, taskDefinitionKeyIn, taskDeleteReason, taskDeleteReasonLike, taskAssignee, taskAssigneeLike, taskOwner, taskOwnerLike, taskPriority, assigned, unassigned, finished, unfinished, processFinished, processUnfinished, taskDueDate, taskDueDateBefore, taskDueDateAfter, withoutTaskDueDate, taskFollowUpDate, taskFollowUpDateBefore, taskFollowUpDateAfter, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, taskVariables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, taskInvolvedUser, taskInvolvedGroup, taskHadCandidateUser, taskHadCandidateGroup, withCandidateGroups, withoutCandidateGroups, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get Tasks (Historic)
   * Queries for historic tasks that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Task Count](https://docs.camunda.org/manual/7.21/reference/rest/history/task/get-task-query-count/) method.
   * @param taskId Filter by task id. (optional)
   * @param taskParentTaskId Filter by parent task id. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processInstanceBusinessKey Filter by process instance business key. (optional)
   * @param processInstanceBusinessKeyIn Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list. (optional)
   * @param processInstanceBusinessKeyLike Filter by  process instance business key that has the parameter value as a substring. (optional)
   * @param executionId Filter by the id of the execution that executed the task. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Restrict to tasks that belong to a process definition with the given key. (optional)
   * @param processDefinitionName Restrict to tasks that belong to a process definition with the given name. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param caseExecutionId Filter by the id of the case execution that executed the task. (optional)
   * @param caseDefinitionId Filter by case definition id. (optional)
   * @param caseDefinitionKey Restrict to tasks that belong to a case definition with the given key. (optional)
   * @param caseDefinitionName Restrict to tasks that belong to a case definition with the given name. (optional)
   * @param activityInstanceIdIn Only include tasks which belong to one of the passed comma-separated activity instance ids. (optional)
   * @param taskName Restrict to tasks that have the given name. (optional)
   * @param taskNameLike Restrict to tasks that have a name with the given parameter value as substring. (optional)
   * @param taskDescription Restrict to tasks that have the given description. (optional)
   * @param taskDescriptionLike Restrict to tasks that have a description that has the parameter value as a substring. (optional)
   * @param taskDefinitionKey Restrict to tasks that have the given key. (optional)
   * @param taskDefinitionKeyIn Restrict to tasks that have one of the passed comma-separated task definition keys. (optional)
   * @param taskDeleteReason Restrict to tasks that have the given delete reason. (optional)
   * @param taskDeleteReasonLike Restrict to tasks that have a delete reason that has the parameter value as a substring. (optional)
   * @param taskAssignee Restrict to tasks that the given user is assigned to. (optional)
   * @param taskAssigneeLike Restrict to tasks that are assigned to users with the parameter value as a substring. (optional)
   * @param taskOwner Restrict to tasks that the given user owns. (optional)
   * @param taskOwnerLike Restrict to tasks that are owned by users with the parameter value as a substring. (optional)
   * @param taskPriority Restrict to tasks that have the given priority. (optional)
   * @param assigned If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned. (optional)
   * @param unassigned If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned. (optional)
   * @param finished Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param unfinished Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param processFinished Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param processUnfinished Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param taskDueDate Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskDueDateBefore Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskDueDateAfter Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param withoutTaskDueDate Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param taskFollowUpDate Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskFollowUpDateBefore Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskFollowUpDateAfter Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedBefore Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedBefore Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedAfter Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param taskVariables Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param processVariables Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param variableNamesIgnoreCase Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
   * @param taskInvolvedUser Restrict to tasks with a historic identity link to the given user. (optional)
   * @param taskInvolvedGroup Restrict to tasks with a historic identity link to the given group. (optional)
   * @param taskHadCandidateUser Restrict to tasks with a historic identity link to the given candidate user. (optional)
   * @param taskHadCandidateGroup Restrict to tasks with a historic identity link to the given candidate group. (optional)
   * @param withCandidateGroups Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withoutCandidateGroups Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricTaskInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricTaskInstanceDto> getHistoricTaskInstances(String taskId, String taskParentTaskId, String processInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, OffsetDateTime taskDueDate, OffsetDateTime taskDueDateBefore, OffsetDateTime taskDueDateAfter, Boolean withoutTaskDueDate, OffsetDateTime taskFollowUpDate, OffsetDateTime taskFollowUpDateBefore, OffsetDateTime taskFollowUpDateAfter, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/task";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("taskId", taskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskParentTaskId", taskParentTaskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionId", executionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionName", processDefinitionName));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseExecutionId", caseExecutionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseDefinitionKey", caseDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseDefinitionName", caseDefinitionName));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskName", taskName));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskNameLike", taskNameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDescription", taskDescription));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDescriptionLike", taskDescriptionLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDefinitionKey", taskDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDefinitionKeyIn", taskDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDeleteReason", taskDeleteReason));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDeleteReasonLike", taskDeleteReasonLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskAssignee", taskAssignee));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskAssigneeLike", taskAssigneeLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskOwner", taskOwner));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskOwnerLike", taskOwnerLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskPriority", taskPriority));
    localVarQueryParams.addAll(apiClient.parameterToPair("assigned", assigned));
    localVarQueryParams.addAll(apiClient.parameterToPair("unassigned", unassigned));
    localVarQueryParams.addAll(apiClient.parameterToPair("finished", finished));
    localVarQueryParams.addAll(apiClient.parameterToPair("unfinished", unfinished));
    localVarQueryParams.addAll(apiClient.parameterToPair("processFinished", processFinished));
    localVarQueryParams.addAll(apiClient.parameterToPair("processUnfinished", processUnfinished));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDueDate", taskDueDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDueDateBefore", taskDueDateBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDueDateAfter", taskDueDateAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTaskDueDate", withoutTaskDueDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskFollowUpDate", taskFollowUpDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskFollowUpDateBefore", taskFollowUpDateBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskFollowUpDateAfter", taskFollowUpDateAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedBefore", startedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedAfter", startedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("finishedBefore", finishedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("finishedAfter", finishedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskVariables", taskVariables));
    localVarQueryParams.addAll(apiClient.parameterToPair("processVariables", processVariables));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskInvolvedUser", taskInvolvedUser));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskInvolvedGroup", taskInvolvedGroup));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskHadCandidateUser", taskHadCandidateUser));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskHadCandidateGroup", taskHadCandidateGroup));
    localVarQueryParams.addAll(apiClient.parameterToPair("withCandidateGroups", withCandidateGroups));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutCandidateGroups", withoutCandidateGroups));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricTaskInstanceDto>> localVarReturnType = new TypeReference<List<HistoricTaskInstanceDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Task Count
   * Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.21/reference/rest/history/task/get-task-query/) method.
   * @param taskId Filter by task id. (optional)
   * @param taskParentTaskId Filter by parent task id. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processInstanceBusinessKey Filter by process instance business key. (optional)
   * @param processInstanceBusinessKeyIn Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list. (optional)
   * @param processInstanceBusinessKeyLike Filter by  process instance business key that has the parameter value as a substring. (optional)
   * @param executionId Filter by the id of the execution that executed the task. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Restrict to tasks that belong to a process definition with the given key. (optional)
   * @param processDefinitionName Restrict to tasks that belong to a process definition with the given name. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param caseExecutionId Filter by the id of the case execution that executed the task. (optional)
   * @param caseDefinitionId Filter by case definition id. (optional)
   * @param caseDefinitionKey Restrict to tasks that belong to a case definition with the given key. (optional)
   * @param caseDefinitionName Restrict to tasks that belong to a case definition with the given name. (optional)
   * @param activityInstanceIdIn Only include tasks which belong to one of the passed comma-separated activity instance ids. (optional)
   * @param taskName Restrict to tasks that have the given name. (optional)
   * @param taskNameLike Restrict to tasks that have a name with the given parameter value as substring. (optional)
   * @param taskDescription Restrict to tasks that have the given description. (optional)
   * @param taskDescriptionLike Restrict to tasks that have a description that has the parameter value as a substring. (optional)
   * @param taskDefinitionKey Restrict to tasks that have the given key. (optional)
   * @param taskDefinitionKeyIn Restrict to tasks that have one of the passed comma-separated task definition keys. (optional)
   * @param taskDeleteReason Restrict to tasks that have the given delete reason. (optional)
   * @param taskDeleteReasonLike Restrict to tasks that have a delete reason that has the parameter value as a substring. (optional)
   * @param taskAssignee Restrict to tasks that the given user is assigned to. (optional)
   * @param taskAssigneeLike Restrict to tasks that are assigned to users with the parameter value as a substring. (optional)
   * @param taskOwner Restrict to tasks that the given user owns. (optional)
   * @param taskOwnerLike Restrict to tasks that are owned by users with the parameter value as a substring. (optional)
   * @param taskPriority Restrict to tasks that have the given priority. (optional)
   * @param assigned If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned. (optional)
   * @param unassigned If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned. (optional)
   * @param finished Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param unfinished Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param processFinished Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param processUnfinished Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param taskDueDate Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskDueDateBefore Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskDueDateAfter Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param withoutTaskDueDate Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param taskFollowUpDate Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskFollowUpDateBefore Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskFollowUpDateAfter Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedBefore Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedBefore Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedAfter Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param taskVariables Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param processVariables Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param variableNamesIgnoreCase Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
   * @param taskInvolvedUser Restrict to tasks with a historic identity link to the given user. (optional)
   * @param taskInvolvedGroup Restrict to tasks with a historic identity link to the given group. (optional)
   * @param taskHadCandidateUser Restrict to tasks with a historic identity link to the given candidate user. (optional)
   * @param taskHadCandidateGroup Restrict to tasks with a historic identity link to the given candidate group. (optional)
   * @param withCandidateGroups Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withoutCandidateGroups Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricTaskInstancesCount(String taskId, String taskParentTaskId, String processInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, OffsetDateTime taskDueDate, OffsetDateTime taskDueDateBefore, OffsetDateTime taskDueDateAfter, Boolean withoutTaskDueDate, OffsetDateTime taskFollowUpDate, OffsetDateTime taskFollowUpDateBefore, OffsetDateTime taskFollowUpDateAfter, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups) throws ApiException {
    return this.getHistoricTaskInstancesCount(taskId, taskParentTaskId, processInstanceId, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, executionId, processDefinitionId, processDefinitionKey, processDefinitionName, caseInstanceId, caseExecutionId, caseDefinitionId, caseDefinitionKey, caseDefinitionName, activityInstanceIdIn, taskName, taskNameLike, taskDescription, taskDescriptionLike, taskDefinitionKey, taskDefinitionKeyIn, taskDeleteReason, taskDeleteReasonLike, taskAssignee, taskAssigneeLike, taskOwner, taskOwnerLike, taskPriority, assigned, unassigned, finished, unfinished, processFinished, processUnfinished, taskDueDate, taskDueDateBefore, taskDueDateAfter, withoutTaskDueDate, taskFollowUpDate, taskFollowUpDateBefore, taskFollowUpDateAfter, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, taskVariables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, taskInvolvedUser, taskInvolvedGroup, taskHadCandidateUser, taskHadCandidateGroup, withCandidateGroups, withoutCandidateGroups, Collections.emptyMap());
  }


  /**
   * Get Task Count
   * Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.21/reference/rest/history/task/get-task-query/) method.
   * @param taskId Filter by task id. (optional)
   * @param taskParentTaskId Filter by parent task id. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param processInstanceBusinessKey Filter by process instance business key. (optional)
   * @param processInstanceBusinessKeyIn Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list. (optional)
   * @param processInstanceBusinessKeyLike Filter by  process instance business key that has the parameter value as a substring. (optional)
   * @param executionId Filter by the id of the execution that executed the task. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Restrict to tasks that belong to a process definition with the given key. (optional)
   * @param processDefinitionName Restrict to tasks that belong to a process definition with the given name. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param caseExecutionId Filter by the id of the case execution that executed the task. (optional)
   * @param caseDefinitionId Filter by case definition id. (optional)
   * @param caseDefinitionKey Restrict to tasks that belong to a case definition with the given key. (optional)
   * @param caseDefinitionName Restrict to tasks that belong to a case definition with the given name. (optional)
   * @param activityInstanceIdIn Only include tasks which belong to one of the passed comma-separated activity instance ids. (optional)
   * @param taskName Restrict to tasks that have the given name. (optional)
   * @param taskNameLike Restrict to tasks that have a name with the given parameter value as substring. (optional)
   * @param taskDescription Restrict to tasks that have the given description. (optional)
   * @param taskDescriptionLike Restrict to tasks that have a description that has the parameter value as a substring. (optional)
   * @param taskDefinitionKey Restrict to tasks that have the given key. (optional)
   * @param taskDefinitionKeyIn Restrict to tasks that have one of the passed comma-separated task definition keys. (optional)
   * @param taskDeleteReason Restrict to tasks that have the given delete reason. (optional)
   * @param taskDeleteReasonLike Restrict to tasks that have a delete reason that has the parameter value as a substring. (optional)
   * @param taskAssignee Restrict to tasks that the given user is assigned to. (optional)
   * @param taskAssigneeLike Restrict to tasks that are assigned to users with the parameter value as a substring. (optional)
   * @param taskOwner Restrict to tasks that the given user owns. (optional)
   * @param taskOwnerLike Restrict to tasks that are owned by users with the parameter value as a substring. (optional)
   * @param taskPriority Restrict to tasks that have the given priority. (optional)
   * @param assigned If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned. (optional)
   * @param unassigned If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned. (optional)
   * @param finished Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param unfinished Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param processFinished Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param processUnfinished Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param taskDueDate Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskDueDateBefore Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskDueDateAfter Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param withoutTaskDueDate Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param taskFollowUpDate Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskFollowUpDateBefore Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param taskFollowUpDateAfter Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedBefore Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param startedAfter Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedBefore Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param finishedAfter Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param taskVariables Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param processVariables Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param variableNamesIgnoreCase Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
   * @param taskInvolvedUser Restrict to tasks with a historic identity link to the given user. (optional)
   * @param taskInvolvedGroup Restrict to tasks with a historic identity link to the given group. (optional)
   * @param taskHadCandidateUser Restrict to tasks with a historic identity link to the given candidate user. (optional)
   * @param taskHadCandidateGroup Restrict to tasks with a historic identity link to the given candidate group. (optional)
   * @param withCandidateGroups Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withoutCandidateGroups Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricTaskInstancesCount(String taskId, String taskParentTaskId, String processInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, OffsetDateTime taskDueDate, OffsetDateTime taskDueDateBefore, OffsetDateTime taskDueDateAfter, Boolean withoutTaskDueDate, OffsetDateTime taskFollowUpDate, OffsetDateTime taskFollowUpDateBefore, OffsetDateTime taskFollowUpDateAfter, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/task/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("taskId", taskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskParentTaskId", taskParentTaskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionId", executionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionName", processDefinitionName));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseExecutionId", caseExecutionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseDefinitionKey", caseDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseDefinitionName", caseDefinitionName));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskName", taskName));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskNameLike", taskNameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDescription", taskDescription));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDescriptionLike", taskDescriptionLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDefinitionKey", taskDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDefinitionKeyIn", taskDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDeleteReason", taskDeleteReason));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDeleteReasonLike", taskDeleteReasonLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskAssignee", taskAssignee));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskAssigneeLike", taskAssigneeLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskOwner", taskOwner));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskOwnerLike", taskOwnerLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskPriority", taskPriority));
    localVarQueryParams.addAll(apiClient.parameterToPair("assigned", assigned));
    localVarQueryParams.addAll(apiClient.parameterToPair("unassigned", unassigned));
    localVarQueryParams.addAll(apiClient.parameterToPair("finished", finished));
    localVarQueryParams.addAll(apiClient.parameterToPair("unfinished", unfinished));
    localVarQueryParams.addAll(apiClient.parameterToPair("processFinished", processFinished));
    localVarQueryParams.addAll(apiClient.parameterToPair("processUnfinished", processUnfinished));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDueDate", taskDueDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDueDateBefore", taskDueDateBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskDueDateAfter", taskDueDateAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTaskDueDate", withoutTaskDueDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskFollowUpDate", taskFollowUpDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskFollowUpDateBefore", taskFollowUpDateBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskFollowUpDateAfter", taskFollowUpDateAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedBefore", startedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("startedAfter", startedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("finishedBefore", finishedBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("finishedAfter", finishedAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskVariables", taskVariables));
    localVarQueryParams.addAll(apiClient.parameterToPair("processVariables", processVariables));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskInvolvedUser", taskInvolvedUser));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskInvolvedGroup", taskInvolvedGroup));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskHadCandidateUser", taskHadCandidateUser));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskHadCandidateGroup", taskHadCandidateGroup));
    localVarQueryParams.addAll(apiClient.parameterToPair("withCandidateGroups", withCandidateGroups));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutCandidateGroups", withoutCandidateGroups));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Tasks (Historic) (POST)
   * Queries for historic tasks that fulfill the given parameters. This method is slightly more powerful than the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.21/reference/rest/history/task/get-task-query/) method because it allows filtering by multiple process or task variables of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;. The size of the result set can be retrieved by using the [Get Task Count (POST)](https://docs.camunda.org/manual/7.21/reference/rest/history/task/post-task-query-count/) method.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param historicTaskInstanceQueryDto  (optional)
   * @return List&lt;HistoricTaskInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricTaskInstanceDto> queryHistoricTaskInstances(Integer firstResult, Integer maxResults, HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto) throws ApiException {
    return this.queryHistoricTaskInstances(firstResult, maxResults, historicTaskInstanceQueryDto, Collections.emptyMap());
  }


  /**
   * Get Tasks (Historic) (POST)
   * Queries for historic tasks that fulfill the given parameters. This method is slightly more powerful than the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.21/reference/rest/history/task/get-task-query/) method because it allows filtering by multiple process or task variables of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;. The size of the result set can be retrieved by using the [Get Task Count (POST)](https://docs.camunda.org/manual/7.21/reference/rest/history/task/post-task-query-count/) method.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param historicTaskInstanceQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricTaskInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricTaskInstanceDto> queryHistoricTaskInstances(Integer firstResult, Integer maxResults, HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historicTaskInstanceQueryDto;
    
    // create path and map variables
    String localVarPath = "/history/task";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricTaskInstanceDto>> localVarReturnType = new TypeReference<List<HistoricTaskInstanceDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Task Count (POST)
   * Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.21/reference/rest/history/task/get-task-query/) method. Corresponds to the size of the result set of the [Get Tasks (Historic) (POST)](https://docs.camunda.org/manual/7.21/reference/rest/history/task/post-task-query/) method and takes the same parameters.
   * @param historicTaskInstanceQueryDto  (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryHistoricTaskInstancesCount(HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto) throws ApiException {
    return this.queryHistoricTaskInstancesCount(historicTaskInstanceQueryDto, Collections.emptyMap());
  }


  /**
   * Get Task Count (POST)
   * Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.21/reference/rest/history/task/get-task-query/) method. Corresponds to the size of the result set of the [Get Tasks (Historic) (POST)](https://docs.camunda.org/manual/7.21/reference/rest/history/task/post-task-query/) method and takes the same parameters.
   * @param historicTaskInstanceQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryHistoricTaskInstancesCount(HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historicTaskInstanceQueryDto;
    
    // create path and map variables
    String localVarPath = "/history/task/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
