/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.AnnotationDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import java.time.OffsetDateTime;
import org.camunda.community.rest.client.dto.UserOperationLogEntryDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricUserOperationLogApi {


  private ApiClient apiClient;

  public HistoricUserOperationLogApi() {
    this(Configuration.getDefaultApiClient());
  }

  public HistoricUserOperationLogApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Clear Annotation of an User Operation Log (Historic)
   * Clear the annotation which was previously set for auditing reasons.
   * @param operationId The operation id of the operation log to be updated. (required)
   * @throws ApiException if fails to make API call
   */
  public void clearAnnotationUserOperationLog(String operationId) throws ApiException {
    this.clearAnnotationUserOperationLog(operationId, Collections.emptyMap());
  }


  /**
   * Clear Annotation of an User Operation Log (Historic)
   * Clear the annotation which was previously set for auditing reasons.
   * @param operationId The operation id of the operation log to be updated. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void clearAnnotationUserOperationLog(String operationId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'operationId' is set
    if (operationId == null) {
      throw new ApiException(400, "Missing the required parameter 'operationId' when calling clearAnnotationUserOperationLog");
    }
    
    // create path and map variables
    String localVarPath = "/history/user-operation/{operationId}/clear-annotation"
      .replaceAll("\\{" + "operationId" + "\\}", apiClient.escapeString(operationId.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get User Operation Log Count
   * Queries for the number of user operation log entries that fulfill the given parameters. Takes the same parameters as the [Get User Operation Log (Historic)](https://docs.camunda.org/manual/7.21/reference/rest/history/user-operation-log/get-user-operation-log-query/) method.
   * @param deploymentId Filter by deployment id. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Filter by process definition key. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param executionId Filter by execution id. (optional)
   * @param caseDefinitionId Filter by case definition id. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param caseExecutionId Filter by case execution id. (optional)
   * @param taskId Only include operations on this task. (optional)
   * @param externalTaskId Only include operations on this external task. (optional)
   * @param batchId Only include operations on this batch. (optional)
   * @param jobId Filter by job id. (optional)
   * @param jobDefinitionId Filter by job definition id. (optional)
   * @param userId Only include operations of this user. (optional)
   * @param operationId Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation. (optional)
   * @param operationType Filter by the type of the operation like &#x60;Claim&#x60; or &#x60;Delegate&#x60;. See the [Javadoc](https://docs.camunda.org/manual/7.21/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types. (optional)
   * @param entityType Filter by the type of the entity that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
   * @param entityTypeIn Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
   * @param category Filter by the category that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
   * @param categoryIn Filter by a comma-separated list of categories that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
   * @param property Only include operations that changed this property, e.g., &#x60;owner&#x60; or &#x60;assignee&#x60;. (optional)
   * @param afterTimestamp Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param beforeTimestamp Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryUserOperationCount(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, OffsetDateTime afterTimestamp, OffsetDateTime beforeTimestamp) throws ApiException {
    return this.queryUserOperationCount(deploymentId, processDefinitionId, processDefinitionKey, processInstanceId, executionId, caseDefinitionId, caseInstanceId, caseExecutionId, taskId, externalTaskId, batchId, jobId, jobDefinitionId, userId, operationId, operationType, entityType, entityTypeIn, category, categoryIn, property, afterTimestamp, beforeTimestamp, Collections.emptyMap());
  }


  /**
   * Get User Operation Log Count
   * Queries for the number of user operation log entries that fulfill the given parameters. Takes the same parameters as the [Get User Operation Log (Historic)](https://docs.camunda.org/manual/7.21/reference/rest/history/user-operation-log/get-user-operation-log-query/) method.
   * @param deploymentId Filter by deployment id. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Filter by process definition key. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param executionId Filter by execution id. (optional)
   * @param caseDefinitionId Filter by case definition id. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param caseExecutionId Filter by case execution id. (optional)
   * @param taskId Only include operations on this task. (optional)
   * @param externalTaskId Only include operations on this external task. (optional)
   * @param batchId Only include operations on this batch. (optional)
   * @param jobId Filter by job id. (optional)
   * @param jobDefinitionId Filter by job definition id. (optional)
   * @param userId Only include operations of this user. (optional)
   * @param operationId Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation. (optional)
   * @param operationType Filter by the type of the operation like &#x60;Claim&#x60; or &#x60;Delegate&#x60;. See the [Javadoc](https://docs.camunda.org/manual/7.21/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types. (optional)
   * @param entityType Filter by the type of the entity that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
   * @param entityTypeIn Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
   * @param category Filter by the category that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
   * @param categoryIn Filter by a comma-separated list of categories that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
   * @param property Only include operations that changed this property, e.g., &#x60;owner&#x60; or &#x60;assignee&#x60;. (optional)
   * @param afterTimestamp Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param beforeTimestamp Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryUserOperationCount(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, OffsetDateTime afterTimestamp, OffsetDateTime beforeTimestamp, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/user-operation/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("deploymentId", deploymentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionId", executionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseExecutionId", caseExecutionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskId", taskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("externalTaskId", externalTaskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("batchId", batchId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobId", jobId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("userId", userId));
    localVarQueryParams.addAll(apiClient.parameterToPair("operationId", operationId));
    localVarQueryParams.addAll(apiClient.parameterToPair("operationType", operationType));
    localVarQueryParams.addAll(apiClient.parameterToPair("entityType", entityType));
    localVarQueryParams.addAll(apiClient.parameterToPair("entityTypeIn", entityTypeIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("category", category));
    localVarQueryParams.addAll(apiClient.parameterToPair("categoryIn", categoryIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("property", property));
    localVarQueryParams.addAll(apiClient.parameterToPair("afterTimestamp", afterTimestamp));
    localVarQueryParams.addAll(apiClient.parameterToPair("beforeTimestamp", beforeTimestamp));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get User Operation Log (Historic)
   * Queries for user operation log entries that fulfill the given parameters. The size of the result set can be retrieved by using the [Get User Operation Log Count](https://docs.camunda.org/manual/7.21/reference/rest/history/user-operation-log/get-user-operation-log-query-count/) method.  Note that the properties of operation log entries are interpreted as restrictions on the entities they apply to. That means, if a single process instance is updated, the field &#x60;processInstanceId&#x60; is populated. If a single operation updates all process instances of the same process definition, the field &#x60;processInstanceId&#x60; is &#x60;null&#x60; (a &#x60;null&#x60; restriction is viewed as a wildcard, i.e., matches a process instance with any id) and the field &#x60;processDefinitionId&#x60; is populated. This way, which entities were changed by a user operation can easily be reconstructed.
   * @param deploymentId Filter by deployment id. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Filter by process definition key. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param executionId Filter by execution id. (optional)
   * @param caseDefinitionId Filter by case definition id. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param caseExecutionId Filter by case execution id. (optional)
   * @param taskId Only include operations on this task. (optional)
   * @param externalTaskId Only include operations on this external task. (optional)
   * @param batchId Only include operations on this batch. (optional)
   * @param jobId Filter by job id. (optional)
   * @param jobDefinitionId Filter by job definition id. (optional)
   * @param userId Only include operations of this user. (optional)
   * @param operationId Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation. (optional)
   * @param operationType Filter by the type of the operation like &#x60;Claim&#x60; or &#x60;Delegate&#x60;. See the [Javadoc](https://docs.camunda.org/manual/7.21/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types. (optional)
   * @param entityType Filter by the type of the entity that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
   * @param entityTypeIn Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
   * @param category Filter by the category that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
   * @param categoryIn Filter by a comma-separated list of categories that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
   * @param property Only include operations that changed this property, e.g., &#x60;owner&#x60; or &#x60;assignee&#x60;. (optional)
   * @param afterTimestamp Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param beforeTimestamp Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;UserOperationLogEntryDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<UserOperationLogEntryDto> queryUserOperationEntries(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, OffsetDateTime afterTimestamp, OffsetDateTime beforeTimestamp, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.queryUserOperationEntries(deploymentId, processDefinitionId, processDefinitionKey, processInstanceId, executionId, caseDefinitionId, caseInstanceId, caseExecutionId, taskId, externalTaskId, batchId, jobId, jobDefinitionId, userId, operationId, operationType, entityType, entityTypeIn, category, categoryIn, property, afterTimestamp, beforeTimestamp, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get User Operation Log (Historic)
   * Queries for user operation log entries that fulfill the given parameters. The size of the result set can be retrieved by using the [Get User Operation Log Count](https://docs.camunda.org/manual/7.21/reference/rest/history/user-operation-log/get-user-operation-log-query-count/) method.  Note that the properties of operation log entries are interpreted as restrictions on the entities they apply to. That means, if a single process instance is updated, the field &#x60;processInstanceId&#x60; is populated. If a single operation updates all process instances of the same process definition, the field &#x60;processInstanceId&#x60; is &#x60;null&#x60; (a &#x60;null&#x60; restriction is viewed as a wildcard, i.e., matches a process instance with any id) and the field &#x60;processDefinitionId&#x60; is populated. This way, which entities were changed by a user operation can easily be reconstructed.
   * @param deploymentId Filter by deployment id. (optional)
   * @param processDefinitionId Filter by process definition id. (optional)
   * @param processDefinitionKey Filter by process definition key. (optional)
   * @param processInstanceId Filter by process instance id. (optional)
   * @param executionId Filter by execution id. (optional)
   * @param caseDefinitionId Filter by case definition id. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param caseExecutionId Filter by case execution id. (optional)
   * @param taskId Only include operations on this task. (optional)
   * @param externalTaskId Only include operations on this external task. (optional)
   * @param batchId Only include operations on this batch. (optional)
   * @param jobId Filter by job id. (optional)
   * @param jobDefinitionId Filter by job definition id. (optional)
   * @param userId Only include operations of this user. (optional)
   * @param operationId Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation. (optional)
   * @param operationType Filter by the type of the operation like &#x60;Claim&#x60; or &#x60;Delegate&#x60;. See the [Javadoc](https://docs.camunda.org/manual/7.21/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types. (optional)
   * @param entityType Filter by the type of the entity that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
   * @param entityTypeIn Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
   * @param category Filter by the category that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
   * @param categoryIn Filter by a comma-separated list of categories that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
   * @param property Only include operations that changed this property, e.g., &#x60;owner&#x60; or &#x60;assignee&#x60;. (optional)
   * @param afterTimestamp Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param beforeTimestamp Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;UserOperationLogEntryDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<UserOperationLogEntryDto> queryUserOperationEntries(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, OffsetDateTime afterTimestamp, OffsetDateTime beforeTimestamp, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/user-operation";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("deploymentId", deploymentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionId", executionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseExecutionId", caseExecutionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskId", taskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("externalTaskId", externalTaskId));
    localVarQueryParams.addAll(apiClient.parameterToPair("batchId", batchId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobId", jobId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("userId", userId));
    localVarQueryParams.addAll(apiClient.parameterToPair("operationId", operationId));
    localVarQueryParams.addAll(apiClient.parameterToPair("operationType", operationType));
    localVarQueryParams.addAll(apiClient.parameterToPair("entityType", entityType));
    localVarQueryParams.addAll(apiClient.parameterToPair("entityTypeIn", entityTypeIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("category", category));
    localVarQueryParams.addAll(apiClient.parameterToPair("categoryIn", categoryIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("property", property));
    localVarQueryParams.addAll(apiClient.parameterToPair("afterTimestamp", afterTimestamp));
    localVarQueryParams.addAll(apiClient.parameterToPair("beforeTimestamp", beforeTimestamp));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<UserOperationLogEntryDto>> localVarReturnType = new TypeReference<List<UserOperationLogEntryDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Set Annotation to an User Operation Log (Historic)
   * Set an annotation for auditing reasons.
   * @param operationId The operation id of the operation log to be updated. (required)
   * @param annotationDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void setAnnotationUserOperationLog(String operationId, AnnotationDto annotationDto) throws ApiException {
    this.setAnnotationUserOperationLog(operationId, annotationDto, Collections.emptyMap());
  }


  /**
   * Set Annotation to an User Operation Log (Historic)
   * Set an annotation for auditing reasons.
   * @param operationId The operation id of the operation log to be updated. (required)
   * @param annotationDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void setAnnotationUserOperationLog(String operationId, AnnotationDto annotationDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = annotationDto;
    
    // verify the required parameter 'operationId' is set
    if (operationId == null) {
      throw new ApiException(400, "Missing the required parameter 'operationId' when calling setAnnotationUserOperationLog");
    }
    
    // create path and map variables
    String localVarPath = "/history/user-operation/{operationId}/set-annotation"
      .replaceAll("\\{" + "operationId" + "\\}", apiClient.escapeString(operationId.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

}
