/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import java.io.File;
import org.camunda.community.rest.client.dto.HistoricVariableInstanceDto;
import org.camunda.community.rest.client.dto.HistoricVariableInstanceQueryDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricVariableInstanceApi {


  private ApiClient apiClient;

  public HistoricVariableInstanceApi() {
    this(Configuration.getDefaultApiClient());
  }

  public HistoricVariableInstanceApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Delete Variable Instance
   * Deletes a historic variable instance by id.
   * @param id The id of the variable instance. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteHistoricVariableInstance(String id) throws ApiException {
    this.deleteHistoricVariableInstance(id, Collections.emptyMap());
  }


  /**
   * Delete Variable Instance
   * Deletes a historic variable instance by id.
   * @param id The id of the variable instance. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteHistoricVariableInstance(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteHistoricVariableInstance");
    }
    
    // create path and map variables
    String localVarPath = "/history/variable-instance/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get Variable Instance
   * Retrieves a historic variable by id.
   * @param id The id of the variable instance. (required)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @return HistoricVariableInstanceDto
   * @throws ApiException if fails to make API call
   */
  public HistoricVariableInstanceDto getHistoricVariableInstance(String id, Boolean deserializeValues) throws ApiException {
    return this.getHistoricVariableInstance(id, deserializeValues, Collections.emptyMap());
  }


  /**
   * Get Variable Instance
   * Retrieves a historic variable by id.
   * @param id The id of the variable instance. (required)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return HistoricVariableInstanceDto
   * @throws ApiException if fails to make API call
   */
  public HistoricVariableInstanceDto getHistoricVariableInstance(String id, Boolean deserializeValues, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getHistoricVariableInstance");
    }
    
    // create path and map variables
    String localVarPath = "/history/variable-instance/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("deserializeValues", deserializeValues));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<HistoricVariableInstanceDto> localVarReturnType = new TypeReference<HistoricVariableInstanceDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Variable Instance (Binary)
   * Retrieves the content of a historic variable by id. Applicable for variables that are serialized as binary data.
   * @param id The id of the variable instance. (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getHistoricVariableInstanceBinary(String id) throws ApiException {
    return this.getHistoricVariableInstanceBinary(id, Collections.emptyMap());
  }


  /**
   * Get Variable Instance (Binary)
   * Retrieves the content of a historic variable by id. Applicable for variables that are serialized as binary data.
   * @param id The id of the variable instance. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getHistoricVariableInstanceBinary(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getHistoricVariableInstanceBinary");
    }
    
    // create path and map variables
    String localVarPath = "/history/variable-instance/{id}/data"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/octet-stream", "*/*", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<File> localVarReturnType = new TypeReference<File>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Variable Instances
   * Queries for historic variable instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Variable Instance Count](https://docs.camunda.org/manual/7.21/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.
   * @param variableName Filter by variable name. (optional)
   * @param variableNameLike Restrict to variables with a name like the parameter. (optional)
   * @param variableValue Filter by variable value. Is treated as a &#x60;String&#x60; object on server side. (optional)
   * @param variableNamesIgnoreCase Match the variable name provided in &#x60;variableName&#x60; and &#x60;variableNameLike&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match the variable value provided in &#x60;variableValue&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
   * @param variableTypeIn Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.21/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#39;serializable&#39;. (optional)
   * @param includeDeleted Include variables that has already been deleted during the execution. (optional)
   * @param processInstanceId Filter by the process instance the variable belongs to. (optional)
   * @param processInstanceIdIn Only include historic variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
   * @param processDefinitionId Filter by the process definition the variable belongs to. (optional)
   * @param processDefinitionKey Filter by a key of the process definition the variable belongs to. (optional)
   * @param executionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated execution ids. (optional)
   * @param caseInstanceId Filter by the case instance the variable belongs to. (optional)
   * @param caseExecutionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids. (optional)
   * @param caseActivityIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids. (optional)
   * @param taskIdIn Only include historic variable instances which belong to one of the passed and and comma-separated task ids. (optional)
   * @param activityInstanceIdIn Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids. (optional)
   * @param tenantIdIn Only include historic variable instances which belong to one of the passed and comma- separated tenant ids. (optional)
   * @param withoutTenantId Only include historic variable instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param variableNameIn Only include historic variable instances which belong to one of the passed and comma-separated variable names. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @return List&lt;HistoricVariableInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricVariableInstanceDto> getHistoricVariableInstances(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues) throws ApiException {
    return this.getHistoricVariableInstances(variableName, variableNameLike, variableValue, variableNamesIgnoreCase, variableValuesIgnoreCase, variableTypeIn, includeDeleted, processInstanceId, processInstanceIdIn, processDefinitionId, processDefinitionKey, executionIdIn, caseInstanceId, caseExecutionIdIn, caseActivityIdIn, taskIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, variableNameIn, sortBy, sortOrder, firstResult, maxResults, deserializeValues, Collections.emptyMap());
  }


  /**
   * Get Variable Instances
   * Queries for historic variable instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Variable Instance Count](https://docs.camunda.org/manual/7.21/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.
   * @param variableName Filter by variable name. (optional)
   * @param variableNameLike Restrict to variables with a name like the parameter. (optional)
   * @param variableValue Filter by variable value. Is treated as a &#x60;String&#x60; object on server side. (optional)
   * @param variableNamesIgnoreCase Match the variable name provided in &#x60;variableName&#x60; and &#x60;variableNameLike&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match the variable value provided in &#x60;variableValue&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
   * @param variableTypeIn Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.21/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#39;serializable&#39;. (optional)
   * @param includeDeleted Include variables that has already been deleted during the execution. (optional)
   * @param processInstanceId Filter by the process instance the variable belongs to. (optional)
   * @param processInstanceIdIn Only include historic variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
   * @param processDefinitionId Filter by the process definition the variable belongs to. (optional)
   * @param processDefinitionKey Filter by a key of the process definition the variable belongs to. (optional)
   * @param executionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated execution ids. (optional)
   * @param caseInstanceId Filter by the case instance the variable belongs to. (optional)
   * @param caseExecutionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids. (optional)
   * @param caseActivityIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids. (optional)
   * @param taskIdIn Only include historic variable instances which belong to one of the passed and and comma-separated task ids. (optional)
   * @param activityInstanceIdIn Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids. (optional)
   * @param tenantIdIn Only include historic variable instances which belong to one of the passed and comma- separated tenant ids. (optional)
   * @param withoutTenantId Only include historic variable instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param variableNameIn Only include historic variable instances which belong to one of the passed and comma-separated variable names. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricVariableInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricVariableInstanceDto> getHistoricVariableInstances(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/variable-instance";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("variableName", variableName));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNameLike", variableNameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableValue", variableValue));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableTypeIn", variableTypeIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("includeDeleted", includeDeleted));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionIdIn", executionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseExecutionIdIn", caseExecutionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseActivityIdIn", caseActivityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskIdIn", taskIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNameIn", variableNameIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    localVarQueryParams.addAll(apiClient.parameterToPair("deserializeValues", deserializeValues));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricVariableInstanceDto>> localVarReturnType = new TypeReference<List<HistoricVariableInstanceDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Variable Instance Count
   * Queries for the number of historic variable instances that fulfill the given parameters. Takes the same parameters as the [Get Variable Instances](https://docs.camunda.org/manual/7.21/reference/rest/history/variable-instance/get-variable-instance-query/) method.
   * @param variableName Filter by variable name. (optional)
   * @param variableNameLike Restrict to variables with a name like the parameter. (optional)
   * @param variableValue Filter by variable value. Is treated as a &#x60;String&#x60; object on server side. (optional)
   * @param variableNamesIgnoreCase Match the variable name provided in &#x60;variableName&#x60; and &#x60;variableNameLike&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match the variable value provided in &#x60;variableValue&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
   * @param variableTypeIn Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.21/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#39;serializable&#39;. (optional)
   * @param includeDeleted Include variables that has already been deleted during the execution. (optional)
   * @param processInstanceId Filter by the process instance the variable belongs to. (optional)
   * @param processInstanceIdIn Only include historic variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
   * @param processDefinitionId Filter by the process definition the variable belongs to. (optional)
   * @param processDefinitionKey Filter by a key of the process definition the variable belongs to. (optional)
   * @param executionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated execution ids. (optional)
   * @param caseInstanceId Filter by the case instance the variable belongs to. (optional)
   * @param caseExecutionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids. (optional)
   * @param caseActivityIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids. (optional)
   * @param taskIdIn Only include historic variable instances which belong to one of the passed and and comma-separated task ids. (optional)
   * @param activityInstanceIdIn Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids. (optional)
   * @param tenantIdIn Only include historic variable instances which belong to one of the passed and comma- separated tenant ids. (optional)
   * @param withoutTenantId Only include historic variable instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param variableNameIn Only include historic variable instances which belong to one of the passed and comma-separated variable names. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricVariableInstancesCount(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn) throws ApiException {
    return this.getHistoricVariableInstancesCount(variableName, variableNameLike, variableValue, variableNamesIgnoreCase, variableValuesIgnoreCase, variableTypeIn, includeDeleted, processInstanceId, processInstanceIdIn, processDefinitionId, processDefinitionKey, executionIdIn, caseInstanceId, caseExecutionIdIn, caseActivityIdIn, taskIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, variableNameIn, Collections.emptyMap());
  }


  /**
   * Get Variable Instance Count
   * Queries for the number of historic variable instances that fulfill the given parameters. Takes the same parameters as the [Get Variable Instances](https://docs.camunda.org/manual/7.21/reference/rest/history/variable-instance/get-variable-instance-query/) method.
   * @param variableName Filter by variable name. (optional)
   * @param variableNameLike Restrict to variables with a name like the parameter. (optional)
   * @param variableValue Filter by variable value. Is treated as a &#x60;String&#x60; object on server side. (optional)
   * @param variableNamesIgnoreCase Match the variable name provided in &#x60;variableName&#x60; and &#x60;variableNameLike&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
   * @param variableValuesIgnoreCase Match the variable value provided in &#x60;variableValue&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
   * @param variableTypeIn Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.21/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#39;serializable&#39;. (optional)
   * @param includeDeleted Include variables that has already been deleted during the execution. (optional)
   * @param processInstanceId Filter by the process instance the variable belongs to. (optional)
   * @param processInstanceIdIn Only include historic variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
   * @param processDefinitionId Filter by the process definition the variable belongs to. (optional)
   * @param processDefinitionKey Filter by a key of the process definition the variable belongs to. (optional)
   * @param executionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated execution ids. (optional)
   * @param caseInstanceId Filter by the case instance the variable belongs to. (optional)
   * @param caseExecutionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids. (optional)
   * @param caseActivityIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids. (optional)
   * @param taskIdIn Only include historic variable instances which belong to one of the passed and and comma-separated task ids. (optional)
   * @param activityInstanceIdIn Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids. (optional)
   * @param tenantIdIn Only include historic variable instances which belong to one of the passed and comma- separated tenant ids. (optional)
   * @param withoutTenantId Only include historic variable instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param variableNameIn Only include historic variable instances which belong to one of the passed and comma-separated variable names. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getHistoricVariableInstancesCount(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/history/variable-instance/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("variableName", variableName));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNameLike", variableNameLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableValue", variableValue));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableTypeIn", variableTypeIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("includeDeleted", includeDeleted));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionIdIn", executionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseExecutionIdIn", caseExecutionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseActivityIdIn", caseActivityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("taskIdIn", taskIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNameIn", variableNameIn));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Variable Instances (POST)
   * Queries for historic variable instances that fulfill the given parameters. This method is slightly more powerful than the [Get Variable Instances](https://docs.camunda.org/manual/7.21/reference/rest/history/variable-instance/get-variable-instance-query/) method because it allows filtering by variable values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @param historicVariableInstanceQueryDto  (optional)
   * @return List&lt;HistoricVariableInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricVariableInstanceDto> queryHistoricVariableInstances(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto) throws ApiException {
    return this.queryHistoricVariableInstances(firstResult, maxResults, deserializeValues, historicVariableInstanceQueryDto, Collections.emptyMap());
  }


  /**
   * Get Variable Instances (POST)
   * Queries for historic variable instances that fulfill the given parameters. This method is slightly more powerful than the [Get Variable Instances](https://docs.camunda.org/manual/7.21/reference/rest/history/variable-instance/get-variable-instance-query/) method because it allows filtering by variable values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
   * @param historicVariableInstanceQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;HistoricVariableInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<HistoricVariableInstanceDto> queryHistoricVariableInstances(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historicVariableInstanceQueryDto;
    
    // create path and map variables
    String localVarPath = "/history/variable-instance";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    localVarQueryParams.addAll(apiClient.parameterToPair("deserializeValues", deserializeValues));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<HistoricVariableInstanceDto>> localVarReturnType = new TypeReference<List<HistoricVariableInstanceDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Variable Instance Count (POST)
   * Queries for historic variable instances that fulfill the given parameters. This method takes the same message body as the [Get Variable Instances (POST)](https://docs.camunda.org/manual/7.21/reference/rest/history/variable-instance/post-variable-instance-query/) method and therefore it is more powerful regarding variable values than the [Get Variable Instance Count](https://docs.camunda.org/manual/7.21/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.
   * @param historicVariableInstanceQueryDto  (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryHistoricVariableInstancesCount(HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto) throws ApiException {
    return this.queryHistoricVariableInstancesCount(historicVariableInstanceQueryDto, Collections.emptyMap());
  }


  /**
   * Get Variable Instance Count (POST)
   * Queries for historic variable instances that fulfill the given parameters. This method takes the same message body as the [Get Variable Instances (POST)](https://docs.camunda.org/manual/7.21/reference/rest/history/variable-instance/post-variable-instance-query/) method and therefore it is more powerful regarding variable values than the [Get Variable Instance Count](https://docs.camunda.org/manual/7.21/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.
   * @param historicVariableInstanceQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryHistoricVariableInstancesCount(HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = historicVariableInstanceQueryDto;
    
    // create path and map variables
    String localVarPath = "/history/variable-instance/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
