/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.AuthenticationResult;
import org.camunda.community.rest.client.dto.BasicUserCredentialsDto;
import org.camunda.community.rest.client.dto.CheckPasswordPolicyResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.IdentityServiceGroupInfoDto;
import org.camunda.community.rest.client.dto.PasswordPolicyDto;
import org.camunda.community.rest.client.dto.PasswordPolicyRequestDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class IdentityApi {


  private ApiClient apiClient;

  public IdentityApi() {
    this(Configuration.getDefaultApiClient());
  }

  public IdentityApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Validate Password
   * A password policy consists of a list of rules that new passwords must follow to be policy compliant. A password can be checked for compliancy via this end point. More information on password policies in Camunda can be found in the password policy [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/password-policy/) and in the [security instructions](https://docs.camunda.org/manual/7.21/user-guide/security/).
   * @param passwordPolicyRequestDto  (optional)
   * @return CheckPasswordPolicyResultDto
   * @throws ApiException if fails to make API call
   */
  public CheckPasswordPolicyResultDto checkPassword(PasswordPolicyRequestDto passwordPolicyRequestDto) throws ApiException {
    return this.checkPassword(passwordPolicyRequestDto, Collections.emptyMap());
  }


  /**
   * Validate Password
   * A password policy consists of a list of rules that new passwords must follow to be policy compliant. A password can be checked for compliancy via this end point. More information on password policies in Camunda can be found in the password policy [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/password-policy/) and in the [security instructions](https://docs.camunda.org/manual/7.21/user-guide/security/).
   * @param passwordPolicyRequestDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CheckPasswordPolicyResultDto
   * @throws ApiException if fails to make API call
   */
  public CheckPasswordPolicyResultDto checkPassword(PasswordPolicyRequestDto passwordPolicyRequestDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = passwordPolicyRequestDto;
    
    // create path and map variables
    String localVarPath = "/identity/password-policy";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CheckPasswordPolicyResultDto> localVarReturnType = new TypeReference<CheckPasswordPolicyResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get a User&#39;s Groups
   * Gets the groups of a user by id and includes all users that share a group with the given user.
   * @param userId The id of the user to get the groups for. (required)
   * @return IdentityServiceGroupInfoDto
   * @throws ApiException if fails to make API call
   */
  public IdentityServiceGroupInfoDto getGroupInfo(String userId) throws ApiException {
    return this.getGroupInfo(userId, Collections.emptyMap());
  }


  /**
   * Get a User&#39;s Groups
   * Gets the groups of a user by id and includes all users that share a group with the given user.
   * @param userId The id of the user to get the groups for. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return IdentityServiceGroupInfoDto
   * @throws ApiException if fails to make API call
   */
  public IdentityServiceGroupInfoDto getGroupInfo(String userId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'userId' is set
    if (userId == null) {
      throw new ApiException(400, "Missing the required parameter 'userId' when calling getGroupInfo");
    }
    
    // create path and map variables
    String localVarPath = "/identity/groups";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("userId", userId));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<IdentityServiceGroupInfoDto> localVarReturnType = new TypeReference<IdentityServiceGroupInfoDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Password Policy
   * A password policy consists of a list of rules that new passwords must follow to be policy compliant. This end point returns a JSON representation of the list of policy rules. More information on password policies in Camunda can be found in the password policy [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/password-policy/) and in the [security instructions](https://docs.camunda.org/manual/7.21/user-guide/security/).
   * @return PasswordPolicyDto
   * @throws ApiException if fails to make API call
   */
  public PasswordPolicyDto getPasswordPolicy() throws ApiException {
    return this.getPasswordPolicy(Collections.emptyMap());
  }


  /**
   * Get Password Policy
   * A password policy consists of a list of rules that new passwords must follow to be policy compliant. This end point returns a JSON representation of the list of policy rules. More information on password policies in Camunda can be found in the password policy [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/password-policy/) and in the [security instructions](https://docs.camunda.org/manual/7.21/user-guide/security/).
   * @param additionalHeaders additionalHeaders for this call
   * @return PasswordPolicyDto
   * @throws ApiException if fails to make API call
   */
  public PasswordPolicyDto getPasswordPolicy(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/identity/password-policy";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<PasswordPolicyDto> localVarReturnType = new TypeReference<PasswordPolicyDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Verify User
   * Verifies that user credentials are valid.
   * @param basicUserCredentialsDto  (optional)
   * @return AuthenticationResult
   * @throws ApiException if fails to make API call
   */
  public AuthenticationResult verifyUser(BasicUserCredentialsDto basicUserCredentialsDto) throws ApiException {
    return this.verifyUser(basicUserCredentialsDto, Collections.emptyMap());
  }


  /**
   * Verify User
   * Verifies that user credentials are valid.
   * @param basicUserCredentialsDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return AuthenticationResult
   * @throws ApiException if fails to make API call
   */
  public AuthenticationResult verifyUser(BasicUserCredentialsDto basicUserCredentialsDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = basicUserCredentialsDto;
    
    // create path and map variables
    String localVarPath = "/identity/verify";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<AuthenticationResult> localVarReturnType = new TypeReference<AuthenticationResult>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
