/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.AnnotationDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.IncidentDto;
import java.time.OffsetDateTime;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class IncidentApi {


  private ApiClient apiClient;

  public IncidentApi() {
    this(Configuration.getDefaultApiClient());
  }

  public IncidentApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Clear Incident Annotation
   * Clears the annotation of an incident with given id.
   * @param id The id of the incident to clear the annotation at. (required)
   * @throws ApiException if fails to make API call
   */
  public void clearIncidentAnnotation(String id) throws ApiException {
    this.clearIncidentAnnotation(id, Collections.emptyMap());
  }


  /**
   * Clear Incident Annotation
   * Clears the annotation of an incident with given id.
   * @param id The id of the incident to clear the annotation at. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void clearIncidentAnnotation(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling clearIncidentAnnotation");
    }
    
    // create path and map variables
    String localVarPath = "/incident/{id}/annotation"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get Incident
   * Retrieves an incident by ID.
   * @param id The id of the incident to be retrieved. (required)
   * @return IncidentDto
   * @throws ApiException if fails to make API call
   */
  public IncidentDto getIncident(String id) throws ApiException {
    return this.getIncident(id, Collections.emptyMap());
  }


  /**
   * Get Incident
   * Retrieves an incident by ID.
   * @param id The id of the incident to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return IncidentDto
   * @throws ApiException if fails to make API call
   */
  public IncidentDto getIncident(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getIncident");
    }
    
    // create path and map variables
    String localVarPath = "/incident/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<IncidentDto> localVarReturnType = new TypeReference<IncidentDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List
   * Queries for incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.21/reference/rest/incident/get-query-count/) method.
   * @param incidentId Restricts to incidents that have the given id. (optional)
   * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
   * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (&#x60;string%&#x60;), ends with (&#x60;%string&#x60;) or contains (&#x60;%string%&#x60;). (optional)
   * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
   * @param processDefinitionKeyIn Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list. (optional)
   * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
   * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
   * @param incidentTimestampBefore Restricts to incidents that have an incidentTimestamp date before the given date.  By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param incidentTimestampAfter Restricts to incidents that have an incidentTimestamp date after the given date.  By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
   * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
   * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
   * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
   * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
   * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
   * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;IncidentDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<IncidentDto> getIncidents(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, OffsetDateTime incidentTimestampBefore, OffsetDateTime incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.getIncidents(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get List
   * Queries for incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.21/reference/rest/incident/get-query-count/) method.
   * @param incidentId Restricts to incidents that have the given id. (optional)
   * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
   * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (&#x60;string%&#x60;), ends with (&#x60;%string&#x60;) or contains (&#x60;%string%&#x60;). (optional)
   * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
   * @param processDefinitionKeyIn Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list. (optional)
   * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
   * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
   * @param incidentTimestampBefore Restricts to incidents that have an incidentTimestamp date before the given date.  By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param incidentTimestampAfter Restricts to incidents that have an incidentTimestamp date after the given date.  By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
   * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
   * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
   * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
   * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
   * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
   * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;IncidentDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<IncidentDto> getIncidents(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, OffsetDateTime incidentTimestampBefore, OffsetDateTime incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/incident";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("incidentId", incidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentType", incidentType));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessage", incidentMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionId", executionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentTimestampBefore", incidentTimestampBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentTimestampAfter", incidentTimestampAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityId", activityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("failedActivityId", failedActivityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("causeIncidentId", causeIncidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("rootCauseIncidentId", rootCauseIncidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("configuration", _configuration));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionIdIn", jobDefinitionIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<IncidentDto>> localVarReturnType = new TypeReference<List<IncidentDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List Count
   * Queries for the number of incidents that fulfill given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.21/reference/rest/incident/get-query/) method.
   * @param incidentId Restricts to incidents that have the given id. (optional)
   * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
   * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (&#x60;string%&#x60;), ends with (&#x60;%string&#x60;) or contains (&#x60;%string%&#x60;). (optional)
   * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
   * @param processDefinitionKeyIn Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list. (optional)
   * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
   * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
   * @param incidentTimestampBefore Restricts to incidents that have an incidentTimestamp date before the given date.  By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param incidentTimestampAfter Restricts to incidents that have an incidentTimestamp date after the given date.  By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
   * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
   * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
   * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
   * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
   * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
   * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getIncidentsCount(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, OffsetDateTime incidentTimestampBefore, OffsetDateTime incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn) throws ApiException {
    return this.getIncidentsCount(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, Collections.emptyMap());
  }


  /**
   * Get List Count
   * Queries for the number of incidents that fulfill given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.21/reference/rest/incident/get-query/) method.
   * @param incidentId Restricts to incidents that have the given id. (optional)
   * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
   * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (&#x60;string%&#x60;), ends with (&#x60;%string&#x60;) or contains (&#x60;%string%&#x60;). (optional)
   * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
   * @param processDefinitionKeyIn Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list. (optional)
   * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
   * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
   * @param incidentTimestampBefore Restricts to incidents that have an incidentTimestamp date before the given date.  By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param incidentTimestampAfter Restricts to incidents that have an incidentTimestamp date after the given date.  By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
   * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
   * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
   * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
   * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
   * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
   * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
   * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getIncidentsCount(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, OffsetDateTime incidentTimestampBefore, OffsetDateTime incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/incident/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("incidentId", incidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentType", incidentType));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessage", incidentMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionId", executionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentTimestampBefore", incidentTimestampBefore));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentTimestampAfter", incidentTimestampAfter));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityId", activityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("failedActivityId", failedActivityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("causeIncidentId", causeIncidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("rootCauseIncidentId", rootCauseIncidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("configuration", _configuration));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionIdIn", jobDefinitionIdIn));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Resolve Incident
   * Resolves an incident with given id.
   * @param id The id of the incident to be resolved. (required)
   * @throws ApiException if fails to make API call
   */
  public void resolveIncident(String id) throws ApiException {
    this.resolveIncident(id, Collections.emptyMap());
  }


  /**
   * Resolve Incident
   * Resolves an incident with given id.
   * @param id The id of the incident to be resolved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void resolveIncident(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling resolveIncident");
    }
    
    // create path and map variables
    String localVarPath = "/incident/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Set Incident Annotation
   * Sets the annotation of an incident with given id.
   * @param id The id of the incident to clear the annotation at. (required)
   * @param annotationDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void setIncidentAnnotation(String id, AnnotationDto annotationDto) throws ApiException {
    this.setIncidentAnnotation(id, annotationDto, Collections.emptyMap());
  }


  /**
   * Set Incident Annotation
   * Sets the annotation of an incident with given id.
   * @param id The id of the incident to clear the annotation at. (required)
   * @param annotationDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void setIncidentAnnotation(String id, AnnotationDto annotationDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = annotationDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling setIncidentAnnotation");
    }
    
    // create path and map variables
    String localVarPath = "/incident/{id}/annotation"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

}
