/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.JobDto;
import org.camunda.community.rest.client.dto.JobDuedateDto;
import org.camunda.community.rest.client.dto.JobQueryDto;
import org.camunda.community.rest.client.dto.JobRetriesDto;
import org.camunda.community.rest.client.dto.JobSuspensionStateDto;
import org.camunda.community.rest.client.dto.PriorityDto;
import org.camunda.community.rest.client.dto.SetJobRetriesDto;
import org.camunda.community.rest.client.dto.SuspensionStateDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class JobApi {


  private ApiClient apiClient;

  public JobApi() {
    this(Configuration.getDefaultApiClient());
  }

  public JobApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Delete Job
   * Deletes a job by id.
   * @param id The id of the job to be deleted. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteJob(String id) throws ApiException {
    this.deleteJob(id, Collections.emptyMap());
  }


  /**
   * Delete Job
   * Deletes a job by id.
   * @param id The id of the job to be deleted. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteJob(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteJob");
    }
    
    // create path and map variables
    String localVarPath = "/job/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Execute Job
   * Executes a job by id. **Note:** The execution of the job happens synchronously in the same thread.
   * @param id The id of the job to be executed. (required)
   * @throws ApiException if fails to make API call
   */
  public void executeJob(String id) throws ApiException {
    this.executeJob(id, Collections.emptyMap());
  }


  /**
   * Execute Job
   * Executes a job by id. **Note:** The execution of the job happens synchronously in the same thread.
   * @param id The id of the job to be executed. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void executeJob(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling executeJob");
    }
    
    // create path and map variables
    String localVarPath = "/job/{id}/execute"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get Job
   * Retrieves a job by id, according to the &#x60;Job&#x60; interface in the engine.
   * @param id The id of the job to be retrieved. (required)
   * @return JobDto
   * @throws ApiException if fails to make API call
   */
  public JobDto getJob(String id) throws ApiException {
    return this.getJob(id, Collections.emptyMap());
  }


  /**
   * Get Job
   * Retrieves a job by id, according to the &#x60;Job&#x60; interface in the engine.
   * @param id The id of the job to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return JobDto
   * @throws ApiException if fails to make API call
   */
  public JobDto getJob(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getJob");
    }
    
    // create path and map variables
    String localVarPath = "/job/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<JobDto> localVarReturnType = new TypeReference<JobDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Jobs
   * Queries for jobs that fulfill given parameters. The size of the result set can be retrieved by using the [Get Job Count](https://docs.camunda.org/manual/7.21/reference/rest/job/get-query-count/) method.
   * @param jobId Filter by job id. (optional)
   * @param jobIds Filter by a comma-separated list of job ids. (optional)
   * @param jobDefinitionId Only select jobs which exist for the given job definition. (optional)
   * @param processInstanceId Only select jobs which exist for the given process instance. (optional)
   * @param processInstanceIds Only select jobs which exist for the given comma-separated list of process instance ids. (optional)
   * @param executionId Only select jobs which exist for the given execution. (optional)
   * @param processDefinitionId Filter by the id of the process definition the jobs run on. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the jobs run on. (optional)
   * @param activityId Only select jobs which exist for an activity with the given id. (optional)
   * @param withRetriesLeft Only select jobs which have retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param executable Only select jobs which are executable, i.e., retries &gt; 0 and due date is &#x60;null&#x60; or due date is in the past. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param timers Only select jobs that are timers. Cannot be used together with &#x60;messages&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param messages Only select jobs that are messages. Cannot be used together with &#x60;timers&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param dueDates Only select jobs where the due date is lower or higher than the given date. Due date expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param createTimes Only select jobs created before or after the given date.  Create time expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param withException Only select jobs that failed due to an exception. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param exceptionMessage Only select jobs that failed due to an exception with the given message. (optional)
   * @param failedActivityId Only select jobs that failed due to an exception at an activity with the given id. (optional)
   * @param noRetriesLeft Only select jobs which have no retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param active Only include active jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended Only include suspended jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param priorityLowerThanOrEquals Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param priorityHigherThanOrEquals Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param tenantIdIn Only include jobs which belong to one of the passed comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include jobs which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeJobsWithoutTenantId Include jobs which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;JobDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<JobDto> getJobs(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.getJobs(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get Jobs
   * Queries for jobs that fulfill given parameters. The size of the result set can be retrieved by using the [Get Job Count](https://docs.camunda.org/manual/7.21/reference/rest/job/get-query-count/) method.
   * @param jobId Filter by job id. (optional)
   * @param jobIds Filter by a comma-separated list of job ids. (optional)
   * @param jobDefinitionId Only select jobs which exist for the given job definition. (optional)
   * @param processInstanceId Only select jobs which exist for the given process instance. (optional)
   * @param processInstanceIds Only select jobs which exist for the given comma-separated list of process instance ids. (optional)
   * @param executionId Only select jobs which exist for the given execution. (optional)
   * @param processDefinitionId Filter by the id of the process definition the jobs run on. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the jobs run on. (optional)
   * @param activityId Only select jobs which exist for an activity with the given id. (optional)
   * @param withRetriesLeft Only select jobs which have retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param executable Only select jobs which are executable, i.e., retries &gt; 0 and due date is &#x60;null&#x60; or due date is in the past. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param timers Only select jobs that are timers. Cannot be used together with &#x60;messages&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param messages Only select jobs that are messages. Cannot be used together with &#x60;timers&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param dueDates Only select jobs where the due date is lower or higher than the given date. Due date expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param createTimes Only select jobs created before or after the given date.  Create time expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param withException Only select jobs that failed due to an exception. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param exceptionMessage Only select jobs that failed due to an exception with the given message. (optional)
   * @param failedActivityId Only select jobs that failed due to an exception at an activity with the given id. (optional)
   * @param noRetriesLeft Only select jobs which have no retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param active Only include active jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended Only include suspended jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param priorityLowerThanOrEquals Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param priorityHigherThanOrEquals Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param tenantIdIn Only include jobs which belong to one of the passed comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include jobs which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeJobsWithoutTenantId Include jobs which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;JobDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<JobDto> getJobs(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/job";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("jobId", jobId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobIds", jobIds));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceIds", processInstanceIds));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionId", executionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityId", activityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
    localVarQueryParams.addAll(apiClient.parameterToPair("executable", executable));
    localVarQueryParams.addAll(apiClient.parameterToPair("timers", timers));
    localVarQueryParams.addAll(apiClient.parameterToPair("messages", messages));
    localVarQueryParams.addAll(apiClient.parameterToPair("dueDates", dueDates));
    localVarQueryParams.addAll(apiClient.parameterToPair("createTimes", createTimes));
    localVarQueryParams.addAll(apiClient.parameterToPair("withException", withException));
    localVarQueryParams.addAll(apiClient.parameterToPair("exceptionMessage", exceptionMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("failedActivityId", failedActivityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("noRetriesLeft", noRetriesLeft));
    localVarQueryParams.addAll(apiClient.parameterToPair("active", active));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
    localVarQueryParams.addAll(apiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("includeJobsWithoutTenantId", includeJobsWithoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<JobDto>> localVarReturnType = new TypeReference<List<JobDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Job Count
   * Queries for the number of jobs that fulfill given parameters. Takes the same parameters as the [Get Jobs](https://docs.camunda.org/manual/7.21/reference/rest/job/get-query/) method.
   * @param jobId Filter by job id. (optional)
   * @param jobIds Filter by a comma-separated list of job ids. (optional)
   * @param jobDefinitionId Only select jobs which exist for the given job definition. (optional)
   * @param processInstanceId Only select jobs which exist for the given process instance. (optional)
   * @param processInstanceIds Only select jobs which exist for the given comma-separated list of process instance ids. (optional)
   * @param executionId Only select jobs which exist for the given execution. (optional)
   * @param processDefinitionId Filter by the id of the process definition the jobs run on. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the jobs run on. (optional)
   * @param activityId Only select jobs which exist for an activity with the given id. (optional)
   * @param withRetriesLeft Only select jobs which have retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param executable Only select jobs which are executable, i.e., retries &gt; 0 and due date is &#x60;null&#x60; or due date is in the past. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param timers Only select jobs that are timers. Cannot be used together with &#x60;messages&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param messages Only select jobs that are messages. Cannot be used together with &#x60;timers&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param dueDates Only select jobs where the due date is lower or higher than the given date. Due date expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param createTimes Only select jobs created before or after the given date.  Create time expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param withException Only select jobs that failed due to an exception. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param exceptionMessage Only select jobs that failed due to an exception with the given message. (optional)
   * @param failedActivityId Only select jobs that failed due to an exception at an activity with the given id. (optional)
   * @param noRetriesLeft Only select jobs which have no retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param active Only include active jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended Only include suspended jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param priorityLowerThanOrEquals Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param priorityHigherThanOrEquals Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param tenantIdIn Only include jobs which belong to one of the passed comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include jobs which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeJobsWithoutTenantId Include jobs which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getJobsCount(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId) throws ApiException {
    return this.getJobsCount(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, Collections.emptyMap());
  }


  /**
   * Get Job Count
   * Queries for the number of jobs that fulfill given parameters. Takes the same parameters as the [Get Jobs](https://docs.camunda.org/manual/7.21/reference/rest/job/get-query/) method.
   * @param jobId Filter by job id. (optional)
   * @param jobIds Filter by a comma-separated list of job ids. (optional)
   * @param jobDefinitionId Only select jobs which exist for the given job definition. (optional)
   * @param processInstanceId Only select jobs which exist for the given process instance. (optional)
   * @param processInstanceIds Only select jobs which exist for the given comma-separated list of process instance ids. (optional)
   * @param executionId Only select jobs which exist for the given execution. (optional)
   * @param processDefinitionId Filter by the id of the process definition the jobs run on. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the jobs run on. (optional)
   * @param activityId Only select jobs which exist for an activity with the given id. (optional)
   * @param withRetriesLeft Only select jobs which have retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param executable Only select jobs which are executable, i.e., retries &gt; 0 and due date is &#x60;null&#x60; or due date is in the past. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param timers Only select jobs that are timers. Cannot be used together with &#x60;messages&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param messages Only select jobs that are messages. Cannot be used together with &#x60;timers&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param dueDates Only select jobs where the due date is lower or higher than the given date. Due date expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param createTimes Only select jobs created before or after the given date.  Create time expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param withException Only select jobs that failed due to an exception. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param exceptionMessage Only select jobs that failed due to an exception with the given message. (optional)
   * @param failedActivityId Only select jobs that failed due to an exception at an activity with the given id. (optional)
   * @param noRetriesLeft Only select jobs which have no retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param active Only include active jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended Only include suspended jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param priorityLowerThanOrEquals Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param priorityHigherThanOrEquals Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
   * @param tenantIdIn Only include jobs which belong to one of the passed comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include jobs which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeJobsWithoutTenantId Include jobs which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getJobsCount(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/job/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("jobId", jobId));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobIds", jobIds));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceId", processInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceIds", processInstanceIds));
    localVarQueryParams.addAll(apiClient.parameterToPair("executionId", executionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityId", activityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
    localVarQueryParams.addAll(apiClient.parameterToPair("executable", executable));
    localVarQueryParams.addAll(apiClient.parameterToPair("timers", timers));
    localVarQueryParams.addAll(apiClient.parameterToPair("messages", messages));
    localVarQueryParams.addAll(apiClient.parameterToPair("dueDates", dueDates));
    localVarQueryParams.addAll(apiClient.parameterToPair("createTimes", createTimes));
    localVarQueryParams.addAll(apiClient.parameterToPair("withException", withException));
    localVarQueryParams.addAll(apiClient.parameterToPair("exceptionMessage", exceptionMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("failedActivityId", failedActivityId));
    localVarQueryParams.addAll(apiClient.parameterToPair("noRetriesLeft", noRetriesLeft));
    localVarQueryParams.addAll(apiClient.parameterToPair("active", active));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
    localVarQueryParams.addAll(apiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("includeJobsWithoutTenantId", includeJobsWithoutTenantId));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Exception Stacktrace
   * Retrieves the exception stacktrace corresponding to the passed job id.
   * @param id The id of the job to get the exception stacktrace for. (required)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object getStacktrace(String id) throws ApiException {
    return this.getStacktrace(id, Collections.emptyMap());
  }


  /**
   * Get Exception Stacktrace
   * Retrieves the exception stacktrace corresponding to the passed job id.
   * @param id The id of the job to get the exception stacktrace for. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object getStacktrace(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getStacktrace");
    }
    
    // create path and map variables
    String localVarPath = "/job/{id}/stacktrace"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "text/plain", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<Object> localVarReturnType = new TypeReference<Object>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Jobs (POST)
   * Queries for jobs that fulfill given parameters. This method is slightly more powerful than the [Get Jobs](https://docs.camunda.org/manual/7.21/reference/rest/job/get-query/) method because it allows filtering by multiple jobs of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param jobQueryDto  (optional)
   * @return List&lt;JobDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<JobDto> queryJobs(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto) throws ApiException {
    return this.queryJobs(firstResult, maxResults, jobQueryDto, Collections.emptyMap());
  }


  /**
   * Get Jobs (POST)
   * Queries for jobs that fulfill given parameters. This method is slightly more powerful than the [Get Jobs](https://docs.camunda.org/manual/7.21/reference/rest/job/get-query/) method because it allows filtering by multiple jobs of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param jobQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;JobDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<JobDto> queryJobs(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = jobQueryDto;
    
    // create path and map variables
    String localVarPath = "/job";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<JobDto>> localVarReturnType = new TypeReference<List<JobDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Job Count (POST)
   * Queries for jobs that fulfill given parameters. This method takes the same message body as the [Get Jobs POST](https://docs.camunda.org/manual/7.21/reference/rest/job/post- query/) method and therefore it is slightly more powerful than the [Get Job Count](https://docs.camunda.org/manual/7.21/reference/rest/job/get-query-count/) method.
   * @param jobQueryDto  (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryJobsCount(JobQueryDto jobQueryDto) throws ApiException {
    return this.queryJobsCount(jobQueryDto, Collections.emptyMap());
  }


  /**
   * Get Job Count (POST)
   * Queries for jobs that fulfill given parameters. This method takes the same message body as the [Get Jobs POST](https://docs.camunda.org/manual/7.21/reference/rest/job/post- query/) method and therefore it is slightly more powerful than the [Get Job Count](https://docs.camunda.org/manual/7.21/reference/rest/job/get-query-count/) method.
   * @param jobQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryJobsCount(JobQueryDto jobQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = jobQueryDto;
    
    // create path and map variables
    String localVarPath = "/job/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Recalculate Job Due Date
   * Recalculates the due date of a job by id.
   * @param id The id of the job to be updated. (required)
   * @param creationDateBased Recalculate the due date based on the creation date of the job or the current date. Value may only be &#x60;false&#x60;, as &#x60;true&#x60; is the default behavior.  (optional)
   * @throws ApiException if fails to make API call
   */
  public void recalculateDuedate(String id, Boolean creationDateBased) throws ApiException {
    this.recalculateDuedate(id, creationDateBased, Collections.emptyMap());
  }


  /**
   * Recalculate Job Due Date
   * Recalculates the due date of a job by id.
   * @param id The id of the job to be updated. (required)
   * @param creationDateBased Recalculate the due date based on the creation date of the job or the current date. Value may only be &#x60;false&#x60;, as &#x60;true&#x60; is the default behavior.  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void recalculateDuedate(String id, Boolean creationDateBased, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling recalculateDuedate");
    }
    
    // create path and map variables
    String localVarPath = "/job/{id}/duedate/recalculate"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("creationDateBased", creationDateBased));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Set Job Due Date
   * Updates the due date of a job by id.
   * @param id The id of the job to be updated. (required)
   * @param jobDuedateDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void setJobDuedate(String id, JobDuedateDto jobDuedateDto) throws ApiException {
    this.setJobDuedate(id, jobDuedateDto, Collections.emptyMap());
  }


  /**
   * Set Job Due Date
   * Updates the due date of a job by id.
   * @param id The id of the job to be updated. (required)
   * @param jobDuedateDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void setJobDuedate(String id, JobDuedateDto jobDuedateDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = jobDuedateDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling setJobDuedate");
    }
    
    // create path and map variables
    String localVarPath = "/job/{id}/duedate"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Set Job Priority
   * Sets the execution priority of a job by id.
   * @param id The id of the job to be updated. (required)
   * @param priorityDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void setJobPriority(String id, PriorityDto priorityDto) throws ApiException {
    this.setJobPriority(id, priorityDto, Collections.emptyMap());
  }


  /**
   * Set Job Priority
   * Sets the execution priority of a job by id.
   * @param id The id of the job to be updated. (required)
   * @param priorityDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void setJobPriority(String id, PriorityDto priorityDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = priorityDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling setJobPriority");
    }
    
    // create path and map variables
    String localVarPath = "/job/{id}/priority"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Set Job Retries
   * Sets the retries of the job to the given number of retries by id.
   * @param id The id of the job to be updated. (required)
   * @param jobRetriesDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void setJobRetries(String id, JobRetriesDto jobRetriesDto) throws ApiException {
    this.setJobRetries(id, jobRetriesDto, Collections.emptyMap());
  }


  /**
   * Set Job Retries
   * Sets the retries of the job to the given number of retries by id.
   * @param id The id of the job to be updated. (required)
   * @param jobRetriesDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void setJobRetries(String id, JobRetriesDto jobRetriesDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = jobRetriesDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling setJobRetries");
    }
    
    // create path and map variables
    String localVarPath = "/job/{id}/retries"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Set Job Retries Async (POST)
   * Create a batch to set retries of jobs asynchronously.
   * @param setJobRetriesDto  (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto setJobRetriesAsyncOperation(SetJobRetriesDto setJobRetriesDto) throws ApiException {
    return this.setJobRetriesAsyncOperation(setJobRetriesDto, Collections.emptyMap());
  }


  /**
   * Set Job Retries Async (POST)
   * Create a batch to set retries of jobs asynchronously.
   * @param setJobRetriesDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto setJobRetriesAsyncOperation(SetJobRetriesDto setJobRetriesDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = setJobRetriesDto;
    
    // create path and map variables
    String localVarPath = "/job/retries";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Activate/Suspend Job By Id
   * Activates or suspends a given job by id.
   * @param id The id of the job to activate or suspend. (required)
   * @param suspensionStateDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateJobSuspensionState(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
    this.updateJobSuspensionState(id, suspensionStateDto, Collections.emptyMap());
  }


  /**
   * Activate/Suspend Job By Id
   * Activates or suspends a given job by id.
   * @param id The id of the job to activate or suspend. (required)
   * @param suspensionStateDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateJobSuspensionState(String id, SuspensionStateDto suspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = suspensionStateDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling updateJobSuspensionState");
    }
    
    // create path and map variables
    String localVarPath = "/job/{id}/suspended"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Activate/Suspend Jobs
   * Activates or suspends jobs matching the given criterion. This can only be on of: * &#x60;jobDefinitionId&#x60; * &#x60;processDefinitionId&#x60; * &#x60;processInstanceId&#x60; * &#x60;processDefinitionKey&#x60;
   * @param jobSuspensionStateDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateSuspensionStateBy(JobSuspensionStateDto jobSuspensionStateDto) throws ApiException {
    this.updateSuspensionStateBy(jobSuspensionStateDto, Collections.emptyMap());
  }


  /**
   * Activate/Suspend Jobs
   * Activates or suspends jobs matching the given criterion. This can only be on of: * &#x60;jobDefinitionId&#x60; * &#x60;processDefinitionId&#x60; * &#x60;processInstanceId&#x60; * &#x60;processDefinitionKey&#x60;
   * @param jobSuspensionStateDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateSuspensionStateBy(JobSuspensionStateDto jobSuspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = jobSuspensionStateDto;
    
    // create path and map variables
    String localVarPath = "/job/suspended";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

}
