/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.JobDefinitionDto;
import org.camunda.community.rest.client.dto.JobDefinitionPriorityDto;
import org.camunda.community.rest.client.dto.JobDefinitionQueryDto;
import org.camunda.community.rest.client.dto.JobDefinitionSuspensionStateDto;
import org.camunda.community.rest.client.dto.JobDefinitionsSuspensionStateDto;
import org.camunda.community.rest.client.dto.RetriesDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class JobDefinitionApi {


  private ApiClient apiClient;

  public JobDefinitionApi() {
    this(Configuration.getDefaultApiClient());
  }

  public JobDefinitionApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get Job Definition
   * Retrieves a job definition by id, according to the &#x60;JobDefinition&#x60; interface in the engine.
   * @param id The id of the job definition to be retrieved. (required)
   * @return JobDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public JobDefinitionDto getJobDefinition(String id) throws ApiException {
    return this.getJobDefinition(id, Collections.emptyMap());
  }


  /**
   * Get Job Definition
   * Retrieves a job definition by id, according to the &#x60;JobDefinition&#x60; interface in the engine.
   * @param id The id of the job definition to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return JobDefinitionDto
   * @throws ApiException if fails to make API call
   */
  public JobDefinitionDto getJobDefinition(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getJobDefinition");
    }
    
    // create path and map variables
    String localVarPath = "/job-definition/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<JobDefinitionDto> localVarReturnType = new TypeReference<JobDefinitionDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Job Definitions
   * Queries for job definitions that fulfill given parameters. The size of the result set can be retrieved by using the [Get Job Definition Count](https://docs.camunda.org/manual/7.21/reference/rest/job-definition/get-query-count/) method.
   * @param jobDefinitionId Filter by job definition id. (optional)
   * @param activityIdIn Only include job definitions which belong to one of the passed and comma-separated activity ids. (optional)
   * @param processDefinitionId Only include job definitions which exist for the given process definition id. (optional)
   * @param processDefinitionKey Only include job definitions which exist for the given process definition key. (optional)
   * @param jobType Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types. (optional)
   * @param jobConfiguration Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration. (optional)
   * @param active Only include active job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended Only include suspended job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withOverridingJobPriority Only include job definitions that have an overriding job priority defined. The only effective value is &#x60;true&#x60;. If set to &#x60;false&#x60;, this filter is not applied. (optional)
   * @param tenantIdIn Only include job definitions which belong to one of the passed and comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include job definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeJobDefinitionsWithoutTenantId Include job definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;JobDefinitionDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<JobDefinitionDto> getJobDefinitions(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.getJobDefinitions(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get Job Definitions
   * Queries for job definitions that fulfill given parameters. The size of the result set can be retrieved by using the [Get Job Definition Count](https://docs.camunda.org/manual/7.21/reference/rest/job-definition/get-query-count/) method.
   * @param jobDefinitionId Filter by job definition id. (optional)
   * @param activityIdIn Only include job definitions which belong to one of the passed and comma-separated activity ids. (optional)
   * @param processDefinitionId Only include job definitions which exist for the given process definition id. (optional)
   * @param processDefinitionKey Only include job definitions which exist for the given process definition key. (optional)
   * @param jobType Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types. (optional)
   * @param jobConfiguration Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration. (optional)
   * @param active Only include active job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended Only include suspended job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withOverridingJobPriority Only include job definitions that have an overriding job priority defined. The only effective value is &#x60;true&#x60;. If set to &#x60;false&#x60;, this filter is not applied. (optional)
   * @param tenantIdIn Only include job definitions which belong to one of the passed and comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include job definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeJobDefinitionsWithoutTenantId Include job definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;JobDefinitionDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<JobDefinitionDto> getJobDefinitions(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/job-definition";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityIdIn", activityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobType", jobType));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobConfiguration", jobConfiguration));
    localVarQueryParams.addAll(apiClient.parameterToPair("active", active));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("withOverridingJobPriority", withOverridingJobPriority));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("includeJobDefinitionsWithoutTenantId", includeJobDefinitionsWithoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<JobDefinitionDto>> localVarReturnType = new TypeReference<List<JobDefinitionDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Job Definition Count
   * Queries for the number of job definitions that fulfill given parameters. Takes the same parameters as the [Get Job Definitions](https://docs.camunda.org/manual/7.21/reference/rest/job-definition/get-query/) method.
   * @param jobDefinitionId Filter by job definition id. (optional)
   * @param activityIdIn Only include job definitions which belong to one of the passed and comma-separated activity ids. (optional)
   * @param processDefinitionId Only include job definitions which exist for the given process definition id. (optional)
   * @param processDefinitionKey Only include job definitions which exist for the given process definition key. (optional)
   * @param jobType Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types. (optional)
   * @param jobConfiguration Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration. (optional)
   * @param active Only include active job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended Only include suspended job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withOverridingJobPriority Only include job definitions that have an overriding job priority defined. The only effective value is &#x60;true&#x60;. If set to &#x60;false&#x60;, this filter is not applied. (optional)
   * @param tenantIdIn Only include job definitions which belong to one of the passed and comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include job definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeJobDefinitionsWithoutTenantId Include job definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getJobDefinitionsCount(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId) throws ApiException {
    return this.getJobDefinitionsCount(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, Collections.emptyMap());
  }


  /**
   * Get Job Definition Count
   * Queries for the number of job definitions that fulfill given parameters. Takes the same parameters as the [Get Job Definitions](https://docs.camunda.org/manual/7.21/reference/rest/job-definition/get-query/) method.
   * @param jobDefinitionId Filter by job definition id. (optional)
   * @param activityIdIn Only include job definitions which belong to one of the passed and comma-separated activity ids. (optional)
   * @param processDefinitionId Only include job definitions which exist for the given process definition id. (optional)
   * @param processDefinitionKey Only include job definitions which exist for the given process definition key. (optional)
   * @param jobType Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types. (optional)
   * @param jobConfiguration Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration. (optional)
   * @param active Only include active job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param suspended Only include suspended job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param withOverridingJobPriority Only include job definitions that have an overriding job priority defined. The only effective value is &#x60;true&#x60;. If set to &#x60;false&#x60;, this filter is not applied. (optional)
   * @param tenantIdIn Only include job definitions which belong to one of the passed and comma-separated tenant ids. (optional)
   * @param withoutTenantId Only include job definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param includeJobDefinitionsWithoutTenantId Include job definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getJobDefinitionsCount(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/job-definition/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityIdIn", activityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobType", jobType));
    localVarQueryParams.addAll(apiClient.parameterToPair("jobConfiguration", jobConfiguration));
    localVarQueryParams.addAll(apiClient.parameterToPair("active", active));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("withOverridingJobPriority", withOverridingJobPriority));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("includeJobDefinitionsWithoutTenantId", includeJobDefinitionsWithoutTenantId));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Job Definitions (POST)
   * Queries for job definitions that fulfill given parameters. This method is slightly more powerful than the [Get Job Definitions](https://docs.camunda.org/manual/7.21/reference/rest/job-definition/get-query/) method because it allows filtering by multiple job definitions of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param jobDefinitionQueryDto  (optional)
   * @return List&lt;JobDefinitionDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<JobDefinitionDto> queryJobDefinitions(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto) throws ApiException {
    return this.queryJobDefinitions(firstResult, maxResults, jobDefinitionQueryDto, Collections.emptyMap());
  }


  /**
   * Get Job Definitions (POST)
   * Queries for job definitions that fulfill given parameters. This method is slightly more powerful than the [Get Job Definitions](https://docs.camunda.org/manual/7.21/reference/rest/job-definition/get-query/) method because it allows filtering by multiple job definitions of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param jobDefinitionQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;JobDefinitionDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<JobDefinitionDto> queryJobDefinitions(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = jobDefinitionQueryDto;
    
    // create path and map variables
    String localVarPath = "/job-definition";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<JobDefinitionDto>> localVarReturnType = new TypeReference<List<JobDefinitionDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Job Definition Count (POST)
   * Queries for the number of job definitions that fulfill given parameters. This method takes the same message body as the [Get Job Definitions (POST)](https://docs.camunda.org/manual/7.21/reference/rest/job-definition/post-query/) method and therefore it is slightly more powerful than the [Get Job Definition Count](https://docs.camunda.org/manual/7.21/reference/rest/job-definition/get-query-count/) method.
   * @param jobDefinitionQueryDto  (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryJobDefinitionsCount(JobDefinitionQueryDto jobDefinitionQueryDto) throws ApiException {
    return this.queryJobDefinitionsCount(jobDefinitionQueryDto, Collections.emptyMap());
  }


  /**
   * Get Job Definition Count (POST)
   * Queries for the number of job definitions that fulfill given parameters. This method takes the same message body as the [Get Job Definitions (POST)](https://docs.camunda.org/manual/7.21/reference/rest/job-definition/post-query/) method and therefore it is slightly more powerful than the [Get Job Definition Count](https://docs.camunda.org/manual/7.21/reference/rest/job-definition/get-query-count/) method.
   * @param jobDefinitionQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryJobDefinitionsCount(JobDefinitionQueryDto jobDefinitionQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = jobDefinitionQueryDto;
    
    // create path and map variables
    String localVarPath = "/job-definition/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Set Job Definition Priority by Id
   * Sets an overriding execution priority for jobs with the given definition id. Optionally, the priorities of all the definitions&#39; existing jobs are updated accordingly. The priority can be reset by setting it to &#x60;null&#x60;, meaning that a new job&#39;s priority will not be determined based on its definition&#39;s priority any longer. See the [user guide on job prioritization](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#set-job-definition-priorities-via-managementservice-api) for details.
   * @param id The id of the job definition to be updated. (required)
   * @param jobDefinitionPriorityDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void setJobPriorityJobDefinition(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto) throws ApiException {
    this.setJobPriorityJobDefinition(id, jobDefinitionPriorityDto, Collections.emptyMap());
  }


  /**
   * Set Job Definition Priority by Id
   * Sets an overriding execution priority for jobs with the given definition id. Optionally, the priorities of all the definitions&#39; existing jobs are updated accordingly. The priority can be reset by setting it to &#x60;null&#x60;, meaning that a new job&#39;s priority will not be determined based on its definition&#39;s priority any longer. See the [user guide on job prioritization](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#set-job-definition-priorities-via-managementservice-api) for details.
   * @param id The id of the job definition to be updated. (required)
   * @param jobDefinitionPriorityDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void setJobPriorityJobDefinition(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = jobDefinitionPriorityDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling setJobPriorityJobDefinition");
    }
    
    // create path and map variables
    String localVarPath = "/job-definition/{id}/jobPriority"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Set Job Retries By Job Definition Id
   * Sets the number of retries of all **failed** jobs associated with the given job definition id.
   * @param id The id of the job definition to be updated. (required)
   * @param retriesDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void setJobRetriesJobDefinition(String id, RetriesDto retriesDto) throws ApiException {
    this.setJobRetriesJobDefinition(id, retriesDto, Collections.emptyMap());
  }


  /**
   * Set Job Retries By Job Definition Id
   * Sets the number of retries of all **failed** jobs associated with the given job definition id.
   * @param id The id of the job definition to be updated. (required)
   * @param retriesDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void setJobRetriesJobDefinition(String id, RetriesDto retriesDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = retriesDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling setJobRetriesJobDefinition");
    }
    
    // create path and map variables
    String localVarPath = "/job-definition/{id}/retries"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Activate/Suspend Job Definition By Id
   * Activates or suspends a given job definition by id.
   * @param id The id of the job definition to activate or suspend. (required)
   * @param jobDefinitionSuspensionStateDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateSuspensionStateJobDefinition(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto) throws ApiException {
    this.updateSuspensionStateJobDefinition(id, jobDefinitionSuspensionStateDto, Collections.emptyMap());
  }


  /**
   * Activate/Suspend Job Definition By Id
   * Activates or suspends a given job definition by id.
   * @param id The id of the job definition to activate or suspend. (required)
   * @param jobDefinitionSuspensionStateDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateSuspensionStateJobDefinition(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = jobDefinitionSuspensionStateDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling updateSuspensionStateJobDefinition");
    }
    
    // create path and map variables
    String localVarPath = "/job-definition/{id}/suspended"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Activate/Suspend Job Definitions
   * Activates or suspends job definitions with the given process definition id or process definition key.
   * @param jobDefinitionsSuspensionStateDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateSuspensionStateJobDefinitions(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto) throws ApiException {
    this.updateSuspensionStateJobDefinitions(jobDefinitionsSuspensionStateDto, Collections.emptyMap());
  }


  /**
   * Activate/Suspend Job Definitions
   * Activates or suspends job definitions with the given process definition id or process definition key.
   * @param jobDefinitionsSuspensionStateDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateSuspensionStateJobDefinitions(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = jobDefinitionsSuspensionStateDto;
    
    // create path and map variables
    String localVarPath = "/job-definition/suspended";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

}
