/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.MetricsIntervalResultDto;
import org.camunda.community.rest.client.dto.MetricsResultDto;
import java.time.OffsetDateTime;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class MetricsApi {


  private ApiClient apiClient;

  public MetricsApi() {
    this(Configuration.getDefaultApiClient());
  }

  public MetricsApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Delete Task Worker Metrics
   * Deletes all task worker metrics prior to the given date or all if no date is provided.
   * @param date The date prior to which all task worker metrics should be deleted. (optional)
   * @throws ApiException if fails to make API call
   */
  public void deleteTaskMetrics(OffsetDateTime date) throws ApiException {
    this.deleteTaskMetrics(date, Collections.emptyMap());
  }


  /**
   * Delete Task Worker Metrics
   * Deletes all task worker metrics prior to the given date or all if no date is provided.
   * @param date The date prior to which all task worker metrics should be deleted. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteTaskMetrics(OffsetDateTime date, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/metrics/task-worker";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("date", date));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get Sum
   * Retrieves the &#x60;sum&#x60; (count) for a given metric.
   * @param metricsName The name of the metric. (required)
   * @param startDate The start date (inclusive). (optional)
   * @param endDate The end date (exclusive). (optional)
   * @return MetricsResultDto
   * @throws ApiException if fails to make API call
   */
  public MetricsResultDto getMetrics(String metricsName, OffsetDateTime startDate, OffsetDateTime endDate) throws ApiException {
    return this.getMetrics(metricsName, startDate, endDate, Collections.emptyMap());
  }


  /**
   * Get Sum
   * Retrieves the &#x60;sum&#x60; (count) for a given metric.
   * @param metricsName The name of the metric. (required)
   * @param startDate The start date (inclusive). (optional)
   * @param endDate The end date (exclusive). (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return MetricsResultDto
   * @throws ApiException if fails to make API call
   */
  public MetricsResultDto getMetrics(String metricsName, OffsetDateTime startDate, OffsetDateTime endDate, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'metricsName' is set
    if (metricsName == null) {
      throw new ApiException(400, "Missing the required parameter 'metricsName' when calling getMetrics");
    }
    
    // create path and map variables
    String localVarPath = "/metrics/{metrics-name}/sum"
      .replaceAll("\\{" + "metrics-name" + "\\}", apiClient.escapeString(metricsName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<MetricsResultDto> localVarReturnType = new TypeReference<MetricsResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Metrics in Interval
   * Retrieves a list of metrics, aggregated for a given interval.
   * @param name The name of the metric. (optional)
   * @param reporter The name of the reporter (host), on which the metrics was logged. This will have value provided by the [hostname configuration property](https://docs.camunda.org/manual/7.21/reference/deployment-descriptors/tags/process-engine/#hostname). (optional)
   * @param startDate The start date (inclusive). (optional)
   * @param endDate The end date (exclusive). (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param interval The interval for which the metrics should be aggregated. Time unit is seconds. Default: The interval is set to 15 minutes (900 seconds). (optional, default to 900)
   * @param aggregateByReporter Aggregate metrics by reporter. (optional)
   * @return List&lt;MetricsIntervalResultDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<MetricsIntervalResultDto> interval(String name, String reporter, OffsetDateTime startDate, OffsetDateTime endDate, Integer firstResult, Integer maxResults, String interval, String aggregateByReporter) throws ApiException {
    return this.interval(name, reporter, startDate, endDate, firstResult, maxResults, interval, aggregateByReporter, Collections.emptyMap());
  }


  /**
   * Get Metrics in Interval
   * Retrieves a list of metrics, aggregated for a given interval.
   * @param name The name of the metric. (optional)
   * @param reporter The name of the reporter (host), on which the metrics was logged. This will have value provided by the [hostname configuration property](https://docs.camunda.org/manual/7.21/reference/deployment-descriptors/tags/process-engine/#hostname). (optional)
   * @param startDate The start date (inclusive). (optional)
   * @param endDate The end date (exclusive). (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param interval The interval for which the metrics should be aggregated. Time unit is seconds. Default: The interval is set to 15 minutes (900 seconds). (optional, default to 900)
   * @param aggregateByReporter Aggregate metrics by reporter. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;MetricsIntervalResultDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<MetricsIntervalResultDto> interval(String name, String reporter, OffsetDateTime startDate, OffsetDateTime endDate, Integer firstResult, Integer maxResults, String interval, String aggregateByReporter, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/metrics";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
    localVarQueryParams.addAll(apiClient.parameterToPair("reporter", reporter));
    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    localVarQueryParams.addAll(apiClient.parameterToPair("interval", interval));
    localVarQueryParams.addAll(apiClient.parameterToPair("aggregateByReporter", aggregateByReporter));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<MetricsIntervalResultDto>> localVarReturnType = new TypeReference<List<MetricsIntervalResultDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
