/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.MigrationExecutionDto;
import org.camunda.community.rest.client.dto.MigrationPlanDto;
import org.camunda.community.rest.client.dto.MigrationPlanGenerationDto;
import org.camunda.community.rest.client.dto.MigrationPlanReportDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class MigrationApi {


  private ApiClient apiClient;

  public MigrationApi() {
    this(Configuration.getDefaultApiClient());
  }

  public MigrationApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Execute Migration Plan
   * Executes a migration plan synchronously for multiple process instances. To execute a migration plan asynchronously, use the [Execute Migration Plan Async(Batch)](https://docs.camunda.org/manual/7.21/reference/rest/migration/execute-migration-async/) method.  For more information about the difference between synchronous and asynchronous execution of a migration plan, please refer to the related section of [the user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/process-instance-migration/#executing-a-migration-plan).
   * @param migrationExecutionDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void executeMigrationPlan(MigrationExecutionDto migrationExecutionDto) throws ApiException {
    this.executeMigrationPlan(migrationExecutionDto, Collections.emptyMap());
  }


  /**
   * Execute Migration Plan
   * Executes a migration plan synchronously for multiple process instances. To execute a migration plan asynchronously, use the [Execute Migration Plan Async(Batch)](https://docs.camunda.org/manual/7.21/reference/rest/migration/execute-migration-async/) method.  For more information about the difference between synchronous and asynchronous execution of a migration plan, please refer to the related section of [the user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/process-instance-migration/#executing-a-migration-plan).
   * @param migrationExecutionDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void executeMigrationPlan(MigrationExecutionDto migrationExecutionDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = migrationExecutionDto;
    
    // create path and map variables
    String localVarPath = "/migration/execute";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Execute Migration Plan Async (Batch)
   * Executes a migration plan asynchronously (batch) for multiple process instances. To execute a migration plan synchronously, use the [Execute MigrationPlan](https://docs.camunda.org/manual/7.21/reference/rest/migration/execute-migration/) method.  For more information about the difference between synchronous and asynchronous execution of a migration plan, please refer to the related section of [the user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/process-instance-migration/#executing-a-migration-plan).
   * @param migrationExecutionDto  (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto executeMigrationPlanAsync(MigrationExecutionDto migrationExecutionDto) throws ApiException {
    return this.executeMigrationPlanAsync(migrationExecutionDto, Collections.emptyMap());
  }


  /**
   * Execute Migration Plan Async (Batch)
   * Executes a migration plan asynchronously (batch) for multiple process instances. To execute a migration plan synchronously, use the [Execute MigrationPlan](https://docs.camunda.org/manual/7.21/reference/rest/migration/execute-migration/) method.  For more information about the difference between synchronous and asynchronous execution of a migration plan, please refer to the related section of [the user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/process-instance-migration/#executing-a-migration-plan).
   * @param migrationExecutionDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto executeMigrationPlanAsync(MigrationExecutionDto migrationExecutionDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = migrationExecutionDto;
    
    // create path and map variables
    String localVarPath = "/migration/executeAsync";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Generate Migration Plan
   * Generates a migration plan for two process definitions. The generated migration plan contains migration instructions which map equal activities between the two process definitions.
   * @param migrationPlanGenerationDto  (optional)
   * @return MigrationPlanDto
   * @throws ApiException if fails to make API call
   */
  public MigrationPlanDto generateMigrationPlan(MigrationPlanGenerationDto migrationPlanGenerationDto) throws ApiException {
    return this.generateMigrationPlan(migrationPlanGenerationDto, Collections.emptyMap());
  }


  /**
   * Generate Migration Plan
   * Generates a migration plan for two process definitions. The generated migration plan contains migration instructions which map equal activities between the two process definitions.
   * @param migrationPlanGenerationDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return MigrationPlanDto
   * @throws ApiException if fails to make API call
   */
  public MigrationPlanDto generateMigrationPlan(MigrationPlanGenerationDto migrationPlanGenerationDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = migrationPlanGenerationDto;
    
    // create path and map variables
    String localVarPath = "/migration/generate";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<MigrationPlanDto> localVarReturnType = new TypeReference<MigrationPlanDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Validate Migration Plan
   * Validates a migration plan statically without executing it. This corresponds to the [creation time validation](https://docs.camunda.org/manual/7.21/user-guide/process-engine/process-instance-migration/#creation-time-validation) described in the user guide.
   * @param migrationPlanDto  (optional)
   * @return MigrationPlanReportDto
   * @throws ApiException if fails to make API call
   */
  public MigrationPlanReportDto validateMigrationPlan(MigrationPlanDto migrationPlanDto) throws ApiException {
    return this.validateMigrationPlan(migrationPlanDto, Collections.emptyMap());
  }


  /**
   * Validate Migration Plan
   * Validates a migration plan statically without executing it. This corresponds to the [creation time validation](https://docs.camunda.org/manual/7.21/user-guide/process-engine/process-instance-migration/#creation-time-validation) described in the user guide.
   * @param migrationPlanDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return MigrationPlanReportDto
   * @throws ApiException if fails to make API call
   */
  public MigrationPlanReportDto validateMigrationPlan(MigrationPlanDto migrationPlanDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = migrationPlanDto;
    
    // create path and map variables
    String localVarPath = "/migration/validate";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<MigrationPlanReportDto> localVarReturnType = new TypeReference<MigrationPlanReportDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
