/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.ActivityInstanceDto;
import org.camunda.community.rest.client.dto.AuthorizationExceptionDto;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CommentDto;
import org.camunda.community.rest.client.dto.CorrelationMessageAsyncDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.DeleteProcessInstancesDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import java.io.File;
import org.camunda.community.rest.client.dto.PatchVariablesDto;
import org.camunda.community.rest.client.dto.ProcessInstanceDto;
import org.camunda.community.rest.client.dto.ProcessInstanceModificationDto;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.ProcessInstanceSuspensionStateAsyncDto;
import org.camunda.community.rest.client.dto.ProcessInstanceSuspensionStateDto;
import org.camunda.community.rest.client.dto.SetJobRetriesByProcessDto;
import org.camunda.community.rest.client.dto.SetVariablesAsyncDto;
import org.camunda.community.rest.client.dto.SuspensionStateDto;
import org.camunda.community.rest.client.dto.VariableValueDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class ProcessInstanceApi {


  private ApiClient apiClient;

  public ProcessInstanceApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ProcessInstanceApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Correlate Message Async (POST)
   * Correlates a message asynchronously to executions that are waiting for this message.  Messages will not be correlated to process definition-level start message events to start process instances.
   * @param correlationMessageAsyncDto  (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto correlateMessageAsyncOperation(CorrelationMessageAsyncDto correlationMessageAsyncDto) throws ApiException {
    return this.correlateMessageAsyncOperation(correlationMessageAsyncDto, Collections.emptyMap());
  }


  /**
   * Correlate Message Async (POST)
   * Correlates a message asynchronously to executions that are waiting for this message.  Messages will not be correlated to process definition-level start message events to start process instances.
   * @param correlationMessageAsyncDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto correlateMessageAsyncOperation(CorrelationMessageAsyncDto correlationMessageAsyncDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = correlationMessageAsyncDto;
    
    // create path and map variables
    String localVarPath = "/process-instance/message-async";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete Async Historic Query Based (POST)
   * Deletes a set of process instances asynchronously (batch) based on a historic process instance query.
   * @param deleteProcessInstancesDto **Unallowed property**: &#x60;processInstanceQuery&#x60; (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto deleteAsyncHistoricQueryBased(DeleteProcessInstancesDto deleteProcessInstancesDto) throws ApiException {
    return this.deleteAsyncHistoricQueryBased(deleteProcessInstancesDto, Collections.emptyMap());
  }


  /**
   * Delete Async Historic Query Based (POST)
   * Deletes a set of process instances asynchronously (batch) based on a historic process instance query.
   * @param deleteProcessInstancesDto **Unallowed property**: &#x60;processInstanceQuery&#x60; (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto deleteAsyncHistoricQueryBased(DeleteProcessInstancesDto deleteProcessInstancesDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = deleteProcessInstancesDto;
    
    // create path and map variables
    String localVarPath = "/process-instance/delete-historic-query-based";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete
   * Deletes a running process instance by id.
   * @param id The id of the process instance to be deleted. (required)
   * @param skipCustomListeners If set to true, the custom listeners will be skipped. (optional, default to false)
   * @param skipIoMappings If set to true, the input/output mappings will be skipped. (optional, default to false)
   * @param skipSubprocesses If set to true, subprocesses related to deleted processes will be skipped. (optional, default to false)
   * @param failIfNotExists If set to false, the request will still be successful if the process id is not found. (optional, default to true)
   * @throws ApiException if fails to make API call
   */
  public void deleteProcessInstance(String id, Boolean skipCustomListeners, Boolean skipIoMappings, Boolean skipSubprocesses, Boolean failIfNotExists) throws ApiException {
    this.deleteProcessInstance(id, skipCustomListeners, skipIoMappings, skipSubprocesses, failIfNotExists, Collections.emptyMap());
  }


  /**
   * Delete
   * Deletes a running process instance by id.
   * @param id The id of the process instance to be deleted. (required)
   * @param skipCustomListeners If set to true, the custom listeners will be skipped. (optional, default to false)
   * @param skipIoMappings If set to true, the input/output mappings will be skipped. (optional, default to false)
   * @param skipSubprocesses If set to true, subprocesses related to deleted processes will be skipped. (optional, default to false)
   * @param failIfNotExists If set to false, the request will still be successful if the process id is not found. (optional, default to true)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteProcessInstance(String id, Boolean skipCustomListeners, Boolean skipIoMappings, Boolean skipSubprocesses, Boolean failIfNotExists, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteProcessInstance");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
    localVarQueryParams.addAll(apiClient.parameterToPair("skipIoMappings", skipIoMappings));
    localVarQueryParams.addAll(apiClient.parameterToPair("skipSubprocesses", skipSubprocesses));
    localVarQueryParams.addAll(apiClient.parameterToPair("failIfNotExists", failIfNotExists));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete Process Variable
   * Deletes a variable of a process instance by id.
   * @param id The id of the process instance to delete the variable from. (required)
   * @param varName The name of the variable to delete. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteProcessInstanceVariable(String id, String varName) throws ApiException {
    this.deleteProcessInstanceVariable(id, varName, Collections.emptyMap());
  }


  /**
   * Delete Process Variable
   * Deletes a variable of a process instance by id.
   * @param id The id of the process instance to delete the variable from. (required)
   * @param varName The name of the variable to delete. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteProcessInstanceVariable(String id, String varName, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteProcessInstanceVariable");
    }
    
    // verify the required parameter 'varName' is set
    if (varName == null) {
      throw new ApiException(400, "Missing the required parameter 'varName' when calling deleteProcessInstanceVariable");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}/variables/{varName}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
      .replaceAll("\\{" + "varName" + "\\}", apiClient.escapeString(varName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete Async (POST)
   * Deletes multiple process instances asynchronously (batch).
   * @param deleteProcessInstancesDto **Unallowed property**: &#x60;historicProcessInstanceQuery&#x60; (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto deleteProcessInstancesAsyncOperation(DeleteProcessInstancesDto deleteProcessInstancesDto) throws ApiException {
    return this.deleteProcessInstancesAsyncOperation(deleteProcessInstancesDto, Collections.emptyMap());
  }


  /**
   * Delete Async (POST)
   * Deletes multiple process instances asynchronously (batch).
   * @param deleteProcessInstancesDto **Unallowed property**: &#x60;historicProcessInstanceQuery&#x60; (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto deleteProcessInstancesAsyncOperation(DeleteProcessInstancesDto deleteProcessInstancesDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = deleteProcessInstancesDto;
    
    // create path and map variables
    String localVarPath = "/process-instance/delete";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Activity Instance
   * Retrieves an Activity Instance (Tree) for a given process instance by id.
   * @param id The id of the process instance for which the activity instance should be retrieved. (required)
   * @return ActivityInstanceDto
   * @throws ApiException if fails to make API call
   */
  public ActivityInstanceDto getActivityInstanceTree(String id) throws ApiException {
    return this.getActivityInstanceTree(id, Collections.emptyMap());
  }


  /**
   * Get Activity Instance
   * Retrieves an Activity Instance (Tree) for a given process instance by id.
   * @param id The id of the process instance for which the activity instance should be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return ActivityInstanceDto
   * @throws ApiException if fails to make API call
   */
  public ActivityInstanceDto getActivityInstanceTree(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getActivityInstanceTree");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}/activity-instances"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<ActivityInstanceDto> localVarReturnType = new TypeReference<ActivityInstanceDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Process Instance
   * Retrieves a process instance by id, according to the &#x60;ProcessInstance&#x60; interface in the engine.
   * @param id The id of the process instance to be retrieved. (required)
   * @return ProcessInstanceDto
   * @throws ApiException if fails to make API call
   */
  public ProcessInstanceDto getProcessInstance(String id) throws ApiException {
    return this.getProcessInstance(id, Collections.emptyMap());
  }


  /**
   * Get Process Instance
   * Retrieves a process instance by id, according to the &#x60;ProcessInstance&#x60; interface in the engine.
   * @param id The id of the process instance to be retrieved. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return ProcessInstanceDto
   * @throws ApiException if fails to make API call
   */
  public ProcessInstanceDto getProcessInstance(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getProcessInstance");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<ProcessInstanceDto> localVarReturnType = new TypeReference<ProcessInstanceDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Process Instance Comments
   * Gets the comments for a process instance by id.
   * @param id The id of the process instance to retrieve the comments for. (required)
   * @return List&lt;CommentDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<CommentDto> getProcessInstanceComments(String id) throws ApiException {
    return this.getProcessInstanceComments(id, Collections.emptyMap());
  }


  /**
   * Get Process Instance Comments
   * Gets the comments for a process instance by id.
   * @param id The id of the process instance to retrieve the comments for. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;CommentDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<CommentDto> getProcessInstanceComments(String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getProcessInstanceComments");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}/comment"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<CommentDto>> localVarReturnType = new TypeReference<List<CommentDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Process Variable
   * Retrieves a variable of a given process instance by id.
   * @param id The id of the process instance to retrieve the variable for. (required)
   * @param varName The name of the variable to retrieve. (required)
   * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
   * @return VariableValueDto
   * @throws ApiException if fails to make API call
   */
  public VariableValueDto getProcessInstanceVariable(String id, String varName, Boolean deserializeValue) throws ApiException {
    return this.getProcessInstanceVariable(id, varName, deserializeValue, Collections.emptyMap());
  }


  /**
   * Get Process Variable
   * Retrieves a variable of a given process instance by id.
   * @param id The id of the process instance to retrieve the variable for. (required)
   * @param varName The name of the variable to retrieve. (required)
   * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
   * @param additionalHeaders additionalHeaders for this call
   * @return VariableValueDto
   * @throws ApiException if fails to make API call
   */
  public VariableValueDto getProcessInstanceVariable(String id, String varName, Boolean deserializeValue, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getProcessInstanceVariable");
    }
    
    // verify the required parameter 'varName' is set
    if (varName == null) {
      throw new ApiException(400, "Missing the required parameter 'varName' when calling getProcessInstanceVariable");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}/variables/{varName}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
      .replaceAll("\\{" + "varName" + "\\}", apiClient.escapeString(varName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("deserializeValue", deserializeValue));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<VariableValueDto> localVarReturnType = new TypeReference<VariableValueDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Process Variable (Binary)
   * Retrieves the content of a Process Variable by the Process Instance id and the Process Variable name. Applicable for byte array or file Process Variables.
   * @param id The id of the process instance to retrieve the variable for. (required)
   * @param varName The name of the variable to retrieve. (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getProcessInstanceVariableBinary(String id, String varName) throws ApiException {
    return this.getProcessInstanceVariableBinary(id, varName, Collections.emptyMap());
  }


  /**
   * Get Process Variable (Binary)
   * Retrieves the content of a Process Variable by the Process Instance id and the Process Variable name. Applicable for byte array or file Process Variables.
   * @param id The id of the process instance to retrieve the variable for. (required)
   * @param varName The name of the variable to retrieve. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getProcessInstanceVariableBinary(String id, String varName, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getProcessInstanceVariableBinary");
    }
    
    // verify the required parameter 'varName' is set
    if (varName == null) {
      throw new ApiException(400, "Missing the required parameter 'varName' when calling getProcessInstanceVariableBinary");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}/variables/{varName}/data"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
      .replaceAll("\\{" + "varName" + "\\}", apiClient.escapeString(varName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/octet-stream", "text/plain", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<File> localVarReturnType = new TypeReference<File>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Process Variables
   * Retrieves all variables of a given process instance by id.
   * @param id The id of the process instance to retrieve the variables from. (required)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
   * @return Map&lt;String, VariableValueDto&gt;
   * @throws ApiException if fails to make API call
   */
  public Map<String, VariableValueDto> getProcessInstanceVariables(String id, Boolean deserializeValues) throws ApiException {
    return this.getProcessInstanceVariables(id, deserializeValues, Collections.emptyMap());
  }


  /**
   * Get Process Variables
   * Retrieves all variables of a given process instance by id.
   * @param id The id of the process instance to retrieve the variables from. (required)
   * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
   * @param additionalHeaders additionalHeaders for this call
   * @return Map&lt;String, VariableValueDto&gt;
   * @throws ApiException if fails to make API call
   */
  public Map<String, VariableValueDto> getProcessInstanceVariables(String id, Boolean deserializeValues, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getProcessInstanceVariables");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}/variables"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("deserializeValues", deserializeValues));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<Map<String, VariableValueDto>> localVarReturnType = new TypeReference<Map<String, VariableValueDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List
   * Queries for process instances that fulfill given parameters. Parameters may be static as well as dynamic runtime properties of process instances. The size of the result set can be retrieved by using the Get Instance Count method.
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param processInstanceIds Filter by a comma-separated list of process instance ids. (optional)
   * @param businessKey Filter by process instance business key. (optional)
   * @param businessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param processDefinitionId Filter by the deployment the id belongs to. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
   * @param processDefinitionKeyIn Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys. (optional)
   * @param processDefinitionKeyNotIn Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys. (optional)
   * @param deploymentId Filter by the deployment the id belongs to. (optional)
   * @param superProcessInstance Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
   * @param subProcessInstance Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id. (optional)
   * @param superCaseInstance Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
   * @param subCaseInstance Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id. (optional)
   * @param active Only include active process instances. Value may only be true, as false is the default behavior. (optional, default to false)
   * @param suspended Only include suspended process instances. Value may only be true, as false is the default behavior. (optional, default to false)
   * @param withIncident Filter by presence of incidents. Selects only process instances that have an incident. (optional, default to false)
   * @param incidentId Filter by the incident id. (optional)
   * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Filter by the incident message. Exact match. (optional)
   * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include process instances which belong to no tenant. (optional, default to false)
   * @param processDefinitionWithoutTenantId Only include process instances which process definition has no tenant id. (optional, default to false)
   * @param activityIdIn Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids. (optional)
   * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional, default to false)
   * @param leafProcessInstances Restrict the query to all process instances that are leaf instances. (i.e. don&#39;t have any sub instances). (optional, default to false)
   * @param variables Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note**: Values are always treated as String objects on server side.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param variableNamesIgnoreCase Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal. (optional, default to false)
   * @param variableValuesIgnoreCase Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal. (optional, default to false)
   * @return List&lt;ProcessInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<ProcessInstanceDto> getProcessInstances(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
    return this.getProcessInstances(sortBy, sortOrder, firstResult, maxResults, processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, Collections.emptyMap());
  }


  /**
   * Get List
   * Queries for process instances that fulfill given parameters. Parameters may be static as well as dynamic runtime properties of process instances. The size of the result set can be retrieved by using the Get Instance Count method.
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param processInstanceIds Filter by a comma-separated list of process instance ids. (optional)
   * @param businessKey Filter by process instance business key. (optional)
   * @param businessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param processDefinitionId Filter by the deployment the id belongs to. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
   * @param processDefinitionKeyIn Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys. (optional)
   * @param processDefinitionKeyNotIn Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys. (optional)
   * @param deploymentId Filter by the deployment the id belongs to. (optional)
   * @param superProcessInstance Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
   * @param subProcessInstance Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id. (optional)
   * @param superCaseInstance Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
   * @param subCaseInstance Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id. (optional)
   * @param active Only include active process instances. Value may only be true, as false is the default behavior. (optional, default to false)
   * @param suspended Only include suspended process instances. Value may only be true, as false is the default behavior. (optional, default to false)
   * @param withIncident Filter by presence of incidents. Selects only process instances that have an incident. (optional, default to false)
   * @param incidentId Filter by the incident id. (optional)
   * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Filter by the incident message. Exact match. (optional)
   * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include process instances which belong to no tenant. (optional, default to false)
   * @param processDefinitionWithoutTenantId Only include process instances which process definition has no tenant id. (optional, default to false)
   * @param activityIdIn Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids. (optional)
   * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional, default to false)
   * @param leafProcessInstances Restrict the query to all process instances that are leaf instances. (i.e. don&#39;t have any sub instances). (optional, default to false)
   * @param variables Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note**: Values are always treated as String objects on server side.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param variableNamesIgnoreCase Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal. (optional, default to false)
   * @param variableValuesIgnoreCase Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal. (optional, default to false)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;ProcessInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<ProcessInstanceDto> getProcessInstances(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/process-instance";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceIds", processInstanceIds));
    localVarQueryParams.addAll(apiClient.parameterToPair("businessKey", businessKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("businessKeyLike", businessKeyLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("deploymentId", deploymentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("superProcessInstance", superProcessInstance));
    localVarQueryParams.addAll(apiClient.parameterToPair("subProcessInstance", subProcessInstance));
    localVarQueryParams.addAll(apiClient.parameterToPair("superCaseInstance", superCaseInstance));
    localVarQueryParams.addAll(apiClient.parameterToPair("subCaseInstance", subCaseInstance));
    localVarQueryParams.addAll(apiClient.parameterToPair("active", active));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("withIncident", withIncident));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentId", incidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentType", incidentType));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessage", incidentMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionWithoutTenantId", processDefinitionWithoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityIdIn", activityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
    localVarQueryParams.addAll(apiClient.parameterToPair("leafProcessInstances", leafProcessInstances));
    localVarQueryParams.addAll(apiClient.parameterToPair("variables", variables));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<ProcessInstanceDto>> localVarReturnType = new TypeReference<List<ProcessInstanceDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List Count
   * Queries for the number of process instances that fulfill given parameters.
   * @param processInstanceIds Filter by a comma-separated list of process instance ids. (optional)
   * @param businessKey Filter by process instance business key. (optional)
   * @param businessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param processDefinitionId Filter by the deployment the id belongs to. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
   * @param processDefinitionKeyIn Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys. (optional)
   * @param processDefinitionKeyNotIn Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys. (optional)
   * @param deploymentId Filter by the deployment the id belongs to. (optional)
   * @param superProcessInstance Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
   * @param subProcessInstance Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id. (optional)
   * @param superCaseInstance Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
   * @param subCaseInstance Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id. (optional)
   * @param active Only include active process instances. Value may only be true, as false is the default behavior. (optional, default to false)
   * @param suspended Only include suspended process instances. Value may only be true, as false is the default behavior. (optional, default to false)
   * @param withIncident Filter by presence of incidents. Selects only process instances that have an incident. (optional, default to false)
   * @param incidentId Filter by the incident id. (optional)
   * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Filter by the incident message. Exact match. (optional)
   * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include process instances which belong to no tenant. (optional, default to false)
   * @param processDefinitionWithoutTenantId Only include process instances which process definition has no tenant id. (optional, default to false)
   * @param activityIdIn Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids. (optional)
   * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional, default to false)
   * @param leafProcessInstances Restrict the query to all process instances that are leaf instances. (i.e. don&#39;t have any sub instances). (optional, default to false)
   * @param variables Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note**: Values are always treated as String objects on server side.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param variableNamesIgnoreCase Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal. (optional, default to false)
   * @param variableValuesIgnoreCase Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal. (optional, default to false)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getProcessInstancesCount(String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
    return this.getProcessInstancesCount(processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, Collections.emptyMap());
  }


  /**
   * Get List Count
   * Queries for the number of process instances that fulfill given parameters.
   * @param processInstanceIds Filter by a comma-separated list of process instance ids. (optional)
   * @param businessKey Filter by process instance business key. (optional)
   * @param businessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
   * @param caseInstanceId Filter by case instance id. (optional)
   * @param processDefinitionId Filter by the deployment the id belongs to. (optional)
   * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
   * @param processDefinitionKeyIn Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys. (optional)
   * @param processDefinitionKeyNotIn Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys. (optional)
   * @param deploymentId Filter by the deployment the id belongs to. (optional)
   * @param superProcessInstance Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
   * @param subProcessInstance Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id. (optional)
   * @param superCaseInstance Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
   * @param subCaseInstance Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id. (optional)
   * @param active Only include active process instances. Value may only be true, as false is the default behavior. (optional, default to false)
   * @param suspended Only include suspended process instances. Value may only be true, as false is the default behavior. (optional, default to false)
   * @param withIncident Filter by presence of incidents. Selects only process instances that have an incident. (optional, default to false)
   * @param incidentId Filter by the incident id. (optional)
   * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
   * @param incidentMessage Filter by the incident message. Exact match. (optional)
   * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
   * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids. (optional)
   * @param withoutTenantId Only include process instances which belong to no tenant. (optional, default to false)
   * @param processDefinitionWithoutTenantId Only include process instances which process definition has no tenant id. (optional, default to false)
   * @param activityIdIn Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids. (optional)
   * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional, default to false)
   * @param leafProcessInstances Restrict the query to all process instances that are leaf instances. (i.e. don&#39;t have any sub instances). (optional, default to false)
   * @param variables Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note**: Values are always treated as String objects on server side.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
   * @param variableNamesIgnoreCase Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal. (optional, default to false)
   * @param variableValuesIgnoreCase Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal. (optional, default to false)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto getProcessInstancesCount(String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/process-instance/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("processInstanceIds", processInstanceIds));
    localVarQueryParams.addAll(apiClient.parameterToPair("businessKey", businessKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("businessKeyLike", businessKeyLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("caseInstanceId", caseInstanceId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionId", processDefinitionId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("deploymentId", deploymentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("superProcessInstance", superProcessInstance));
    localVarQueryParams.addAll(apiClient.parameterToPair("subProcessInstance", subProcessInstance));
    localVarQueryParams.addAll(apiClient.parameterToPair("superCaseInstance", superCaseInstance));
    localVarQueryParams.addAll(apiClient.parameterToPair("subCaseInstance", subCaseInstance));
    localVarQueryParams.addAll(apiClient.parameterToPair("active", active));
    localVarQueryParams.addAll(apiClient.parameterToPair("suspended", suspended));
    localVarQueryParams.addAll(apiClient.parameterToPair("withIncident", withIncident));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentId", incidentId));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentType", incidentType));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessage", incidentMessage));
    localVarQueryParams.addAll(apiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
    localVarQueryParams.addAll(apiClient.parameterToPair("tenantIdIn", tenantIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("withoutTenantId", withoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("processDefinitionWithoutTenantId", processDefinitionWithoutTenantId));
    localVarQueryParams.addAll(apiClient.parameterToPair("activityIdIn", activityIdIn));
    localVarQueryParams.addAll(apiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
    localVarQueryParams.addAll(apiClient.parameterToPair("leafProcessInstances", leafProcessInstances));
    localVarQueryParams.addAll(apiClient.parameterToPair("variables", variables));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
    localVarQueryParams.addAll(apiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Modify Process Instance Execution State
   * Submits a list of modification instructions to change a process instance&#39;s execution state. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Canceling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed immediately and in the order they are provided in this request&#39;s body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/develop/user-guide/process-engine/process-instance-modification/).
   * @param id The id of the process instance to modify. (required)
   * @param processInstanceModificationDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void modifyProcessInstance(String id, ProcessInstanceModificationDto processInstanceModificationDto) throws ApiException {
    this.modifyProcessInstance(id, processInstanceModificationDto, Collections.emptyMap());
  }


  /**
   * Modify Process Instance Execution State
   * Submits a list of modification instructions to change a process instance&#39;s execution state. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Canceling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed immediately and in the order they are provided in this request&#39;s body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/develop/user-guide/process-engine/process-instance-modification/).
   * @param id The id of the process instance to modify. (required)
   * @param processInstanceModificationDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void modifyProcessInstance(String id, ProcessInstanceModificationDto processInstanceModificationDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = processInstanceModificationDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling modifyProcessInstance");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}/modification"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Modify Process Instance Execution State Async
   * Submits a list of modification instructions to change a process instance&#39;s execution state async. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Cancelling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed asynchronous and in the order they are provided in this request&#39;s body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/process-instance-modification/).
   * @param id The id of the process instance to modify. (required)
   * @param processInstanceModificationDto  (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto modifyProcessInstanceAsyncOperation(String id, ProcessInstanceModificationDto processInstanceModificationDto) throws ApiException {
    return this.modifyProcessInstanceAsyncOperation(id, processInstanceModificationDto, Collections.emptyMap());
  }


  /**
   * Modify Process Instance Execution State Async
   * Submits a list of modification instructions to change a process instance&#39;s execution state async. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Cancelling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed asynchronous and in the order they are provided in this request&#39;s body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/process-instance-modification/).
   * @param id The id of the process instance to modify. (required)
   * @param processInstanceModificationDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto modifyProcessInstanceAsyncOperation(String id, ProcessInstanceModificationDto processInstanceModificationDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = processInstanceModificationDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling modifyProcessInstanceAsyncOperation");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}/modification-async"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update/Delete Process Variables
   * Updates or deletes the variables of a process instance by id. Updates precede deletions. So, if a variable is updated AND deleted, the deletion overrides the update.
   * @param id The id of the process instance to set variables for. (required)
   * @param patchVariablesDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void modifyProcessInstanceVariables(String id, PatchVariablesDto patchVariablesDto) throws ApiException {
    this.modifyProcessInstanceVariables(id, patchVariablesDto, Collections.emptyMap());
  }


  /**
   * Update/Delete Process Variables
   * Updates or deletes the variables of a process instance by id. Updates precede deletions. So, if a variable is updated AND deleted, the deletion overrides the update.
   * @param id The id of the process instance to set variables for. (required)
   * @param patchVariablesDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void modifyProcessInstanceVariables(String id, PatchVariablesDto patchVariablesDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = patchVariablesDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling modifyProcessInstanceVariables");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}/variables"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get List (POST)
   * Queries for process instances that fulfill given parameters through a JSON object. This method is slightly more powerful than the Get Instances method because it allows filtering by multiple process variables of types &#x60;string&#x60;, &#x60;number&#x60; or &#x60;boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param processInstanceQueryDto  (optional)
   * @return List&lt;ProcessInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<ProcessInstanceDto> queryProcessInstances(Integer firstResult, Integer maxResults, ProcessInstanceQueryDto processInstanceQueryDto) throws ApiException {
    return this.queryProcessInstances(firstResult, maxResults, processInstanceQueryDto, Collections.emptyMap());
  }


  /**
   * Get List (POST)
   * Queries for process instances that fulfill given parameters through a JSON object. This method is slightly more powerful than the Get Instances method because it allows filtering by multiple process variables of types &#x60;string&#x60;, &#x60;number&#x60; or &#x60;boolean&#x60;.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param processInstanceQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;ProcessInstanceDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<ProcessInstanceDto> queryProcessInstances(Integer firstResult, Integer maxResults, ProcessInstanceQueryDto processInstanceQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = processInstanceQueryDto;
    
    // create path and map variables
    String localVarPath = "/process-instance";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<ProcessInstanceDto>> localVarReturnType = new TypeReference<List<ProcessInstanceDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List Count (POST)
   * Queries for the number of process instances that fulfill the given parameters. This method takes the same message body as the Get Instances (POST) method and therefore it is slightly more powerful than the Get Instance Count method.
   * @param processInstanceQueryDto  (optional)
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryProcessInstancesCount(ProcessInstanceQueryDto processInstanceQueryDto) throws ApiException {
    return this.queryProcessInstancesCount(processInstanceQueryDto, Collections.emptyMap());
  }


  /**
   * Get List Count (POST)
   * Queries for the number of process instances that fulfill the given parameters. This method takes the same message body as the Get Instances (POST) method and therefore it is slightly more powerful than the Get Instance Count method.
   * @param processInstanceQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CountResultDto
   * @throws ApiException if fails to make API call
   */
  public CountResultDto queryProcessInstancesCount(ProcessInstanceQueryDto processInstanceQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = processInstanceQueryDto;
    
    // create path and map variables
    String localVarPath = "/process-instance/count";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update Process Variable
   * Sets a variable of a given process instance by id.
   * @param id The id of the process instance to set the variable for. (required)
   * @param varName The name of the variable to set. (required)
   * @param variableValueDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void setProcessInstanceVariable(String id, String varName, VariableValueDto variableValueDto) throws ApiException {
    this.setProcessInstanceVariable(id, varName, variableValueDto, Collections.emptyMap());
  }


  /**
   * Update Process Variable
   * Sets a variable of a given process instance by id.
   * @param id The id of the process instance to set the variable for. (required)
   * @param varName The name of the variable to set. (required)
   * @param variableValueDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void setProcessInstanceVariable(String id, String varName, VariableValueDto variableValueDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = variableValueDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling setProcessInstanceVariable");
    }
    
    // verify the required parameter 'varName' is set
    if (varName == null) {
      throw new ApiException(400, "Missing the required parameter 'varName' when calling setProcessInstanceVariable");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}/variables/{varName}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
      .replaceAll("\\{" + "varName" + "\\}", apiClient.escapeString(varName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Update Process Variable (Binary)
   * Sets the serialized value for a binary variable or the binary value for a file variable.
   * @param id The id of the process instance to retrieve the variable for. (required)
   * @param varName The name of the variable to retrieve. (required)
   * @param data The binary data to be set. For File variables, this multipart can contain the filename, binary value and MIME type of the file variable to be set Only the filename is mandatory. (optional)
   * @param valueType The name of the variable type. Either Bytes for a byte array variable or File for a file variable. (optional)
   * @throws ApiException if fails to make API call
   */
  public void setProcessInstanceVariableBinary(String id, String varName, File data, String valueType) throws ApiException {
    this.setProcessInstanceVariableBinary(id, varName, data, valueType, Collections.emptyMap());
  }


  /**
   * Update Process Variable (Binary)
   * Sets the serialized value for a binary variable or the binary value for a file variable.
   * @param id The id of the process instance to retrieve the variable for. (required)
   * @param varName The name of the variable to retrieve. (required)
   * @param data The binary data to be set. For File variables, this multipart can contain the filename, binary value and MIME type of the file variable to be set Only the filename is mandatory. (optional)
   * @param valueType The name of the variable type. Either Bytes for a byte array variable or File for a file variable. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void setProcessInstanceVariableBinary(String id, String varName, File data, String valueType, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling setProcessInstanceVariableBinary");
    }
    
    // verify the required parameter 'varName' is set
    if (varName == null) {
      throw new ApiException(400, "Missing the required parameter 'varName' when calling setProcessInstanceVariableBinary");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}/variables/{varName}/data"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
      .replaceAll("\\{" + "varName" + "\\}", apiClient.escapeString(varName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    if (data != null)
      localVarFormParams.put("data", data);
if (valueType != null)
      localVarFormParams.put("valueType", valueType);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "multipart/form-data"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Set Job Retries Async (POST)
   * Create a batch to set retries of jobs associated with given processes asynchronously.
   * @param setJobRetriesByProcessDto Please note that if both processInstances and processInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: &#x60;historicProcessInstanceQuery&#x60; (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto setRetriesByProcess(SetJobRetriesByProcessDto setJobRetriesByProcessDto) throws ApiException {
    return this.setRetriesByProcess(setJobRetriesByProcessDto, Collections.emptyMap());
  }


  /**
   * Set Job Retries Async (POST)
   * Create a batch to set retries of jobs associated with given processes asynchronously.
   * @param setJobRetriesByProcessDto Please note that if both processInstances and processInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: &#x60;historicProcessInstanceQuery&#x60; (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto setRetriesByProcess(SetJobRetriesByProcessDto setJobRetriesByProcessDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = setJobRetriesByProcessDto;
    
    // create path and map variables
    String localVarPath = "/process-instance/job-retries";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Set Job Retries Async Historic Query Based (POST)
   * Create a batch to set retries of jobs asynchronously based on a historic process instance query.
   * @param setJobRetriesByProcessDto Please note that if both processInstances and historicProcessInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: &#x60;processInstanceQuery&#x60; (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto setRetriesByProcessHistoricQueryBased(SetJobRetriesByProcessDto setJobRetriesByProcessDto) throws ApiException {
    return this.setRetriesByProcessHistoricQueryBased(setJobRetriesByProcessDto, Collections.emptyMap());
  }


  /**
   * Set Job Retries Async Historic Query Based (POST)
   * Create a batch to set retries of jobs asynchronously based on a historic process instance query.
   * @param setJobRetriesByProcessDto Please note that if both processInstances and historicProcessInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: &#x60;processInstanceQuery&#x60; (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto setRetriesByProcessHistoricQueryBased(SetJobRetriesByProcessDto setJobRetriesByProcessDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = setJobRetriesByProcessDto;
    
    // create path and map variables
    String localVarPath = "/process-instance/job-retries-historic-query-based";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Set Variables Async (POST)
   * Update or create runtime process variables in the root scope of process instances.
   * @param setVariablesAsyncDto  (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto setVariablesAsyncOperation(SetVariablesAsyncDto setVariablesAsyncDto) throws ApiException {
    return this.setVariablesAsyncOperation(setVariablesAsyncDto, Collections.emptyMap());
  }


  /**
   * Set Variables Async (POST)
   * Update or create runtime process variables in the root scope of process instances.
   * @param setVariablesAsyncDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto setVariablesAsyncOperation(SetVariablesAsyncDto setVariablesAsyncDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = setVariablesAsyncDto;
    
    // create path and map variables
    String localVarPath = "/process-instance/variables-async";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Activate/Suspend In Group
   * Activates or suspends process instances by providing certain criteria:  # Activate/Suspend Process Instance By Process Definition Id * &#x60;suspend&#x60; * &#x60;processDefinitionId&#x60;  # Activate/Suspend Process Instance By Process Definition Key  * &#x60;suspend&#x60; * &#x60;processDefinitionKey&#x60; * &#x60;processDefinitionTenantId&#x60; * &#x60;processDefinitionWithoutTenantId&#x60;  # Activate/Suspend Process Instance In Group * &#x60;suspend&#x60; * &#x60;processInstanceIds&#x60; * &#x60;processInstanceQuery&#x60; * &#x60;historicProcessInstanceQuery&#x60;
   * @param processInstanceSuspensionStateDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateSuspensionState(ProcessInstanceSuspensionStateDto processInstanceSuspensionStateDto) throws ApiException {
    this.updateSuspensionState(processInstanceSuspensionStateDto, Collections.emptyMap());
  }


  /**
   * Activate/Suspend In Group
   * Activates or suspends process instances by providing certain criteria:  # Activate/Suspend Process Instance By Process Definition Id * &#x60;suspend&#x60; * &#x60;processDefinitionId&#x60;  # Activate/Suspend Process Instance By Process Definition Key  * &#x60;suspend&#x60; * &#x60;processDefinitionKey&#x60; * &#x60;processDefinitionTenantId&#x60; * &#x60;processDefinitionWithoutTenantId&#x60;  # Activate/Suspend Process Instance In Group * &#x60;suspend&#x60; * &#x60;processInstanceIds&#x60; * &#x60;processInstanceQuery&#x60; * &#x60;historicProcessInstanceQuery&#x60;
   * @param processInstanceSuspensionStateDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateSuspensionState(ProcessInstanceSuspensionStateDto processInstanceSuspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = processInstanceSuspensionStateDto;
    
    // create path and map variables
    String localVarPath = "/process-instance/suspended";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Activate/Suspend In Batch
   * Activates or suspends process instances asynchronously with a list of process instance ids, a process instance query, and/or a historical process instance query.
   * @param processInstanceSuspensionStateAsyncDto  (optional)
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto updateSuspensionStateAsyncOperation(ProcessInstanceSuspensionStateAsyncDto processInstanceSuspensionStateAsyncDto) throws ApiException {
    return this.updateSuspensionStateAsyncOperation(processInstanceSuspensionStateAsyncDto, Collections.emptyMap());
  }


  /**
   * Activate/Suspend In Batch
   * Activates or suspends process instances asynchronously with a list of process instance ids, a process instance query, and/or a historical process instance query.
   * @param processInstanceSuspensionStateAsyncDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BatchDto
   * @throws ApiException if fails to make API call
   */
  public BatchDto updateSuspensionStateAsyncOperation(ProcessInstanceSuspensionStateAsyncDto processInstanceSuspensionStateAsyncDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = processInstanceSuspensionStateAsyncDto;
    
    // create path and map variables
    String localVarPath = "/process-instance/suspended-async";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Activate/Suspend Process Instance By Id
   * Activates or suspends a given process instance by id.
   * @param id The id of the process instance to activate or suspend. (required)
   * @param suspensionStateDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateSuspensionStateById(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
    this.updateSuspensionStateById(id, suspensionStateDto, Collections.emptyMap());
  }


  /**
   * Activate/Suspend Process Instance By Id
   * Activates or suspends a given process instance by id.
   * @param id The id of the process instance to activate or suspend. (required)
   * @param suspensionStateDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateSuspensionStateById(String id, SuspensionStateDto suspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = suspensionStateDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling updateSuspensionStateById");
    }
    
    // create path and map variables
    String localVarPath = "/process-instance/{id}/suspended"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

}
