/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.SchemaLogEntryDto;
import org.camunda.community.rest.client.dto.SchemaLogQueryDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class SchemaLogApi {


  private ApiClient apiClient;

  public SchemaLogApi() {
    this(Configuration.getDefaultApiClient());
  }

  public SchemaLogApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get List
   * Queries for schema log entries that fulfill given parameters.
   * @param version Only return schema log entries with a specific version. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @return List&lt;SchemaLogEntryDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<SchemaLogEntryDto> getSchemaLog(String version, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
    return this.getSchemaLog(version, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
  }


  /**
   * Get List
   * Queries for schema log entries that fulfill given parameters.
   * @param version Only return schema log entries with a specific version. (optional)
   * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
   * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;SchemaLogEntryDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<SchemaLogEntryDto> getSchemaLog(String version, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/schema/log";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));
    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<SchemaLogEntryDto>> localVarReturnType = new TypeReference<List<SchemaLogEntryDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get List (POST)
   * Queries for schema log entries that fulfill given parameters.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param schemaLogQueryDto  (optional)
   * @return List&lt;SchemaLogEntryDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<SchemaLogEntryDto> querySchemaLog(Integer firstResult, Integer maxResults, SchemaLogQueryDto schemaLogQueryDto) throws ApiException {
    return this.querySchemaLog(firstResult, maxResults, schemaLogQueryDto, Collections.emptyMap());
  }


  /**
   * Get List (POST)
   * Queries for schema log entries that fulfill given parameters.
   * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
   * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
   * @param schemaLogQueryDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;SchemaLogEntryDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<SchemaLogEntryDto> querySchemaLog(Integer firstResult, Integer maxResults, SchemaLogQueryDto schemaLogQueryDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = schemaLogQueryDto;
    
    // create path and map variables
    String localVarPath = "/schema/log";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("firstResult", firstResult));
    localVarQueryParams.addAll(apiClient.parameterToPair("maxResults", maxResults));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<SchemaLogEntryDto>> localVarReturnType = new TypeReference<List<SchemaLogEntryDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
