/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.IdentityLinkDto;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class TaskIdentityLinkApi {


  private ApiClient apiClient;

  public TaskIdentityLinkApi() {
    this(Configuration.getDefaultApiClient());
  }

  public TaskIdentityLinkApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Add
   * Adds an identity link to a task by id. Can be used to link any user or group to a task and specify a relation.
   * @param id The id of the task to add a link to. (required)
   * @param identityLinkDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void addIdentityLink(String id, IdentityLinkDto identityLinkDto) throws ApiException {
    this.addIdentityLink(id, identityLinkDto, Collections.emptyMap());
  }


  /**
   * Add
   * Adds an identity link to a task by id. Can be used to link any user or group to a task and specify a relation.
   * @param id The id of the task to add a link to. (required)
   * @param identityLinkDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void addIdentityLink(String id, IdentityLinkDto identityLinkDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = identityLinkDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling addIdentityLink");
    }
    
    // create path and map variables
    String localVarPath = "/task/{id}/identity-links"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete
   * Removes an identity link from a task by id
   * @param id The id of the task to remove a link from. (required)
   * @param identityLinkDto  (optional)
   * @throws ApiException if fails to make API call
   */
  public void deleteIdentityLink(String id, IdentityLinkDto identityLinkDto) throws ApiException {
    this.deleteIdentityLink(id, identityLinkDto, Collections.emptyMap());
  }


  /**
   * Delete
   * Removes an identity link from a task by id
   * @param id The id of the task to remove a link from. (required)
   * @param identityLinkDto  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteIdentityLink(String id, IdentityLinkDto identityLinkDto, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = identityLinkDto;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteIdentityLink");
    }
    
    // create path and map variables
    String localVarPath = "/task/{id}/identity-links/delete"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get List
   * Gets the identity links for a task by id, which are the users and groups that are in *some* relation to it (including assignee and owner).
   * @param id The id of the task to retrieve the identity links for. (required)
   * @param type Filter by the type of links to include. (optional)
   * @return List&lt;IdentityLinkDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<IdentityLinkDto> getIdentityLinks(String id, String type) throws ApiException {
    return this.getIdentityLinks(id, type, Collections.emptyMap());
  }


  /**
   * Get List
   * Gets the identity links for a task by id, which are the users and groups that are in *some* relation to it (including assignee and owner).
   * @param id The id of the task to retrieve the identity links for. (required)
   * @param type Filter by the type of links to include. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;IdentityLinkDto&gt;
   * @throws ApiException if fails to make API call
   */
  public List<IdentityLinkDto> getIdentityLinks(String id, String type, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getIdentityLinks");
    }
    
    // create path and map variables
    String localVarPath = "/task/{id}/identity-links"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    TypeReference<List<IdentityLinkDto>> localVarReturnType = new TypeReference<List<IdentityLinkDto>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
