/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.IncidentStatisticsResultDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * ActivityStatisticsResultDto
 */
@JsonPropertyOrder({
  ActivityStatisticsResultDto.JSON_PROPERTY_ID,
  ActivityStatisticsResultDto.JSON_PROPERTY_INSTANCES,
  ActivityStatisticsResultDto.JSON_PROPERTY_FAILED_JOBS,
  ActivityStatisticsResultDto.JSON_PROPERTY_INCIDENTS,
  ActivityStatisticsResultDto.JSON_PROPERTY_AT_CLASS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class ActivityStatisticsResultDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_INSTANCES = "instances";
  private Integer instances;

  public static final String JSON_PROPERTY_FAILED_JOBS = "failedJobs";
  private Integer failedJobs;

  public static final String JSON_PROPERTY_INCIDENTS = "incidents";
  private JsonNullable<List<IncidentStatisticsResultDto>> incidents = JsonNullable.<List<IncidentStatisticsResultDto>>undefined();

  public static final String JSON_PROPERTY_AT_CLASS = "@class";
  private JsonNullable<String> atClass = JsonNullable.<String>undefined();

  public ActivityStatisticsResultDto() {
  }

  public ActivityStatisticsResultDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the activity the results are aggregated for.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public ActivityStatisticsResultDto instances(Integer instances) {
    
    this.instances = instances;
    return this;
  }

   /**
   * The total number of running process instances of this activity.
   * @return instances
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getInstances() {
    return instances;
  }


  @JsonProperty(JSON_PROPERTY_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstances(Integer instances) {
    this.instances = instances;
  }


  public ActivityStatisticsResultDto failedJobs(Integer failedJobs) {
    
    this.failedJobs = failedJobs;
    return this;
  }

   /**
   * The total number of failed jobs for the running instances. **Note**: Will be &#x60;0&#x60; (not &#x60;null&#x60;), if failed jobs were excluded.
   * @return failedJobs
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FAILED_JOBS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFailedJobs() {
    return failedJobs;
  }


  @JsonProperty(JSON_PROPERTY_FAILED_JOBS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFailedJobs(Integer failedJobs) {
    this.failedJobs = failedJobs;
  }


  public ActivityStatisticsResultDto incidents(List<IncidentStatisticsResultDto> incidents) {
    this.incidents = JsonNullable.<List<IncidentStatisticsResultDto>>of(incidents);
    
    return this;
  }

  public ActivityStatisticsResultDto addIncidentsItem(IncidentStatisticsResultDto incidentsItem) {
    if (this.incidents == null || !this.incidents.isPresent()) {
      this.incidents = JsonNullable.<List<IncidentStatisticsResultDto>>of(new ArrayList<>());
    }
    try {
      this.incidents.get().add(incidentsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Each item in the resulting array is an object which contains &#x60;incidentType&#x60; and &#x60;incidentCount&#x60;. **Note**: Will be an empty array, if &#x60;incidents&#x60; or &#x60;incidentsForType&#x60; were excluded. Furthermore, the array will be also empty if no incidents were found.
   * @return incidents
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<IncidentStatisticsResultDto> getIncidents() {
        return incidents.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCIDENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<IncidentStatisticsResultDto>> getIncidents_JsonNullable() {
    return incidents;
  }
  
  @JsonProperty(JSON_PROPERTY_INCIDENTS)
  public void setIncidents_JsonNullable(JsonNullable<List<IncidentStatisticsResultDto>> incidents) {
    this.incidents = incidents;
  }

  public void setIncidents(List<IncidentStatisticsResultDto> incidents) {
    this.incidents = JsonNullable.<List<IncidentStatisticsResultDto>>of(incidents);
  }


  public ActivityStatisticsResultDto atClass(String atClass) {
    this.atClass = JsonNullable.<String>of(atClass);
    
    return this;
  }

   /**
   * The fully qualified class name of the data transfer object class. The class name might change in future releases.
   * @return atClass
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getAtClass() {
        return atClass.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_AT_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getAtClass_JsonNullable() {
    return atClass;
  }
  
  @JsonProperty(JSON_PROPERTY_AT_CLASS)
  public void setAtClass_JsonNullable(JsonNullable<String> atClass) {
    this.atClass = atClass;
  }

  public void setAtClass(String atClass) {
    this.atClass = JsonNullable.<String>of(atClass);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActivityStatisticsResultDto activityStatisticsResultDto = (ActivityStatisticsResultDto) o;
    return equalsNullable(this.id, activityStatisticsResultDto.id) &&
        Objects.equals(this.instances, activityStatisticsResultDto.instances) &&
        Objects.equals(this.failedJobs, activityStatisticsResultDto.failedJobs) &&
        equalsNullable(this.incidents, activityStatisticsResultDto.incidents) &&
        equalsNullable(this.atClass, activityStatisticsResultDto.atClass);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), instances, failedJobs, hashCodeNullable(incidents), hashCodeNullable(atClass));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActivityStatisticsResultDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    instances: ").append(toIndentedString(instances)).append("\n");
    sb.append("    failedJobs: ").append(toIndentedString(failedJobs)).append("\n");
    sb.append("    incidents: ").append(toIndentedString(incidents)).append("\n");
    sb.append("    atClass: ").append(toIndentedString(atClass)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `instances` to the URL query string
    if (getInstances() != null) {
      try {
        joiner.add(String.format("%sinstances%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getInstances()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `failedJobs` to the URL query string
    if (getFailedJobs() != null) {
      try {
        joiner.add(String.format("%sfailedJobs%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFailedJobs()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidents` to the URL query string
    if (getIncidents() != null) {
      for (int i = 0; i < getIncidents().size(); i++) {
        if (getIncidents().get(i) != null) {
          joiner.add(getIncidents().get(i).toUrlQueryString(String.format("%sincidents%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `@class` to the URL query string
    if (getAtClass() != null) {
      try {
        joiner.add(String.format("%s@class%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAtClass()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

