/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * AtomLink
 */
@JsonPropertyOrder({
  AtomLink.JSON_PROPERTY_REL,
  AtomLink.JSON_PROPERTY_HREF,
  AtomLink.JSON_PROPERTY_METHOD
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class AtomLink {
  public static final String JSON_PROPERTY_REL = "rel";
  private JsonNullable<String> rel = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_HREF = "href";
  private JsonNullable<String> href = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_METHOD = "method";
  private JsonNullable<String> method = JsonNullable.<String>undefined();

  public AtomLink() {
  }

  public AtomLink rel(String rel) {
    this.rel = JsonNullable.<String>of(rel);
    
    return this;
  }

   /**
   * The relation of the link to the object that belongs to.
   * @return rel
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRel() {
        return rel.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRel_JsonNullable() {
    return rel;
  }
  
  @JsonProperty(JSON_PROPERTY_REL)
  public void setRel_JsonNullable(JsonNullable<String> rel) {
    this.rel = rel;
  }

  public void setRel(String rel) {
    this.rel = JsonNullable.<String>of(rel);
  }


  public AtomLink href(String href) {
    this.href = JsonNullable.<String>of(href);
    
    return this;
  }

   /**
   * The url of the link.
   * @return href
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getHref() {
        return href.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_HREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getHref_JsonNullable() {
    return href;
  }
  
  @JsonProperty(JSON_PROPERTY_HREF)
  public void setHref_JsonNullable(JsonNullable<String> href) {
    this.href = href;
  }

  public void setHref(String href) {
    this.href = JsonNullable.<String>of(href);
  }


  public AtomLink method(String method) {
    this.method = JsonNullable.<String>of(method);
    
    return this;
  }

   /**
   * The http method.
   * @return method
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getMethod() {
        return method.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getMethod_JsonNullable() {
    return method;
  }
  
  @JsonProperty(JSON_PROPERTY_METHOD)
  public void setMethod_JsonNullable(JsonNullable<String> method) {
    this.method = method;
  }

  public void setMethod(String method) {
    this.method = JsonNullable.<String>of(method);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AtomLink atomLink = (AtomLink) o;
    return equalsNullable(this.rel, atomLink.rel) &&
        equalsNullable(this.href, atomLink.href) &&
        equalsNullable(this.method, atomLink.method);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(rel), hashCodeNullable(href), hashCodeNullable(method));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AtomLink {\n");
    sb.append("    rel: ").append(toIndentedString(rel)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    method: ").append(toIndentedString(method)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `rel` to the URL query string
    if (getRel() != null) {
      try {
        joiner.add(String.format("%srel%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRel()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `href` to the URL query string
    if (getHref() != null) {
      try {
        joiner.add(String.format("%shref%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHref()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `method` to the URL query string
    if (getMethod() != null) {
      try {
        joiner.add(String.format("%smethod%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMethod()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

