/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * AuthorizationCheckResultDto
 */
@JsonPropertyOrder({
  AuthorizationCheckResultDto.JSON_PROPERTY_PERMISSION_NAME,
  AuthorizationCheckResultDto.JSON_PROPERTY_RESOURCE_NAME,
  AuthorizationCheckResultDto.JSON_PROPERTY_RESOURCE_ID,
  AuthorizationCheckResultDto.JSON_PROPERTY_AUTHORIZED
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class AuthorizationCheckResultDto {
  public static final String JSON_PROPERTY_PERMISSION_NAME = "permissionName";
  private JsonNullable<String> permissionName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_RESOURCE_NAME = "resourceName";
  private JsonNullable<String> resourceName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_RESOURCE_ID = "resourceId";
  private JsonNullable<String> resourceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_AUTHORIZED = "authorized";
  private JsonNullable<Boolean> authorized = JsonNullable.<Boolean>undefined();

  public AuthorizationCheckResultDto() {
  }

  public AuthorizationCheckResultDto permissionName(String permissionName) {
    this.permissionName = JsonNullable.<String>of(permissionName);
    
    return this;
  }

   /**
   * Name of the permission which was checked.
   * @return permissionName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getPermissionName() {
        return permissionName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PERMISSION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getPermissionName_JsonNullable() {
    return permissionName;
  }
  
  @JsonProperty(JSON_PROPERTY_PERMISSION_NAME)
  public void setPermissionName_JsonNullable(JsonNullable<String> permissionName) {
    this.permissionName = permissionName;
  }

  public void setPermissionName(String permissionName) {
    this.permissionName = JsonNullable.<String>of(permissionName);
  }


  public AuthorizationCheckResultDto resourceName(String resourceName) {
    this.resourceName = JsonNullable.<String>of(resourceName);
    
    return this;
  }

   /**
   * The name of the resource for which the permission check was performed.
   * @return resourceName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getResourceName() {
        return resourceName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESOURCE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getResourceName_JsonNullable() {
    return resourceName;
  }
  
  @JsonProperty(JSON_PROPERTY_RESOURCE_NAME)
  public void setResourceName_JsonNullable(JsonNullable<String> resourceName) {
    this.resourceName = resourceName;
  }

  public void setResourceName(String resourceName) {
    this.resourceName = JsonNullable.<String>of(resourceName);
  }


  public AuthorizationCheckResultDto resourceId(String resourceId) {
    this.resourceId = JsonNullable.<String>of(resourceId);
    
    return this;
  }

   /**
   * The id of the resource for which the permission check was performed.
   * @return resourceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getResourceId() {
        return resourceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getResourceId_JsonNullable() {
    return resourceId;
  }
  
  @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
  public void setResourceId_JsonNullable(JsonNullable<String> resourceId) {
    this.resourceId = resourceId;
  }

  public void setResourceId(String resourceId) {
    this.resourceId = JsonNullable.<String>of(resourceId);
  }


  public AuthorizationCheckResultDto authorized(Boolean authorized) {
    this.authorized = JsonNullable.<Boolean>of(authorized);
    
    return this;
  }

   /**
   * Returns true or false depending on whether the user is authorized or not.
   * @return authorized
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getAuthorized() {
        return authorized.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_AUTHORIZED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getAuthorized_JsonNullable() {
    return authorized;
  }
  
  @JsonProperty(JSON_PROPERTY_AUTHORIZED)
  public void setAuthorized_JsonNullable(JsonNullable<Boolean> authorized) {
    this.authorized = authorized;
  }

  public void setAuthorized(Boolean authorized) {
    this.authorized = JsonNullable.<Boolean>of(authorized);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorizationCheckResultDto authorizationCheckResultDto = (AuthorizationCheckResultDto) o;
    return equalsNullable(this.permissionName, authorizationCheckResultDto.permissionName) &&
        equalsNullable(this.resourceName, authorizationCheckResultDto.resourceName) &&
        equalsNullable(this.resourceId, authorizationCheckResultDto.resourceId) &&
        equalsNullable(this.authorized, authorizationCheckResultDto.authorized);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(permissionName), hashCodeNullable(resourceName), hashCodeNullable(resourceId), hashCodeNullable(authorized));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizationCheckResultDto {\n");
    sb.append("    permissionName: ").append(toIndentedString(permissionName)).append("\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    authorized: ").append(toIndentedString(authorized)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `permissionName` to the URL query string
    if (getPermissionName() != null) {
      try {
        joiner.add(String.format("%spermissionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPermissionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceName` to the URL query string
    if (getResourceName() != null) {
      try {
        joiner.add(String.format("%sresourceName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceId` to the URL query string
    if (getResourceId() != null) {
      try {
        joiner.add(String.format("%sresourceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `authorized` to the URL query string
    if (getAuthorized() != null) {
      try {
        joiner.add(String.format("%sauthorized%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAuthorized()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

