/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * AuthorizationCreateDto
 */
@JsonPropertyOrder({
  AuthorizationCreateDto.JSON_PROPERTY_TYPE,
  AuthorizationCreateDto.JSON_PROPERTY_PERMISSIONS,
  AuthorizationCreateDto.JSON_PROPERTY_USER_ID,
  AuthorizationCreateDto.JSON_PROPERTY_GROUP_ID,
  AuthorizationCreateDto.JSON_PROPERTY_RESOURCE_TYPE,
  AuthorizationCreateDto.JSON_PROPERTY_RESOURCE_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class AuthorizationCreateDto {
  public static final String JSON_PROPERTY_TYPE = "type";
  private JsonNullable<Integer> type = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
  private JsonNullable<List<String>> permissions = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_USER_ID = "userId";
  private JsonNullable<String> userId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_GROUP_ID = "groupId";
  private JsonNullable<String> groupId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
  private JsonNullable<Integer> resourceType = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_RESOURCE_ID = "resourceId";
  private JsonNullable<String> resourceId = JsonNullable.<String>undefined();

  public AuthorizationCreateDto() {
  }

  public AuthorizationCreateDto type(Integer type) {
    this.type = JsonNullable.<Integer>of(type);
    
    return this;
  }

   /**
   * The type of the authorization (0&#x3D;global, 1&#x3D;grant, 2&#x3D;revoke). See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service.md#authorization-type) for more information about authorization types.
   * @return type
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getType() {
        return type.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getType_JsonNullable() {
    return type;
  }
  
  @JsonProperty(JSON_PROPERTY_TYPE)
  public void setType_JsonNullable(JsonNullable<Integer> type) {
    this.type = type;
  }

  public void setType(Integer type) {
    this.type = JsonNullable.<Integer>of(type);
  }


  public AuthorizationCreateDto permissions(List<String> permissions) {
    this.permissions = JsonNullable.<List<String>>of(permissions);
    
    return this;
  }

  public AuthorizationCreateDto addPermissionsItem(String permissionsItem) {
    if (this.permissions == null || !this.permissions.isPresent()) {
      this.permissions = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.permissions.get().add(permissionsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array of Strings holding the permissions provided by this authorization.
   * @return permissions
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getPermissions() {
        return permissions.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PERMISSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getPermissions_JsonNullable() {
    return permissions;
  }
  
  @JsonProperty(JSON_PROPERTY_PERMISSIONS)
  public void setPermissions_JsonNullable(JsonNullable<List<String>> permissions) {
    this.permissions = permissions;
  }

  public void setPermissions(List<String> permissions) {
    this.permissions = JsonNullable.<List<String>>of(permissions);
  }


  public AuthorizationCreateDto userId(String userId) {
    this.userId = JsonNullable.<String>of(userId);
    
    return this;
  }

   /**
   * The id of the user this authorization has been created for. The value &#x60;*&#x60; represents a global authorization ranging over all users.
   * @return userId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getUserId() {
        return userId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getUserId_JsonNullable() {
    return userId;
  }
  
  @JsonProperty(JSON_PROPERTY_USER_ID)
  public void setUserId_JsonNullable(JsonNullable<String> userId) {
    this.userId = userId;
  }

  public void setUserId(String userId) {
    this.userId = JsonNullable.<String>of(userId);
  }


  public AuthorizationCreateDto groupId(String groupId) {
    this.groupId = JsonNullable.<String>of(groupId);
    
    return this;
  }

   /**
   * The id of the group this authorization has been created for.
   * @return groupId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getGroupId() {
        return groupId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_GROUP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getGroupId_JsonNullable() {
    return groupId;
  }
  
  @JsonProperty(JSON_PROPERTY_GROUP_ID)
  public void setGroupId_JsonNullable(JsonNullable<String> groupId) {
    this.groupId = groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = JsonNullable.<String>of(groupId);
  }


  public AuthorizationCreateDto resourceType(Integer resourceType) {
    this.resourceType = JsonNullable.<Integer>of(resourceType);
    
    return this;
  }

   /**
   * An integer representing the resource type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types.
   * @return resourceType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getResourceType() {
        return resourceType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getResourceType_JsonNullable() {
    return resourceType;
  }
  
  @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
  public void setResourceType_JsonNullable(JsonNullable<Integer> resourceType) {
    this.resourceType = resourceType;
  }

  public void setResourceType(Integer resourceType) {
    this.resourceType = JsonNullable.<Integer>of(resourceType);
  }


  public AuthorizationCreateDto resourceId(String resourceId) {
    this.resourceId = JsonNullable.<String>of(resourceId);
    
    return this;
  }

   /**
   * The resource Id. The value &#x60;*&#x60; represents an authorization ranging over all instances of a resource.
   * @return resourceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getResourceId() {
        return resourceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getResourceId_JsonNullable() {
    return resourceId;
  }
  
  @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
  public void setResourceId_JsonNullable(JsonNullable<String> resourceId) {
    this.resourceId = resourceId;
  }

  public void setResourceId(String resourceId) {
    this.resourceId = JsonNullable.<String>of(resourceId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorizationCreateDto authorizationCreateDto = (AuthorizationCreateDto) o;
    return equalsNullable(this.type, authorizationCreateDto.type) &&
        equalsNullable(this.permissions, authorizationCreateDto.permissions) &&
        equalsNullable(this.userId, authorizationCreateDto.userId) &&
        equalsNullable(this.groupId, authorizationCreateDto.groupId) &&
        equalsNullable(this.resourceType, authorizationCreateDto.resourceType) &&
        equalsNullable(this.resourceId, authorizationCreateDto.resourceId);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(type), hashCodeNullable(permissions), hashCodeNullable(userId), hashCodeNullable(groupId), hashCodeNullable(resourceType), hashCodeNullable(resourceId));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizationCreateDto {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `permissions` to the URL query string
    if (getPermissions() != null) {
      for (int i = 0; i < getPermissions().size(); i++) {
        try {
          joiner.add(String.format("%spermissions%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getPermissions().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `userId` to the URL query string
    if (getUserId() != null) {
      try {
        joiner.add(String.format("%suserId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUserId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `groupId` to the URL query string
    if (getGroupId() != null) {
      try {
        joiner.add(String.format("%sgroupId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getGroupId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceType` to the URL query string
    if (getResourceType() != null) {
      try {
        joiner.add(String.format("%sresourceType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceId` to the URL query string
    if (getResourceId() != null) {
      try {
        joiner.add(String.format("%sresourceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

