/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * AuthorizationDto
 */
@JsonPropertyOrder({
  AuthorizationDto.JSON_PROPERTY_ID,
  AuthorizationDto.JSON_PROPERTY_TYPE,
  AuthorizationDto.JSON_PROPERTY_PERMISSIONS,
  AuthorizationDto.JSON_PROPERTY_USER_ID,
  AuthorizationDto.JSON_PROPERTY_GROUP_ID,
  AuthorizationDto.JSON_PROPERTY_RESOURCE_TYPE,
  AuthorizationDto.JSON_PROPERTY_RESOURCE_ID,
  AuthorizationDto.JSON_PROPERTY_REMOVAL_TIME,
  AuthorizationDto.JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class AuthorizationDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TYPE = "type";
  private JsonNullable<Integer> type = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
  private JsonNullable<List<String>> permissions = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_USER_ID = "userId";
  private JsonNullable<String> userId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_GROUP_ID = "groupId";
  private JsonNullable<String> groupId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
  private JsonNullable<Integer> resourceType = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_RESOURCE_ID = "resourceId";
  private JsonNullable<String> resourceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_REMOVAL_TIME = "removalTime";
  private JsonNullable<OffsetDateTime> removalTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
  private JsonNullable<String> rootProcessInstanceId = JsonNullable.<String>undefined();

  public AuthorizationDto() {
  }

  public AuthorizationDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the authorization.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public AuthorizationDto type(Integer type) {
    this.type = JsonNullable.<Integer>of(type);
    
    return this;
  }

   /**
   * The type of the authorization (0&#x3D;global, 1&#x3D;grant, 2&#x3D;revoke). See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service.md#authorization-type) for more information about authorization types.
   * @return type
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getType() {
        return type.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getType_JsonNullable() {
    return type;
  }
  
  @JsonProperty(JSON_PROPERTY_TYPE)
  public void setType_JsonNullable(JsonNullable<Integer> type) {
    this.type = type;
  }

  public void setType(Integer type) {
    this.type = JsonNullable.<Integer>of(type);
  }


  public AuthorizationDto permissions(List<String> permissions) {
    this.permissions = JsonNullable.<List<String>>of(permissions);
    
    return this;
  }

  public AuthorizationDto addPermissionsItem(String permissionsItem) {
    if (this.permissions == null || !this.permissions.isPresent()) {
      this.permissions = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.permissions.get().add(permissionsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array of Strings holding the permissions provided by this authorization.
   * @return permissions
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getPermissions() {
        return permissions.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PERMISSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getPermissions_JsonNullable() {
    return permissions;
  }
  
  @JsonProperty(JSON_PROPERTY_PERMISSIONS)
  public void setPermissions_JsonNullable(JsonNullable<List<String>> permissions) {
    this.permissions = permissions;
  }

  public void setPermissions(List<String> permissions) {
    this.permissions = JsonNullable.<List<String>>of(permissions);
  }


  public AuthorizationDto userId(String userId) {
    this.userId = JsonNullable.<String>of(userId);
    
    return this;
  }

   /**
   * The id of the user this authorization has been created for. The value &#x60;*&#x60; represents a global authorization ranging over all users.
   * @return userId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getUserId() {
        return userId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getUserId_JsonNullable() {
    return userId;
  }
  
  @JsonProperty(JSON_PROPERTY_USER_ID)
  public void setUserId_JsonNullable(JsonNullable<String> userId) {
    this.userId = userId;
  }

  public void setUserId(String userId) {
    this.userId = JsonNullable.<String>of(userId);
  }


  public AuthorizationDto groupId(String groupId) {
    this.groupId = JsonNullable.<String>of(groupId);
    
    return this;
  }

   /**
   * The id of the group this authorization has been created for.
   * @return groupId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getGroupId() {
        return groupId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_GROUP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getGroupId_JsonNullable() {
    return groupId;
  }
  
  @JsonProperty(JSON_PROPERTY_GROUP_ID)
  public void setGroupId_JsonNullable(JsonNullable<String> groupId) {
    this.groupId = groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = JsonNullable.<String>of(groupId);
  }


  public AuthorizationDto resourceType(Integer resourceType) {
    this.resourceType = JsonNullable.<Integer>of(resourceType);
    
    return this;
  }

   /**
   * An integer representing the resource type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types.
   * @return resourceType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getResourceType() {
        return resourceType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getResourceType_JsonNullable() {
    return resourceType;
  }
  
  @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
  public void setResourceType_JsonNullable(JsonNullable<Integer> resourceType) {
    this.resourceType = resourceType;
  }

  public void setResourceType(Integer resourceType) {
    this.resourceType = JsonNullable.<Integer>of(resourceType);
  }


  public AuthorizationDto resourceId(String resourceId) {
    this.resourceId = JsonNullable.<String>of(resourceId);
    
    return this;
  }

   /**
   * The resource Id. The value &#x60;*&#x60; represents an authorization ranging over all instances of a resource.
   * @return resourceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getResourceId() {
        return resourceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getResourceId_JsonNullable() {
    return resourceId;
  }
  
  @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
  public void setResourceId_JsonNullable(JsonNullable<String> resourceId) {
    this.resourceId = resourceId;
  }

  public void setResourceId(String resourceId) {
    this.resourceId = JsonNullable.<String>of(resourceId);
  }


  public AuthorizationDto removalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
    
    return this;
  }

   /**
   * The removal time indicates the date a historic instance authorization is cleaned up. A removal time can only be assigned to a historic instance authorization. Can be &#x60;null&#x60; when not related to a historic instance resource or when the removal time strategy is end and the root process instance is not finished. Default format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return removalTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getRemovalTime() {
        return removalTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getRemovalTime_JsonNullable() {
    return removalTime;
  }
  
  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  public void setRemovalTime_JsonNullable(JsonNullable<OffsetDateTime> removalTime) {
    this.removalTime = removalTime;
  }

  public void setRemovalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
  }


  public AuthorizationDto rootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
    
    return this;
  }

   /**
   * The process instance id of the root process instance the historic instance authorization is related to. Can be &#x60;null&#x60; if not related to a historic instance resource.
   * @return rootProcessInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRootProcessInstanceId() {
        return rootProcessInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRootProcessInstanceId_JsonNullable() {
    return rootProcessInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  public void setRootProcessInstanceId_JsonNullable(JsonNullable<String> rootProcessInstanceId) {
    this.rootProcessInstanceId = rootProcessInstanceId;
  }

  public void setRootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorizationDto authorizationDto = (AuthorizationDto) o;
    return equalsNullable(this.id, authorizationDto.id) &&
        equalsNullable(this.type, authorizationDto.type) &&
        equalsNullable(this.permissions, authorizationDto.permissions) &&
        equalsNullable(this.userId, authorizationDto.userId) &&
        equalsNullable(this.groupId, authorizationDto.groupId) &&
        equalsNullable(this.resourceType, authorizationDto.resourceType) &&
        equalsNullable(this.resourceId, authorizationDto.resourceId) &&
        equalsNullable(this.removalTime, authorizationDto.removalTime) &&
        equalsNullable(this.rootProcessInstanceId, authorizationDto.rootProcessInstanceId);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(type), hashCodeNullable(permissions), hashCodeNullable(userId), hashCodeNullable(groupId), hashCodeNullable(resourceType), hashCodeNullable(resourceId), hashCodeNullable(removalTime), hashCodeNullable(rootProcessInstanceId));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizationDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    removalTime: ").append(toIndentedString(removalTime)).append("\n");
    sb.append("    rootProcessInstanceId: ").append(toIndentedString(rootProcessInstanceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `permissions` to the URL query string
    if (getPermissions() != null) {
      for (int i = 0; i < getPermissions().size(); i++) {
        try {
          joiner.add(String.format("%spermissions%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getPermissions().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `userId` to the URL query string
    if (getUserId() != null) {
      try {
        joiner.add(String.format("%suserId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUserId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `groupId` to the URL query string
    if (getGroupId() != null) {
      try {
        joiner.add(String.format("%sgroupId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getGroupId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceType` to the URL query string
    if (getResourceType() != null) {
      try {
        joiner.add(String.format("%sresourceType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceId` to the URL query string
    if (getResourceId() != null) {
      try {
        joiner.add(String.format("%sresourceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `removalTime` to the URL query string
    if (getRemovalTime() != null) {
      try {
        joiner.add(String.format("%sremovalTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRemovalTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rootProcessInstanceId` to the URL query string
    if (getRootProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%srootProcessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRootProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

