/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CamundaFormRef
 */
@JsonPropertyOrder({
  CamundaFormRef.JSON_PROPERTY_KEY,
  CamundaFormRef.JSON_PROPERTY_BINDING,
  CamundaFormRef.JSON_PROPERTY_VERSION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class CamundaFormRef {
  public static final String JSON_PROPERTY_KEY = "key";
  private JsonNullable<String> key = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_BINDING = "binding";
  private JsonNullable<String> binding = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_VERSION = "version";
  private JsonNullable<Integer> version = JsonNullable.<Integer>undefined();

  public CamundaFormRef() {
  }

  public CamundaFormRef key(String key) {
    this.key = JsonNullable.<String>of(key);
    
    return this;
  }

   /**
   * The key of the Camunda Form.
   * @return key
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getKey() {
        return key.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getKey_JsonNullable() {
    return key;
  }
  
  @JsonProperty(JSON_PROPERTY_KEY)
  public void setKey_JsonNullable(JsonNullable<String> key) {
    this.key = key;
  }

  public void setKey(String key) {
    this.key = JsonNullable.<String>of(key);
  }


  public CamundaFormRef binding(String binding) {
    this.binding = JsonNullable.<String>of(binding);
    
    return this;
  }

   /**
   * The binding of the Camunda Form. Can be &#x60;latest&#x60;, &#x60;deployment&#x60; or &#x60;version&#x60;.
   * @return binding
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getBinding() {
        return binding.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_BINDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getBinding_JsonNullable() {
    return binding;
  }
  
  @JsonProperty(JSON_PROPERTY_BINDING)
  public void setBinding_JsonNullable(JsonNullable<String> binding) {
    this.binding = binding;
  }

  public void setBinding(String binding) {
    this.binding = JsonNullable.<String>of(binding);
  }


  public CamundaFormRef version(Integer version) {
    this.version = JsonNullable.<Integer>of(version);
    
    return this;
  }

   /**
   * The specific version of a Camunda Form. This property is only set if &#x60;binding&#x60; is &#x60;version&#x60;.
   * @return version
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getVersion() {
        return version.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getVersion_JsonNullable() {
    return version;
  }
  
  @JsonProperty(JSON_PROPERTY_VERSION)
  public void setVersion_JsonNullable(JsonNullable<Integer> version) {
    this.version = version;
  }

  public void setVersion(Integer version) {
    this.version = JsonNullable.<Integer>of(version);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CamundaFormRef camundaFormRef = (CamundaFormRef) o;
    return equalsNullable(this.key, camundaFormRef.key) &&
        equalsNullable(this.binding, camundaFormRef.binding) &&
        equalsNullable(this.version, camundaFormRef.version);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(key), hashCodeNullable(binding), hashCodeNullable(version));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CamundaFormRef {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    binding: ").append(toIndentedString(binding)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `key` to the URL query string
    if (getKey() != null) {
      try {
        joiner.add(String.format("%skey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `binding` to the URL query string
    if (getBinding() != null) {
      try {
        joiner.add(String.format("%sbinding%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBinding()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `version` to the URL query string
    if (getVersion() != null) {
      try {
        joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

