/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.PasswordPolicyRuleDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CheckPasswordPolicyResultDto
 */
@JsonPropertyOrder({
  CheckPasswordPolicyResultDto.JSON_PROPERTY_RULES,
  CheckPasswordPolicyResultDto.JSON_PROPERTY_VALID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class CheckPasswordPolicyResultDto {
  public static final String JSON_PROPERTY_RULES = "rules";
  private JsonNullable<List<PasswordPolicyRuleDto>> rules = JsonNullable.<List<PasswordPolicyRuleDto>>undefined();

  public static final String JSON_PROPERTY_VALID = "valid";
  private JsonNullable<Boolean> valid = JsonNullable.<Boolean>undefined();

  public CheckPasswordPolicyResultDto() {
  }

  public CheckPasswordPolicyResultDto rules(List<PasswordPolicyRuleDto> rules) {
    this.rules = JsonNullable.<List<PasswordPolicyRuleDto>>of(rules);
    
    return this;
  }

  public CheckPasswordPolicyResultDto addRulesItem(PasswordPolicyRuleDto rulesItem) {
    if (this.rules == null || !this.rules.isPresent()) {
      this.rules = JsonNullable.<List<PasswordPolicyRuleDto>>of(new ArrayList<>());
    }
    try {
      this.rules.get().add(rulesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array of password policy rules. Each element of the array is representing one rule of the policy.
   * @return rules
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<PasswordPolicyRuleDto> getRules() {
        return rules.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<PasswordPolicyRuleDto>> getRules_JsonNullable() {
    return rules;
  }
  
  @JsonProperty(JSON_PROPERTY_RULES)
  public void setRules_JsonNullable(JsonNullable<List<PasswordPolicyRuleDto>> rules) {
    this.rules = rules;
  }

  public void setRules(List<PasswordPolicyRuleDto> rules) {
    this.rules = JsonNullable.<List<PasswordPolicyRuleDto>>of(rules);
  }


  public CheckPasswordPolicyResultDto valid(Boolean valid) {
    this.valid = JsonNullable.<Boolean>of(valid);
    
    return this;
  }

   /**
   * &#x60;true&#x60; if the password is compliant with the policy, otherwise &#x60;false&#x60;.
   * @return valid
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getValid() {
        return valid.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VALID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getValid_JsonNullable() {
    return valid;
  }
  
  @JsonProperty(JSON_PROPERTY_VALID)
  public void setValid_JsonNullable(JsonNullable<Boolean> valid) {
    this.valid = valid;
  }

  public void setValid(Boolean valid) {
    this.valid = JsonNullable.<Boolean>of(valid);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CheckPasswordPolicyResultDto checkPasswordPolicyResultDto = (CheckPasswordPolicyResultDto) o;
    return equalsNullable(this.rules, checkPasswordPolicyResultDto.rules) &&
        equalsNullable(this.valid, checkPasswordPolicyResultDto.valid);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(rules), hashCodeNullable(valid));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CheckPasswordPolicyResultDto {\n");
    sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
    sb.append("    valid: ").append(toIndentedString(valid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `rules` to the URL query string
    if (getRules() != null) {
      for (int i = 0; i < getRules().size(); i++) {
        if (getRules().get(i) != null) {
          joiner.add(getRules().get(i).toUrlQueryString(String.format("%srules%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `valid` to the URL query string
    if (getValid() != null) {
      try {
        joiner.add(String.format("%svalid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getValid()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

