/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CorrelationMessageDto
 */
@JsonPropertyOrder({
  CorrelationMessageDto.JSON_PROPERTY_MESSAGE_NAME,
  CorrelationMessageDto.JSON_PROPERTY_BUSINESS_KEY,
  CorrelationMessageDto.JSON_PROPERTY_TENANT_ID,
  CorrelationMessageDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  CorrelationMessageDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  CorrelationMessageDto.JSON_PROPERTY_CORRELATION_KEYS,
  CorrelationMessageDto.JSON_PROPERTY_LOCAL_CORRELATION_KEYS,
  CorrelationMessageDto.JSON_PROPERTY_PROCESS_VARIABLES,
  CorrelationMessageDto.JSON_PROPERTY_PROCESS_VARIABLES_LOCAL,
  CorrelationMessageDto.JSON_PROPERTY_PROCESS_VARIABLES_TO_TRIGGERED_SCOPE,
  CorrelationMessageDto.JSON_PROPERTY_ALL,
  CorrelationMessageDto.JSON_PROPERTY_RESULT_ENABLED,
  CorrelationMessageDto.JSON_PROPERTY_VARIABLES_IN_RESULT_ENABLED
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class CorrelationMessageDto {
  public static final String JSON_PROPERTY_MESSAGE_NAME = "messageName";
  private JsonNullable<String> messageName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_BUSINESS_KEY = "businessKey";
  private JsonNullable<String> businessKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CORRELATION_KEYS = "correlationKeys";
  private JsonNullable<Map<String, VariableValueDto>> correlationKeys = JsonNullable.<Map<String, VariableValueDto>>undefined();

  public static final String JSON_PROPERTY_LOCAL_CORRELATION_KEYS = "localCorrelationKeys";
  private JsonNullable<Map<String, VariableValueDto>> localCorrelationKeys = JsonNullable.<Map<String, VariableValueDto>>undefined();

  public static final String JSON_PROPERTY_PROCESS_VARIABLES = "processVariables";
  private JsonNullable<Map<String, VariableValueDto>> processVariables = JsonNullable.<Map<String, VariableValueDto>>undefined();

  public static final String JSON_PROPERTY_PROCESS_VARIABLES_LOCAL = "processVariablesLocal";
  private JsonNullable<Map<String, VariableValueDto>> processVariablesLocal = JsonNullable.<Map<String, VariableValueDto>>undefined();

  public static final String JSON_PROPERTY_PROCESS_VARIABLES_TO_TRIGGERED_SCOPE = "processVariablesToTriggeredScope";
  private JsonNullable<Map<String, VariableValueDto>> processVariablesToTriggeredScope = JsonNullable.<Map<String, VariableValueDto>>undefined();

  public static final String JSON_PROPERTY_ALL = "all";
  private JsonNullable<Boolean> all = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_RESULT_ENABLED = "resultEnabled";
  private JsonNullable<Boolean> resultEnabled = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_VARIABLES_IN_RESULT_ENABLED = "variablesInResultEnabled";
  private JsonNullable<Boolean> variablesInResultEnabled = JsonNullable.<Boolean>of(false);

  public CorrelationMessageDto() {
  }

  public CorrelationMessageDto messageName(String messageName) {
    this.messageName = JsonNullable.<String>of(messageName);
    
    return this;
  }

   /**
   * The name of the message to deliver.
   * @return messageName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getMessageName() {
        return messageName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MESSAGE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getMessageName_JsonNullable() {
    return messageName;
  }
  
  @JsonProperty(JSON_PROPERTY_MESSAGE_NAME)
  public void setMessageName_JsonNullable(JsonNullable<String> messageName) {
    this.messageName = messageName;
  }

  public void setMessageName(String messageName) {
    this.messageName = JsonNullable.<String>of(messageName);
  }


  public CorrelationMessageDto businessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
    
    return this;
  }

   /**
   * Used for correlation of process instances that wait for incoming messages. Will only correlate to executions that belong to a process instance with the provided business key.
   * @return businessKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getBusinessKey() {
        return businessKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getBusinessKey_JsonNullable() {
    return businessKey;
  }
  
  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  public void setBusinessKey_JsonNullable(JsonNullable<String> businessKey) {
    this.businessKey = businessKey;
  }

  public void setBusinessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
  }


  public CorrelationMessageDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * Used to correlate the message for a tenant with the given id. Will only correlate to executions and process definitions which belong to the tenant. Must not be supplied in conjunction with a &#x60;withoutTenantId&#x60;.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public CorrelationMessageDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * A Boolean value that indicates whether the message should only be correlated to executions and process definitions which belong to no tenant or not. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. Must not be supplied in conjunction with a &#x60;tenantId&#x60;.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public CorrelationMessageDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * Used to correlate the message to the process instance with the given id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public CorrelationMessageDto correlationKeys(Map<String, VariableValueDto> correlationKeys) {
    this.correlationKeys = JsonNullable.<Map<String, VariableValueDto>>of(correlationKeys);
    
    return this;
  }

  public CorrelationMessageDto putCorrelationKeysItem(String key, VariableValueDto correlationKeysItem) {
    if (this.correlationKeys == null || !this.correlationKeys.isPresent()) {
      this.correlationKeys = JsonNullable.<Map<String, VariableValueDto>>of(new HashMap<>());
    }
    try {
      this.correlationKeys.get().put(key, correlationKeysItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Used for correlation of process instances that wait for incoming messages. Has to be a JSON object containing key-value pairs that are matched against process instance variables during correlation. Each key is a variable name and each value a JSON variable value object with the following properties.
   * @return correlationKeys
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, VariableValueDto> getCorrelationKeys() {
        return correlationKeys.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CORRELATION_KEYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, VariableValueDto>> getCorrelationKeys_JsonNullable() {
    return correlationKeys;
  }
  
  @JsonProperty(JSON_PROPERTY_CORRELATION_KEYS)
  public void setCorrelationKeys_JsonNullable(JsonNullable<Map<String, VariableValueDto>> correlationKeys) {
    this.correlationKeys = correlationKeys;
  }

  public void setCorrelationKeys(Map<String, VariableValueDto> correlationKeys) {
    this.correlationKeys = JsonNullable.<Map<String, VariableValueDto>>of(correlationKeys);
  }


  public CorrelationMessageDto localCorrelationKeys(Map<String, VariableValueDto> localCorrelationKeys) {
    this.localCorrelationKeys = JsonNullable.<Map<String, VariableValueDto>>of(localCorrelationKeys);
    
    return this;
  }

  public CorrelationMessageDto putLocalCorrelationKeysItem(String key, VariableValueDto localCorrelationKeysItem) {
    if (this.localCorrelationKeys == null || !this.localCorrelationKeys.isPresent()) {
      this.localCorrelationKeys = JsonNullable.<Map<String, VariableValueDto>>of(new HashMap<>());
    }
    try {
      this.localCorrelationKeys.get().put(key, localCorrelationKeysItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Local variables used for correlation of executions (process instances) that wait for incoming messages. Has to be a JSON object containing key-value pairs that are matched against local variables during correlation. Each key is a variable name and each value a JSON variable value object with the following properties.
   * @return localCorrelationKeys
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, VariableValueDto> getLocalCorrelationKeys() {
        return localCorrelationKeys.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LOCAL_CORRELATION_KEYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, VariableValueDto>> getLocalCorrelationKeys_JsonNullable() {
    return localCorrelationKeys;
  }
  
  @JsonProperty(JSON_PROPERTY_LOCAL_CORRELATION_KEYS)
  public void setLocalCorrelationKeys_JsonNullable(JsonNullable<Map<String, VariableValueDto>> localCorrelationKeys) {
    this.localCorrelationKeys = localCorrelationKeys;
  }

  public void setLocalCorrelationKeys(Map<String, VariableValueDto> localCorrelationKeys) {
    this.localCorrelationKeys = JsonNullable.<Map<String, VariableValueDto>>of(localCorrelationKeys);
  }


  public CorrelationMessageDto processVariables(Map<String, VariableValueDto> processVariables) {
    this.processVariables = JsonNullable.<Map<String, VariableValueDto>>of(processVariables);
    
    return this;
  }

  public CorrelationMessageDto putProcessVariablesItem(String key, VariableValueDto processVariablesItem) {
    if (this.processVariables == null || !this.processVariables.isPresent()) {
      this.processVariables = JsonNullable.<Map<String, VariableValueDto>>of(new HashMap<>());
    }
    try {
      this.processVariables.get().put(key, processVariablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A map of variables that is injected into the triggered execution or process instance after the message has been delivered. Each key is a variable name and each value a JSON variable value object with the following properties.
   * @return processVariables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, VariableValueDto> getProcessVariables() {
        return processVariables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, VariableValueDto>> getProcessVariables_JsonNullable() {
    return processVariables;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_VARIABLES)
  public void setProcessVariables_JsonNullable(JsonNullable<Map<String, VariableValueDto>> processVariables) {
    this.processVariables = processVariables;
  }

  public void setProcessVariables(Map<String, VariableValueDto> processVariables) {
    this.processVariables = JsonNullable.<Map<String, VariableValueDto>>of(processVariables);
  }


  public CorrelationMessageDto processVariablesLocal(Map<String, VariableValueDto> processVariablesLocal) {
    this.processVariablesLocal = JsonNullable.<Map<String, VariableValueDto>>of(processVariablesLocal);
    
    return this;
  }

  public CorrelationMessageDto putProcessVariablesLocalItem(String key, VariableValueDto processVariablesLocalItem) {
    if (this.processVariablesLocal == null || !this.processVariablesLocal.isPresent()) {
      this.processVariablesLocal = JsonNullable.<Map<String, VariableValueDto>>of(new HashMap<>());
    }
    try {
      this.processVariablesLocal.get().put(key, processVariablesLocalItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A map of local variables that is injected into the execution waiting on the message. Each key is a variable name and each value a JSON variable value object with the following properties.
   * @return processVariablesLocal
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, VariableValueDto> getProcessVariablesLocal() {
        return processVariablesLocal.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_VARIABLES_LOCAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, VariableValueDto>> getProcessVariablesLocal_JsonNullable() {
    return processVariablesLocal;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_VARIABLES_LOCAL)
  public void setProcessVariablesLocal_JsonNullable(JsonNullable<Map<String, VariableValueDto>> processVariablesLocal) {
    this.processVariablesLocal = processVariablesLocal;
  }

  public void setProcessVariablesLocal(Map<String, VariableValueDto> processVariablesLocal) {
    this.processVariablesLocal = JsonNullable.<Map<String, VariableValueDto>>of(processVariablesLocal);
  }


  public CorrelationMessageDto processVariablesToTriggeredScope(Map<String, VariableValueDto> processVariablesToTriggeredScope) {
    this.processVariablesToTriggeredScope = JsonNullable.<Map<String, VariableValueDto>>of(processVariablesToTriggeredScope);
    
    return this;
  }

  public CorrelationMessageDto putProcessVariablesToTriggeredScopeItem(String key, VariableValueDto processVariablesToTriggeredScopeItem) {
    if (this.processVariablesToTriggeredScope == null || !this.processVariablesToTriggeredScope.isPresent()) {
      this.processVariablesToTriggeredScope = JsonNullable.<Map<String, VariableValueDto>>of(new HashMap<>());
    }
    try {
      this.processVariablesToTriggeredScope.get().put(key, processVariablesToTriggeredScopeItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A map of variables that is injected into the new scope triggered by message correlation. Each key is a variable name and each value a JSON variable value object with the following properties.
   * @return processVariablesToTriggeredScope
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, VariableValueDto> getProcessVariablesToTriggeredScope() {
        return processVariablesToTriggeredScope.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_VARIABLES_TO_TRIGGERED_SCOPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, VariableValueDto>> getProcessVariablesToTriggeredScope_JsonNullable() {
    return processVariablesToTriggeredScope;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_VARIABLES_TO_TRIGGERED_SCOPE)
  public void setProcessVariablesToTriggeredScope_JsonNullable(JsonNullable<Map<String, VariableValueDto>> processVariablesToTriggeredScope) {
    this.processVariablesToTriggeredScope = processVariablesToTriggeredScope;
  }

  public void setProcessVariablesToTriggeredScope(Map<String, VariableValueDto> processVariablesToTriggeredScope) {
    this.processVariablesToTriggeredScope = JsonNullable.<Map<String, VariableValueDto>>of(processVariablesToTriggeredScope);
  }


  public CorrelationMessageDto all(Boolean all) {
    this.all = JsonNullable.<Boolean>of(all);
    
    return this;
  }

   /**
   * A Boolean value that indicates whether the message should be correlated to exactly one entity or multiple entities. If the value is set to &#x60;false&#x60;, the message will be correlated to exactly one entity (execution or process definition). If the value is set to &#x60;true&#x60;, the message will be correlated to multiple executions and a process definition that can be instantiated by this message in one go.
   * @return all
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getAll() {
        return all.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ALL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getAll_JsonNullable() {
    return all;
  }
  
  @JsonProperty(JSON_PROPERTY_ALL)
  public void setAll_JsonNullable(JsonNullable<Boolean> all) {
    this.all = all;
  }

  public void setAll(Boolean all) {
    this.all = JsonNullable.<Boolean>of(all);
  }


  public CorrelationMessageDto resultEnabled(Boolean resultEnabled) {
    this.resultEnabled = JsonNullable.<Boolean>of(resultEnabled);
    
    return this;
  }

   /**
   * A Boolean value that indicates whether the result of the correlation should be returned or not. If this property is set to &#x60;true&#x60;, there will be returned a list of message correlation result objects. Depending on the all property, there will be either one ore more returned results in the list.  The default value is &#x60;false&#x60;, which means no result will be returned.
   * @return resultEnabled
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getResultEnabled() {
        return resultEnabled.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESULT_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getResultEnabled_JsonNullable() {
    return resultEnabled;
  }
  
  @JsonProperty(JSON_PROPERTY_RESULT_ENABLED)
  public void setResultEnabled_JsonNullable(JsonNullable<Boolean> resultEnabled) {
    this.resultEnabled = resultEnabled;
  }

  public void setResultEnabled(Boolean resultEnabled) {
    this.resultEnabled = JsonNullable.<Boolean>of(resultEnabled);
  }


  public CorrelationMessageDto variablesInResultEnabled(Boolean variablesInResultEnabled) {
    this.variablesInResultEnabled = JsonNullable.<Boolean>of(variablesInResultEnabled);
    
    return this;
  }

   /**
   * A Boolean value that indicates whether the result of the correlation should contain process variables or not. The parameter resultEnabled should be set to &#x60;true&#x60; in order to use this it.  The default value is &#x60;false&#x60;, which means the variables will not be returned.
   * @return variablesInResultEnabled
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getVariablesInResultEnabled() {
        return variablesInResultEnabled.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLES_IN_RESULT_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getVariablesInResultEnabled_JsonNullable() {
    return variablesInResultEnabled;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLES_IN_RESULT_ENABLED)
  public void setVariablesInResultEnabled_JsonNullable(JsonNullable<Boolean> variablesInResultEnabled) {
    this.variablesInResultEnabled = variablesInResultEnabled;
  }

  public void setVariablesInResultEnabled(Boolean variablesInResultEnabled) {
    this.variablesInResultEnabled = JsonNullable.<Boolean>of(variablesInResultEnabled);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CorrelationMessageDto correlationMessageDto = (CorrelationMessageDto) o;
    return equalsNullable(this.messageName, correlationMessageDto.messageName) &&
        equalsNullable(this.businessKey, correlationMessageDto.businessKey) &&
        equalsNullable(this.tenantId, correlationMessageDto.tenantId) &&
        equalsNullable(this.withoutTenantId, correlationMessageDto.withoutTenantId) &&
        equalsNullable(this.processInstanceId, correlationMessageDto.processInstanceId) &&
        equalsNullable(this.correlationKeys, correlationMessageDto.correlationKeys) &&
        equalsNullable(this.localCorrelationKeys, correlationMessageDto.localCorrelationKeys) &&
        equalsNullable(this.processVariables, correlationMessageDto.processVariables) &&
        equalsNullable(this.processVariablesLocal, correlationMessageDto.processVariablesLocal) &&
        equalsNullable(this.processVariablesToTriggeredScope, correlationMessageDto.processVariablesToTriggeredScope) &&
        equalsNullable(this.all, correlationMessageDto.all) &&
        equalsNullable(this.resultEnabled, correlationMessageDto.resultEnabled) &&
        equalsNullable(this.variablesInResultEnabled, correlationMessageDto.variablesInResultEnabled);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(messageName), hashCodeNullable(businessKey), hashCodeNullable(tenantId), hashCodeNullable(withoutTenantId), hashCodeNullable(processInstanceId), hashCodeNullable(correlationKeys), hashCodeNullable(localCorrelationKeys), hashCodeNullable(processVariables), hashCodeNullable(processVariablesLocal), hashCodeNullable(processVariablesToTriggeredScope), hashCodeNullable(all), hashCodeNullable(resultEnabled), hashCodeNullable(variablesInResultEnabled));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CorrelationMessageDto {\n");
    sb.append("    messageName: ").append(toIndentedString(messageName)).append("\n");
    sb.append("    businessKey: ").append(toIndentedString(businessKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    correlationKeys: ").append(toIndentedString(correlationKeys)).append("\n");
    sb.append("    localCorrelationKeys: ").append(toIndentedString(localCorrelationKeys)).append("\n");
    sb.append("    processVariables: ").append(toIndentedString(processVariables)).append("\n");
    sb.append("    processVariablesLocal: ").append(toIndentedString(processVariablesLocal)).append("\n");
    sb.append("    processVariablesToTriggeredScope: ").append(toIndentedString(processVariablesToTriggeredScope)).append("\n");
    sb.append("    all: ").append(toIndentedString(all)).append("\n");
    sb.append("    resultEnabled: ").append(toIndentedString(resultEnabled)).append("\n");
    sb.append("    variablesInResultEnabled: ").append(toIndentedString(variablesInResultEnabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `messageName` to the URL query string
    if (getMessageName() != null) {
      try {
        joiner.add(String.format("%smessageName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMessageName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `businessKey` to the URL query string
    if (getBusinessKey() != null) {
      try {
        joiner.add(String.format("%sbusinessKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBusinessKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `correlationKeys` to the URL query string
    if (getCorrelationKeys() != null) {
      for (String _key : getCorrelationKeys().keySet()) {
        if (getCorrelationKeys().get(_key) != null) {
          joiner.add(getCorrelationKeys().get(_key).toUrlQueryString(String.format("%scorrelationKeys%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `localCorrelationKeys` to the URL query string
    if (getLocalCorrelationKeys() != null) {
      for (String _key : getLocalCorrelationKeys().keySet()) {
        if (getLocalCorrelationKeys().get(_key) != null) {
          joiner.add(getLocalCorrelationKeys().get(_key).toUrlQueryString(String.format("%slocalCorrelationKeys%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `processVariables` to the URL query string
    if (getProcessVariables() != null) {
      for (String _key : getProcessVariables().keySet()) {
        if (getProcessVariables().get(_key) != null) {
          joiner.add(getProcessVariables().get(_key).toUrlQueryString(String.format("%sprocessVariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `processVariablesLocal` to the URL query string
    if (getProcessVariablesLocal() != null) {
      for (String _key : getProcessVariablesLocal().keySet()) {
        if (getProcessVariablesLocal().get(_key) != null) {
          joiner.add(getProcessVariablesLocal().get(_key).toUrlQueryString(String.format("%sprocessVariablesLocal%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `processVariablesToTriggeredScope` to the URL query string
    if (getProcessVariablesToTriggeredScope() != null) {
      for (String _key : getProcessVariablesToTriggeredScope().keySet()) {
        if (getProcessVariablesToTriggeredScope().get(_key) != null) {
          joiner.add(getProcessVariablesToTriggeredScope().get(_key).toUrlQueryString(String.format("%sprocessVariablesToTriggeredScope%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `all` to the URL query string
    if (getAll() != null) {
      try {
        joiner.add(String.format("%sall%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAll()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resultEnabled` to the URL query string
    if (getResultEnabled() != null) {
      try {
        joiner.add(String.format("%sresultEnabled%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResultEnabled()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variablesInResultEnabled` to the URL query string
    if (getVariablesInResultEnabled() != null) {
      try {
        joiner.add(String.format("%svariablesInResultEnabled%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariablesInResultEnabled()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

