/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * DeleteProcessInstancesDto
 */
@JsonPropertyOrder({
  DeleteProcessInstancesDto.JSON_PROPERTY_PROCESS_INSTANCE_IDS,
  DeleteProcessInstancesDto.JSON_PROPERTY_DELETE_REASON,
  DeleteProcessInstancesDto.JSON_PROPERTY_SKIP_CUSTOM_LISTENERS,
  DeleteProcessInstancesDto.JSON_PROPERTY_SKIP_SUBPROCESSES,
  DeleteProcessInstancesDto.JSON_PROPERTY_SKIP_IO_MAPPINGS,
  DeleteProcessInstancesDto.JSON_PROPERTY_PROCESS_INSTANCE_QUERY,
  DeleteProcessInstancesDto.JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class DeleteProcessInstancesDto {
  public static final String JSON_PROPERTY_PROCESS_INSTANCE_IDS = "processInstanceIds";
  private JsonNullable<List<String>> processInstanceIds = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_DELETE_REASON = "deleteReason";
  private JsonNullable<String> deleteReason = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SKIP_CUSTOM_LISTENERS = "skipCustomListeners";
  private JsonNullable<Boolean> skipCustomListeners = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SKIP_SUBPROCESSES = "skipSubprocesses";
  private JsonNullable<Boolean> skipSubprocesses = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SKIP_IO_MAPPINGS = "skipIoMappings";
  private JsonNullable<Boolean> skipIoMappings = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_QUERY = "processInstanceQuery";
  private ProcessInstanceQueryDto processInstanceQuery;

  public static final String JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY = "historicProcessInstanceQuery";
  private HistoricProcessInstanceQueryDto historicProcessInstanceQuery;

  public DeleteProcessInstancesDto() {
  }

  public DeleteProcessInstancesDto processInstanceIds(List<String> processInstanceIds) {
    this.processInstanceIds = JsonNullable.<List<String>>of(processInstanceIds);
    
    return this;
  }

  public DeleteProcessInstancesDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
    if (this.processInstanceIds == null || !this.processInstanceIds.isPresent()) {
      this.processInstanceIds = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processInstanceIds.get().add(processInstanceIdsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A list process instance ids to delete.
   * @return processInstanceIds
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessInstanceIds() {
        return processInstanceIds.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessInstanceIds_JsonNullable() {
    return processInstanceIds;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_IDS)
  public void setProcessInstanceIds_JsonNullable(JsonNullable<List<String>> processInstanceIds) {
    this.processInstanceIds = processInstanceIds;
  }

  public void setProcessInstanceIds(List<String> processInstanceIds) {
    this.processInstanceIds = JsonNullable.<List<String>>of(processInstanceIds);
  }


  public DeleteProcessInstancesDto deleteReason(String deleteReason) {
    this.deleteReason = JsonNullable.<String>of(deleteReason);
    
    return this;
  }

   /**
   * A string with delete reason.
   * @return deleteReason
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDeleteReason() {
        return deleteReason.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DELETE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDeleteReason_JsonNullable() {
    return deleteReason;
  }
  
  @JsonProperty(JSON_PROPERTY_DELETE_REASON)
  public void setDeleteReason_JsonNullable(JsonNullable<String> deleteReason) {
    this.deleteReason = deleteReason;
  }

  public void setDeleteReason(String deleteReason) {
    this.deleteReason = JsonNullable.<String>of(deleteReason);
  }


  public DeleteProcessInstancesDto skipCustomListeners(Boolean skipCustomListeners) {
    this.skipCustomListeners = JsonNullable.<Boolean>of(skipCustomListeners);
    
    return this;
  }

   /**
   * Skip execution listener invocation for activities that are started or ended as part of this request.
   * @return skipCustomListeners
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSkipCustomListeners() {
        return skipCustomListeners.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SKIP_CUSTOM_LISTENERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSkipCustomListeners_JsonNullable() {
    return skipCustomListeners;
  }
  
  @JsonProperty(JSON_PROPERTY_SKIP_CUSTOM_LISTENERS)
  public void setSkipCustomListeners_JsonNullable(JsonNullable<Boolean> skipCustomListeners) {
    this.skipCustomListeners = skipCustomListeners;
  }

  public void setSkipCustomListeners(Boolean skipCustomListeners) {
    this.skipCustomListeners = JsonNullable.<Boolean>of(skipCustomListeners);
  }


  public DeleteProcessInstancesDto skipSubprocesses(Boolean skipSubprocesses) {
    this.skipSubprocesses = JsonNullable.<Boolean>of(skipSubprocesses);
    
    return this;
  }

   /**
   * Skip deletion of the subprocesses related to deleted processes as part of this request.
   * @return skipSubprocesses
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSkipSubprocesses() {
        return skipSubprocesses.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SKIP_SUBPROCESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSkipSubprocesses_JsonNullable() {
    return skipSubprocesses;
  }
  
  @JsonProperty(JSON_PROPERTY_SKIP_SUBPROCESSES)
  public void setSkipSubprocesses_JsonNullable(JsonNullable<Boolean> skipSubprocesses) {
    this.skipSubprocesses = skipSubprocesses;
  }

  public void setSkipSubprocesses(Boolean skipSubprocesses) {
    this.skipSubprocesses = JsonNullable.<Boolean>of(skipSubprocesses);
  }


  public DeleteProcessInstancesDto skipIoMappings(Boolean skipIoMappings) {
    this.skipIoMappings = JsonNullable.<Boolean>of(skipIoMappings);
    
    return this;
  }

   /**
   * Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.21/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started or ended as part of this request.
   * @return skipIoMappings
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSkipIoMappings() {
        return skipIoMappings.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SKIP_IO_MAPPINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSkipIoMappings_JsonNullable() {
    return skipIoMappings;
  }
  
  @JsonProperty(JSON_PROPERTY_SKIP_IO_MAPPINGS)
  public void setSkipIoMappings_JsonNullable(JsonNullable<Boolean> skipIoMappings) {
    this.skipIoMappings = skipIoMappings;
  }

  public void setSkipIoMappings(Boolean skipIoMappings) {
    this.skipIoMappings = JsonNullable.<Boolean>of(skipIoMappings);
  }


  public DeleteProcessInstancesDto processInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
    
    this.processInstanceQuery = processInstanceQuery;
    return this;
  }

   /**
   * Get processInstanceQuery
   * @return processInstanceQuery
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProcessInstanceQueryDto getProcessInstanceQuery() {
    return processInstanceQuery;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
    this.processInstanceQuery = processInstanceQuery;
  }


  public DeleteProcessInstancesDto historicProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
    
    this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    return this;
  }

   /**
   * Get historicProcessInstanceQuery
   * @return historicProcessInstanceQuery
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
    return historicProcessInstanceQuery;
  }


  @JsonProperty(JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
    this.historicProcessInstanceQuery = historicProcessInstanceQuery;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeleteProcessInstancesDto deleteProcessInstancesDto = (DeleteProcessInstancesDto) o;
    return equalsNullable(this.processInstanceIds, deleteProcessInstancesDto.processInstanceIds) &&
        equalsNullable(this.deleteReason, deleteProcessInstancesDto.deleteReason) &&
        equalsNullable(this.skipCustomListeners, deleteProcessInstancesDto.skipCustomListeners) &&
        equalsNullable(this.skipSubprocesses, deleteProcessInstancesDto.skipSubprocesses) &&
        equalsNullable(this.skipIoMappings, deleteProcessInstancesDto.skipIoMappings) &&
        Objects.equals(this.processInstanceQuery, deleteProcessInstancesDto.processInstanceQuery) &&
        Objects.equals(this.historicProcessInstanceQuery, deleteProcessInstancesDto.historicProcessInstanceQuery);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(processInstanceIds), hashCodeNullable(deleteReason), hashCodeNullable(skipCustomListeners), hashCodeNullable(skipSubprocesses), hashCodeNullable(skipIoMappings), processInstanceQuery, historicProcessInstanceQuery);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeleteProcessInstancesDto {\n");
    sb.append("    processInstanceIds: ").append(toIndentedString(processInstanceIds)).append("\n");
    sb.append("    deleteReason: ").append(toIndentedString(deleteReason)).append("\n");
    sb.append("    skipCustomListeners: ").append(toIndentedString(skipCustomListeners)).append("\n");
    sb.append("    skipSubprocesses: ").append(toIndentedString(skipSubprocesses)).append("\n");
    sb.append("    skipIoMappings: ").append(toIndentedString(skipIoMappings)).append("\n");
    sb.append("    processInstanceQuery: ").append(toIndentedString(processInstanceQuery)).append("\n");
    sb.append("    historicProcessInstanceQuery: ").append(toIndentedString(historicProcessInstanceQuery)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processInstanceIds` to the URL query string
    if (getProcessInstanceIds() != null) {
      for (int i = 0; i < getProcessInstanceIds().size(); i++) {
        try {
          joiner.add(String.format("%sprocessInstanceIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessInstanceIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `deleteReason` to the URL query string
    if (getDeleteReason() != null) {
      try {
        joiner.add(String.format("%sdeleteReason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeleteReason()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `skipCustomListeners` to the URL query string
    if (getSkipCustomListeners() != null) {
      try {
        joiner.add(String.format("%sskipCustomListeners%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSkipCustomListeners()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `skipSubprocesses` to the URL query string
    if (getSkipSubprocesses() != null) {
      try {
        joiner.add(String.format("%sskipSubprocesses%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSkipSubprocesses()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `skipIoMappings` to the URL query string
    if (getSkipIoMappings() != null) {
      try {
        joiner.add(String.format("%sskipIoMappings%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSkipIoMappings()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceQuery` to the URL query string
    if (getProcessInstanceQuery() != null) {
      joiner.add(getProcessInstanceQuery().toUrlQueryString(prefix + "processInstanceQuery" + suffix));
    }

    // add `historicProcessInstanceQuery` to the URL query string
    if (getHistoricProcessInstanceQuery() != null) {
      joiner.add(getHistoricProcessInstanceQuery().toUrlQueryString(prefix + "historicProcessInstanceQuery" + suffix));
    }

    return joiner.toString();
  }

}

