/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.community.rest.client.dto.AtomLink;
import org.camunda.community.rest.client.dto.CaseDefinitionDto;
import org.camunda.community.rest.client.dto.DecisionDefinitionDto;
import org.camunda.community.rest.client.dto.DecisionRequirementsDefinitionDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * DeploymentWithDefinitionsDto
 */
@JsonPropertyOrder({
  DeploymentWithDefinitionsDto.JSON_PROPERTY_ID,
  DeploymentWithDefinitionsDto.JSON_PROPERTY_TENANT_ID,
  DeploymentWithDefinitionsDto.JSON_PROPERTY_DEPLOYMENT_TIME,
  DeploymentWithDefinitionsDto.JSON_PROPERTY_SOURCE,
  DeploymentWithDefinitionsDto.JSON_PROPERTY_NAME,
  DeploymentWithDefinitionsDto.JSON_PROPERTY_LINKS,
  DeploymentWithDefinitionsDto.JSON_PROPERTY_DEPLOYED_PROCESS_DEFINITIONS,
  DeploymentWithDefinitionsDto.JSON_PROPERTY_DEPLOYED_DECISION_DEFINITIONS,
  DeploymentWithDefinitionsDto.JSON_PROPERTY_DEPLOYED_DECISION_REQUIREMENTS_DEFINITIONS,
  DeploymentWithDefinitionsDto.JSON_PROPERTY_DEPLOYED_CASE_DEFINITIONS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class DeploymentWithDefinitionsDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DEPLOYMENT_TIME = "deploymentTime";
  private JsonNullable<OffsetDateTime> deploymentTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_SOURCE = "source";
  private JsonNullable<String> source = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NAME = "name";
  private JsonNullable<String> name = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_LINKS = "links";
  private JsonNullable<List<AtomLink>> links = JsonNullable.<List<AtomLink>>undefined();

  public static final String JSON_PROPERTY_DEPLOYED_PROCESS_DEFINITIONS = "deployedProcessDefinitions";
  private JsonNullable<Map<String, ProcessDefinitionDto>> deployedProcessDefinitions = JsonNullable.<Map<String, ProcessDefinitionDto>>undefined();

  public static final String JSON_PROPERTY_DEPLOYED_DECISION_DEFINITIONS = "deployedDecisionDefinitions";
  private JsonNullable<Map<String, DecisionDefinitionDto>> deployedDecisionDefinitions = JsonNullable.<Map<String, DecisionDefinitionDto>>undefined();

  public static final String JSON_PROPERTY_DEPLOYED_DECISION_REQUIREMENTS_DEFINITIONS = "deployedDecisionRequirementsDefinitions";
  private JsonNullable<Map<String, DecisionRequirementsDefinitionDto>> deployedDecisionRequirementsDefinitions = JsonNullable.<Map<String, DecisionRequirementsDefinitionDto>>undefined();

  public static final String JSON_PROPERTY_DEPLOYED_CASE_DEFINITIONS = "deployedCaseDefinitions";
  private JsonNullable<Map<String, CaseDefinitionDto>> deployedCaseDefinitions = JsonNullable.<Map<String, CaseDefinitionDto>>undefined();

  public DeploymentWithDefinitionsDto() {
  }

  public DeploymentWithDefinitionsDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the deployment.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public DeploymentWithDefinitionsDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * The tenant id of the deployment.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public DeploymentWithDefinitionsDto deploymentTime(OffsetDateTime deploymentTime) {
    this.deploymentTime = JsonNullable.<OffsetDateTime>of(deploymentTime);
    
    return this;
  }

   /**
   * The time when the deployment was created.
   * @return deploymentTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getDeploymentTime() {
        return deploymentTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DEPLOYMENT_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getDeploymentTime_JsonNullable() {
    return deploymentTime;
  }
  
  @JsonProperty(JSON_PROPERTY_DEPLOYMENT_TIME)
  public void setDeploymentTime_JsonNullable(JsonNullable<OffsetDateTime> deploymentTime) {
    this.deploymentTime = deploymentTime;
  }

  public void setDeploymentTime(OffsetDateTime deploymentTime) {
    this.deploymentTime = JsonNullable.<OffsetDateTime>of(deploymentTime);
  }


  public DeploymentWithDefinitionsDto source(String source) {
    this.source = JsonNullable.<String>of(source);
    
    return this;
  }

   /**
   * The source of the deployment.
   * @return source
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getSource() {
        return source.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getSource_JsonNullable() {
    return source;
  }
  
  @JsonProperty(JSON_PROPERTY_SOURCE)
  public void setSource_JsonNullable(JsonNullable<String> source) {
    this.source = source;
  }

  public void setSource(String source) {
    this.source = JsonNullable.<String>of(source);
  }


  public DeploymentWithDefinitionsDto name(String name) {
    this.name = JsonNullable.<String>of(name);
    
    return this;
  }

   /**
   * The name of the deployment.
   * @return name
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getName() {
        return name.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getName_JsonNullable() {
    return name;
  }
  
  @JsonProperty(JSON_PROPERTY_NAME)
  public void setName_JsonNullable(JsonNullable<String> name) {
    this.name = name;
  }

  public void setName(String name) {
    this.name = JsonNullable.<String>of(name);
  }


  public DeploymentWithDefinitionsDto links(List<AtomLink> links) {
    this.links = JsonNullable.<List<AtomLink>>of(links);
    
    return this;
  }

  public DeploymentWithDefinitionsDto addLinksItem(AtomLink linksItem) {
    if (this.links == null || !this.links.isPresent()) {
      this.links = JsonNullable.<List<AtomLink>>of(new ArrayList<>());
    }
    try {
      this.links.get().add(linksItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The links associated to this resource, with &#x60;method&#x60;, &#x60;href&#x60; and &#x60;rel&#x60;.
   * @return links
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<AtomLink> getLinks() {
        return links.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<AtomLink>> getLinks_JsonNullable() {
    return links;
  }
  
  @JsonProperty(JSON_PROPERTY_LINKS)
  public void setLinks_JsonNullable(JsonNullable<List<AtomLink>> links) {
    this.links = links;
  }

  public void setLinks(List<AtomLink> links) {
    this.links = JsonNullable.<List<AtomLink>>of(links);
  }


  public DeploymentWithDefinitionsDto deployedProcessDefinitions(Map<String, ProcessDefinitionDto> deployedProcessDefinitions) {
    this.deployedProcessDefinitions = JsonNullable.<Map<String, ProcessDefinitionDto>>of(deployedProcessDefinitions);
    
    return this;
  }

  public DeploymentWithDefinitionsDto putDeployedProcessDefinitionsItem(String key, ProcessDefinitionDto deployedProcessDefinitionsItem) {
    if (this.deployedProcessDefinitions == null || !this.deployedProcessDefinitions.isPresent()) {
      this.deployedProcessDefinitions = JsonNullable.<Map<String, ProcessDefinitionDto>>of(new HashMap<>());
    }
    try {
      this.deployedProcessDefinitions.get().put(key, deployedProcessDefinitionsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON Object containing a property for each of the process definitions, which are successfully deployed with that deployment. The key is the process definition id, the value is a JSON Object corresponding to the process definition.
   * @return deployedProcessDefinitions
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, ProcessDefinitionDto> getDeployedProcessDefinitions() {
        return deployedProcessDefinitions.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DEPLOYED_PROCESS_DEFINITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, ProcessDefinitionDto>> getDeployedProcessDefinitions_JsonNullable() {
    return deployedProcessDefinitions;
  }
  
  @JsonProperty(JSON_PROPERTY_DEPLOYED_PROCESS_DEFINITIONS)
  public void setDeployedProcessDefinitions_JsonNullable(JsonNullable<Map<String, ProcessDefinitionDto>> deployedProcessDefinitions) {
    this.deployedProcessDefinitions = deployedProcessDefinitions;
  }

  public void setDeployedProcessDefinitions(Map<String, ProcessDefinitionDto> deployedProcessDefinitions) {
    this.deployedProcessDefinitions = JsonNullable.<Map<String, ProcessDefinitionDto>>of(deployedProcessDefinitions);
  }


  public DeploymentWithDefinitionsDto deployedDecisionDefinitions(Map<String, DecisionDefinitionDto> deployedDecisionDefinitions) {
    this.deployedDecisionDefinitions = JsonNullable.<Map<String, DecisionDefinitionDto>>of(deployedDecisionDefinitions);
    
    return this;
  }

  public DeploymentWithDefinitionsDto putDeployedDecisionDefinitionsItem(String key, DecisionDefinitionDto deployedDecisionDefinitionsItem) {
    if (this.deployedDecisionDefinitions == null || !this.deployedDecisionDefinitions.isPresent()) {
      this.deployedDecisionDefinitions = JsonNullable.<Map<String, DecisionDefinitionDto>>of(new HashMap<>());
    }
    try {
      this.deployedDecisionDefinitions.get().put(key, deployedDecisionDefinitionsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON Object containing a property for each of the decision definitions, which are successfully deployed with that deployment. The key is the decision definition id, the value is a JSON Object corresponding to the decision definition.
   * @return deployedDecisionDefinitions
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, DecisionDefinitionDto> getDeployedDecisionDefinitions() {
        return deployedDecisionDefinitions.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DEPLOYED_DECISION_DEFINITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, DecisionDefinitionDto>> getDeployedDecisionDefinitions_JsonNullable() {
    return deployedDecisionDefinitions;
  }
  
  @JsonProperty(JSON_PROPERTY_DEPLOYED_DECISION_DEFINITIONS)
  public void setDeployedDecisionDefinitions_JsonNullable(JsonNullable<Map<String, DecisionDefinitionDto>> deployedDecisionDefinitions) {
    this.deployedDecisionDefinitions = deployedDecisionDefinitions;
  }

  public void setDeployedDecisionDefinitions(Map<String, DecisionDefinitionDto> deployedDecisionDefinitions) {
    this.deployedDecisionDefinitions = JsonNullable.<Map<String, DecisionDefinitionDto>>of(deployedDecisionDefinitions);
  }


  public DeploymentWithDefinitionsDto deployedDecisionRequirementsDefinitions(Map<String, DecisionRequirementsDefinitionDto> deployedDecisionRequirementsDefinitions) {
    this.deployedDecisionRequirementsDefinitions = JsonNullable.<Map<String, DecisionRequirementsDefinitionDto>>of(deployedDecisionRequirementsDefinitions);
    
    return this;
  }

  public DeploymentWithDefinitionsDto putDeployedDecisionRequirementsDefinitionsItem(String key, DecisionRequirementsDefinitionDto deployedDecisionRequirementsDefinitionsItem) {
    if (this.deployedDecisionRequirementsDefinitions == null || !this.deployedDecisionRequirementsDefinitions.isPresent()) {
      this.deployedDecisionRequirementsDefinitions = JsonNullable.<Map<String, DecisionRequirementsDefinitionDto>>of(new HashMap<>());
    }
    try {
      this.deployedDecisionRequirementsDefinitions.get().put(key, deployedDecisionRequirementsDefinitionsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON Object containing a property for each of the decision requirements definitions, which are successfully deployed with that deployment. The key is the decision requirements definition id, the value is a JSON Object corresponding to the decision requirements definition.
   * @return deployedDecisionRequirementsDefinitions
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, DecisionRequirementsDefinitionDto> getDeployedDecisionRequirementsDefinitions() {
        return deployedDecisionRequirementsDefinitions.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DEPLOYED_DECISION_REQUIREMENTS_DEFINITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, DecisionRequirementsDefinitionDto>> getDeployedDecisionRequirementsDefinitions_JsonNullable() {
    return deployedDecisionRequirementsDefinitions;
  }
  
  @JsonProperty(JSON_PROPERTY_DEPLOYED_DECISION_REQUIREMENTS_DEFINITIONS)
  public void setDeployedDecisionRequirementsDefinitions_JsonNullable(JsonNullable<Map<String, DecisionRequirementsDefinitionDto>> deployedDecisionRequirementsDefinitions) {
    this.deployedDecisionRequirementsDefinitions = deployedDecisionRequirementsDefinitions;
  }

  public void setDeployedDecisionRequirementsDefinitions(Map<String, DecisionRequirementsDefinitionDto> deployedDecisionRequirementsDefinitions) {
    this.deployedDecisionRequirementsDefinitions = JsonNullable.<Map<String, DecisionRequirementsDefinitionDto>>of(deployedDecisionRequirementsDefinitions);
  }


  public DeploymentWithDefinitionsDto deployedCaseDefinitions(Map<String, CaseDefinitionDto> deployedCaseDefinitions) {
    this.deployedCaseDefinitions = JsonNullable.<Map<String, CaseDefinitionDto>>of(deployedCaseDefinitions);
    
    return this;
  }

  public DeploymentWithDefinitionsDto putDeployedCaseDefinitionsItem(String key, CaseDefinitionDto deployedCaseDefinitionsItem) {
    if (this.deployedCaseDefinitions == null || !this.deployedCaseDefinitions.isPresent()) {
      this.deployedCaseDefinitions = JsonNullable.<Map<String, CaseDefinitionDto>>of(new HashMap<>());
    }
    try {
      this.deployedCaseDefinitions.get().put(key, deployedCaseDefinitionsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON Object containing a property for each of the case definitions, which are successfully deployed with that deployment. The key is the case definition id, the value is a JSON Object corresponding to the case definition.
   * @return deployedCaseDefinitions
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, CaseDefinitionDto> getDeployedCaseDefinitions() {
        return deployedCaseDefinitions.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DEPLOYED_CASE_DEFINITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, CaseDefinitionDto>> getDeployedCaseDefinitions_JsonNullable() {
    return deployedCaseDefinitions;
  }
  
  @JsonProperty(JSON_PROPERTY_DEPLOYED_CASE_DEFINITIONS)
  public void setDeployedCaseDefinitions_JsonNullable(JsonNullable<Map<String, CaseDefinitionDto>> deployedCaseDefinitions) {
    this.deployedCaseDefinitions = deployedCaseDefinitions;
  }

  public void setDeployedCaseDefinitions(Map<String, CaseDefinitionDto> deployedCaseDefinitions) {
    this.deployedCaseDefinitions = JsonNullable.<Map<String, CaseDefinitionDto>>of(deployedCaseDefinitions);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentWithDefinitionsDto deploymentWithDefinitionsDto = (DeploymentWithDefinitionsDto) o;
    return equalsNullable(this.id, deploymentWithDefinitionsDto.id) &&
        equalsNullable(this.tenantId, deploymentWithDefinitionsDto.tenantId) &&
        equalsNullable(this.deploymentTime, deploymentWithDefinitionsDto.deploymentTime) &&
        equalsNullable(this.source, deploymentWithDefinitionsDto.source) &&
        equalsNullable(this.name, deploymentWithDefinitionsDto.name) &&
        equalsNullable(this.links, deploymentWithDefinitionsDto.links) &&
        equalsNullable(this.deployedProcessDefinitions, deploymentWithDefinitionsDto.deployedProcessDefinitions) &&
        equalsNullable(this.deployedDecisionDefinitions, deploymentWithDefinitionsDto.deployedDecisionDefinitions) &&
        equalsNullable(this.deployedDecisionRequirementsDefinitions, deploymentWithDefinitionsDto.deployedDecisionRequirementsDefinitions) &&
        equalsNullable(this.deployedCaseDefinitions, deploymentWithDefinitionsDto.deployedCaseDefinitions);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(tenantId), hashCodeNullable(deploymentTime), hashCodeNullable(source), hashCodeNullable(name), hashCodeNullable(links), hashCodeNullable(deployedProcessDefinitions), hashCodeNullable(deployedDecisionDefinitions), hashCodeNullable(deployedDecisionRequirementsDefinitions), hashCodeNullable(deployedCaseDefinitions));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentWithDefinitionsDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    deploymentTime: ").append(toIndentedString(deploymentTime)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    deployedProcessDefinitions: ").append(toIndentedString(deployedProcessDefinitions)).append("\n");
    sb.append("    deployedDecisionDefinitions: ").append(toIndentedString(deployedDecisionDefinitions)).append("\n");
    sb.append("    deployedDecisionRequirementsDefinitions: ").append(toIndentedString(deployedDecisionRequirementsDefinitions)).append("\n");
    sb.append("    deployedCaseDefinitions: ").append(toIndentedString(deployedCaseDefinitions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deploymentTime` to the URL query string
    if (getDeploymentTime() != null) {
      try {
        joiner.add(String.format("%sdeploymentTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeploymentTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `source` to the URL query string
    if (getSource() != null) {
      try {
        joiner.add(String.format("%ssource%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSource()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `links` to the URL query string
    if (getLinks() != null) {
      for (int i = 0; i < getLinks().size(); i++) {
        if (getLinks().get(i) != null) {
          joiner.add(getLinks().get(i).toUrlQueryString(String.format("%slinks%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `deployedProcessDefinitions` to the URL query string
    if (getDeployedProcessDefinitions() != null) {
      for (String _key : getDeployedProcessDefinitions().keySet()) {
        if (getDeployedProcessDefinitions().get(_key) != null) {
          joiner.add(getDeployedProcessDefinitions().get(_key).toUrlQueryString(String.format("%sdeployedProcessDefinitions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `deployedDecisionDefinitions` to the URL query string
    if (getDeployedDecisionDefinitions() != null) {
      for (String _key : getDeployedDecisionDefinitions().keySet()) {
        if (getDeployedDecisionDefinitions().get(_key) != null) {
          joiner.add(getDeployedDecisionDefinitions().get(_key).toUrlQueryString(String.format("%sdeployedDecisionDefinitions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `deployedDecisionRequirementsDefinitions` to the URL query string
    if (getDeployedDecisionRequirementsDefinitions() != null) {
      for (String _key : getDeployedDecisionRequirementsDefinitions().keySet()) {
        if (getDeployedDecisionRequirementsDefinitions().get(_key) != null) {
          joiner.add(getDeployedDecisionRequirementsDefinitions().get(_key).toUrlQueryString(String.format("%sdeployedDecisionRequirementsDefinitions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `deployedCaseDefinitions` to the URL query string
    if (getDeployedCaseDefinitions() != null) {
      for (String _key : getDeployedCaseDefinitions().keySet()) {
        if (getDeployedCaseDefinitions().get(_key) != null) {
          joiner.add(getDeployedCaseDefinitions().get(_key).toUrlQueryString(String.format("%sdeployedCaseDefinitions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

