/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * DurationReportResultDto
 */
@JsonPropertyOrder({
  DurationReportResultDto.JSON_PROPERTY_PERIOD,
  DurationReportResultDto.JSON_PROPERTY_PERIOD_UNIT,
  DurationReportResultDto.JSON_PROPERTY_MINIMUM,
  DurationReportResultDto.JSON_PROPERTY_MAXIMUM,
  DurationReportResultDto.JSON_PROPERTY_AVERAGE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class DurationReportResultDto {
  public static final String JSON_PROPERTY_PERIOD = "period";
  private JsonNullable<Integer> period = JsonNullable.<Integer>undefined();

  /**
   * The unit of the given period. Possible values are &#x60;MONTH&#x60; and &#x60;QUARTER&#x60;.
   */
  public enum PeriodUnitEnum {
    MONTH("MONTH"),
    
    QUARTER("QUARTER");

    private String value;

    PeriodUnitEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PeriodUnitEnum fromValue(String value) {
      for (PeriodUnitEnum b : PeriodUnitEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_PERIOD_UNIT = "periodUnit";
  private JsonNullable<PeriodUnitEnum> periodUnit = JsonNullable.<PeriodUnitEnum>undefined();

  public static final String JSON_PROPERTY_MINIMUM = "minimum";
  private JsonNullable<Long> minimum = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_MAXIMUM = "maximum";
  private JsonNullable<Long> maximum = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_AVERAGE = "average";
  private JsonNullable<Long> average = JsonNullable.<Long>undefined();

  public DurationReportResultDto() {
  }

  public DurationReportResultDto period(Integer period) {
    this.period = JsonNullable.<Integer>of(period);
    
    return this;
  }

   /**
   * Specifies a timespan within a year. **Note:** The period must be interpreted in conjunction with the returned &#x60;periodUnit&#x60;.
   * @return period
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getPeriod() {
        return period.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PERIOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getPeriod_JsonNullable() {
    return period;
  }
  
  @JsonProperty(JSON_PROPERTY_PERIOD)
  public void setPeriod_JsonNullable(JsonNullable<Integer> period) {
    this.period = period;
  }

  public void setPeriod(Integer period) {
    this.period = JsonNullable.<Integer>of(period);
  }


  public DurationReportResultDto periodUnit(PeriodUnitEnum periodUnit) {
    this.periodUnit = JsonNullable.<PeriodUnitEnum>of(periodUnit);
    
    return this;
  }

   /**
   * The unit of the given period. Possible values are &#x60;MONTH&#x60; and &#x60;QUARTER&#x60;.
   * @return periodUnit
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public PeriodUnitEnum getPeriodUnit() {
        return periodUnit.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PERIOD_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<PeriodUnitEnum> getPeriodUnit_JsonNullable() {
    return periodUnit;
  }
  
  @JsonProperty(JSON_PROPERTY_PERIOD_UNIT)
  public void setPeriodUnit_JsonNullable(JsonNullable<PeriodUnitEnum> periodUnit) {
    this.periodUnit = periodUnit;
  }

  public void setPeriodUnit(PeriodUnitEnum periodUnit) {
    this.periodUnit = JsonNullable.<PeriodUnitEnum>of(periodUnit);
  }


  public DurationReportResultDto minimum(Long minimum) {
    this.minimum = JsonNullable.<Long>of(minimum);
    
    return this;
  }

   /**
   * The smallest duration in milliseconds of all completed process instances which were started in the given period.
   * @return minimum
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getMinimum() {
        return minimum.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MINIMUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getMinimum_JsonNullable() {
    return minimum;
  }
  
  @JsonProperty(JSON_PROPERTY_MINIMUM)
  public void setMinimum_JsonNullable(JsonNullable<Long> minimum) {
    this.minimum = minimum;
  }

  public void setMinimum(Long minimum) {
    this.minimum = JsonNullable.<Long>of(minimum);
  }


  public DurationReportResultDto maximum(Long maximum) {
    this.maximum = JsonNullable.<Long>of(maximum);
    
    return this;
  }

   /**
   * The greatest duration in milliseconds of all completed process instances which were started in the given period.
   * @return maximum
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getMaximum() {
        return maximum.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MAXIMUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getMaximum_JsonNullable() {
    return maximum;
  }
  
  @JsonProperty(JSON_PROPERTY_MAXIMUM)
  public void setMaximum_JsonNullable(JsonNullable<Long> maximum) {
    this.maximum = maximum;
  }

  public void setMaximum(Long maximum) {
    this.maximum = JsonNullable.<Long>of(maximum);
  }


  public DurationReportResultDto average(Long average) {
    this.average = JsonNullable.<Long>of(average);
    
    return this;
  }

   /**
   * The average duration in milliseconds of all completed process instances which were started in the given period.
   * @return average
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getAverage() {
        return average.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_AVERAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getAverage_JsonNullable() {
    return average;
  }
  
  @JsonProperty(JSON_PROPERTY_AVERAGE)
  public void setAverage_JsonNullable(JsonNullable<Long> average) {
    this.average = average;
  }

  public void setAverage(Long average) {
    this.average = JsonNullable.<Long>of(average);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DurationReportResultDto durationReportResultDto = (DurationReportResultDto) o;
    return equalsNullable(this.period, durationReportResultDto.period) &&
        equalsNullable(this.periodUnit, durationReportResultDto.periodUnit) &&
        equalsNullable(this.minimum, durationReportResultDto.minimum) &&
        equalsNullable(this.maximum, durationReportResultDto.maximum) &&
        equalsNullable(this.average, durationReportResultDto.average);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(period), hashCodeNullable(periodUnit), hashCodeNullable(minimum), hashCodeNullable(maximum), hashCodeNullable(average));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DurationReportResultDto {\n");
    sb.append("    period: ").append(toIndentedString(period)).append("\n");
    sb.append("    periodUnit: ").append(toIndentedString(periodUnit)).append("\n");
    sb.append("    minimum: ").append(toIndentedString(minimum)).append("\n");
    sb.append("    maximum: ").append(toIndentedString(maximum)).append("\n");
    sb.append("    average: ").append(toIndentedString(average)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `period` to the URL query string
    if (getPeriod() != null) {
      try {
        joiner.add(String.format("%speriod%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPeriod()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `periodUnit` to the URL query string
    if (getPeriodUnit() != null) {
      try {
        joiner.add(String.format("%speriodUnit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPeriodUnit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `minimum` to the URL query string
    if (getMinimum() != null) {
      try {
        joiner.add(String.format("%sminimum%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMinimum()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `maximum` to the URL query string
    if (getMaximum() != null) {
      try {
        joiner.add(String.format("%smaximum%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMaximum()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `average` to the URL query string
    if (getAverage() != null) {
      try {
        joiner.add(String.format("%saverage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAverage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

