/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * EvaluationConditionDto
 */
@JsonPropertyOrder({
  EvaluationConditionDto.JSON_PROPERTY_VARIABLES,
  EvaluationConditionDto.JSON_PROPERTY_BUSINESS_KEY,
  EvaluationConditionDto.JSON_PROPERTY_TENANT_ID,
  EvaluationConditionDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  EvaluationConditionDto.JSON_PROPERTY_PROCESS_DEFINITION_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class EvaluationConditionDto {
  public static final String JSON_PROPERTY_VARIABLES = "variables";
  private JsonNullable<Map<String, VariableValueDto>> variables = JsonNullable.<Map<String, VariableValueDto>>undefined();

  public static final String JSON_PROPERTY_BUSINESS_KEY = "businessKey";
  private JsonNullable<String> businessKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public EvaluationConditionDto() {
  }

  public EvaluationConditionDto variables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
    
    return this;
  }

  public EvaluationConditionDto putVariablesItem(String key, VariableValueDto variablesItem) {
    if (this.variables == null || !this.variables.isPresent()) {
      this.variables = JsonNullable.<Map<String, VariableValueDto>>of(new HashMap<>());
    }
    try {
      this.variables.get().put(key, variablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A map of variables which are used for evaluation of the conditions and are injected into the process instances which have been triggered. Each key is a variable name and each value a JSON variable value object with the following properties.
   * @return variables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, VariableValueDto> getVariables() {
        return variables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, VariableValueDto>> getVariables_JsonNullable() {
    return variables;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  public void setVariables_JsonNullable(JsonNullable<Map<String, VariableValueDto>> variables) {
    this.variables = variables;
  }

  public void setVariables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
  }


  public EvaluationConditionDto businessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
    
    return this;
  }

   /**
   * Used for the process instances that have been triggered after the evaluation.
   * @return businessKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getBusinessKey() {
        return businessKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getBusinessKey_JsonNullable() {
    return businessKey;
  }
  
  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  public void setBusinessKey_JsonNullable(JsonNullable<String> businessKey) {
    this.businessKey = businessKey;
  }

  public void setBusinessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
  }


  public EvaluationConditionDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * Used to evaluate a condition for a tenant with the given id. Will only evaluate conditions of process definitions which belong to the tenant.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public EvaluationConditionDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * A Boolean value that indicates whether the conditions should only be evaluated of process definitions which belong to no tenant or not. Value may only be true, as false is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public EvaluationConditionDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * Used to evaluate conditions of the process definition with the given id.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EvaluationConditionDto evaluationConditionDto = (EvaluationConditionDto) o;
    return equalsNullable(this.variables, evaluationConditionDto.variables) &&
        equalsNullable(this.businessKey, evaluationConditionDto.businessKey) &&
        equalsNullable(this.tenantId, evaluationConditionDto.tenantId) &&
        equalsNullable(this.withoutTenantId, evaluationConditionDto.withoutTenantId) &&
        equalsNullable(this.processDefinitionId, evaluationConditionDto.processDefinitionId);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(variables), hashCodeNullable(businessKey), hashCodeNullable(tenantId), hashCodeNullable(withoutTenantId), hashCodeNullable(processDefinitionId));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EvaluationConditionDto {\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    businessKey: ").append(toIndentedString(businessKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (String _key : getVariables().keySet()) {
        if (getVariables().get(_key) != null) {
          joiner.add(getVariables().get(_key).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `businessKey` to the URL query string
    if (getBusinessKey() != null) {
      try {
        joiner.add(String.format("%sbusinessKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBusinessKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

