/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.EventSubscriptionQueryDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A event subscription query which retrieves a list of event subscriptions
 */
@JsonPropertyOrder({
  EventSubscriptionQueryDto.JSON_PROPERTY_EVENT_SUBSCRIPTION_ID,
  EventSubscriptionQueryDto.JSON_PROPERTY_EVENT_NAME,
  EventSubscriptionQueryDto.JSON_PROPERTY_EVENT_TYPE,
  EventSubscriptionQueryDto.JSON_PROPERTY_EXECUTION_ID,
  EventSubscriptionQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  EventSubscriptionQueryDto.JSON_PROPERTY_ACTIVITY_ID,
  EventSubscriptionQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  EventSubscriptionQueryDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  EventSubscriptionQueryDto.JSON_PROPERTY_INCLUDE_EVENT_SUBSCRIPTIONS_WITHOUT_TENANT_ID,
  EventSubscriptionQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class EventSubscriptionQueryDto {
  public static final String JSON_PROPERTY_EVENT_SUBSCRIPTION_ID = "eventSubscriptionId";
  private JsonNullable<String> eventSubscriptionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EVENT_NAME = "eventName";
  private JsonNullable<String> eventName = JsonNullable.<String>undefined();

  /**
   * The type of the event subscription.
   */
  public enum EventTypeEnum {
    MESSAGE("message"),
    
    SIGNAL("signal"),
    
    COMPENSATE("compensate"),
    
    CONDITIONAL("conditional");

    private String value;

    EventTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EventTypeEnum fromValue(String value) {
      for (EventTypeEnum b : EventTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
  private JsonNullable<EventTypeEnum> eventType = JsonNullable.<EventTypeEnum>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_INCLUDE_EVENT_SUBSCRIPTIONS_WITHOUT_TENANT_ID = "includeEventSubscriptionsWithoutTenantId";
  private JsonNullable<Boolean> includeEventSubscriptionsWithoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<EventSubscriptionQueryDtoSortingInner>> sorting = JsonNullable.<List<EventSubscriptionQueryDtoSortingInner>>undefined();

  public EventSubscriptionQueryDto() {
  }

  public EventSubscriptionQueryDto eventSubscriptionId(String eventSubscriptionId) {
    this.eventSubscriptionId = JsonNullable.<String>of(eventSubscriptionId);
    
    return this;
  }

   /**
   * The id of the event subscription.
   * @return eventSubscriptionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getEventSubscriptionId() {
        return eventSubscriptionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EVENT_SUBSCRIPTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getEventSubscriptionId_JsonNullable() {
    return eventSubscriptionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EVENT_SUBSCRIPTION_ID)
  public void setEventSubscriptionId_JsonNullable(JsonNullable<String> eventSubscriptionId) {
    this.eventSubscriptionId = eventSubscriptionId;
  }

  public void setEventSubscriptionId(String eventSubscriptionId) {
    this.eventSubscriptionId = JsonNullable.<String>of(eventSubscriptionId);
  }


  public EventSubscriptionQueryDto eventName(String eventName) {
    this.eventName = JsonNullable.<String>of(eventName);
    
    return this;
  }

   /**
   * The name of the event this subscription belongs to as defined in the process model.
   * @return eventName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getEventName() {
        return eventName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EVENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getEventName_JsonNullable() {
    return eventName;
  }
  
  @JsonProperty(JSON_PROPERTY_EVENT_NAME)
  public void setEventName_JsonNullable(JsonNullable<String> eventName) {
    this.eventName = eventName;
  }

  public void setEventName(String eventName) {
    this.eventName = JsonNullable.<String>of(eventName);
  }


  public EventSubscriptionQueryDto eventType(EventTypeEnum eventType) {
    this.eventType = JsonNullable.<EventTypeEnum>of(eventType);
    
    return this;
  }

   /**
   * The type of the event subscription.
   * @return eventType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public EventTypeEnum getEventType() {
        return eventType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<EventTypeEnum> getEventType_JsonNullable() {
    return eventType;
  }
  
  @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
  public void setEventType_JsonNullable(JsonNullable<EventTypeEnum> eventType) {
    this.eventType = eventType;
  }

  public void setEventType(EventTypeEnum eventType) {
    this.eventType = JsonNullable.<EventTypeEnum>of(eventType);
  }


  public EventSubscriptionQueryDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * The execution that is subscribed on the referenced event.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public EventSubscriptionQueryDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * The process instance this subscription belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public EventSubscriptionQueryDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * The identifier of the activity that this event subscription belongs to. This could for example be the id of a receive task.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public EventSubscriptionQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public EventSubscriptionQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by a comma-separated list of tenant ids. Only select subscriptions that belong to one of the given tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public EventSubscriptionQueryDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * Only select subscriptions which have no tenant id. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public EventSubscriptionQueryDto includeEventSubscriptionsWithoutTenantId(Boolean includeEventSubscriptionsWithoutTenantId) {
    this.includeEventSubscriptionsWithoutTenantId = JsonNullable.<Boolean>of(includeEventSubscriptionsWithoutTenantId);
    
    return this;
  }

   /**
   * Select event subscriptions which have no tenant id. Can be used in combination with tenantIdIn parameter. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return includeEventSubscriptionsWithoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getIncludeEventSubscriptionsWithoutTenantId() {
        return includeEventSubscriptionsWithoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCLUDE_EVENT_SUBSCRIPTIONS_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getIncludeEventSubscriptionsWithoutTenantId_JsonNullable() {
    return includeEventSubscriptionsWithoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_INCLUDE_EVENT_SUBSCRIPTIONS_WITHOUT_TENANT_ID)
  public void setIncludeEventSubscriptionsWithoutTenantId_JsonNullable(JsonNullable<Boolean> includeEventSubscriptionsWithoutTenantId) {
    this.includeEventSubscriptionsWithoutTenantId = includeEventSubscriptionsWithoutTenantId;
  }

  public void setIncludeEventSubscriptionsWithoutTenantId(Boolean includeEventSubscriptionsWithoutTenantId) {
    this.includeEventSubscriptionsWithoutTenantId = JsonNullable.<Boolean>of(includeEventSubscriptionsWithoutTenantId);
  }


  public EventSubscriptionQueryDto sorting(List<EventSubscriptionQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<EventSubscriptionQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public EventSubscriptionQueryDto addSortingItem(EventSubscriptionQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<EventSubscriptionQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Apply sorting of the result
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<EventSubscriptionQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<EventSubscriptionQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<EventSubscriptionQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<EventSubscriptionQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<EventSubscriptionQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EventSubscriptionQueryDto eventSubscriptionQueryDto = (EventSubscriptionQueryDto) o;
    return equalsNullable(this.eventSubscriptionId, eventSubscriptionQueryDto.eventSubscriptionId) &&
        equalsNullable(this.eventName, eventSubscriptionQueryDto.eventName) &&
        equalsNullable(this.eventType, eventSubscriptionQueryDto.eventType) &&
        equalsNullable(this.executionId, eventSubscriptionQueryDto.executionId) &&
        equalsNullable(this.processInstanceId, eventSubscriptionQueryDto.processInstanceId) &&
        equalsNullable(this.activityId, eventSubscriptionQueryDto.activityId) &&
        equalsNullable(this.tenantIdIn, eventSubscriptionQueryDto.tenantIdIn) &&
        equalsNullable(this.withoutTenantId, eventSubscriptionQueryDto.withoutTenantId) &&
        equalsNullable(this.includeEventSubscriptionsWithoutTenantId, eventSubscriptionQueryDto.includeEventSubscriptionsWithoutTenantId) &&
        equalsNullable(this.sorting, eventSubscriptionQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(eventSubscriptionId), hashCodeNullable(eventName), hashCodeNullable(eventType), hashCodeNullable(executionId), hashCodeNullable(processInstanceId), hashCodeNullable(activityId), hashCodeNullable(tenantIdIn), hashCodeNullable(withoutTenantId), hashCodeNullable(includeEventSubscriptionsWithoutTenantId), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EventSubscriptionQueryDto {\n");
    sb.append("    eventSubscriptionId: ").append(toIndentedString(eventSubscriptionId)).append("\n");
    sb.append("    eventName: ").append(toIndentedString(eventName)).append("\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    includeEventSubscriptionsWithoutTenantId: ").append(toIndentedString(includeEventSubscriptionsWithoutTenantId)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `eventSubscriptionId` to the URL query string
    if (getEventSubscriptionId() != null) {
      try {
        joiner.add(String.format("%seventSubscriptionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEventSubscriptionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `eventName` to the URL query string
    if (getEventName() != null) {
      try {
        joiner.add(String.format("%seventName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEventName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `eventType` to the URL query string
    if (getEventType() != null) {
      try {
        joiner.add(String.format("%seventType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEventType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `includeEventSubscriptionsWithoutTenantId` to the URL query string
    if (getIncludeEventSubscriptionsWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%sincludeEventSubscriptionsWithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncludeEventSubscriptionsWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

