/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.ExecutionQueryDtoSortingInner;
import org.camunda.community.rest.client.dto.VariableQueryParameterDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A Execution instance query which defines a list of Execution instances
 */
@JsonPropertyOrder({
  ExecutionQueryDto.JSON_PROPERTY_BUSINESS_KEY,
  ExecutionQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ExecutionQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  ExecutionQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  ExecutionQueryDto.JSON_PROPERTY_ACTIVITY_ID,
  ExecutionQueryDto.JSON_PROPERTY_SIGNAL_EVENT_SUBSCRIPTION_NAME,
  ExecutionQueryDto.JSON_PROPERTY_MESSAGE_EVENT_SUBSCRIPTION_NAME,
  ExecutionQueryDto.JSON_PROPERTY_ACTIVE,
  ExecutionQueryDto.JSON_PROPERTY_SUSPENDED,
  ExecutionQueryDto.JSON_PROPERTY_INCIDENT_ID,
  ExecutionQueryDto.JSON_PROPERTY_INCIDENT_TYPE,
  ExecutionQueryDto.JSON_PROPERTY_INCIDENT_MESSAGE,
  ExecutionQueryDto.JSON_PROPERTY_INCIDENT_MESSAGE_LIKE,
  ExecutionQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  ExecutionQueryDto.JSON_PROPERTY_VARIABLES,
  ExecutionQueryDto.JSON_PROPERTY_PROCESS_VARIABLES,
  ExecutionQueryDto.JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE,
  ExecutionQueryDto.JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE,
  ExecutionQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class ExecutionQueryDto {
  public static final String JSON_PROPERTY_BUSINESS_KEY = "businessKey";
  private JsonNullable<String> businessKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SIGNAL_EVENT_SUBSCRIPTION_NAME = "signalEventSubscriptionName";
  private JsonNullable<String> signalEventSubscriptionName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_MESSAGE_EVENT_SUBSCRIPTION_NAME = "messageEventSubscriptionName";
  private JsonNullable<String> messageEventSubscriptionName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private JsonNullable<Boolean> active = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SUSPENDED = "suspended";
  private JsonNullable<Boolean> suspended = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_INCIDENT_ID = "incidentId";
  private JsonNullable<String> incidentId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_INCIDENT_TYPE = "incidentType";
  private JsonNullable<String> incidentType = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_INCIDENT_MESSAGE = "incidentMessage";
  private JsonNullable<String> incidentMessage = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_INCIDENT_MESSAGE_LIKE = "incidentMessageLike";
  private JsonNullable<String> incidentMessageLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  private JsonNullable<List<VariableQueryParameterDto>> variables = JsonNullable.<List<VariableQueryParameterDto>>undefined();

  public static final String JSON_PROPERTY_PROCESS_VARIABLES = "processVariables";
  private JsonNullable<List<VariableQueryParameterDto>> processVariables = JsonNullable.<List<VariableQueryParameterDto>>undefined();

  public static final String JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
  private JsonNullable<Boolean> variableNamesIgnoreCase = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
  private JsonNullable<Boolean> variableValuesIgnoreCase = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<ExecutionQueryDtoSortingInner>> sorting = JsonNullable.<List<ExecutionQueryDtoSortingInner>>undefined();

  public ExecutionQueryDto() {
  }

  public ExecutionQueryDto businessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
    
    return this;
  }

   /**
   * Filter by the business key of the process instances the executions belong to.
   * @return businessKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getBusinessKey() {
        return businessKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getBusinessKey_JsonNullable() {
    return businessKey;
  }
  
  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  public void setBusinessKey_JsonNullable(JsonNullable<String> businessKey) {
    this.businessKey = businessKey;
  }

  public void setBusinessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
  }


  public ExecutionQueryDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * Filter by the process definition the executions run on.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public ExecutionQueryDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * Filter by the key of the process definition the executions run on.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public ExecutionQueryDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * Filter by the id of the process instance the execution belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public ExecutionQueryDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * Filter by the id of the activity the execution currently executes.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public ExecutionQueryDto signalEventSubscriptionName(String signalEventSubscriptionName) {
    this.signalEventSubscriptionName = JsonNullable.<String>of(signalEventSubscriptionName);
    
    return this;
  }

   /**
   * Select only those executions that expect a signal of the given name.
   * @return signalEventSubscriptionName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getSignalEventSubscriptionName() {
        return signalEventSubscriptionName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SIGNAL_EVENT_SUBSCRIPTION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getSignalEventSubscriptionName_JsonNullable() {
    return signalEventSubscriptionName;
  }
  
  @JsonProperty(JSON_PROPERTY_SIGNAL_EVENT_SUBSCRIPTION_NAME)
  public void setSignalEventSubscriptionName_JsonNullable(JsonNullable<String> signalEventSubscriptionName) {
    this.signalEventSubscriptionName = signalEventSubscriptionName;
  }

  public void setSignalEventSubscriptionName(String signalEventSubscriptionName) {
    this.signalEventSubscriptionName = JsonNullable.<String>of(signalEventSubscriptionName);
  }


  public ExecutionQueryDto messageEventSubscriptionName(String messageEventSubscriptionName) {
    this.messageEventSubscriptionName = JsonNullable.<String>of(messageEventSubscriptionName);
    
    return this;
  }

   /**
   * Select only those executions that expect a message of the given name.
   * @return messageEventSubscriptionName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getMessageEventSubscriptionName() {
        return messageEventSubscriptionName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MESSAGE_EVENT_SUBSCRIPTION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getMessageEventSubscriptionName_JsonNullable() {
    return messageEventSubscriptionName;
  }
  
  @JsonProperty(JSON_PROPERTY_MESSAGE_EVENT_SUBSCRIPTION_NAME)
  public void setMessageEventSubscriptionName_JsonNullable(JsonNullable<String> messageEventSubscriptionName) {
    this.messageEventSubscriptionName = messageEventSubscriptionName;
  }

  public void setMessageEventSubscriptionName(String messageEventSubscriptionName) {
    this.messageEventSubscriptionName = JsonNullable.<String>of(messageEventSubscriptionName);
  }


  public ExecutionQueryDto active(Boolean active) {
    this.active = JsonNullable.<Boolean>of(active);
    
    return this;
  }

   /**
   * Only include active executions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return active
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getActive() {
        return active.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getActive_JsonNullable() {
    return active;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  public void setActive_JsonNullable(JsonNullable<Boolean> active) {
    this.active = active;
  }

  public void setActive(Boolean active) {
    this.active = JsonNullable.<Boolean>of(active);
  }


  public ExecutionQueryDto suspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
    
    return this;
  }

   /**
   * Only include suspended executions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuspended() {
        return suspended.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuspended_JsonNullable() {
    return suspended;
  }
  
  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  public void setSuspended_JsonNullable(JsonNullable<Boolean> suspended) {
    this.suspended = suspended;
  }

  public void setSuspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
  }


  public ExecutionQueryDto incidentId(String incidentId) {
    this.incidentId = JsonNullable.<String>of(incidentId);
    
    return this;
  }

   /**
   * Filter by the incident id.
   * @return incidentId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getIncidentId() {
        return incidentId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCIDENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getIncidentId_JsonNullable() {
    return incidentId;
  }
  
  @JsonProperty(JSON_PROPERTY_INCIDENT_ID)
  public void setIncidentId_JsonNullable(JsonNullable<String> incidentId) {
    this.incidentId = incidentId;
  }

  public void setIncidentId(String incidentId) {
    this.incidentId = JsonNullable.<String>of(incidentId);
  }


  public ExecutionQueryDto incidentType(String incidentType) {
    this.incidentType = JsonNullable.<String>of(incidentType);
    
    return this;
  }

   /**
   * Filter by the incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
   * @return incidentType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getIncidentType() {
        return incidentType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCIDENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getIncidentType_JsonNullable() {
    return incidentType;
  }
  
  @JsonProperty(JSON_PROPERTY_INCIDENT_TYPE)
  public void setIncidentType_JsonNullable(JsonNullable<String> incidentType) {
    this.incidentType = incidentType;
  }

  public void setIncidentType(String incidentType) {
    this.incidentType = JsonNullable.<String>of(incidentType);
  }


  public ExecutionQueryDto incidentMessage(String incidentMessage) {
    this.incidentMessage = JsonNullable.<String>of(incidentMessage);
    
    return this;
  }

   /**
   * Filter by the incident message. Exact match.
   * @return incidentMessage
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getIncidentMessage() {
        return incidentMessage.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCIDENT_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getIncidentMessage_JsonNullable() {
    return incidentMessage;
  }
  
  @JsonProperty(JSON_PROPERTY_INCIDENT_MESSAGE)
  public void setIncidentMessage_JsonNullable(JsonNullable<String> incidentMessage) {
    this.incidentMessage = incidentMessage;
  }

  public void setIncidentMessage(String incidentMessage) {
    this.incidentMessage = JsonNullable.<String>of(incidentMessage);
  }


  public ExecutionQueryDto incidentMessageLike(String incidentMessageLike) {
    this.incidentMessageLike = JsonNullable.<String>of(incidentMessageLike);
    
    return this;
  }

   /**
   * Filter by the incident message that the parameter is a substring of.
   * @return incidentMessageLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getIncidentMessageLike() {
        return incidentMessageLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCIDENT_MESSAGE_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getIncidentMessageLike_JsonNullable() {
    return incidentMessageLike;
  }
  
  @JsonProperty(JSON_PROPERTY_INCIDENT_MESSAGE_LIKE)
  public void setIncidentMessageLike_JsonNullable(JsonNullable<String> incidentMessageLike) {
    this.incidentMessageLike = incidentMessageLike;
  }

  public void setIncidentMessageLike(String incidentMessageLike) {
    this.incidentMessageLike = JsonNullable.<String>of(incidentMessageLike);
  }


  public ExecutionQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public ExecutionQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by a  list of tenant ids. An execution must have one of the given tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public ExecutionQueryDto variables(List<VariableQueryParameterDto> variables) {
    this.variables = JsonNullable.<List<VariableQueryParameterDto>>of(variables);
    
    return this;
  }

  public ExecutionQueryDto addVariablesItem(VariableQueryParameterDto variablesItem) {
    if (this.variables == null || !this.variables.isPresent()) {
      this.variables = JsonNullable.<List<VariableQueryParameterDto>>of(new ArrayList<>());
    }
    try {
      this.variables.get().add(variablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array to only include executions that have variables with certain values.  The array consists of objects with the three properties &#x60;name&#x60;, &#x60;operator&#x60; and &#x60;value&#x60;. &#x60;name (String)&#x60; is the variable name, &#x60;operator (String)&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. &#x60;value&#x60; may be &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;.
   * @return variables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<VariableQueryParameterDto> getVariables() {
        return variables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<VariableQueryParameterDto>> getVariables_JsonNullable() {
    return variables;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  public void setVariables_JsonNullable(JsonNullable<List<VariableQueryParameterDto>> variables) {
    this.variables = variables;
  }

  public void setVariables(List<VariableQueryParameterDto> variables) {
    this.variables = JsonNullable.<List<VariableQueryParameterDto>>of(variables);
  }


  public ExecutionQueryDto processVariables(List<VariableQueryParameterDto> processVariables) {
    this.processVariables = JsonNullable.<List<VariableQueryParameterDto>>of(processVariables);
    
    return this;
  }

  public ExecutionQueryDto addProcessVariablesItem(VariableQueryParameterDto processVariablesItem) {
    if (this.processVariables == null || !this.processVariables.isPresent()) {
      this.processVariables = JsonNullable.<List<VariableQueryParameterDto>>of(new ArrayList<>());
    }
    try {
      this.processVariables.get().add(processVariablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array to only include executions that belong to a process instance with variables with certain values.  The array consists of objects with the three properties &#x60;name&#x60;, &#x60;operator&#x60; and &#x60;value&#x60;. &#x60;name (String)&#x60; is the variable name, &#x60;operator (String)&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. &#x60;value&#x60; may be &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to.
   * @return processVariables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<VariableQueryParameterDto> getProcessVariables() {
        return processVariables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<VariableQueryParameterDto>> getProcessVariables_JsonNullable() {
    return processVariables;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_VARIABLES)
  public void setProcessVariables_JsonNullable(JsonNullable<List<VariableQueryParameterDto>> processVariables) {
    this.processVariables = processVariables;
  }

  public void setProcessVariables(List<VariableQueryParameterDto> processVariables) {
    this.processVariables = JsonNullable.<List<VariableQueryParameterDto>>of(processVariables);
  }


  public ExecutionQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = JsonNullable.<Boolean>of(variableNamesIgnoreCase);
    
    return this;
  }

   /**
   * Match all variable names provided in &#x60;variables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal.
   * @return variableNamesIgnoreCase
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getVariableNamesIgnoreCase() {
        return variableNamesIgnoreCase.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getVariableNamesIgnoreCase_JsonNullable() {
    return variableNamesIgnoreCase;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE)
  public void setVariableNamesIgnoreCase_JsonNullable(JsonNullable<Boolean> variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = variableNamesIgnoreCase;
  }

  public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = JsonNullable.<Boolean>of(variableNamesIgnoreCase);
  }


  public ExecutionQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = JsonNullable.<Boolean>of(variableValuesIgnoreCase);
    
    return this;
  }

   /**
   * Match all variable values provided in &#x60;variables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal.
   * @return variableValuesIgnoreCase
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getVariableValuesIgnoreCase() {
        return variableValuesIgnoreCase.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getVariableValuesIgnoreCase_JsonNullable() {
    return variableValuesIgnoreCase;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE)
  public void setVariableValuesIgnoreCase_JsonNullable(JsonNullable<Boolean> variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = variableValuesIgnoreCase;
  }

  public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = JsonNullable.<Boolean>of(variableValuesIgnoreCase);
  }


  public ExecutionQueryDto sorting(List<ExecutionQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<ExecutionQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public ExecutionQueryDto addSortingItem(ExecutionQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<ExecutionQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Has no effect for the &#x60;/count&#x60; endpoint
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<ExecutionQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<ExecutionQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<ExecutionQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<ExecutionQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<ExecutionQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExecutionQueryDto executionQueryDto = (ExecutionQueryDto) o;
    return equalsNullable(this.businessKey, executionQueryDto.businessKey) &&
        equalsNullable(this.processDefinitionId, executionQueryDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, executionQueryDto.processDefinitionKey) &&
        equalsNullable(this.processInstanceId, executionQueryDto.processInstanceId) &&
        equalsNullable(this.activityId, executionQueryDto.activityId) &&
        equalsNullable(this.signalEventSubscriptionName, executionQueryDto.signalEventSubscriptionName) &&
        equalsNullable(this.messageEventSubscriptionName, executionQueryDto.messageEventSubscriptionName) &&
        equalsNullable(this.active, executionQueryDto.active) &&
        equalsNullable(this.suspended, executionQueryDto.suspended) &&
        equalsNullable(this.incidentId, executionQueryDto.incidentId) &&
        equalsNullable(this.incidentType, executionQueryDto.incidentType) &&
        equalsNullable(this.incidentMessage, executionQueryDto.incidentMessage) &&
        equalsNullable(this.incidentMessageLike, executionQueryDto.incidentMessageLike) &&
        equalsNullable(this.tenantIdIn, executionQueryDto.tenantIdIn) &&
        equalsNullable(this.variables, executionQueryDto.variables) &&
        equalsNullable(this.processVariables, executionQueryDto.processVariables) &&
        equalsNullable(this.variableNamesIgnoreCase, executionQueryDto.variableNamesIgnoreCase) &&
        equalsNullable(this.variableValuesIgnoreCase, executionQueryDto.variableValuesIgnoreCase) &&
        equalsNullable(this.sorting, executionQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(businessKey), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(processInstanceId), hashCodeNullable(activityId), hashCodeNullable(signalEventSubscriptionName), hashCodeNullable(messageEventSubscriptionName), hashCodeNullable(active), hashCodeNullable(suspended), hashCodeNullable(incidentId), hashCodeNullable(incidentType), hashCodeNullable(incidentMessage), hashCodeNullable(incidentMessageLike), hashCodeNullable(tenantIdIn), hashCodeNullable(variables), hashCodeNullable(processVariables), hashCodeNullable(variableNamesIgnoreCase), hashCodeNullable(variableValuesIgnoreCase), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExecutionQueryDto {\n");
    sb.append("    businessKey: ").append(toIndentedString(businessKey)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    signalEventSubscriptionName: ").append(toIndentedString(signalEventSubscriptionName)).append("\n");
    sb.append("    messageEventSubscriptionName: ").append(toIndentedString(messageEventSubscriptionName)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    incidentId: ").append(toIndentedString(incidentId)).append("\n");
    sb.append("    incidentType: ").append(toIndentedString(incidentType)).append("\n");
    sb.append("    incidentMessage: ").append(toIndentedString(incidentMessage)).append("\n");
    sb.append("    incidentMessageLike: ").append(toIndentedString(incidentMessageLike)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    processVariables: ").append(toIndentedString(processVariables)).append("\n");
    sb.append("    variableNamesIgnoreCase: ").append(toIndentedString(variableNamesIgnoreCase)).append("\n");
    sb.append("    variableValuesIgnoreCase: ").append(toIndentedString(variableValuesIgnoreCase)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `businessKey` to the URL query string
    if (getBusinessKey() != null) {
      try {
        joiner.add(String.format("%sbusinessKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBusinessKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `signalEventSubscriptionName` to the URL query string
    if (getSignalEventSubscriptionName() != null) {
      try {
        joiner.add(String.format("%ssignalEventSubscriptionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSignalEventSubscriptionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `messageEventSubscriptionName` to the URL query string
    if (getMessageEventSubscriptionName() != null) {
      try {
        joiner.add(String.format("%smessageEventSubscriptionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMessageEventSubscriptionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `active` to the URL query string
    if (getActive() != null) {
      try {
        joiner.add(String.format("%sactive%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActive()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `suspended` to the URL query string
    if (getSuspended() != null) {
      try {
        joiner.add(String.format("%ssuspended%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuspended()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentId` to the URL query string
    if (getIncidentId() != null) {
      try {
        joiner.add(String.format("%sincidentId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncidentId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentType` to the URL query string
    if (getIncidentType() != null) {
      try {
        joiner.add(String.format("%sincidentType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncidentType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentMessage` to the URL query string
    if (getIncidentMessage() != null) {
      try {
        joiner.add(String.format("%sincidentMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncidentMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentMessageLike` to the URL query string
    if (getIncidentMessageLike() != null) {
      try {
        joiner.add(String.format("%sincidentMessageLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncidentMessageLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (int i = 0; i < getVariables().size(); i++) {
        if (getVariables().get(i) != null) {
          joiner.add(getVariables().get(i).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `processVariables` to the URL query string
    if (getProcessVariables() != null) {
      for (int i = 0; i < getProcessVariables().size(); i++) {
        if (getProcessVariables().get(i) != null) {
          joiner.add(getProcessVariables().get(i).toUrlQueryString(String.format("%sprocessVariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `variableNamesIgnoreCase` to the URL query string
    if (getVariableNamesIgnoreCase() != null) {
      try {
        joiner.add(String.format("%svariableNamesIgnoreCase%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableNamesIgnoreCase()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableValuesIgnoreCase` to the URL query string
    if (getVariableValuesIgnoreCase() != null) {
      try {
        joiner.add(String.format("%svariableValuesIgnoreCase%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableValuesIgnoreCase()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

