/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * An External Task object with the following properties
 */
@JsonPropertyOrder({
  ExternalTaskDto.JSON_PROPERTY_ACTIVITY_ID,
  ExternalTaskDto.JSON_PROPERTY_ACTIVITY_INSTANCE_ID,
  ExternalTaskDto.JSON_PROPERTY_ERROR_MESSAGE,
  ExternalTaskDto.JSON_PROPERTY_EXECUTION_ID,
  ExternalTaskDto.JSON_PROPERTY_ID,
  ExternalTaskDto.JSON_PROPERTY_LOCK_EXPIRATION_TIME,
  ExternalTaskDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ExternalTaskDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  ExternalTaskDto.JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG,
  ExternalTaskDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  ExternalTaskDto.JSON_PROPERTY_TENANT_ID,
  ExternalTaskDto.JSON_PROPERTY_RETRIES,
  ExternalTaskDto.JSON_PROPERTY_SUSPENDED,
  ExternalTaskDto.JSON_PROPERTY_WORKER_ID,
  ExternalTaskDto.JSON_PROPERTY_TOPIC_NAME,
  ExternalTaskDto.JSON_PROPERTY_PRIORITY,
  ExternalTaskDto.JSON_PROPERTY_BUSINESS_KEY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class ExternalTaskDto {
  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_INSTANCE_ID = "activityInstanceId";
  private JsonNullable<String> activityInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  private JsonNullable<String> errorMessage = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_LOCK_EXPIRATION_TIME = "lockExpirationTime";
  private JsonNullable<OffsetDateTime> lockExpirationTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG = "processDefinitionVersionTag";
  private JsonNullable<String> processDefinitionVersionTag = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_RETRIES = "retries";
  private JsonNullable<Integer> retries = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_SUSPENDED = "suspended";
  private JsonNullable<Boolean> suspended = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_WORKER_ID = "workerId";
  private JsonNullable<String> workerId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TOPIC_NAME = "topicName";
  private JsonNullable<String> topicName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  private JsonNullable<Long> priority = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_BUSINESS_KEY = "businessKey";
  private JsonNullable<String> businessKey = JsonNullable.<String>undefined();

  public ExternalTaskDto() {
  }

  public ExternalTaskDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * The id of the activity that this external task belongs to.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public ExternalTaskDto activityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
    
    return this;
  }

   /**
   * The id of the activity instance that the external task belongs to.
   * @return activityInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityInstanceId() {
        return activityInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityInstanceId_JsonNullable() {
    return activityInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  public void setActivityInstanceId_JsonNullable(JsonNullable<String> activityInstanceId) {
    this.activityInstanceId = activityInstanceId;
  }

  public void setActivityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
  }


  public ExternalTaskDto errorMessage(String errorMessage) {
    this.errorMessage = JsonNullable.<String>of(errorMessage);
    
    return this;
  }

   /**
   * The full error message submitted with the latest reported failure executing this task; &#x60;null&#x60; if no failure was reported previously or if no error message was submitted
   * @return errorMessage
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getErrorMessage() {
        return errorMessage.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getErrorMessage_JsonNullable() {
    return errorMessage;
  }
  
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  public void setErrorMessage_JsonNullable(JsonNullable<String> errorMessage) {
    this.errorMessage = errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = JsonNullable.<String>of(errorMessage);
  }


  public ExternalTaskDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * The id of the execution that the external task belongs to.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public ExternalTaskDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the external task.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public ExternalTaskDto lockExpirationTime(OffsetDateTime lockExpirationTime) {
    this.lockExpirationTime = JsonNullable.<OffsetDateTime>of(lockExpirationTime);
    
    return this;
  }

   /**
   * The date that the task&#39;s most recent lock expires or has expired.
   * @return lockExpirationTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getLockExpirationTime() {
        return lockExpirationTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LOCK_EXPIRATION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getLockExpirationTime_JsonNullable() {
    return lockExpirationTime;
  }
  
  @JsonProperty(JSON_PROPERTY_LOCK_EXPIRATION_TIME)
  public void setLockExpirationTime_JsonNullable(JsonNullable<OffsetDateTime> lockExpirationTime) {
    this.lockExpirationTime = lockExpirationTime;
  }

  public void setLockExpirationTime(OffsetDateTime lockExpirationTime) {
    this.lockExpirationTime = JsonNullable.<OffsetDateTime>of(lockExpirationTime);
  }


  public ExternalTaskDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * The id of the process definition the external task is defined in.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public ExternalTaskDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * The key of the process definition the external task is defined in.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public ExternalTaskDto processDefinitionVersionTag(String processDefinitionVersionTag) {
    this.processDefinitionVersionTag = JsonNullable.<String>of(processDefinitionVersionTag);
    
    return this;
  }

   /**
   * The version tag of the process definition the external task is defined in.
   * @return processDefinitionVersionTag
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionVersionTag() {
        return processDefinitionVersionTag.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionVersionTag_JsonNullable() {
    return processDefinitionVersionTag;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG)
  public void setProcessDefinitionVersionTag_JsonNullable(JsonNullable<String> processDefinitionVersionTag) {
    this.processDefinitionVersionTag = processDefinitionVersionTag;
  }

  public void setProcessDefinitionVersionTag(String processDefinitionVersionTag) {
    this.processDefinitionVersionTag = JsonNullable.<String>of(processDefinitionVersionTag);
  }


  public ExternalTaskDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * The id of the process instance the external task belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public ExternalTaskDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * The id of the tenant the external task belongs to.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public ExternalTaskDto retries(Integer retries) {
    this.retries = JsonNullable.<Integer>of(retries);
    
    return this;
  }

   /**
   * The number of retries the task currently has left.
   * @return retries
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getRetries() {
        return retries.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getRetries_JsonNullable() {
    return retries;
  }
  
  @JsonProperty(JSON_PROPERTY_RETRIES)
  public void setRetries_JsonNullable(JsonNullable<Integer> retries) {
    this.retries = retries;
  }

  public void setRetries(Integer retries) {
    this.retries = JsonNullable.<Integer>of(retries);
  }


  public ExternalTaskDto suspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
    
    return this;
  }

   /**
   * A flag indicating whether the external task is suspended or not.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuspended() {
        return suspended.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuspended_JsonNullable() {
    return suspended;
  }
  
  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  public void setSuspended_JsonNullable(JsonNullable<Boolean> suspended) {
    this.suspended = suspended;
  }

  public void setSuspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
  }


  public ExternalTaskDto workerId(String workerId) {
    this.workerId = JsonNullable.<String>of(workerId);
    
    return this;
  }

   /**
   * The id of the worker that posesses or posessed the most recent lock.
   * @return workerId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getWorkerId() {
        return workerId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WORKER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getWorkerId_JsonNullable() {
    return workerId;
  }
  
  @JsonProperty(JSON_PROPERTY_WORKER_ID)
  public void setWorkerId_JsonNullable(JsonNullable<String> workerId) {
    this.workerId = workerId;
  }

  public void setWorkerId(String workerId) {
    this.workerId = JsonNullable.<String>of(workerId);
  }


  public ExternalTaskDto topicName(String topicName) {
    this.topicName = JsonNullable.<String>of(topicName);
    
    return this;
  }

   /**
   * The topic name of the external task.
   * @return topicName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTopicName() {
        return topicName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TOPIC_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTopicName_JsonNullable() {
    return topicName;
  }
  
  @JsonProperty(JSON_PROPERTY_TOPIC_NAME)
  public void setTopicName_JsonNullable(JsonNullable<String> topicName) {
    this.topicName = topicName;
  }

  public void setTopicName(String topicName) {
    this.topicName = JsonNullable.<String>of(topicName);
  }


  public ExternalTaskDto priority(Long priority) {
    this.priority = JsonNullable.<Long>of(priority);
    
    return this;
  }

   /**
   * The priority of the external task.
   * @return priority
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getPriority() {
        return priority.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getPriority_JsonNullable() {
    return priority;
  }
  
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  public void setPriority_JsonNullable(JsonNullable<Long> priority) {
    this.priority = priority;
  }

  public void setPriority(Long priority) {
    this.priority = JsonNullable.<Long>of(priority);
  }


  public ExternalTaskDto businessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
    
    return this;
  }

   /**
   * The business key of the process instance the external task belongs to.
   * @return businessKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getBusinessKey() {
        return businessKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getBusinessKey_JsonNullable() {
    return businessKey;
  }
  
  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  public void setBusinessKey_JsonNullable(JsonNullable<String> businessKey) {
    this.businessKey = businessKey;
  }

  public void setBusinessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExternalTaskDto externalTaskDto = (ExternalTaskDto) o;
    return equalsNullable(this.activityId, externalTaskDto.activityId) &&
        equalsNullable(this.activityInstanceId, externalTaskDto.activityInstanceId) &&
        equalsNullable(this.errorMessage, externalTaskDto.errorMessage) &&
        equalsNullable(this.executionId, externalTaskDto.executionId) &&
        equalsNullable(this.id, externalTaskDto.id) &&
        equalsNullable(this.lockExpirationTime, externalTaskDto.lockExpirationTime) &&
        equalsNullable(this.processDefinitionId, externalTaskDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, externalTaskDto.processDefinitionKey) &&
        equalsNullable(this.processDefinitionVersionTag, externalTaskDto.processDefinitionVersionTag) &&
        equalsNullable(this.processInstanceId, externalTaskDto.processInstanceId) &&
        equalsNullable(this.tenantId, externalTaskDto.tenantId) &&
        equalsNullable(this.retries, externalTaskDto.retries) &&
        equalsNullable(this.suspended, externalTaskDto.suspended) &&
        equalsNullable(this.workerId, externalTaskDto.workerId) &&
        equalsNullable(this.topicName, externalTaskDto.topicName) &&
        equalsNullable(this.priority, externalTaskDto.priority) &&
        equalsNullable(this.businessKey, externalTaskDto.businessKey);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(activityId), hashCodeNullable(activityInstanceId), hashCodeNullable(errorMessage), hashCodeNullable(executionId), hashCodeNullable(id), hashCodeNullable(lockExpirationTime), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(processDefinitionVersionTag), hashCodeNullable(processInstanceId), hashCodeNullable(tenantId), hashCodeNullable(retries), hashCodeNullable(suspended), hashCodeNullable(workerId), hashCodeNullable(topicName), hashCodeNullable(priority), hashCodeNullable(businessKey));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExternalTaskDto {\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    activityInstanceId: ").append(toIndentedString(activityInstanceId)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    lockExpirationTime: ").append(toIndentedString(lockExpirationTime)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionVersionTag: ").append(toIndentedString(processDefinitionVersionTag)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    workerId: ").append(toIndentedString(workerId)).append("\n");
    sb.append("    topicName: ").append(toIndentedString(topicName)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    businessKey: ").append(toIndentedString(businessKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityInstanceId` to the URL query string
    if (getActivityInstanceId() != null) {
      try {
        joiner.add(String.format("%sactivityInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorMessage` to the URL query string
    if (getErrorMessage() != null) {
      try {
        joiner.add(String.format("%serrorMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `lockExpirationTime` to the URL query string
    if (getLockExpirationTime() != null) {
      try {
        joiner.add(String.format("%slockExpirationTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLockExpirationTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionVersionTag` to the URL query string
    if (getProcessDefinitionVersionTag() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionVersionTag%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionVersionTag()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `retries` to the URL query string
    if (getRetries() != null) {
      try {
        joiner.add(String.format("%sretries%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRetries()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `suspended` to the URL query string
    if (getSuspended() != null) {
      try {
        joiner.add(String.format("%ssuspended%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuspended()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `workerId` to the URL query string
    if (getWorkerId() != null) {
      try {
        joiner.add(String.format("%sworkerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWorkerId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `topicName` to the URL query string
    if (getTopicName() != null) {
      try {
        joiner.add(String.format("%stopicName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTopicName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `priority` to the URL query string
    if (getPriority() != null) {
      try {
        joiner.add(String.format("%spriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `businessKey` to the URL query string
    if (getBusinessKey() != null) {
      try {
        joiner.add(String.format("%sbusinessKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBusinessKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

