/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * ExternalTaskFailureDto
 */
@JsonPropertyOrder({
  ExternalTaskFailureDto.JSON_PROPERTY_WORKER_ID,
  ExternalTaskFailureDto.JSON_PROPERTY_ERROR_MESSAGE,
  ExternalTaskFailureDto.JSON_PROPERTY_ERROR_DETAILS,
  ExternalTaskFailureDto.JSON_PROPERTY_RETRIES,
  ExternalTaskFailureDto.JSON_PROPERTY_RETRY_TIMEOUT,
  ExternalTaskFailureDto.JSON_PROPERTY_VARIABLES,
  ExternalTaskFailureDto.JSON_PROPERTY_LOCAL_VARIABLES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class ExternalTaskFailureDto {
  public static final String JSON_PROPERTY_WORKER_ID = "workerId";
  private String workerId;

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  private JsonNullable<String> errorMessage = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ERROR_DETAILS = "errorDetails";
  private JsonNullable<String> errorDetails = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_RETRIES = "retries";
  private JsonNullable<Integer> retries = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_RETRY_TIMEOUT = "retryTimeout";
  private JsonNullable<Long> retryTimeout = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  private JsonNullable<Map<String, VariableValueDto>> variables = JsonNullable.<Map<String, VariableValueDto>>undefined();

  public static final String JSON_PROPERTY_LOCAL_VARIABLES = "localVariables";
  private JsonNullable<Map<String, VariableValueDto>> localVariables = JsonNullable.<Map<String, VariableValueDto>>undefined();

  public ExternalTaskFailureDto() {
  }

  public ExternalTaskFailureDto workerId(String workerId) {
    
    this.workerId = workerId;
    return this;
  }

   /**
   * **Mandatory.** The ID of the worker who is performing the operation on the external task. If the task is already locked, must match the id of the worker who has most recently locked the task.
   * @return workerId
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WORKER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWorkerId() {
    return workerId;
  }


  @JsonProperty(JSON_PROPERTY_WORKER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWorkerId(String workerId) {
    this.workerId = workerId;
  }


  public ExternalTaskFailureDto errorMessage(String errorMessage) {
    this.errorMessage = JsonNullable.<String>of(errorMessage);
    
    return this;
  }

   /**
   * An message indicating the reason of the failure.
   * @return errorMessage
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getErrorMessage() {
        return errorMessage.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getErrorMessage_JsonNullable() {
    return errorMessage;
  }
  
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  public void setErrorMessage_JsonNullable(JsonNullable<String> errorMessage) {
    this.errorMessage = errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = JsonNullable.<String>of(errorMessage);
  }


  public ExternalTaskFailureDto errorDetails(String errorDetails) {
    this.errorDetails = JsonNullable.<String>of(errorDetails);
    
    return this;
  }

   /**
   * A detailed error description.
   * @return errorDetails
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getErrorDetails() {
        return errorDetails.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ERROR_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getErrorDetails_JsonNullable() {
    return errorDetails;
  }
  
  @JsonProperty(JSON_PROPERTY_ERROR_DETAILS)
  public void setErrorDetails_JsonNullable(JsonNullable<String> errorDetails) {
    this.errorDetails = errorDetails;
  }

  public void setErrorDetails(String errorDetails) {
    this.errorDetails = JsonNullable.<String>of(errorDetails);
  }


  public ExternalTaskFailureDto retries(Integer retries) {
    this.retries = JsonNullable.<Integer>of(retries);
    
    return this;
  }

   /**
   * A number of how often the task should be retried. Must be &gt;&#x3D; 0. If this is 0, an incident is created and the task cannot be fetched anymore unless the retries are increased again. The incident&#39;s message is set to the &#x60;errorMessage&#x60; parameter.
   * @return retries
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getRetries() {
        return retries.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getRetries_JsonNullable() {
    return retries;
  }
  
  @JsonProperty(JSON_PROPERTY_RETRIES)
  public void setRetries_JsonNullable(JsonNullable<Integer> retries) {
    this.retries = retries;
  }

  public void setRetries(Integer retries) {
    this.retries = JsonNullable.<Integer>of(retries);
  }


  public ExternalTaskFailureDto retryTimeout(Long retryTimeout) {
    this.retryTimeout = JsonNullable.<Long>of(retryTimeout);
    
    return this;
  }

   /**
   * A timeout in milliseconds before the external task becomes available again for fetching. Must be &gt;&#x3D; 0.
   * @return retryTimeout
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getRetryTimeout() {
        return retryTimeout.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RETRY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getRetryTimeout_JsonNullable() {
    return retryTimeout;
  }
  
  @JsonProperty(JSON_PROPERTY_RETRY_TIMEOUT)
  public void setRetryTimeout_JsonNullable(JsonNullable<Long> retryTimeout) {
    this.retryTimeout = retryTimeout;
  }

  public void setRetryTimeout(Long retryTimeout) {
    this.retryTimeout = JsonNullable.<Long>of(retryTimeout);
  }


  public ExternalTaskFailureDto variables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
    
    return this;
  }

  public ExternalTaskFailureDto putVariablesItem(String key, VariableValueDto variablesItem) {
    if (this.variables == null || !this.variables.isPresent()) {
      this.variables = JsonNullable.<Map<String, VariableValueDto>>of(new HashMap<>());
    }
    try {
      this.variables.get().put(key, variablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON object containing variable key-value pairs. Each key is a variable name and each value a JSON variable value object with the following properties:
   * @return variables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, VariableValueDto> getVariables() {
        return variables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, VariableValueDto>> getVariables_JsonNullable() {
    return variables;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  public void setVariables_JsonNullable(JsonNullable<Map<String, VariableValueDto>> variables) {
    this.variables = variables;
  }

  public void setVariables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
  }


  public ExternalTaskFailureDto localVariables(Map<String, VariableValueDto> localVariables) {
    this.localVariables = JsonNullable.<Map<String, VariableValueDto>>of(localVariables);
    
    return this;
  }

  public ExternalTaskFailureDto putLocalVariablesItem(String key, VariableValueDto localVariablesItem) {
    if (this.localVariables == null || !this.localVariables.isPresent()) {
      this.localVariables = JsonNullable.<Map<String, VariableValueDto>>of(new HashMap<>());
    }
    try {
      this.localVariables.get().put(key, localVariablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON object containing local variable key-value pairs. Local variables are set only in the scope of external task. Each key is a variable name and each value a JSON variable value object with the following properties:
   * @return localVariables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, VariableValueDto> getLocalVariables() {
        return localVariables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LOCAL_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, VariableValueDto>> getLocalVariables_JsonNullable() {
    return localVariables;
  }
  
  @JsonProperty(JSON_PROPERTY_LOCAL_VARIABLES)
  public void setLocalVariables_JsonNullable(JsonNullable<Map<String, VariableValueDto>> localVariables) {
    this.localVariables = localVariables;
  }

  public void setLocalVariables(Map<String, VariableValueDto> localVariables) {
    this.localVariables = JsonNullable.<Map<String, VariableValueDto>>of(localVariables);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExternalTaskFailureDto externalTaskFailureDto = (ExternalTaskFailureDto) o;
    return Objects.equals(this.workerId, externalTaskFailureDto.workerId) &&
        equalsNullable(this.errorMessage, externalTaskFailureDto.errorMessage) &&
        equalsNullable(this.errorDetails, externalTaskFailureDto.errorDetails) &&
        equalsNullable(this.retries, externalTaskFailureDto.retries) &&
        equalsNullable(this.retryTimeout, externalTaskFailureDto.retryTimeout) &&
        equalsNullable(this.variables, externalTaskFailureDto.variables) &&
        equalsNullable(this.localVariables, externalTaskFailureDto.localVariables);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(workerId, hashCodeNullable(errorMessage), hashCodeNullable(errorDetails), hashCodeNullable(retries), hashCodeNullable(retryTimeout), hashCodeNullable(variables), hashCodeNullable(localVariables));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExternalTaskFailureDto {\n");
    sb.append("    workerId: ").append(toIndentedString(workerId)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    errorDetails: ").append(toIndentedString(errorDetails)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    retryTimeout: ").append(toIndentedString(retryTimeout)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    localVariables: ").append(toIndentedString(localVariables)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `workerId` to the URL query string
    if (getWorkerId() != null) {
      try {
        joiner.add(String.format("%sworkerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWorkerId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorMessage` to the URL query string
    if (getErrorMessage() != null) {
      try {
        joiner.add(String.format("%serrorMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorDetails` to the URL query string
    if (getErrorDetails() != null) {
      try {
        joiner.add(String.format("%serrorDetails%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorDetails()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `retries` to the URL query string
    if (getRetries() != null) {
      try {
        joiner.add(String.format("%sretries%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRetries()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `retryTimeout` to the URL query string
    if (getRetryTimeout() != null) {
      try {
        joiner.add(String.format("%sretryTimeout%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRetryTimeout()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (String _key : getVariables().keySet()) {
        if (getVariables().get(_key) != null) {
          joiner.add(getVariables().get(_key).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `localVariables` to the URL query string
    if (getLocalVariables() != null) {
      for (String _key : getLocalVariables().keySet()) {
        if (getLocalVariables().get(_key) != null) {
          joiner.add(getLocalVariables().get(_key).toUrlQueryString(String.format("%slocalVariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

